from gladier.base import GladierBaseTool
from .funcx_functions import manifest_to_funcx_tasks, manifest_dummy_compute_callback


class ManifestTransfer(GladierBaseTool):

    flow_definition = {
        'Comment': 'Hello Gladier Automate Flow',
        'StartAt': 'ManifestTutorial',
        'States': {
            'ManifestTutorial': {
                'Comment': 'Manifest Transfer Globus Tutorial Endpoint 1 /share/godata/ files',
                'Type': 'Action',
                'ActionUrl': 'https://develop.concierge.nick.globuscs.info/api/automate/transfer',
                'ActionScope': 'https://auth.globus.org/scopes/524361f2-e4a9-4bd0-a3a6-03e365cac8a9/concierge',
                'Parameters': {
                    'manifest_id.$': '$.input.manifest_id',
                    'destination.$': '$.input.manifest_destination',
                },
                'ResultPath': '$.ManifestTutorialResult',
                'WaitTime': 300,
                'End': True,
            },
        }
    }

    required_input = [
        'manifest_id',
        'manifest_destination'
    ]

    flow_input = {
        # Contains tutorial files on /share/godata/ for Globus Tutorial Endpoint 1
        'manifest_id': '22ea05b3-a708-4524-b2c7-b3a635ffb1c3',
        # By default, this will transfer to Globus Tutorial Endpoint 2
        'manifest_destination': 'globus://ddb59af0-6d04-11e5-ba46-22000b92c6ec/~/'
    }

    # Flow uses no FuncX functions
    funcx_functions = []


class ManifestToFuncXTasks(GladierBaseTool):
    flow_definition = {
        'Comment': 'Turn a set of files or directories into funcx tasks',
        'StartAt': 'CreateFuncXTasks',
        'States': {
            'CreateFuncXTasks': {
                'Comment': 'Fetch a manifest, extract a list of files to process, and create a funcx '
                           'task list',
                'Type': 'Action',
                'ActionUrl': 'https://api.funcx.org/automate',
                'ActionScope': 'https://auth.globus.org/scopes/facd7ccc-c5f4-42aa-916b-a0e270e2c2a9/automate2',
                'Parameters': {
                    'tasks': [{
                        'endpoint.$': '$.input.funcx_endpoint_non_compute',
                        'func.$': f'$.input.manifest_to_funcx_tasks_funcx_id',
                        'payload.$': '$.input'
                    }]
                },
                'ResultPath': '$.CreateFuncXTasksOutput',
                'WaitTime': 300,
                'Next': 'RunFuncXTasks',
            },
            'RunFuncXTasks': {
                'Comment': 'Run a funcx task on each file or directory',
                'Type': 'Action',
                'ActionUrl': 'https://api.funcx.org/automate',
                'ActionScope': 'https://auth.globus.org/scopes/facd7ccc-c5f4-42aa-916b-a0e270e2c2a9/automate2',
                # Fetch the input generated by the previous task
                'InputPath': '$.CreateFuncXTasksOutput.details.result',
                'ResultPath': '$.ManifestFuncXTasksOutput',
                'WaitTime': 300,
                'End': True,
            },
        }
    }

    required_input = [
        'funcx_endpoint_non_compute',
        'manifest_to_funcx_tasks_manifest_id',

        'manifest_to_funcx_tasks_funcx_endpoint_compute',
        # 'manifest_to_funcx_tasks_callback_funcx_id'
    ]

    flow_input = {
        # Contains tutorial files on /share/godata/ for Globus Tutorial Endpoint 1
        'manifest_to_funcx_tasks_manifest_id': '22ea05b3-a708-4524-b2c7-b3a635ffb1c3',
        'manifest_to_funcx_tasks_suffix': '',
        'manifest_to_funcx_tasks_use_dirs': False,
    }

    # Flow uses no FuncX functions
    funcx_functions = [
        manifest_to_funcx_tasks,
        manifest_dummy_compute_callback,
    ]
