"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtNetwork
from PyQt5 import QtCore
from PyQt5.QtXmlPatterns import *
from PyQt5 import sip


class QXmlSchemaValidator(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlschemavalidator.html

    **Detailed Description**

    The QXmlSchemaValidator class loads, parses an XML instance document and
    validates it against a W3C XML Schema that has been compiled with
    **QXmlSchema** .

    The following example shows how to load a XML Schema from a local file,
    check whether it is a valid schema document and use it for validation of an
    XML instance document:

    **QUrl**  schemaUrl("file:///home/user/schema.xsd");
    **QXmlSchema**  schema;
            schema.load(schemaUrl);

            if
    (schema.isValid()) {
                **QFile**  file("test.xml");
    file.open(**QIODevice** ::ReadOnly);
    **QXmlSchemaValidator**  validator(schema);
                if
    (validator.validate(&file, **QUrl** ::fromLocalFile(file.fileName())))
    **qDebug** () << "instance document is valid";
                else
    **qDebug** () << "instance document is invalid";
            }

    **XML Schema Version**

    This class implements schema validation according to the **XML Schema**  1.0
    specification.

    **See also** **QXmlSchema**  and **XML Schema Validation Example** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#QXmlSchemaValidator

        **QXmlSchemaValidator::QXmlSchemaValidator()**

        Constructs a schema validator. The schema used for validation must be
        referenced in the XML instance document via the `xsi:schemaLocation` or
        `xsi:noNamespaceSchemaLocation` attribute.
        """
        ...

    @typing.overload
    def __init__(self, schema: QXmlSchema) -> None:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#QXmlSchemaValidator-1

        **QXmlSchemaValidator::QXmlSchemaValidator(const QXmlSchema & schema )**

        Constructs a schema validator that will use **schema** for validation.
        If an empty **QXmlSchema**  schema is passed to the validator, the
        schema used for validation must be referenced in the XML instance
        document via the `xsi:schemaLocation` or `xsi:noNamespaceSchemaLocation`
        attribute.
        """
        ...

    def networkAccessManager(self) -> QtNetwork.QNetworkAccessManager:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#networkAccessManager

        **QNetworkAccessManager *QXmlSchemaValidator::networkAccessManager()
        const**

        Returns the network manager, or 0 if it has not been set.

        **See also** **setNetworkAccessManager** ().
        """
        ...

    def setNetworkAccessManager(
        self, networkmanager: QtNetwork.QNetworkAccessManager
    ) -> None:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#setNetworkAccessManager

        **void
        QXmlSchemaValidator::setNetworkAccessManager(QNetworkAccessManager *
        manager )**

        Sets the network manager to **manager**. **QXmlSchemaValidator**  does
        not take ownership of **manager**.

        **See also** **networkAccessManager** ().
        """
        ...

    def uriResolver(self) -> QAbstractUriResolver:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#uriResolver

        **const QAbstractUriResolver *QXmlSchemaValidator::uriResolver() const**

        Returns the schema's URI resolver. If no URI resolver has been set, Qt
        XML Patterns will use the URIs in instance documents as they are.

        The URI resolver provides a level of abstraction, or **polymorphic
        URIs**. A resolver can rewrite **logical** URIs to physical ones, or it
        can translate obsolete or invalid URIs to valid ones.

        When Qt XML Patterns calls **QAbstractUriResolver::resolve** () the
        absolute URI is the URI mandated by the schema specification, and the
        relative URI is the URI specified by the user.

        **See also** **setUriResolver** ().
        """
        ...

    def setUriResolver(self, resolver: QAbstractUriResolver) -> None:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#setUriResolver

        **void QXmlSchemaValidator::setUriResolver(const QAbstractUriResolver *
        resolver )**

        Sets the URI resolver to **resolver**. **QXmlSchemaValidator**  does not
        take ownership of **resolver**.

        **See also** **uriResolver** ().
        """
        ...

    def messageHandler(self) -> QAbstractMessageHandler:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#messageHandler

        **QAbstractMessageHandler *QXmlSchemaValidator::messageHandler() const**

        Returns the message handler that handles parsing and validation messages
        for this **QXmlSchemaValidator** .

        **See also** **setMessageHandler** ().
        """
        ...

    def setMessageHandler(self, handler: QAbstractMessageHandler) -> None:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#setMessageHandler

        **void QXmlSchemaValidator::setMessageHandler(QAbstractMessageHandler *
        handler )**

        Changes the **message handler**  for this **QXmlSchemaValidator**  to
        **handler**. The schema validator sends all parsing and validation
        messages to this message handler. **QXmlSchemaValidator**  does not take
        ownership of **handler**.

        Normally, the default message handler is sufficient. It writes compile
        and validation messages to **stderr**. The default message handler
        includes color codes if **stderr** can render colors.

        When **QXmlSchemaValidator**  calls **QAbstractMessageHandler::message**
        (), the arguments are as follows:

        message() argumentSemantics
        **QtMsgType**  typeOnly **QtWarningMsg**
        and **QtFatalMsg**  are used. The former identifies a warning, while the
        latter identifies an error.
        const **QString**  & descriptionAn XHTML
        document which is the actual message. It is translated into the current
        language.
        const **QUrl**  &identifierIdentifies the error with a URI,
        where the fragment is the error code, and the rest of the URI is the
        error namespace.
        const **QSourceLocation**  & sourceLocationIdentifies
        where the error occurred.

        **See also** **messageHandler** ().
        """
        ...

    def schema(self) -> QXmlSchema:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#schema

        **QXmlSchema QXmlSchemaValidator::schema() const**

        Returns the schema that is used for validation.

        **See also** **setSchema** ().
        """
        ...

    def namePool(self) -> QXmlNamePool:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#namePool

        **QXmlNamePool QXmlSchemaValidator::namePool() const**

        Returns the name pool used by this **QXmlSchemaValidator**  for
        constructing **names** . There is no setter for the name pool, because
        mixing name pools causes errors due to name confusion.
        """
        ...

    @typing.overload
    def validate(self, source: QtCore.QUrl) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#validate

        **bool QXmlSchemaValidator::validate(const QUrl & source ) const**

        Validates the XML instance document read from **source** against the
        schema.

        Returns `true` if the XML instance document is valid according to the
        schema, `false` otherwise.

        Example:

        const **QXmlSchema**  schema = getSchema();

                const **QUrl**
        url("http://www.schema-example.org/test.xml");
        **QXmlSchemaValidator**  validator(schema);
                if
        (validator.validate(url))
                    **qDebug** () << "instance
        document is valid";
                else
                    **qDebug** () << "instance
        document is invalid";
        """
        ...

    @typing.overload
    def validate(
        self, source: QtCore.QIODevice, documentUri: QtCore.QUrl = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#validate-1

        **bool QXmlSchemaValidator::validate(QIODevice * source , const QUrl &
        documentUri = QUrl()) const**

        Validates the XML instance document read from **source** with the given
        **documentUri** against the schema.

        Returns `true` if the XML instance document is valid according to the
        schema, `false` otherwise.

        Example:

        const **QXmlSchema**  schema = getSchema();

                **QFile**
        file("test.xml");
                file.open(**QIODevice** ::ReadOnly);
        **QXmlSchemaValidator**  validator(schema);
                if
        (validator.validate(&file, **QUrl** ::fromLocalFile(file.fileName())))
        **qDebug** () << "instance document is valid";
                else
        **qDebug** () << "instance document is invalid";
        """
        ...

    @typing.overload
    def validate(
        self,
        data: typing.Union[QtCore.QByteArray, bytes, bytearray],
        documentUri: QtCore.QUrl = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#validate-2

        **bool QXmlSchemaValidator::validate(const QByteArray & data , const
        QUrl & documentUri = QUrl()) const**

        Validates the XML instance document read from **data** with the given
        **documentUri** against the schema.

        Returns `true` if the XML instance document is valid according to the
        schema, `false` otherwise.

        Example:

        const **QXmlSchema**  schema = getSchema();

                **QByteArray**
        data("<?xml version=\\"1.0\\" encoding=\\"UTF-8\\"?>"
        "<test></test>");

                **QBuffer**  buffer(&data);
        buffer.open(**QIODevice** ::ReadOnly);
        **QXmlSchemaValidator**  validator(schema);
                if
        (validator.validate(&buffer))
                    **qDebug** () << "instance
        document is valid";
                else
                    **qDebug** () << "instance
        document is invalid";
        """
        ...

    def setSchema(self, schema: QXmlSchema) -> None:
        """
        https://doc.qt.io/qt-5/qxmlschemavalidator.html#setSchema

        **void QXmlSchemaValidator::setSchema(const QXmlSchema & schema )**

        Sets the **schema** that shall be used for further validation. If the
        schema is empty, the schema used for validation must be referenced in
        the XML instance document via the `xsi:schemaLocation` or
        `xsi:noNamespaceSchemaLocation` attribute.

        **See also** **schema** ().
        """
        ...
