"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
from PyQt5.QtXmlPatterns import *
from PyQt5 import sip


class QXmlResultItems(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlresultitems.html

    **Detailed Description**

    QXmlResultItems presents the evaluation of an associated query as a sequence
    of **QXmlItems** . The sequence is traversed by repeatedly calling **next**
    (), which actually produces the sequence by lazy evaluation of the query.

    **QXmlQuery**  query;
        query.setQuery("<e/>, 1, 'two'");
    **QXmlResultItems**  result;

        if (query.isValid()) {
    query.evaluateTo(&result);
            **QXmlItem**  item(result.next());
    while (!item.isNull()) {
                // use item
                item =
    result.next();
            }
            if (result.hasError()) {
                /*
    Runtime error! */
            }
        }

    An effect of letting **next** () produce the sequence by lazy evaluation is
    that a query error can occur on any call to **next** (). If an error occurs,
    both **next** () and **current** () will return the null **QXmlItem** , and
    **hasError** () will return true.

    QXmlResultItems can be thought of as an "iterator" that traverses the
    sequence of query results once, in the forward direction. Each call to
    **next** () advances the iterator to the next **QXmlItem**  in the sequence
    and returns it, and **current** () always returns the **QXmlItem**  that
    **next** () returned the last time it was called.

    **Note:** When using the QXmlResultItems overload of
    **QXmlQuery::evaluateTo** () to execute a query, it is advisable to create a
    new instance of this class for each new set of results rather than reusing
    an old instance.

    **See also** **QXmlItem::isNode** (), **QXmlItem::isAtomicValue** (), and
    **QXmlNodeModelIndex** .
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlresultitems.html#QXmlResultItems

        **QXmlResultItems::QXmlResultItems()**

        Constructs an instance of QXmlResultItems.
        """
        ...

    def current(self) -> QXmlItem:
        """
        https://doc.qt.io/qt-5/qxmlresultitems.html#current

        **QXmlItem QXmlResultItems::current() const**

        Returns the current item. The current item is the last item that was
        produced and returned by **next** ().

        Returns a null **QXmlItem**  if there is no associated **QXmlQuery** .
        """
        ...

    def next(self) -> QXmlItem:
        """
        https://doc.qt.io/qt-5/qxmlresultitems.html#next

        **QXmlItem QXmlResultItems::next()**

        Returns the next result in the sequence produced by lazy evaluation of
        the associated query. When the returned **QXmlItem**  is null, either
        the evaluation terminated normally without producing another result, or
        an error occurred. Call **hasError** () to determine whether the null
        item was caused by normal termination or by an error.

        Returns a null **QXmlItem**  if there is no associated **QXmlQuery** .
        """
        ...

    def hasError(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlresultitems.html#hasError

        **bool QXmlResultItems::hasError() const**

        If an error occurred during evaluation of the query, true is returned.

        Returns false if query evaluation has been done.
        """
        ...
