"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtNetwork
from PyQt5 import QtCore
from PyQt5.QtXmlPatterns import *
from PyQt5 import sip


class QXmlQuery(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlquery.html

    **Detailed Description**

    The QXmlQuery class compiles and executes queries written in the **XQuery
    language** . QXmlQuery is typically used to query XML data, but it can also
    query non-XML data that has been modeled to look like XML.

    Using QXmlQuery to query XML data, as in the snippet below, is simple
    because it can use the built-in **XML data model**  as its delegate to the
    underlying query engine for traversing the data. The built-in data model is
    specified in **XQuery 1.0 and XPath 2.0 Data Model** .

    **QXmlQuery**  query;
    query.setQuery("doc('index.html')/html/body/p[1]");
    **QXmlSerializer**  serializer(query, myOutputDevice);
    query.evaluateTo(&serializer);

    The example uses QXmlQuery to match the first paragraph of an XML document
    and then **output the result**  to a device as XML.

    Using QXmlQuery to query **non-XML** data requires writing a subclass of
    **QAbstractXmlNodeModel**  to use as a replacement for the built-in XML data
    model. The custom data model will be able to traverse the non-XML data as
    required by the **QAbstractXmlNodeModel**  interface. An instance of this
    custom data model then becomes the delegate used by the query engine to
    traverse the non-XML data. For an example of how to use QXmlQuery to query
    non-XML data, see the documentation for **QAbstractXmlNodeModel** .

    **Running XQueries**

    To run a query set up with QXmlQuery, call one of the evaluation functions.

    * **evaluateTo** (**QAbstractXmlReceiver**  *) is called with a pointer to
    an XML **receiver** , which receives the query results as a sequence of
    callbacks. The receiver callback class is like the callback class used for
    translating the output of a SAX parser. **QXmlSerializer** , for example, is
    a receiver callback class for translating the sequence of callbacks for
    output as unformatted XML text.

    * **evaluateTo** (**QXmlResultItems**  *) is called with a pointer to an
    iterator for an empty sequence of query **result items** . The Java-like
    iterator allows the query results to be accessed sequentially.

    * **evaluateTo** (**QStringList**  *) is like **evaluateTo**
    (**QXmlResultItems**  *), but the query must evaluate to a sequence of
    strings.

    **Running XPath Expressions**

    The XPath language is a subset of the **XQuery**  language, so running an
    XPath expression is the same as running an **XQuery**  query. Pass the XPath
    expression to QXmlQuery using **setQuery** ().

    **Running XSLT Stylesheets**

    Running an XSLT stylesheet is like running an **XQuery** , except that when
    you construct your QXmlQuery, you must pass **QXmlQuery::XSLT20**  to tell
    QXmlQuery to interpret whatever it gets from **setQuery** () as an XSLT
    stylesheet instead of as an **XQuery** . You must also set the input
    document by calling **setFocus** ().

    **QXmlQuery**  query(**QXmlQuery** ::XSLT20);
    query.setFocus(**QUrl** ("myInput.xml"));
            query.setQuery(**QUrl**
    ("myStylesheet.xsl"));
            query.evaluateTo(out);

    **Note:** Currently, **setFocus** () must be called **before** **setQuery**
    () when using XSLT.

    Another way to run an XSLT stylesheet is to use the `xmlpatterns` command
    line utility.

    xmlpatterns myStylesheet.xsl myInput.xml

    **Note:** For the current release, XSLT support should be considered
    experimental. See section **XSLT conformance**  for details.

    Stylesheet parameters are bound using **bindVariable** ().

    **Binding A Query To A Starting Node**

    When a query is run on XML data, as in the snippet above, the `doc()`
    function returns the node in the built-in data model where the query
    evaluation will begin. But when a query is run on a custom node model
    containing non-XML data, one of the **bindVariable** () functions must be
    called to bind a variable name to a starting node in the custom model. A
    $variable reference is used in the **XQuery**  text to access the starting
    node in the custom model. It is not necessary to declare the variable name
    external in the query. See the example in the documentation for
    **QAbstractXmlNodeModel** .

    **Reentrancy and Thread-Safety**

    QXmlQuery is reentrant but not thread-safe. It is safe to use the QxmlQuery
    copy constructor to create a copy of a query and run the same query multiple
    times. Behind the scenes, QXmlQuery will reuse resources such as opened
    files and compiled queries to the extent possible. But it is not safe to use
    the same instance of QXmlQuery in multiple threads.

    **Error Handling**

    Errors can occur during query evaluation. Examples include type errors and
    file loading errors. When an error occurs:

    * The error message is sent to the **messageHandler** ().
      *
    **QXmlResultItems::hasError** () will return `true`, or **evaluateTo** ()
    will return `false`;
      * The results of the evaluation are undefined.

    **Resource Management**

    When a query runs, it parses documents, allocating internal data structures
    to hold them, and it may load other resources over the network. It reuses
    these allocated resources when possible, to avoid having to reload and
    reparse them.

    When **setQuery** () is called, the query text is compiled into an internal
    data structure and optimized. The optimized form can then be reused for
    multiple evaluations of the query. Since the compile-and-optimize process
    can be expensive, repeating it for the same query should be avoided by using
    a separate instance of QXmlQuery for each query text.

    Once a document has been parsed, its internal representation is maintained
    in the QXmlQuery instance and shared among multiple QXmlQuery instances.

    An instance of **QCoreApplication**  must exist before QXmlQuery can be
    used.

    **Event Handling**

    When QXmlQuery accesses resources (e.g., calling `fn:doc()` to load a file,
    or accessing a device via a bound variable), the event loop is used, which
    means events will be processed. To avoid processing events when QXmlQuery
    accesses resources, create your QXmlQuery instance in a separate thread.
    """

    class QueryLanguage(int):
        XQuery10: QXmlQuery = ...
        XSLT20: QXmlQuery = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#QXmlQuery

        **QXmlQuery::QXmlQuery()**

        Constructs an invalid, empty query that cannot be used until
        **setQuery** () is called.

        **Note:** This constructor must not be used if you intend to use this
        QXmlQuery to process XSL-T stylesheets. The other constructor must be
        used in that case.
        """
        ...

    @typing.overload
    def __init__(self, other: "QXmlQuery") -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#QXmlQuery-1

        **QXmlQuery::QXmlQuery(const QXmlQuery & other )**

        Constructs a QXmlQuery that is a copy of **other**. The new instance
        will share resources with the existing query to the extent possible.
        """
        ...

    @typing.overload
    def __init__(self, np: QXmlNamePool) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#QXmlQuery-2

        **QXmlQuery::QXmlQuery(const QXmlNamePool & np )**

        Constructs a query that will use **np** as its name pool. The query
        cannot be evaluated until **setQuery** () has been called.
        """
        ...

    @typing.overload
    def __init__(
        self, queryLanguage: "QXmlQuery.QueryLanguage", pool: QXmlNamePool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#QXmlQuery-3

        **QXmlQuery::QXmlQuery(QXmlQuery::QueryLanguage queryLanguage , const
        QXmlNamePool & np = QXmlNamePool())**

        Constructs a query that will be used to run Xqueries or XSL-T
        stylesheets, depending on the value of **queryLanguage**. It will use
        **np** as its name pool.

        **Note:** If your QXmlQuery will process XSL-T stylesheets, this
        constructor must be used. The default constructor can only create
        instances of QXmlQuery for running XQueries.

        **Note:** The XSL-T support in this release is considered experimental.
        See the **XSLT conformance**  for details.

        This function was introduced in Qt 4.5.

        **See also** **queryLanguage** ().
        """
        ...

    def queryLanguage(self) -> "QXmlQuery.QueryLanguage":
        """
        https://doc.qt.io/qt-5/qxmlquery.html#queryLanguage

        **QXmlQuery::QueryLanguage QXmlQuery::queryLanguage() const**

        Returns a value indicating what this **QXmlQuery**  is being used for.
        The default is **QXmlQuery::XQuery10** , which means the **QXmlQuery**
        is being used for running **XQuery**  and XPath queries.
        **QXmlQuery::XSLT20**  can also be returned, which indicates the
        **QXmlQuery**  is for running XSL-T spreadsheets.

        This function was introduced in Qt 4.5.
        """
        ...

    def networkAccessManager(self) -> QtNetwork.QNetworkAccessManager:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#networkAccessManager

        **QNetworkAccessManager *QXmlQuery::networkAccessManager() const**

        Returns the network manager, or 0 if it has not been set.

        This function was introduced in Qt 4.5.

        **See also** **setNetworkAccessManager** ().
        """
        ...

    def setNetworkAccessManager(
        self, newManager: QtNetwork.QNetworkAccessManager
    ) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#setNetworkAccessManager

        **void QXmlQuery::setNetworkAccessManager(QNetworkAccessManager *
        newManager )**

        Sets the network manager to **newManager**. **QXmlQuery**  does not take
        ownership of **newManager**.

        This function was introduced in Qt 4.5.

        **See also** **networkAccessManager** ().
        """
        ...

    def initialTemplateName(self) -> QXmlName:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#initialTemplateName

        **QXmlName QXmlQuery::initialTemplateName() const**

        Returns the name of the XSL-T stylesheet template that the processor
        will call first when running an XSL-T stylesheet. This function only
        applies when using **QXmlQuery**  to process XSL-T stylesheets. By
        default, no initial template is set. In that case, a default constructed
        **QXmlName**  is returned.

        This function was introduced in Qt 4.5.

        **See also** **setInitialTemplateName** ().
        """
        ...

    @typing.overload
    def setInitialTemplateName(self, name: QXmlName) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#setInitialTemplateName

        **void QXmlQuery::setInitialTemplateName(const QXmlName & name )**

        Sets the **name** of the initial template. The initial template is the
        one the processor calls first, instead of attempting to match a template
        to the context node (if any). If an initial template is not set, the
        standard order of template invocation will be used.

        This function only applies when using **QXmlQuery**  to process XSL-T
        stylesheets. The name becomes part of the compiled stylesheet.
        Therefore, this function must be called before calling **setQuery** ().

        If the stylesheet has no template named **name** , the processor will
        use the standard order of template invocation.

        This function was introduced in Qt 4.5.

        **See also** **initialTemplateName** ().
        """
        ...

    @typing.overload
    def setInitialTemplateName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#setInitialTemplateName-1

        **void QXmlQuery::setInitialTemplateName(const QString & localName )**

        This is an overloaded function.

        Sets the name of the initial template to **localName** , which must be a
        valid **local name** . The initial template is the one the processor
        calls first, instead of attempting to match a template to the context
        node (if any). If an initial template is not set, the standard order of
        template invocation will be used.

        This function only applies when using **QXmlQuery**  to process XSL-T
        stylesheets. The name becomes part of the compiled stylesheet.
        Therefore, this function must be called before calling **setQuery** ().

        If **localName** is not a valid **local name** , the effect is
        undefined. If the stylesheet has no template named **localName** , the
        processor will use the standard order of template invocation.

        This function was introduced in Qt 4.5.

        **See also** **initialTemplateName** ().
        """
        ...

    @typing.overload
    def setFocus(self, item: QXmlItem) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#setFocus

        **void QXmlQuery::setFocus(const QXmlItem & item )**

        Sets the focus to **item**. The focus is the set of items that the
        context item expression and path expressions navigate from. For example,
        in the expression **p/span** , the element that **p** evaluates to is
        the focus for the following expression, **span**.

        The focus can be accessed using the context item expression, i.e., dot
        (".").

        By default, the focus is not set and is undefined. It will therefore
        result in a dynamic error, `XPDY0002`, if the focus is attempted to be
        accessed. The focus must be set before the query is set with
        **setQuery** ().

        There is no behavior defined for setting an item which is null.
        """
        ...

    @typing.overload
    def setFocus(self, documentURI: QtCore.QUrl) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#setFocus-1

        **bool QXmlQuery::setFocus(const QUrl & documentURI )**

        This is an overloaded function.

        Sets the focus to be the document located at **documentURI** and returns
        true. If **documentURI** cannot be loaded, false is returned. It is
        undefined at what time the document may be loaded. When loading the
        document, the message handler and URI resolver set on this **QXmlQuery**
        are used.

        If **documentURI** is empty or is not a valid URI, the behavior of this
        function is undefined.

        This function was introduced in Qt 4.5.
        """
        ...

    @typing.overload
    def setFocus(self, document: QtCore.QIODevice) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#setFocus-2

        **bool QXmlQuery::setFocus(QIODevice * document )**

        Sets the focus to be the **document** read from the **QIODevice**  and
        returns true. If **document** cannot be loaded, false is returned.

        **QXmlQuery**  does not take ownership of **document**. The user
        guarantees that a document is available from the **document** device and
        that the document is not empty. The device must be opened in at least
        read-only mode. **document** must stay in scope as long as the current
        query is active.

        This is an overloaded function.

        This function was introduced in Qt 4.5.
        """
        ...

    @typing.overload
    def setFocus(self, focus: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#setFocus-3

        **bool QXmlQuery::setFocus(const QString & focus )**

        This function behaves identically to calling the setFocus() overload
        with a **QIODevice**  whose content is **focus** encoded as UTF-8. That
        is, **focus** is treated as if it contained an XML document.

        Returns the same result as the overload.

        This is an overloaded function.

        This function was introduced in Qt 4.6.
        """
        ...

    def uriResolver(self) -> QAbstractUriResolver:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#uriResolver

        **const QAbstractUriResolver *QXmlQuery::uriResolver() const**

        Returns the query's URI resolver. If no URI resolver has been set, Qt
        XML Patterns will use the URIs in queries as they are.

        The URI resolver provides a level of abstraction, or **polymorphic
        URIs**. A resolver can rewrite **logical** URIs to physical ones, or it
        can translate obsolete or invalid URIs to valid ones.

        Qt XML Patterns calls the URI resolver for all URIs it encounters,
        except for namespaces. Specifically, all builtin functions that deal
        with URIs (`fn:doc()`, and `fn:doc-available()`).

        In the case of `fn:doc()`, the absolute URI is the base URI in the
        static context (which most likely is the location of the query). Rather
        than use the URI the user specified, the return value of
        **QAbstractUriResolver::resolve** () will be used.

        When Qt XML Patterns calls **QAbstractUriResolver::resolve** () the
        absolute URI is the URI mandated by the **XQuery**  language, and the
        relative URI is the URI specified by the user.

        **See also** **setUriResolver** ().
        """
        ...

    def setUriResolver(self, resolver: QAbstractUriResolver) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#setUriResolver

        **void QXmlQuery::setUriResolver(const QAbstractUriResolver * resolver
        )**

        Sets the URI resolver to **resolver**. **QXmlQuery**  does not take
        ownership of **resolver**.

        **See also** **uriResolver** ().
        """
        ...

    def evaluateToString(self) -> str:
        ...

    def evaluateToStringList(self) -> typing.List[str]:
        ...

    @typing.overload
    def evaluateTo(self, result: "QXmlResultItems") -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#evaluateTo

        **void QXmlQuery::evaluateTo(QXmlResultItems * result ) const**

        Starts the evaluation and makes it available in **result**. If
        **result** is null, the behavior is undefined. The evaluation takes
        place incrementally (lazy evaluation), as the caller uses
        **QXmlResultItems::next** () to get the next result.

        **See also** **QXmlResultItems::next** ().
        """
        ...

    @typing.overload
    def evaluateTo(self, callback: QAbstractXmlReceiver) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#evaluateTo-1

        **bool QXmlQuery::evaluateTo(QAbstractXmlReceiver * callback ) const**

        Evaluates this query and sends the result as a sequence of callbacks to
        the **receiver**  **callback**. **QXmlQuery**  does not take ownership
        of **callback**.

        If an error occurs during the evaluation, error messages are sent to
        **messageHandler** () and `false` is returned.

        If this query **is invalid** , `false` is returned and the behavior is
        undefined. If **callback** is null, behavior is undefined.

        **See also** **QAbstractXmlReceiver**  and **isValid** ().
        """
        ...

    @typing.overload
    def evaluateTo(self, target: QtCore.QIODevice) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#evaluateTo-2

        **bool QXmlQuery::evaluateTo(QStringList * target ) const**

        Attempts to evaluate the query and returns the results in the **target**
        **string list** .

        If the query **is valid**  and the evaluation succeeds, true is
        returned. Otherwise, false is returned and the contents of **target**
        are undefined.

        The query must evaluate to a sequence of `xs:string` values. If the
        query does not evaluate to a sequence of strings, the values can often
        be converted by adding a call to `string()` at the end of the **XQuery**
        .

        If **target** is null, the behavior is undefined.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#isValid

        **bool QXmlQuery::isValid() const**

        Returns true if this query is valid. Examples of invalid queries are
        ones that contain syntax errors or that have not had **setQuery** ()
        called for them yet.
        """
        ...

    @typing.overload
    def bindVariable(self, name: QXmlName, value: QXmlItem) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#bindVariable

        **void QXmlQuery::bindVariable(const QXmlName & name , const QXmlItem &
        value )**

        Binds the variable **name** to the **value** so that $ **name** can be
        used from within the query to refer to the **value**.

        **name** must not be **null**. **name**.isNull() must return false. If
        **name** has already been bound by a previous bindVariable() call, its
        previous binding will be overridden.

        If **value** is null so that **value**.isNull() returns true, and
        **name** already has a binding, the effect is to remove the existing
        binding for **name**.

        To bind a value of type **QString**  or **QUrl** , wrap the value in a
        **QVariant**  such that **QXmlItem** 's **QVariant**  constructor is
        called.

        All strings processed by the query must be valid **XQuery**  strings,
        which means they must contain only XML 1.0 characters. However, this
        requirement is not checked. If the query processes an invalid string,
        the behavior is undefined.

        **See also** **QVariant::isValid** (), **How QVariant maps to XQuery's
        Data Model** , and **QXmlItem::isNull** ().
        """
        ...

    @typing.overload
    def bindVariable(self, name: QXmlName, a1: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#bindVariable-1

        **void QXmlQuery::bindVariable(const QString & localName , const
        QXmlItem & value )**

        This is an overloaded function.

        This function constructs a **QXmlName**  from **localName** using the
        query's **namespace** . The function then behaves as the overloaded
        function. It is equivalent to the following snippet.

        **QXmlNamePool**  namePool(query.namePool());
        query.bindVariable(**QXmlName** (namePool, localName), value);
        """
        ...

    @typing.overload
    def bindVariable(self, name: QXmlName, query: "QXmlQuery") -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#bindVariable-2

        **void QXmlQuery::bindVariable(const QXmlName & name , QIODevice *
        device )**

        Binds the variable **name** to the **device** so that $ **name** can be
        used from within the query to refer to the **device**. The **QIODevice**
        **device** is exposed to the query as a URI of type `xs:anyURI`, which
        can be passed to the `fn:doc()` function to be read. E.g., this function
        can be used to pass an XML document in memory to `fn:doc`.

        **QByteArray**  myDocument;
                **QBuffer**  buffer(&myDocument); //
        This is a QIODevice.
                buffer.open(**QIODevice** ::ReadOnly);
        **QXmlQuery**  query;
                query.bindVariable("myDocument", &buffer);
        query.setQuery("doc($myDocument)");

        The caller must ensure that **device** has been opened with at least
        **QIODevice::ReadOnly**  prior to this binding. Otherwise, behavior is
        undefined.

        If the query will access an XML document contained in a **QString** ,
        use a **QBuffer**  as shown in the following snippet. Suppose
        **myQString** contains `<document>content</document>`

        **QBuffer**  device;
                device.setData(myQString.toUtf8());
        device.open(**QIODevice** ::ReadOnly);

                **QXmlQuery**
        query;
                query.setQuery("doc($inputDocument)/query[theDocument]");
        query.bindVariable("inputDocument", &device);

        **name** must not be **null**. **name**.isNull() must return false. If
        **name** has already been bound, its previous binding will be
        overridden. The URI that **name** evaluates to is arbitrary and may
        change.

        If the type of the variable binding changes (e.g., if a previous binding
        by the same name was a **QVariant** , or if there was no previous
        binding), **isValid** () will return `false`, and recompilation of the
        query text is required. To recompile the query, call **setQuery** ().
        For this reason, bindVariable() should be called before **setQuery** (),
        if possible.

        **Note:** **device** must not be deleted while this **QXmlQuery**
        exists.
        """
        ...

    @typing.overload
    def bindVariable(self, localName: str, value: QXmlItem) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#bindVariable-3

        **void QXmlQuery::bindVariable(const QString & localName , QIODevice *
        device )**

        This is an overloaded function.

        If **localName** is a valid **NCName** , this function is equivalent to
        the following snippet.

        **QXmlNamePool**  namePool(query.namePool());
        query.bindVariable(**QXmlName** (namePool, localName), device);

        A **QXmlName**  is constructed from **localName** , and is passed to the
        appropriate overload along with **device**.

        **See also** **QXmlName::isNCName** ().
        """
        ...

    @typing.overload
    def bindVariable(self, localName: str, a1: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#bindVariable-4

        **void QXmlQuery::bindVariable(const QXmlName & name , const QXmlQuery &
        query )**

        Binds the result of the query **query** , to a variable by name
        **name**.

        Evaluation of **query** will be commenced when this function is called.

        If **query** is invalid, behavior is undefined. **query** will be
        copied.

        This function was introduced in Qt 4.5.

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def bindVariable(self, localName: str, query: "QXmlQuery") -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#bindVariable-5

        **void QXmlQuery::bindVariable(const QString & localName , const
        QXmlQuery & query )**

        This is an overloaded function.

        Has the same behavior and effects as the function being overloaded, but
        takes the variable name **localName** as a **QString** . **query** is
        used as in the overloaded function.

        This function was introduced in Qt 4.5.
        """
        ...

    def namePool(self) -> QXmlNamePool:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#namePool

        **QXmlNamePool QXmlQuery::namePool() const**

        Returns the name pool used by this **QXmlQuery**  for constructing
        **names** . There is no setter for the name pool, because mixing name
        pools causes errors due to name confusion.
        """
        ...

    @typing.overload
    def setQuery(self, sourceCode: str, documentUri: QtCore.QUrl = ...) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#setQuery

        **void QXmlQuery::setQuery(QIODevice * sourceCode , const QUrl &
        documentURI = QUrl())**

        Sets this **QXmlQuery**  to an **XQuery**  read from the **sourceCode**
        device. The device must have been opened with at least
        **QIODevice::ReadOnly** .

        **documentURI** represents the query obtained from the **sourceCode**
        device. It is the base URI of the static context, as defined in the
        **XQuery language** . It is used internally to resolve relative URIs
        that appear in the query, and for message reporting. **documentURI** can
        be empty. If it is empty, the **application file path**  is used. If it
        is not empty, it may be either relative or absolute. If it is relative,
        it is resolved itself against the **application file path**  before it
        is used. If **documentURI** is neither a valid URI nor empty, the result
        is undefined.

        If the query contains a static error (e.g. syntax error), an error
        message is sent to the **messageHandler** (), and **isValid** () will
        return **false**.

        Variables must be bound before setQuery() is called.

        The encoding of the **XQuery**  in **sourceCode** is detected internally
        using the rules for setting and detecting encoding of **XQuery**  files,
        which are explained in the **XQuery language** .

        If **sourceCode** is `null` or not readable, or if **documentURI** is
        not a valid URI, behavior is undefined.

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def setQuery(
        self, sourceCode: QtCore.QIODevice, documentUri: QtCore.QUrl = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#setQuery-1

        **void QXmlQuery::setQuery(const QString & sourceCode , const QUrl &
        documentURI = QUrl())**

        This is an overloaded function.

        The behavior and requirements of this function are the same as for
        setQuery(**QIODevice** *, const **QUrl** &), after the **XQuery**  has
        been read from the IO device into a string. Because **sourceCode** is
        already a Unicode string, detection of its encoding is unnecessary.
        """
        ...

    @typing.overload
    def setQuery(self, queryURI: QtCore.QUrl, baseUri: QtCore.QUrl = ...) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#setQuery-2

        **void QXmlQuery::setQuery(const QUrl & queryURI , const QUrl & baseURI
        = QUrl())**

        Sets this **QXmlQuery**  to the **XQuery**  read from the **queryURI**.
        Use **isValid** () after calling this function. If an error occurred
        reading **queryURI** , e.g., the query does not exist, cannot be read,
        or is invalid, **isValid** () will return **false**.

        The supported URI schemes are the same as those in the **XQuery**
        function `fn:doc`, except that queryURI can be the object of a variable
        binding.

        **baseURI** is the Base URI of the static context, as defined in the
        **XQuery language** . It is used internally to resolve relative URIs
        that appear in the query, and for message reporting. If **baseURI** is
        empty, **queryURI** is used. Otherwise, **baseURI** is used, and it is
        resolved against the **application file path**  if it is relative.

        If **queryURI** is empty or invalid, or if **baseURI** is invalid, the
        behavior of this function is undefined.
        """
        ...

    def messageHandler(self) -> QAbstractMessageHandler:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#messageHandler

        **QAbstractMessageHandler *QXmlQuery::messageHandler() const**

        Returns the message handler that handles compile and runtime messages
        for this **QXmlQuery** .

        **See also** **setMessageHandler** ().
        """
        ...

    def setMessageHandler(self, messageHandler: QAbstractMessageHandler) -> None:
        """
        https://doc.qt.io/qt-5/qxmlquery.html#setMessageHandler

        **void QXmlQuery::setMessageHandler(QAbstractMessageHandler *
        aMessageHandler )**

        Changes the **message handler**  for this **QXmlQuery**  to
        **aMessageHandler**. The query sends all compile and runtime messages to
        this message handler. **QXmlQuery**  does not take ownership of
        **aMessageHandler**.

        Normally, the default message handler is sufficient. It writes compile
        and runtime messages to **stderr**. The default message handler includes
        color codes if **stderr** can render colors.

        Note that changing the message handler after the query has been compiled
        has no effect, i.e. the query uses the same message handler at runtime
        that it uses at compile time.

        When **QXmlQuery**  calls **QAbstractMessageHandler::message** (), the
        arguments are as follows:

        message() argumentSemantics
        **QtMsgType**  typeOnly **QtWarningMsg**
        and **QtFatalMsg**  are used. The former identifies a compile or runtime
        warning, while the latter identifies a dynamic or static error.
        const
        **QString**  & descriptionAn XHTML document which is the actual message.
        It is translated into the current language.
        const **QUrl**
        &identifierIdentifies the error with a URI, where the fragment is the
        error code, and the rest of the URI is the error namespace.
        const
        **QSourceLocation**  & sourceLocationIdentifies where the error
        occurred.

        **See also** **messageHandler** ().
        """
        ...
