"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtXmlPatterns import *


class QXmlFormatter(QXmlSerializer):
    """
    https://doc.qt.io/qt-5/qxmlformatter.html

    **Detailed Description**

    QXmlFormatter is a subclass of **QXmlSerializer**  that formats the XML
    output to make it easier for humans to read.

    **QXmlSerializer**  outputs XML without adding unnecessary whitespace. In
    particular, it does not add **newlines** and indentation. To make the XML
    output easier to read, QXmlFormatter adds **newlines** and indentation by
    adding, removing, and modifying **sequence nodes**  that only consist of
    whitespace. It also modifies whitespace in other places where it is not
    significant; e.g., between attributes and in the document prologue.

    For example, where the base class **QXmlSerializer**  would output this:

    <a><b/><c/><p>Some Text</p></a>

    QXmlFormatter outputs this:

    <a>
           <b/>
           <c/>
           <p>Some Text</p>
        </a>

    If you just want to serialize your XML in a human-readable format, use
    QXmlFormatter as it is. The default indentation level is 4 spaces, but you
    can set your own indentation value **setIndentationDepth** ().

    The **newlines** and indentation added by QXmlFormatter are suitable for
    common formats, such as XHTML, SVG, or Docbook, where whitespace is not
    significant. However, if your XML will be used as input where whitespace is
    significant, then you must write your own subclass of **QXmlSerializer**  or
    **QAbstractXmlReceiver** .

    Note that using QXmlFormatter instead of **QXmlSerializer**  will increase
    computational overhead and document storage size due to the insertion of
    whitespace.

    Note also that the indentation style used by QXmlFormatter remains loosely
    defined and may change in future versions of Qt. If a specific indentation
    style is required then either use the base class **QXmlSerializer**
    directly, or write your own subclass of **QXmlSerializer**  or
    **QAbstractXmlReceiver** . Alternatively, you can subclass QXmlFormatter and
    reimplement the callbacks there.

    **QXmlQuery**  query;
    query.setQuery("doc('index.html')/html/body/p[1]");
    **QXmlFormatter**  formatter(query, myOutputDevice);
    formatter.setIndentationDepth(2);
        query.evaluateTo(&formatter);
    """

    def __init__(self, query: "QXmlQuery", outputDevice: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#QXmlFormatter

        **QXmlFormatter::QXmlFormatter(const QXmlQuery & query , QIODevice *
        outputDevice )**

        Constructs a formatter that uses the name pool and message handler in
        **query** , and writes the result to **outputDevice** as formatted XML.

        **outputDevice** is passed directly to **QXmlSerializer** 's
        constructor.

        **See also** **QXmlSerializer** .
        """
        ...

    def setIndentationDepth(self, depth: int) -> None:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#setIndentationDepth

        **void QXmlFormatter::setIndentationDepth(int depth )**

        Sets **depth** to be the number of spaces **QXmlFormatter**  will output
        for level of indentation. The default is four.

        **See also** **indentationDepth** ().
        """
        ...

    def indentationDepth(self) -> int:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#indentationDepth

        **int QXmlFormatter::indentationDepth() const**

        Returns the number of spaces **QXmlFormatter**  will output for each
        indentation level. The default is four.

        **See also** **setIndentationDepth** ().
        """
        ...

    def endOfSequence(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#endOfSequence

        **[override virtual] void QXmlFormatter::endOfSequence()**

        Reimplements: **QXmlSerializer::endOfSequence** ().
        """
        ...

    def startOfSequence(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#startOfSequence

        **[override virtual] void QXmlFormatter::startOfSequence()**

        Reimplements: **QXmlSerializer::startOfSequence** ().
        """
        ...

    def endDocument(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#endDocument

        **[override virtual] void QXmlFormatter::endDocument()**

        Reimplements: **QXmlSerializer::endDocument** ().
        """
        ...

    def startDocument(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#startDocument

        **[override virtual] void QXmlFormatter::startDocument()**

        Reimplements: **QXmlSerializer::startDocument** ().
        """
        ...

    def atomicValue(self, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#atomicValue

        **[override virtual] void QXmlFormatter::atomicValue(const QVariant &
        value )**

        Reimplements: **QXmlSerializer::atomicValue** (const QVariant &value).
        """
        ...

    def processingInstruction(self, name: "QXmlName", value: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#processingInstruction

        **[override virtual] void QXmlFormatter::processingInstruction(const
        QXmlName & name , const QString & value )**

        Reimplements: **QXmlSerializer::processingInstruction** (const QXmlName
        &name, const QString &value).
        """
        ...

    def attribute(self, name: "QXmlName", value: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#attribute

        **[override virtual] void QXmlFormatter::attribute(const QXmlName & name
        , const QStringRef & value )**

        Reimplements: **QXmlSerializer::attribute** (const QXmlName &name, const
        QStringRef &value).
        """
        ...

    def endElement(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#endElement

        **[override virtual] void QXmlFormatter::endElement()**

        Reimplements: **QXmlSerializer::endElement** ().
        """
        ...

    def startElement(self, name: "QXmlName") -> None:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#startElement

        **[override virtual] void QXmlFormatter::startElement(const QXmlName &
        name )**

        Reimplements: **QXmlSerializer::startElement** (const QXmlName &name).
        """
        ...

    def comment(self, value: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#comment

        **[override virtual] void QXmlFormatter::comment(const QString & value
        )**

        Reimplements: **QXmlSerializer::comment** (const QString &value).
        """
        ...

    def characters(self, value: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlformatter.html#characters

        **[override virtual] void QXmlFormatter::characters(const QStringRef &
        value )**

        Reimplements: **QXmlSerializer::characters** (const QStringRef &value).
        """
        ...
