"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5 import sip


class QSourceLocation(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qsourcelocation.html

    **Detailed Description**

    QSourceLocation is a simple value based class that has three properties,
    **uri** (), **line** (), and **column** (), that, taken together, identify a
    certain point in a resource, e.g., a file or an in-memory document.

    **line** () and **column** () refer to character counts (not byte counts),
    and they both start from 1, as opposed to 0.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsourcelocation.html#QSourceLocation

        **QSourceLocation::QSourceLocation()**

        Construct a QSourceLocation that doesn't identify anything at all.

        For a default constructed QSourceLocation(), **isNull** () returns
        `true`.
        """
        ...

    @typing.overload
    def __init__(self, other: "QSourceLocation") -> None:
        """
        https://doc.qt.io/qt-5/qsourcelocation.html#QSourceLocation-1

        **QSourceLocation::QSourceLocation(const QSourceLocation & other )**

        Constructs a QSourceLocation that is a copy of **other**.
        """
        ...

    @typing.overload
    def __init__(self, u: QtCore.QUrl, line: int = ..., column: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsourcelocation.html#QSourceLocation-2

        **QSourceLocation::QSourceLocation(const QUrl & u , int l = -1, int c =
        -1)**

        Constructs a QSourceLocation with URI **u** , line **l** and column
        **c**.
        """
        ...

    def __hash__(self) -> int:
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsourcelocation.html#isNull

        **bool QSourceLocation::isNull() const**

        Returns `true` if this **QSourceLocation**  doesn't identify anything.

        For a default constructed **QSourceLocation** , this function returns
        `true`. The same applies for any other **QSourceLocation**  whose
        **uri** () is invalid.
        """
        ...

    def setUri(self, newUri: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-5/qsourcelocation.html#setUri

        **void QSourceLocation::setUri(const QUrl & newUri )**

        Sets the URI to **newUri**.

        **See also** **uri** ().
        """
        ...

    def uri(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qsourcelocation.html#uri

        **QUrl QSourceLocation::uri() const**

        Returns the resource that this **QSourceLocation**  refers to. For
        example, the resource could be a file in the local file system, if the
        URI scheme is `file`.

        **See also** **setUri** ().
        """
        ...

    def setLine(self, newLine: int) -> None:
        """
        https://doc.qt.io/qt-5/qsourcelocation.html#setLine

        **void QSourceLocation::setLine(qint64 newLine )**

        Sets the line number to **newLine**. 0 is an invalid line number. The
        first line number is 1.

        **See also** **line** ().
        """
        ...

    def line(self) -> int:
        """
        https://doc.qt.io/qt-5/qsourcelocation.html#line

        **qint64 QSourceLocation::line() const**

        Returns the current line number. The first line number is 1, not 0. The
        default value is -1, indicating the line number is unknown.

        **See also** **setLine** ().
        """
        ...

    def setColumn(self, newColumn: int) -> None:
        """
        https://doc.qt.io/qt-5/qsourcelocation.html#setColumn

        **void QSourceLocation::setColumn(qint64 newColumn )**

        Sets the column number to **newColumn**. 0 is an invalid column number.
        The first column number is 1.

        **See also** **column** ().
        """
        ...

    def column(self) -> int:
        """
        https://doc.qt.io/qt-5/qsourcelocation.html#column

        **qint64 QSourceLocation::column() const**

        Returns the current column number. The column number refers to the count
        of characters, not bytes. The first column is column 1, not 0. The
        default value is -1, indicating the column number is unknown.

        **See also** **setColumn** ().
        """
        ...
