"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtXmlPatterns import *


class QAbstractMessageHandler(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qabstractmessagehandler.html

    **Detailed Description**

    QAbstractMessageHandler is an abstract base class that provides a callback
    interface for handling messages. For example, class **QXmlQuery**  parses
    and runs an **XQuery** . When it detects a compile or runtime error, it
    generates an appropriate error message, but rather than output the message
    itself, it passes the message to the **message** () function of its
    QAbstractMessageHandler. See **QXmlQuery::setMessageHandler** ().

    You create a message handler by subclassing QAbstractMessageHandler and
    implementing **handleMessage** (). You then pass a pointer to an instance of
    your subclass to any classes that must generate messages. The messages are
    sent to the message handler via the **message** () function, which forwards
    them to your handleMessge().

    A single instance of QAbstractMessageHandler can be called on to handle
    messages from multiple sources. Hence, the content of a message, which is
    the **description** parameter passed to **message** () and **handleMessage**
    (), must be interpreted in light of the context that required the message to
    be sent. That context is specified by the **identifier** and
    **sourceLocation** parameters to **message** () **handleMessage** ().
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qabstractmessagehandler.html#QAbstractMessageHand
        ler

        **QAbstractMessageHandler::QAbstractMessageHandler(QObject * parent =
        nullptr)**

        Constructs a QAbstractMessageHandler. The **parent** is passed to the
        **QObject**  base class constructor.
        """
        ...

    def handleMessage(
        self,
        type: QtCore.QtMsgType,
        description: str,
        identifier: QtCore.QUrl,
        sourceLocation: "QSourceLocation",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractmessagehandler.html#handleMessage

        **[pure virtual protected] void
        QAbstractMessageHandler::handleMessage(QtMsgType type , const QString &
        description , const QUrl & identifier = QUrl(), const QSourceLocation &
        sourceLocation = QSourceLocation())**

        This function must be implemented by the sub-class. **message** () will
        call this function, passing in its parameters, **type** ,
        **description** , **identifier** and **sourceLocation** unmodified.

        This function can potentially be called from multiple threads. It's the
        reimplementation's responsibility to ensure thread safety.
        """
        ...

    def message(
        self,
        type: QtCore.QtMsgType,
        description: str,
        identifier: QtCore.QUrl = ...,
        sourceLocation: "QSourceLocation" = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractmessagehandler.html#message

        **void QAbstractMessageHandler::message(QtMsgType type , const QString &
        description , const QUrl & identifier = QUrl(), const QSourceLocation &
        sourceLocation = QSourceLocation())**

        Sends a message to this message handler. **type** is the kind of message
        being sent. **description** is the message content. The **identifier**
        is a URI that identifies the message and is the key to interpreting the
        other arguments.

        Typically, this class is used for reporting errors, as is the case for
        **QXmlQuery** , which uses a **QAbstractMessageHandler**  to report
        compile and runtime **XQuery**  errors. Hence, using a **QUrl**  as the
        message **identifier** is was inspired by the explanation of **error
        handling in the XQuery language** . Because the **identifier** is
        composed of a namespace URI and a local part, identifiers with the same
        local part are unique. The caller is responsible for ensuring that
        **identifier** is either a valid **QUrl**  or a default constructed
        **QUrl** .

        **sourceLocation** identifies a location in a resource (i.e., file or
        document) where the need for reporting a message was detected.

        This function unconditionally calls **handleMessage** (), passing all
        its parameters unmodified.

        **See also** <http://www.w3.org/TR/xquery/#errors>.
        """
        ...
