"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import sip


class QXmlParseException(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlparseexception.html

    **Detailed Description**

    The XML subsystem constructs an instance of this class when it detects an
    error. You can retrieve the place where the error occurred using
    **systemId** (), **publicId** (), **lineNumber** () and **columnNumber** (),
    along with the error **message** (). The possible error messages are:

    * "no error occurred"
      * "error triggered by consumer"
      * "unexpected end
    of file"
      * "more than one document type definition"
      * "error occurred
    while parsing element"
      * "tag mismatch"
      * "error occurred while parsing
    content"
      * "unexpected character"
      * "invalid name for processing
    instruction"
      * "version expected while reading the XML declaration"
      *
    "wrong value for standalone declaration"
      * "encoding declaration or
    standalone declaration expected while reading the XML declaration"
      *
    "standalone declaration expected while reading the XML declaration"
      *
    "error occurred while parsing document type definition"
      * "letter is
    expected"
      * "error occurred while parsing comment"
      * "error occurred
    while parsing reference"
      * "internal general entity reference not allowed
    in DTD"
      * "external parsed general entity reference not allowed in
    attribute value"
      * "external parsed general entity reference not allowed
    in DTD"
      * "unparsed entity reference n wrong context"
      * "recursive
    entities"
      * "error in the text declaration of an external entity"

    Note that, if you want to display these error messages to your application's
    users, they will be displayed in English unless they are explicitly
    translated.

    **See also** **QXmlErrorHandler**  and **QXmlReader** .
    """

    @typing.overload
    def __init__(
        self,
        name: str = ...,
        column: int = ...,
        line: int = ...,
        publicId: str = ...,
        systemId: str = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qxmlparseexception.html#QXmlParseException

        **QXmlParseException::QXmlParseException(const QString & name =
        QString(), int c = -1, int l = -1, const QString & p = QString(), const
        QString & s = QString())**

        Constructs a parse exception with the error string **name** for column
        **c** and line **l** for the public identifier **p** and the system
        identifier **s**.
        """
        ...

    @typing.overload
    def __init__(self, other: "QXmlParseException") -> None:
        """
        https://doc.qt.io/qt-5/qxmlparseexception.html#QXmlParseException-1

        **QXmlParseException::QXmlParseException(const QXmlParseException &
        other )**

        Creates a copy of **other**.
        """
        ...

    def message(self) -> str:
        """
        https://doc.qt.io/qt-5/qxmlparseexception.html#message

        **QString QXmlParseException::message() const**

        Returns the error message.
        """
        ...

    def systemId(self) -> str:
        """
        https://doc.qt.io/qt-5/qxmlparseexception.html#systemId

        **QString QXmlParseException::systemId() const**

        Returns the system identifier where the error occurred.
        """
        ...

    def publicId(self) -> str:
        """
        https://doc.qt.io/qt-5/qxmlparseexception.html#publicId

        **QString QXmlParseException::publicId() const**

        Returns the public identifier where the error occurred.
        """
        ...

    def lineNumber(self) -> int:
        """
        https://doc.qt.io/qt-5/qxmlparseexception.html#lineNumber

        **int QXmlParseException::lineNumber() const**

        Returns the line number where the error occurred.
        """
        ...

    def columnNumber(self) -> int:
        """
        https://doc.qt.io/qt-5/qxmlparseexception.html#columnNumber

        **int QXmlParseException::columnNumber() const**

        Returns the column number where the error occurred.
        """
        ...
