"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import sip


class QXmlLexicalHandler(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmllexicalhandler.html

    **Detailed Description**

    The events in the lexical handler apply to the entire document, not just to
    the document element, and all lexical handler events appear between the
    content handler's startDocument and endDocument events.

    You can set the lexical handler with **QXmlReader::setLexicalHandler** ().

    This interface's design is based on the SAX2 extension LexicalHandler.

    The interface provides the **startDTD** (), **endDTD** (), **startEntity**
    (), **endEntity** (), **startCDATA** (), **endCDATA** () and **comment** ()
    functions.

    **See also** **QXmlDTDHandler** , **QXmlDeclHandler** ,
    **QXmlContentHandler** , **QXmlEntityResolver** , **QXmlErrorHandler** , and
    Introduction to SAX2.
    """

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, a0: "QXmlLexicalHandler") -> None:
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qxmllexicalhandler.html#errorString

        **[pure virtual] QString QXmlLexicalHandler::errorString() const**

        The reader calls this function to get an error string if any of the
        handler functions returns `false`.
        """
        ...

    def comment(self, ch: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmllexicalhandler.html#comment

        **[pure virtual] bool QXmlLexicalHandler::comment(const QString & ch )**

        The reader calls this function to report an XML comment anywhere in the
        document. It reports the text of the comment in **ch**.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.
        """
        ...

    def endCDATA(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmllexicalhandler.html#endCDATA

        **[pure virtual] bool QXmlLexicalHandler::endCDATA()**

        The reader calls this function to report the end of a CDATA section.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.

        **See also** **startCDATA** () and **QXmlContentHandler::characters**
        ().
        """
        ...

    def startCDATA(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmllexicalhandler.html#startCDATA

        **[pure virtual] bool QXmlLexicalHandler::startCDATA()**

        The reader calls this function to report the start of a CDATA section.
        The content of the CDATA section is reported through the
        **QXmlContentHandler::characters** () function. This function is
        intended only to report the boundary.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.

        **See also** **endCDATA** ().
        """
        ...

    def endEntity(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmllexicalhandler.html#endEntity

        **[pure virtual] bool QXmlLexicalHandler::endEntity(const QString & name
        )**

        The reader calls this function to report the end of an entity called
        **name**.

        For every **startEntity** () call, there is a corresponding endEntity()
        call. The calls to **startEntity** () and endEntity() are properly
        nested.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.

        **See also** **startEntity** (), **QXmlContentHandler::skippedEntity**
        (), and **QXmlSimpleReader::setFeature** ().
        """
        ...

    def startEntity(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmllexicalhandler.html#startEntity

        **[pure virtual] bool QXmlLexicalHandler::startEntity(const QString &
        name )**

        The reader calls this function to report the start of an entity called
        **name**.

        Note that if the entity is unknown, the reader reports it through
        **QXmlContentHandler::skippedEntity** () and not through this function.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.

        **See also** **endEntity** () and **QXmlSimpleReader::setFeature** ().
        """
        ...

    def endDTD(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmllexicalhandler.html#endDTD

        **[pure virtual] bool QXmlLexicalHandler::endDTD()**

        The reader calls this function to report the end of a DTD declaration,
        if any.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.

        **See also** **startDTD** ().
        """
        ...

    def startDTD(self, name: str, publicId: str, systemId: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmllexicalhandler.html#startDTD

        **[pure virtual] bool QXmlLexicalHandler::startDTD(const QString & name
        , const QString & publicId , const QString & systemId )**

        The reader calls this function to report the start of a DTD declaration,
        if any. It reports the name of the document type in **name** , the
        public identifier in **publicId** and the system identifier in
        **systemId**.

        If the public identifier is missing, **publicId** is set to an empty
        string. If the system identifier is missing, **systemId** is set to an
        empty string. Note that it is not valid XML to have a public identifier
        but no system identifier; in such cases a parse error will occur.

        All declarations reported through QXmlDTDHandler or QXmlDeclHandler
        appear between the startDTD() and **endDTD** () calls.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.

        **See also** **endDTD** ().
        """
        ...
