"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import sip


class QXmlDTDHandler(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmldtdhandler.html

    **Detailed Description**

    If an application needs information about notations and unparsed entities,
    it can implement this interface and register an instance with
    **QXmlReader::setDTDHandler** ().

    Note that this interface includes only those DTD events that the XML
    recommendation requires processors to report, i.e. notation and unparsed
    entity declarations using **notationDecl** () and **unparsedEntityDecl** ()
    respectively.

    **See also** **QXmlDeclHandler** , **QXmlContentHandler** ,
    **QXmlEntityResolver** , **QXmlErrorHandler** , **QXmlLexicalHandler** , and
    Introduction to SAX2.
    """

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, a0: "QXmlDTDHandler") -> None:
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qxmldtdhandler.html#errorString

        **[pure virtual] QString QXmlDTDHandler::errorString() const**

        The reader calls this function to get an error string if any of the
        handler functions returns `false`.
        """
        ...

    def unparsedEntityDecl(
        self, name: str, publicId: str, systemId: str, notationName: str
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qxmldtdhandler.html#unparsedEntityDecl

        **[pure virtual] bool QXmlDTDHandler::unparsedEntityDecl(const QString &
        name , const QString & publicId , const QString & systemId , const
        QString & notationName )**

        The reader calls this function when it finds an unparsed entity
        declaration.

        The argument **name** is the unparsed entity's name, **publicId** is the
        entity's public identifier, **systemId** is the entity's system
        identifier and **notationName** is the name of the associated notation.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.
        """
        ...

    def notationDecl(self, name: str, publicId: str, systemId: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmldtdhandler.html#notationDecl

        **[pure virtual] bool QXmlDTDHandler::notationDecl(const QString & name
        , const QString & publicId , const QString & systemId )**

        The reader calls this function when it has parsed a notation
        declaration.

        The argument **name** is the notation name, **publicId** is the
        notation's public identifier and **systemId** is the notation's system
        identifier.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.
        """
        ...
