"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtXml import *
from PyQt5 import sip


class QXmlContentHandler(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlcontenthandler.html

    **Detailed Description**

    If the application needs to be informed of basic parsing events, it can
    implement this interface and activate it using
    **QXmlReader::setContentHandler** (). The reader can then report basic
    document-related events like the start and end of elements and character
    data through this interface.

    The order of events in this interface is very important, and mirrors the
    order of information in the document itself. For example, all of an
    element's content (character data, processing instructions, and sub-
    elements) appears, in order, between the **startElement** () event and the
    corresponding **endElement** () event.

    The class **QXmlDefaultHandler**  provides a default implementation for this
    interface; subclassing from the **QXmlDefaultHandler**  class is very
    convenient if you only want to be informed of some parsing events.

    The **startDocument** () function is called at the start of the document,
    and **endDocument** () is called at the end. Before parsing begins
    **setDocumentLocator** () is called. For each element **startElement** () is
    called, with **endElement** () being called at the end of each element. The
    **characters** () function is called with chunks of character data;
    **ignorableWhitespace** () is called with chunks of whitespace and
    **processingInstruction** () is called with processing instructions. If an
    entity is skipped **skippedEntity** () is called. At the beginning of
    prefix-URI scopes **startPrefixMapping** () is called.

    **See also** **QXmlDTDHandler** , **QXmlDeclHandler** ,
    **QXmlEntityResolver** , **QXmlErrorHandler** , **QXmlLexicalHandler** , and
    Introduction to SAX2.
    """

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, a0: "QXmlContentHandler") -> None:
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qxmlcontenthandler.html#errorString

        **[pure virtual] QString QXmlContentHandler::errorString() const**

        The reader calls this function to get an error string, e.g. if any of
        the handler functions returns `false`.
        """
        ...

    def skippedEntity(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlcontenthandler.html#skippedEntity

        **[pure virtual] bool QXmlContentHandler::skippedEntity(const QString &
        name )**

        Some readers may skip entities if they have not seen the declarations
        (e.g. because they are in an external DTD). If they do so they report
        that they skipped the entity called **name** by calling this function.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.
        """
        ...

    def processingInstruction(self, target: str, data: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlcontenthandler.html#processingInstruction

        **[pure virtual] bool QXmlContentHandler::processingInstruction(const
        QString & target , const QString & data )**

        The reader calls this function when it has parsed a processing
        instruction.

        **target** is the target name of the processing instruction and **data**
        is the data in the processing instruction.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.
        """
        ...

    def ignorableWhitespace(self, ch: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlcontenthandler.html#ignorableWhitespace

        **[pure virtual] bool QXmlContentHandler::ignorableWhitespace(const
        QString & ch )**

        Some readers may use this function to report each chunk of whitespace in
        element content. The whitespace is reported in **ch**.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.
        """
        ...

    def characters(self, ch: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlcontenthandler.html#characters

        **[pure virtual] bool QXmlContentHandler::characters(const QString & ch
        )**

        The reader calls this function when it has parsed a chunk of character
        data (either normal character data or character data inside a CDATA
        section; if you need to distinguish between those two types you must use
        **QXmlLexicalHandler::startCDATA** () and
        **QXmlLexicalHandler::endCDATA** ()). The character data is reported in
        **ch**.

        Some readers report whitespace in element content using the
        **ignorableWhitespace** () function rather than using this one.

        A reader may report the character data of an element in more than one
        chunk; e.g. a reader might want to report "a<b" in three characters()
        events ("a ", "<" and " b").

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.
        """
        ...

    def endElement(self, namespaceURI: str, localName: str, qName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlcontenthandler.html#endElement

        **[pure virtual] bool QXmlContentHandler::endElement(const QString &
        namespaceURI , const QString & localName , const QString & qName )**

        The reader calls this function when it has parsed an end element tag
        with the qualified name **qName** , the local name **localName** and the
        namespace URI **namespaceURI**.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.

        **See also** **startElement** () and Namespace Support via Features.
        """
        ...

    def startElement(
        self, namespaceURI: str, localName: str, qName: str, atts: QXmlAttributes
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlcontenthandler.html#startElement

        **[pure virtual] bool QXmlContentHandler::startElement(const QString &
        namespaceURI , const QString & localName , const QString & qName , const
        QXmlAttributes & atts )**

        The reader calls this function when it has parsed a start element tag.

        There is a corresponding **endElement** () call when the corresponding
        end element tag is read. The startElement() and **endElement** () calls
        are always nested correctly. Empty element tags (e.g. `<x/>`) cause a
        startElement() call to be immediately followed by an **endElement** ()
        call.

        The attribute list provided only contains attributes with explicit
        values. The attribute list contains attributes used for namespace
        declaration (i.e. attributes starting with xmlns) only if the namespace-
        prefix property of the reader is true.

        The argument **namespaceURI** is the namespace URI, or an empty string
        if the element has no namespace URI or if no namespace processing is
        done. **localName** is the local name (without prefix), or an empty
        string if no namespace processing is done, **qName** is the qualified
        name (with prefix) and **atts** are the attributes attached to the
        element. If there are no attributes, **atts** is an empty attributes
        object.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.

        **See also** **endElement** () and Namespace Support via Features.
        """
        ...

    def endPrefixMapping(self, prefix: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlcontenthandler.html#endPrefixMapping

        **[pure virtual] bool QXmlContentHandler::endPrefixMapping(const QString
        & prefix )**

        The reader calls this function to signal the end of a prefix mapping for
        the prefix **prefix**.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.

        **See also** **startPrefixMapping** () and Namespace Support via
        Features.
        """
        ...

    def startPrefixMapping(self, prefix: str, uri: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlcontenthandler.html#startPrefixMapping

        **[pure virtual] bool QXmlContentHandler::startPrefixMapping(const
        QString & prefix , const QString & uri )**

        The reader calls this function to signal the begin of a prefix-URI
        namespace mapping scope. This information is not necessary for normal
        namespace processing since the reader automatically replaces prefixes
        for element and attribute names.

        Note that startPrefixMapping() and **endPrefixMapping** () calls are not
        guaranteed to be properly nested relative to each other: all
        startPrefixMapping() events occur before the corresponding
        **startElement** () event, and all **endPrefixMapping** () events occur
        after the corresponding **endElement** () event, but their order is not
        otherwise guaranteed.

        The argument **prefix** is the namespace prefix being declared and the
        argument **uri** is the namespace URI the prefix is mapped to.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.

        **See also** **endPrefixMapping** () and Namespace Support via Features.
        """
        ...

    def endDocument(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlcontenthandler.html#endDocument

        **[pure virtual] bool QXmlContentHandler::endDocument()**

        The reader calls this function after it has finished parsing. It is
        called just once, and is the last handler function called. It is called
        after the reader has read all input or has abandoned parsing because of
        a fatal error.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.

        **See also** **startDocument** ().
        """
        ...

    def startDocument(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlcontenthandler.html#startDocument

        **[pure virtual] bool QXmlContentHandler::startDocument()**

        The reader calls this function when it starts parsing the document. The
        reader calls this function just once, after the call to
        **setDocumentLocator** (), and before any other functions in this class
        or in the QXmlDTDHandler class are called.

        If this function returns `false` the reader stops parsing and reports an
        error. The reader uses the function **errorString** () to get the error
        message.

        **See also** **endDocument** ().
        """
        ...

    def setDocumentLocator(self, locator: QXmlLocator) -> None:
        """
        https://doc.qt.io/qt-5/qxmlcontenthandler.html#setDocumentLocator

        **[pure virtual] void QXmlContentHandler::setDocumentLocator(QXmlLocator
        * locator )**

        The reader calls this function before it starts parsing the document.
        The argument **locator** is a pointer to a QXmlLocator which allows the
        application to get the parsing position within the document.

        Do not destroy the **locator** ; it is destroyed when the reader is
        destroyed. (Do not use the **locator** after the reader is destroyed).
        """
        ...
