"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtXml import *
from PyQt5 import sip


class QDomNode(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdomnode.html

    **Detailed Description**

    Many functions in the DOM return a QDomNode.

    You can find out the type of a node using **isAttr** (), **isCDATASection**
    (), **isDocumentFragment** (), **isDocument** (), **isDocumentType** (),
    **isElement** (), **isEntityReference** (), **isText** (), **isEntity** (),
    **isNotation** (), **isProcessingInstruction** (), **isCharacterData** ()
    and **isComment** ().

    A QDomNode can be converted into one of its subclasses using **toAttr** (),
    **toCDATASection** (), **toDocumentFragment** (), **toDocument** (),
    **toDocumentType** (), **toElement** (), **toEntityReference** (),
    **toText** (), **toEntity** (), **toNotation** (),
    **toProcessingInstruction** (), **toCharacterData** () or **toComment** ().
    You can convert a node to a null node with **clear** ().

    Copies of the QDomNode class share their data using explicit sharing. This
    means that modifying one node will change all copies. This is especially
    useful in combination with functions which return a QDomNode, e.g.
    **firstChild** (). You can make an independent (deep) copy of the node with
    **cloneNode** ().

    A QDomNode can be null, much like `nullptr`. Creating a copy of a null node
    results in another null node. It is not possible to modify a null node, but
    it is possible to assign another, possibly non-null node to it. In this
    case, the copy of the null node will remain null. You can check if a
    QDomNode is null by calling **isNull** (). The empty constructor of a
    QDomNode (or any of the derived classes) creates a null node.

    Nodes are inserted with **insertBefore** (), **insertAfter** () or
    **appendChild** (). You can replace one node with another using
    **replaceChild** () and remove a node with **removeChild** ().

    To traverse nodes use **firstChild** () to get a node's first child (if
    any), and **nextSibling** () to traverse. QDomNode also provides
    **lastChild** (), **previousSibling** () and **parentNode** (). To find the
    first child node with a particular node name use **namedItem** ().

    To find out if a node has children use **hasChildNodes** () and to get a
    list of all of a node's children use **childNodes** ().

    The node's name and value (the meaning of which varies depending on its
    type) is returned by **nodeName** () and **nodeValue** () respectively. The
    node's type is returned by **nodeType** (). The node's value can be set with
    **setNodeValue** ().

    The document to which the node belongs is returned by **ownerDocument** ().

    Adjacent **QDomText**  nodes can be merged into a single node with
    **normalize** ().

    **QDomElement**  nodes have attributes which can be retrieved with
    **attributes** ().

    **QDomElement**  and **QDomAttr**  nodes can have namespaces which can be
    retrieved with **namespaceURI** (). Their local name is retrieved with
    **localName** (), and their prefix with **prefix** (). The prefix can be set
    with **setPrefix** ().

    You can write the XML representation of the node to a text stream with
    **save** ().

    The following example looks for the first element in an XML document and
    prints the names of all the elements that are its direct children.

    **QDomDocument**  d;
        d.setContent(someXML);
        **QDomNode**  n =
    d.firstChild();
        while (!n.isNull()) {
            if (n.isElement()) {
    **QDomElement**  e = n.toElement();
                cout << "Element name: " <<
    e.tagName() << Qt::endl;
                break;
            }
            n =
    n.nextSibling();
        }

    For further information about the Document Object Model see **Level 1**  and
    **Level 2 Core** . For a more general introduction of the DOM implementation
    see the **QDomDocument**  documentation.
    """

    class EncodingPolicy(int):
        EncodingFromDocument: QDomNode = ...
        EncodingFromTextStream: QDomNode = ...

    class NodeType(int):
        ElementNode: QDomNode = ...
        AttributeNode: QDomNode = ...
        TextNode: QDomNode = ...
        CDATASectionNode: QDomNode = ...
        EntityReferenceNode: QDomNode = ...
        EntityNode: QDomNode = ...
        ProcessingInstructionNode: QDomNode = ...
        CommentNode: QDomNode = ...
        DocumentNode: QDomNode = ...
        DocumentTypeNode: QDomNode = ...
        DocumentFragmentNode: QDomNode = ...
        NotationNode: QDomNode = ...
        BaseNode: QDomNode = ...
        CharacterDataNode: QDomNode = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdomnode.html#QDomNode

        **QDomNode::QDomNode()**

        Constructs a **null**  node.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QDomNode") -> None:
        """
        https://doc.qt.io/qt-5/qdomnode.html#QDomNode-1

        **QDomNode::QDomNode(const QDomNode & n )**

        Constructs a copy of **n**.

        The data of the copy is shared (shallow copy): modifying one node will
        also change the other. If you want to make a deep copy, use
        **cloneNode** ().
        """
        ...

    def columnNumber(self) -> int:
        """
        https://doc.qt.io/qt-5/qdomnode.html#columnNumber

        **int QDomNode::columnNumber() const**

        For nodes created by **QDomDocument::setContent** (), this function
        returns the column number in the XML document where the node was parsed.
        Otherwise, -1 is returned.

        This function was introduced in Qt 4.1.

        **See also** **lineNumber** () and **QDomDocument::setContent** ().
        """
        ...

    def lineNumber(self) -> int:
        """
        https://doc.qt.io/qt-5/qdomnode.html#lineNumber

        **int QDomNode::lineNumber() const**

        For nodes created by **QDomDocument::setContent** (), this function
        returns the line number in the XML document where the node was parsed.
        Otherwise, -1 is returned.

        This function was introduced in Qt 4.1.

        **See also** **columnNumber** () and **QDomDocument::setContent** ().
        """
        ...

    def nextSiblingElement(self, taName: str = ...) -> "QDomElement":
        """
        https://doc.qt.io/qt-5/qdomnode.html#nextSiblingElement

        **QDomElement QDomNode::nextSiblingElement(const QString & tagName =
        QString()) const**

        Returns the next sibling element with tag name **tagName** if
        **tagName** is non-empty; otherwise returns any next sibling element.
        Returns a null element if no such sibling exists.

        **See also** **firstChildElement** (), **previousSiblingElement** (),
        and **lastChildElement** ().
        """
        ...

    def previousSiblingElement(self, tagName: str = ...) -> "QDomElement":
        """
        https://doc.qt.io/qt-5/qdomnode.html#previousSiblingElement

        **QDomElement QDomNode::previousSiblingElement(const QString & tagName =
        QString()) const**

        Returns the previous sibilng element with tag name **tagName** if
        **tagName** is non-empty; otherwise returns any previous sibling
        element. Returns a null element if no such sibling exists.

        **See also** **firstChildElement** (), **nextSiblingElement** (), and
        **lastChildElement** ().
        """
        ...

    def lastChildElement(self, tagName: str = ...) -> "QDomElement":
        """
        https://doc.qt.io/qt-5/qdomnode.html#lastChildElement

        **QDomElement QDomNode::lastChildElement(const QString & tagName =
        QString()) const**

        Returns the last child element with tag name **tagName** if tagName is
        non-empty; otherwise returns the last child element. Returns a null
        element if no such child exists.

        **See also** **firstChildElement** (), **previousSiblingElement** (),
        and **nextSiblingElement** ().
        """
        ...

    def firstChildElement(self, tagName: str = ...) -> "QDomElement":
        """
        https://doc.qt.io/qt-5/qdomnode.html#firstChildElement

        **QDomElement QDomNode::firstChildElement(const QString & tagName =
        QString()) const**

        Returns the first child element with tag name **tagName** if tagName is
        non-empty; otherwise returns the first child element. Returns a null
        element if no such child exists.

        **See also** **lastChildElement** (), **previousSiblingElement** (), and
        **nextSiblingElement** ().
        """
        ...

    def save(
        self, a0: QtCore.QTextStream, a1: int, a2: "QDomNode.EncodingPolicy" = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdomnode.html#save

        **void QDomNode::save(QTextStream & stream , int indent ,
        QDomNode::EncodingPolicy encodingPolicy =
        QDomNode::EncodingFromDocument) const**

        Writes the XML representation of the node and all its children to the
        stream **stream**. This function uses **indent** as the amount of space
        to indent the node.

        If the document contains invalid XML characters or characters that
        cannot be encoded in the given encoding, the result and behavior is
        undefined.

        If **encodingPolicy** is **QDomNode::EncodingFromDocument**  and this
        node is a document node, the encoding of text stream **stream** 's
        encoding is set by treating a processing instruction by name "xml" as an
        XML declaration, if one exists, and otherwise defaults to UTF-8. XML
        declarations are not processing instructions, but this behavior exists
        for historical reasons. If this node is not a document node, the text
        stream's encoding is used.

        If **encodingPolicy** is **EncodingFromTextStream**  and this node is a
        document node, this function behaves as save(**QTextStream**  &str, int
        indent) with the exception that the encoding specified in the text
        stream **stream** is used.

        If the document contains invalid XML characters or characters that
        cannot be encoded in the given encoding, the result and behavior is
        undefined.

        This function was introduced in Qt 4.2.
        """
        ...

    def toComment(self) -> "QDomComment":
        """
        https://doc.qt.io/qt-5/qdomnode.html#toComment

        **QDomComment QDomNode::toComment() const**

        Converts a **QDomNode**  into a **QDomComment** . If the node is not a
        comment the returned object will be **null** .

        **See also** **isComment** ().
        """
        ...

    def toCharacterData(self) -> "QDomCharacterData":
        """
        https://doc.qt.io/qt-5/qdomnode.html#toCharacterData

        **QDomCharacterData QDomNode::toCharacterData() const**

        Converts a **QDomNode**  into a **QDomCharacterData** . If the node is
        not a character data node the returned object will be **null** .

        **See also** **isCharacterData** ().
        """
        ...

    def toProcessingInstruction(self) -> "QDomProcessingInstruction":
        """
        https://doc.qt.io/qt-5/qdomnode.html#toProcessingInstruction

        **QDomProcessingInstruction QDomNode::toProcessingInstruction() const**

        Converts a **QDomNode**  into a **QDomProcessingInstruction** . If the
        node is not a processing instruction the returned object will be
        **null** .

        **See also** **isProcessingInstruction** ().
        """
        ...

    def toNotation(self) -> "QDomNotation":
        """
        https://doc.qt.io/qt-5/qdomnode.html#toNotation

        **QDomNotation QDomNode::toNotation() const**

        Converts a **QDomNode**  into a **QDomNotation** . If the node is not a
        notation the returned object will be **null** .

        **See also** **isNotation** ().
        """
        ...

    def toEntity(self) -> "QDomEntity":
        """
        https://doc.qt.io/qt-5/qdomnode.html#toEntity

        **QDomEntity QDomNode::toEntity() const**

        Converts a **QDomNode**  into a **QDomEntity** . If the node is not an
        entity the returned object will be **null** .

        **See also** **isEntity** ().
        """
        ...

    def toText(self) -> "QDomText":
        """
        https://doc.qt.io/qt-5/qdomnode.html#toText

        **QDomText QDomNode::toText() const**

        Converts a **QDomNode**  into a **QDomText** . If the node is not a
        text, the returned object will be **null** .

        **See also** **isText** ().
        """
        ...

    def toEntityReference(self) -> "QDomEntityReference":
        """
        https://doc.qt.io/qt-5/qdomnode.html#toEntityReference

        **QDomEntityReference QDomNode::toEntityReference() const**

        Converts a **QDomNode**  into a **QDomEntityReference** . If the node is
        not an entity reference, the returned object will be **null** .

        **See also** **isEntityReference** ().
        """
        ...

    def toElement(self) -> "QDomElement":
        """
        https://doc.qt.io/qt-5/qdomnode.html#toElement

        **QDomElement QDomNode::toElement() const**

        Converts a **QDomNode**  into a **QDomElement** . If the node is not an
        element the returned object will be **null** .

        **See also** **isElement** ().
        """
        ...

    def toDocumentType(self) -> "QDomDocumentType":
        """
        https://doc.qt.io/qt-5/qdomnode.html#toDocumentType

        **QDomDocumentType QDomNode::toDocumentType() const**

        Converts a **QDomNode**  into a **QDomDocumentType** . If the node is
        not a document type the returned object will be **null** .

        **See also** **isDocumentType** ().
        """
        ...

    def toDocument(self) -> "QDomDocument":
        """
        https://doc.qt.io/qt-5/qdomnode.html#toDocument

        **QDomDocument QDomNode::toDocument() const**

        Converts a **QDomNode**  into a **QDomDocument** . If the node is not a
        document the returned object will be **null** .

        **See also** **isDocument** ().
        """
        ...

    def toDocumentFragment(self) -> "QDomDocumentFragment":
        """
        https://doc.qt.io/qt-5/qdomnode.html#toDocumentFragment

        **QDomDocumentFragment QDomNode::toDocumentFragment() const**

        Converts a **QDomNode**  into a **QDomDocumentFragment** . If the node
        is not a document fragment the returned object will be **null** .

        **See also** **isDocumentFragment** ().
        """
        ...

    def toCDATASection(self) -> "QDomCDATASection":
        """
        https://doc.qt.io/qt-5/qdomnode.html#toCDATASection

        **QDomCDATASection QDomNode::toCDATASection() const**

        Converts a **QDomNode**  into a **QDomCDATASection** . If the node is
        not a CDATA section, the returned object will be **null** .

        **See also** **isCDATASection** ().
        """
        ...

    def toAttr(self) -> "QDomAttr":
        """
        https://doc.qt.io/qt-5/qdomnode.html#toAttr

        **QDomAttr QDomNode::toAttr() const**

        Converts a **QDomNode**  into a **QDomAttr** . If the node is not an
        attribute, the returned object will be **null** .

        **See also** **isAttr** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qdomnode.html#clear

        **void QDomNode::clear()**

        Converts the node into a null node; if it was not a null node before,
        its type and contents are deleted.

        **See also** **isNull** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isNull

        **bool QDomNode::isNull() const**

        Returns `true` if this node is null (i.e. if it has no type or
        contents); otherwise returns `false`.
        """
        ...

    def namedItem(self, name: str) -> "QDomNode":
        """
        https://doc.qt.io/qt-5/qdomnode.html#namedItem

        **QDomNode QDomNode::namedItem(const QString & name ) const**

        Returns the first direct child node for which **nodeName** () equals
        **name**.

        If no such direct child exists, a **null node**  is returned.

        **See also** **nodeName** ().
        """
        ...

    def isComment(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isComment

        **bool QDomNode::isComment() const**

        Returns `true` if the node is a comment; otherwise returns `false`.

        If this function returns `true`, it does not imply that this object is a
        **QDomComment** ; you can get the **QDomComment**  with **toComment**
        ().

        **See also** **toComment** ().
        """
        ...

    def isCharacterData(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isCharacterData

        **bool QDomNode::isCharacterData() const**

        Returns `true` if the node is a character data node; otherwise returns
        `false`.

        If this function returns `true`, it does not imply that this object is a
        **QDomCharacterData** ; you can get the **QDomCharacterData**  with
        **toCharacterData** ().

        **See also** **toCharacterData** ().
        """
        ...

    def isProcessingInstruction(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isProcessingInstruction

        **bool QDomNode::isProcessingInstruction() const**

        Returns `true` if the node is a processing instruction; otherwise
        returns `false`.

        If this function returns `true`, it does not imply that this object is a
        **QDomProcessingInstruction** ; you can get the QProcessingInstruction
        with **toProcessingInstruction** ().

        **See also** **toProcessingInstruction** ().
        """
        ...

    def isNotation(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isNotation

        **bool QDomNode::isNotation() const**

        Returns `true` if the node is a notation; otherwise returns `false`.

        If this function returns `true`, it does not imply that this object is a
        **QDomNotation** ; you can get the **QDomNotation**  with **toNotation**
        ().

        **See also** **toNotation** ().
        """
        ...

    def isEntity(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isEntity

        **bool QDomNode::isEntity() const**

        Returns `true` if the node is an entity; otherwise returns `false`.

        If this function returns `true`, it does not imply that this object is a
        **QDomEntity** ; you can get the **QDomEntity**  with **toEntity** ().

        **See also** **toEntity** ().
        """
        ...

    def isText(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isText

        **bool QDomNode::isText() const**

        Returns `true` if the node is a text node; otherwise returns `false`.

        If this function returns `true`, it does not imply that this object is a
        **QDomText** ; you can get the **QDomText**  with **toText** ().

        **See also** **toText** ().
        """
        ...

    def isEntityReference(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isEntityReference

        **bool QDomNode::isEntityReference() const**

        Returns `true` if the node is an entity reference; otherwise returns
        false.

        If this function returns `true`, it does not imply that this object is a
        **QDomEntityReference** ; you can get the **QDomEntityReference**  with
        **toEntityReference** ().

        **See also** **toEntityReference** ().
        """
        ...

    def isElement(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isElement

        **bool QDomNode::isElement() const**

        Returns `true` if the node is an element; otherwise returns `false`.

        If this function returns `true`, it does not imply that this object is a
        **QDomElement** ; you can get the **QDomElement**  with **toElement**
        ().

        **See also** **toElement** ().
        """
        ...

    def isDocumentType(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isDocumentType

        **bool QDomNode::isDocumentType() const**

        Returns `true` if the node is a document type; otherwise returns false.

        If this function returns `true`, it does not imply that this object is a
        **QDomDocumentType** ; you can get the **QDomDocumentType**  with
        **toDocumentType** ().

        **See also** **toDocumentType** ().
        """
        ...

    def isDocument(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isDocument

        **bool QDomNode::isDocument() const**

        Returns `true` if the node is a document; otherwise returns `false`.

        If this function returns `true`, it does not imply that this object is a
        **QDomDocument** ; you can get the **QDomDocument**  with **toDocument**
        ().

        **See also** **toDocument** ().
        """
        ...

    def isDocumentFragment(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isDocumentFragment

        **bool QDomNode::isDocumentFragment() const**

        Returns `true` if the node is a document fragment; otherwise returns
        false.

        If this function returns `true`, it does not imply that this object is a
        **QDomDocumentFragment** ; you can get the **QDomDocumentFragment**
        with **toDocumentFragment** ().

        **See also** **toDocumentFragment** ().
        """
        ...

    def isCDATASection(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isCDATASection

        **bool QDomNode::isCDATASection() const**

        Returns `true` if the node is a CDATA section; otherwise returns false.

        If this function returns `true`, it does not imply that this object is a
        **QDomCDATASection** ; you can get the **QDomCDATASection**  with
        **toCDATASection** ().

        **See also** **toCDATASection** ().
        """
        ...

    def isAttr(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isAttr

        **bool QDomNode::isAttr() const**

        Returns `true` if the node is an attribute; otherwise returns `false`.

        If this function returns `true`, it does not imply that this object is a
        QDomAttribute; you can get the QDomAttribute with toAttribute().

        **See also** **toAttr** ().
        """
        ...

    def setPrefix(self, pre: str) -> None:
        """
        https://doc.qt.io/qt-5/qdomnode.html#setPrefix

        **void QDomNode::setPrefix(const QString & pre )**

        If the node has a namespace prefix, this function changes the namespace
        prefix of the node to **pre**. Otherwise this function does nothing.

        Only nodes of type **ElementNode**  or **AttributeNode**  can have
        namespaces. A namespace prefix must have be specified at creation time;
        it is not possible to add a namespace prefix afterwards.

        **See also** **prefix** (), **localName** (), **namespaceURI** (),
        **QDomDocument::createElementNS** (), and
        **QDomDocument::createAttributeNS** ().
        """
        ...

    def prefix(self) -> str:
        """
        https://doc.qt.io/qt-5/qdomnode.html#prefix

        **QString QDomNode::prefix() const**

        Returns the namespace prefix of the node or an empty string if the node
        has no namespace prefix.

        Only nodes of type **ElementNode**  or **AttributeNode**  can have
        namespaces. A namespace prefix must be specified at creation time. If a
        node was created with a namespace prefix, you can change it later with
        **setPrefix** ().

        If you create an element or attribute with
        **QDomDocument::createElement** () or **QDomDocument::createAttribute**
        (), the prefix will be an empty string. If you use
        **QDomDocument::createElementNS** () or
        **QDomDocument::createAttributeNS** () instead, the prefix will not be
        an empty string; but it might be an empty string if the name does not
        have a prefix.

        **See also** **setPrefix** (), **localName** (), **namespaceURI** (),
        **QDomDocument::createElementNS** (), and
        **QDomDocument::createAttributeNS** ().
        """
        ...

    def setNodeValue(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qdomnode.html#setNodeValue

        **void QDomNode::setNodeValue(const QString & v )**

        Sets the node's value to **v**.

        **See also** **nodeValue** ().
        """
        ...

    def nodeValue(self) -> str:
        """
        https://doc.qt.io/qt-5/qdomnode.html#nodeValue

        **QString QDomNode::nodeValue() const**

        Returns the value of the node.

        The meaning of the value depends on the subclass:

        NameMeaning
        **QDomAttr** The attribute value
        **QDomCDATASection**
        The content of the CDATA section
        **QDomComment** The comment
        **QDomProcessingInstruction** The data of the processing instruction
        **QDomText** The text

        All the other subclasses do not have a node value and will return an
        empty string.

        **See also** **setNodeValue** () and **nodeName** ().
        """
        ...

    def hasAttributes(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#hasAttributes

        **bool QDomNode::hasAttributes() const**

        Returns `true` if the node has attributes; otherwise returns `false`.

        **See also** **attributes** ().
        """
        ...

    def localName(self) -> str:
        """
        https://doc.qt.io/qt-5/qdomnode.html#localName

        **QString QDomNode::localName() const**

        If the node uses namespaces, this function returns the local name of the
        node; otherwise it returns an empty string.

        Only nodes of type **ElementNode**  or **AttributeNode**  can have
        namespaces. A namespace must have been specified at creation time; it is
        not possible to add a namespace afterwards.

        **See also** **prefix** (), **namespaceURI** (),
        **QDomDocument::createElementNS** (), and
        **QDomDocument::createAttributeNS** ().
        """
        ...

    def namespaceURI(self) -> str:
        """
        https://doc.qt.io/qt-5/qdomnode.html#namespaceURI

        **QString QDomNode::namespaceURI() const**

        Returns the namespace URI of this node or an empty string if the node
        has no namespace URI.

        Only nodes of type **ElementNode**  or **AttributeNode**  can have
        namespaces. A namespace URI must be specified at creation time and
        cannot be changed later.

        **See also** **prefix** (), **localName** (),
        **QDomDocument::createElementNS** (), and
        **QDomDocument::createAttributeNS** ().
        """
        ...

    def ownerDocument(self) -> "QDomDocument":
        """
        https://doc.qt.io/qt-5/qdomnode.html#ownerDocument

        **QDomDocument QDomNode::ownerDocument() const**

        Returns the document to which this node belongs.
        """
        ...

    def attributes(self) -> "QDomNamedNodeMap":
        """
        https://doc.qt.io/qt-5/qdomnode.html#attributes

        **QDomNamedNodeMap QDomNode::attributes() const**

        Returns a named node map of all attributes. Attributes are only provided
        for **QDomElement** s.

        Changing the attributes in the map will also change the attributes of
        this **QDomNode** .
        """
        ...

    def nextSibling(self) -> "QDomNode":
        """
        https://doc.qt.io/qt-5/qdomnode.html#nextSibling

        **QDomNode QDomNode::nextSibling() const**

        Returns the next sibling in the document tree. Changing the returned
        node will also change the node in the document tree.

        If you have XML like this:

        <h1>Heading</h1>
            <p>The text...</p>
            <h2>Next heading</h2>

        and this **QDomNode**  represents the <p> tag, nextSibling() will return
        the node representing the <h2> tag.

        **See also** **previousSibling** ().
        """
        ...

    def previousSibling(self) -> "QDomNode":
        """
        https://doc.qt.io/qt-5/qdomnode.html#previousSibling

        **QDomNode QDomNode::previousSibling() const**

        Returns the previous sibling in the document tree. Changing the returned
        node will also change the node in the document tree.

        For example, if you have XML like this:

        <h1>Heading</h1>
            <p>The text...</p>
            <h2>Next heading</h2>

        and this **QDomNode**  represents the &lt;p&gt; tag, previousSibling()
        will return the node representing the &lt;h1&gt; tag.

        **See also** **nextSibling** ().
        """
        ...

    def lastChild(self) -> "QDomNode":
        """
        https://doc.qt.io/qt-5/qdomnode.html#lastChild

        **QDomNode QDomNode::lastChild() const**

        Returns the last child of the node. If there is no child node, a **null
        node**  is returned. Changing the returned node will also change the
        node in the document tree.

        **See also** **firstChild** () and **childNodes** ().
        """
        ...

    def firstChild(self) -> "QDomNode":
        """
        https://doc.qt.io/qt-5/qdomnode.html#firstChild

        **QDomNode QDomNode::firstChild() const**

        Returns the first child of the node. If there is no child node, a **null
        node**  is returned. Changing the returned node will also change the
        node in the document tree.

        **See also** **lastChild** () and **childNodes** ().
        """
        ...

    def childNodes(self) -> "QDomNodeList":
        """
        https://doc.qt.io/qt-5/qdomnode.html#childNodes

        **QDomNodeList QDomNode::childNodes() const**

        Returns a list of all direct child nodes.

        Most often you will call this function on a **QDomElement**  object.

        For example, if the XML document looks like this:

        <body>
            <h1>Heading</h1>
            <p>Hello <b>you</b></p>
            </body>

        Then the list of child nodes for the "body"-element will contain the
        node created by the &lt;h1&gt; tag and the node created by the &lt;p&gt;
        tag.

        The nodes in the list are not copied; so changing the nodes in the list
        will also change the children of this node.

        **See also** **firstChild** () and **lastChild** ().
        """
        ...

    def parentNode(self) -> "QDomNode":
        """
        https://doc.qt.io/qt-5/qdomnode.html#parentNode

        **QDomNode QDomNode::parentNode() const**

        Returns the parent node. If this node has no parent, a null node is
        returned (i.e. a node for which **isNull** () returns `true`).
        """
        ...

    def nodeType(self) -> "QDomNode.NodeType":
        """
        https://doc.qt.io/qt-5/qdomnode.html#nodeType

        **QDomNode::NodeType QDomNode::nodeType() const**

        Returns the type of the node.

        **See also** **toAttr** (), **toCDATASection** (),
        **toDocumentFragment** (), **toDocument** (), **toDocumentType** (),
        **toElement** (), **toEntityReference** (), **toText** (), **toEntity**
        (), **toNotation** (), **toProcessingInstruction** (),
        **toCharacterData** (), and **toComment** ().
        """
        ...

    def nodeName(self) -> str:
        """
        https://doc.qt.io/qt-5/qdomnode.html#nodeName

        **QString QDomNode::nodeName() const**

        Returns the name of the node.

        The meaning of the name depends on the subclass:

        NameMeaning
        **QDomAttr** The name of the attribute
        **QDomCDATASection** The string "#cdata-section"
        **QDomComment** The
        string "#comment"
        **QDomDocument** The string "#document"
        **QDomDocumentFragment** The string "#document-fragment"
        **QDomDocumentType** The name of the document type
        **QDomElement** The
        tag name
        **QDomEntity** The name of the entity
        **QDomEntityReference** The name of the referenced entity
        **QDomNotation** The name of the notation
        **QDomProcessingInstruction** The target of the processing instruction
        **QDomText** The string "#text"

        **Note:** This function does not take the presence of namespaces into
        account when processing the names of element and attribute nodes. As a
        result, the returned name can contain any namespace prefix that may be
        present. To obtain the node name of an element or attribute, use
        **localName** (); to obtain the namespace prefix, use **namespaceURI**
        ().

        **See also** **nodeValue** ().
        """
        ...

    def isSupported(self, feature: str, version: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#isSupported

        **bool QDomNode::isSupported(const QString & feature , const QString &
        version ) const**

        Returns `true` if the DOM implementation implements the feature
        **feature** and this feature is supported by this node in the version
        **version** ; otherwise returns `false`.

        **See also** **QDomImplementation::hasFeature** ().
        """
        ...

    def normalize(self) -> None:
        """
        https://doc.qt.io/qt-5/qdomnode.html#normalize

        **void QDomNode::normalize()**

        Calling normalize() on an element converts all its children into a
        standard form. This means that adjacent **QDomText**  objects will be
        merged into a single text object (**QDomCDATASection**  nodes are not
        merged).
        """
        ...

    def cloneNode(self, deep: bool = ...) -> "QDomNode":
        """
        https://doc.qt.io/qt-5/qdomnode.html#cloneNode

        **QDomNode QDomNode::cloneNode(bool deep = true) const**

        Creates a deep (not shallow) copy of the **QDomNode** .

        If **deep** is true, then the cloning is done recursively which means
        that all the node's children are deep copied too. If **deep** is false
        only the node itself is copied and the copy will have no child nodes.
        """
        ...

    def hasChildNodes(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnode.html#hasChildNodes

        **bool QDomNode::hasChildNodes() const**

        Returns `true` if the node has one or more children; otherwise returns
        `false`.
        """
        ...

    def appendChild(self, newChild: "QDomNode") -> "QDomNode":
        """
        https://doc.qt.io/qt-5/qdomnode.html#appendChild

        **QDomNode QDomNode::appendChild(const QDomNode & newChild )**

        Appends **newChild** as the node's last child.

        If **newChild** is the child of another node, it is reparented to this
        node. If **newChild** is a child of this node, then its position in the
        list of children is changed.

        If **newChild** is a **QDomDocumentFragment** , then the children of the
        fragment are removed from the fragment and appended.

        If **newChild** is a **QDomElement**  and this node is a
        **QDomDocument**  that already has an element node as a child,
        **newChild** is not added as a child and a null node is returned.

        Returns a new reference to **newChild** on success or a **null node**
        on failure.

        Calling this function on a null node(created, for example, with the
        default constructor) does nothing and returns a **null node** .

        The DOM specification disallow inserting attribute nodes, but for
        historical reasons, QDom accepts them anyway.

        **See also** **insertBefore** (), **insertAfter** (), **replaceChild**
        (), and **removeChild** ().
        """
        ...

    def removeChild(self, oldChild: "QDomNode") -> "QDomNode":
        """
        https://doc.qt.io/qt-5/qdomnode.html#removeChild

        **QDomNode QDomNode::removeChild(const QDomNode & oldChild )**

        Removes **oldChild** from the list of children. **oldChild** must be a
        direct child of this node.

        Returns a new reference to **oldChild** on success or a **null node**
        on failure.

        **See also** **insertBefore** (), **insertAfter** (), **replaceChild**
        (), and **appendChild** ().
        """
        ...

    def replaceChild(self, newChild: "QDomNode", oldChild: "QDomNode") -> "QDomNode":
        """
        https://doc.qt.io/qt-5/qdomnode.html#replaceChild

        **QDomNode QDomNode::replaceChild(const QDomNode & newChild , const
        QDomNode & oldChild )**

        Replaces **oldChild** with **newChild**. **oldChild** must be a direct
        child of this node.

        If **newChild** is the child of another node, it is reparented to this
        node. If **newChild** is a child of this node, then its position in the
        list of children is changed.

        If **newChild** is a **QDomDocumentFragment** , then **oldChild** is
        replaced by all of the children of the fragment.

        Returns a new reference to **oldChild** on success or a **null node**
        on failure.

        **See also** **insertBefore** (), **insertAfter** (), **removeChild**
        (), and **appendChild** ().
        """
        ...

    def insertAfter(self, newChild: "QDomNode", refChild: "QDomNode") -> "QDomNode":
        """
        https://doc.qt.io/qt-5/qdomnode.html#insertAfter

        **QDomNode QDomNode::insertAfter(const QDomNode & newChild , const
        QDomNode & refChild )**

        Inserts the node **newChild** after the child node **refChild**.
        **refChild** must be a direct child of this node. If **refChild** is
        **null**  then **newChild** is appended as this node's last child.

        If **newChild** is the child of another node, it is reparented to this
        node. If **newChild** is a child of this node, then its position in the
        list of children is changed.

        If **newChild** is a **QDomDocumentFragment** , then the children of the
        fragment are removed from the fragment and inserted after **refChild**.

        Returns a new reference to **newChild** on success or a **null node**
        on failure.

        The DOM specification disallow inserting attribute nodes, but due to
        historical reasons QDom accept them nevertheless.

        **See also** **insertBefore** (), **replaceChild** (), **removeChild**
        (), and **appendChild** ().
        """
        ...

    def insertBefore(self, newChild: "QDomNode", refChild: "QDomNode") -> "QDomNode":
        """
        https://doc.qt.io/qt-5/qdomnode.html#insertBefore

        **QDomNode QDomNode::insertBefore(const QDomNode & newChild , const
        QDomNode & refChild )**

        Inserts the node **newChild** before the child node **refChild**.
        **refChild** must be a direct child of this node. If **refChild** is
        **null**  then **newChild** is inserted as the node's first child.

        If **newChild** is the child of another node, it is reparented to this
        node. If **newChild** is a child of this node, then its position in the
        list of children is changed.

        If **newChild** is a **QDomDocumentFragment** , then the children of the
        fragment are removed from the fragment and inserted before **refChild**.

        Returns a new reference to **newChild** on success or a **null node**
        on failure.

        The DOM specification disallow inserting attribute nodes, but due to
        historical reasons QDom accept them nevertheless.

        **See also** **insertAfter** (), **replaceChild** (), **removeChild**
        (), and **appendChild** ().
        """
        ...
