"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtXml import *
from PyQt5 import sip


class QDomNamedNodeMap(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdomnamednodemap.html

    **Detailed Description**

    Note that QDomNamedNodeMap does not inherit from **QDomNodeList** .
    QDomNamedNodeMaps do not provide any specific node ordering. Although nodes
    in a QDomNamedNodeMap may be accessed by an ordinal index, this is simply to
    allow a convenient enumeration of the contents of a QDomNamedNodeMap, and
    does not imply that the DOM specifies an ordering of the nodes.

    The QDomNamedNodeMap is used in three places:

    1. **QDomDocumentType::entities** () returns a map of all entities described
    in the DTD.
      2. **QDomDocumentType::notations** () returns a map of all
    notations described in the DTD.
      3. **QDomNode::attributes** () returns a
    map of all attributes of an element.

    Items in the map are identified by the name which QDomNode::name() returns.
    Nodes are retrieved using **namedItem** (), **namedItemNS** () or **item**
    (). New nodes are inserted with **setNamedItem** () or **setNamedItemNS** ()
    and removed with **removeNamedItem** () or **removeNamedItemNS** (). Use
    **contains** () to see if an item with the given name is in the named node
    map. The number of items is returned by **length** ().

    Terminology: in this class we use "item" and "node" interchangeably.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#QDomNamedNodeMap

        **QDomNamedNodeMap::QDomNamedNodeMap()**

        Constructs an empty named node map.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QDomNamedNodeMap") -> None:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#QDomNamedNodeMap-1

        **QDomNamedNodeMap::QDomNamedNodeMap(const QDomNamedNodeMap & n )**

        Constructs a copy of **n**.
        """
        ...

    def contains(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#contains

        **bool QDomNamedNodeMap::contains(const QString & name ) const**

        Returns `true` if the map contains a node called **name** ; otherwise
        returns `false`.

        **Note:** This function does not take the presence of namespaces into
        account. Use **namedItemNS** () to test whether the map contains a node
        with a specific namespace URI and name.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#isEmpty

        **bool QDomNamedNodeMap::isEmpty() const**

        Returns `true` if the map is empty; otherwise returns `false`. This
        function is provided for Qt API consistency.
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#size

        **int QDomNamedNodeMap::size() const**

        This function is provided for Qt API consistency. It is equivalent to
        **length** ().
        """
        ...

    def __len__(self) -> int:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#count

        **int QDomNamedNodeMap::count() const**

        This function is provided for Qt API consistency. It is equivalent to
        **length** ().
        """
        ...

    def length(self) -> int:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#length

        **int QDomNamedNodeMap::length() const**

        Returns the number of nodes in the map.

        **See also** **item** ().
        """
        ...

    def removeNamedItemNS(self, nsURI: str, localName: str) -> QDomNode:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#removeNamedItemNS

        **QDomNode QDomNamedNodeMap::removeNamedItemNS(const QString & nsURI ,
        const QString & localName )**

        Removes the node with the local name **localName** and the namespace URI
        **nsURI** from the map.

        The function returns the removed node or a **null node**  if the map did
        not contain a node with the local name **localName** and the namespace
        URI **nsURI**.

        **See also** **setNamedItemNS** (), **namedItemNS** (), and
        **removeNamedItem** ().
        """
        ...

    def setNamedItemNS(self, newNode: QDomNode) -> QDomNode:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#setNamedItemNS

        **QDomNode QDomNamedNodeMap::setNamedItemNS(const QDomNode & newNode )**

        Inserts the node **newNode** in the map. If a node with the same
        namespace URI and the same local name already exists in the map, it is
        replaced by **newNode**. If the new node replaces an existing node, the
        replaced node is returned.

        **See also** **namedItemNS** (), **removeNamedItemNS** (), and
        **setNamedItem** ().
        """
        ...

    def namedItemNS(self, nsURI: str, localName: str) -> QDomNode:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#namedItemNS

        **QDomNode QDomNamedNodeMap::namedItemNS(const QString & nsURI , const
        QString & localName ) const**

        Returns the node associated with the local name **localName** and the
        namespace URI **nsURI**.

        If the map does not contain such a node, a **null node**  is returned.

        **See also** **setNamedItemNS** () and **namedItem** ().
        """
        ...

    def item(self, index: int) -> QDomNode:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#item

        **QDomNode QDomNamedNodeMap::item(int index ) const**

        Retrieves the node at position **index**.

        This can be used to iterate over the map. Note that the nodes in the map
        are ordered arbitrarily.

        **See also** **length** ().
        """
        ...

    def removeNamedItem(self, name: str) -> QDomNode:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#removeNamedItem

        **QDomNode QDomNamedNodeMap::removeNamedItem(const QString & name )**

        Removes the node called **name** from the map.

        The function returns the removed node or a **null node**  if the map did
        not contain a node called **name**.

        **See also** **setNamedItem** (), **namedItem** (), and
        **removeNamedItemNS** ().
        """
        ...

    def setNamedItem(self, newNode: QDomNode) -> QDomNode:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#setNamedItem

        **QDomNode QDomNamedNodeMap::setNamedItem(const QDomNode & newNode )**

        Inserts the node **newNode** into the named node map. The name used by
        the map is the node name of **newNode** as returned by
        **QDomNode::nodeName** ().

        If the new node replaces an existing node, i.e. the map contains a node
        with the same name, the replaced node is returned.

        **See also** **namedItem** (), **removeNamedItem** (), and
        **setNamedItemNS** ().
        """
        ...

    def namedItem(self, name: str) -> QDomNode:
        """
        https://doc.qt.io/qt-5/qdomnamednodemap.html#namedItem

        **QDomNode QDomNamedNodeMap::namedItem(const QString & name ) const**

        Returns the node called **name**.

        If the named node map does not contain such a node, a **null node**  is
        returned. A node's name is the name returned by **QDomNode::nodeName**
        ().

        **See also** **setNamedItem** () and **namedItemNS** ().
        """
        ...
