"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtWinExtras import *


class QWinTaskbarProgress(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qwintaskbarprogress.html

    **Detailed Description**

    A progress indicator is used to give the user an indication of the progress
    of an operation and to reassure them that the application is still running.

    The progress indicator uses the concept of **steps**. It is set up by
    specifying the minimum and maximum possible step values, and it will display
    the percentage of steps that have been completed when you later give it the
    current step value. The percentage is calculated by dividing the progress
    (**value** () - **minimum** ()) divided by **maximum** () - **minimum** ().

    The minimum and maximum number of steps can be specified by calling
    **setMinimum** () and **setMaximum** (). The current number of steps is set
    with **setValue** (). The progress indicator can be rewound to the beginning
    with **reset** ().

    If minimum and maximum both are set to `0`, the indicator shows up as a busy
    (indeterminate) indicator instead of a percentage of steps. This is useful
    when it is not possible to determine the number of steps.

    ![Screenshot of a progress indicator](images/taskbar-progress.png)A progress
    indicator at 50%.
    ![Screenshot of a paused progress
    indicator](images/taskbar-progress-paused.png)A paused progress indicator at
    50%.
    ![Screenshot of a stopped progress indicator](images/taskbar-
    progress-stopped.png)A stopped progress indicator at 50%.
    ![Screenshot of
    an indeterminate progress indicator](images/taskbar-progress-
    indeterminate.png)An indeterminate progress indicator.

    **Note:** The final appearance of the progress indicator varies depending on
    the active Windows theme.

    **See also** **QWinTaskbarButton** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#QWinTaskbarProgress

        **QWinTaskbarProgress::QWinTaskbarProgress(QObject * parent = nullptr)**

        Constructs a QWinTaskbarProgress with the parent object **parent**.
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#stop

        **[slot] void QWinTaskbarProgress::stop()**

        Stops the progress indicator.

        **See also** **stopped** .
        """
        ...

    def setPaused(self, paused: bool) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#paused-prop

        **paused : bool**

        This property holds whether the progress indicator is paused.

        The default value is `false`.

        The final appearance of a paused progress indicator depends on the
        active Windows theme. Typically, a paused progress indicator turns
        yellow to indicate that the progress is currently paused. Unlike a
        **stopped**  progress indicator, a paused progress should not be used to
        indicate an error.

        **Access functions:**

        bool **isPaused** () const
        void **setPaused** (bool **paused** )

        **Notifier signal:**

        void **pausedChanged** (bool **paused** )

        **See also** **pause** () and **resume** ().
        """
        ...

    def resume(self) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#resume

        **[slot] void QWinTaskbarProgress::resume()**

        Resumes a paused or stopped progress indicator.

        **See also** **paused**  and **stopped** .
        """
        ...

    def pause(self) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#pause

        **[slot] void QWinTaskbarProgress::pause()**

        Pauses the progress indicator.

        **See also** **paused** .
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#visible-prop

        **visible : bool**

        This property holds whether the progress indicator is visible.

        The default value is `false`.

        **Access functions:**

        bool **isVisible** () const
        void **setVisible** (bool **visible** )

        **Notifier signal:**

        void **visibilityChanged** (bool **visible** )

        **Member Function Documentation**
        """
        ...

    def hide(self) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#hide

        **[slot] void QWinTaskbarProgress::hide()**

        Hides the progress indicator.
        """
        ...

    def show(self) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#show

        **[slot] void QWinTaskbarProgress::show()**

        Shows the progress indicator.
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#reset

        **[slot] void QWinTaskbarProgress::reset()**

        Resets the progress indicator.

        This function rewinds the value to the minimum value.
        """
        ...

    def setRange(self, minimum: int, maximum: int) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#setRange

        **[slot] void QWinTaskbarProgress::setRange(int minimum , int maximum
        )**

        Sets both the **minimum** and **maximum** values.
        """
        ...

    def setMaximum(self, maximum: int) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#maximum-prop

        **maximum : int**

        This property holds the maximum value of the progress indicator

        The default value is `100`.

        **Access functions:**

        int **maximum** () const
        void **setMaximum** (int **maximum** )

        **Notifier signal:**

        void **maximumChanged** (int **maximum** )
        """
        ...

    def setMinimum(self, minimum: int) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#minimum-prop

        **minimum : int**

        This property holds the minimum value of the progress indicator

        The default value is `0`.

        **Access functions:**

        int **minimum** () const
        void **setMinimum** (int **minimum** )

        **Notifier signal:**

        void **minimumChanged** (int **minimum** )
        """
        ...

    def setValue(self, value: int) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#value-prop

        **value : int**

        This property holds the current value of the progress indicator

        The default value is `0`.

        **Access functions:**

        int **value** () const
        void **setValue** (int **value** )

        **Notifier signal:**

        void **valueChanged** (int **value** )
        """
        ...

    def isStopped(self) -> bool:
        ...

    def isPaused(self) -> bool:
        ...

    def isVisible(self) -> bool:
        ...

    def maximum(self) -> int:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#maximum-prop

        **maximum : int**

        This property holds the maximum value of the progress indicator

        The default value is `100`.

        **Access functions:**

        int **maximum** () const
        void **setMaximum** (int **maximum** )

        **Notifier signal:**

        void **maximumChanged** (int **maximum** )
        """
        ...

    def minimum(self) -> int:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#minimum-prop

        **minimum : int**

        This property holds the minimum value of the progress indicator

        The default value is `0`.

        **Access functions:**

        int **minimum** () const
        void **setMinimum** (int **minimum** )

        **Notifier signal:**

        void **minimumChanged** (int **minimum** )
        """
        ...

    def value(self) -> int:
        """
        https://doc.qt.io/qt-5/qwintaskbarprogress.html#value-prop

        **value : int**

        This property holds the current value of the progress indicator

        The default value is `0`.

        **Access functions:**

        int **value** () const
        void **setValue** (int **value** )

        **Notifier signal:**

        void **valueChanged** (int **value** )
        """
        ...

    @property
    def maximumChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def minimumChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def pausedChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def stoppedChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def valueChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def visibilityChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
