"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtWinExtras import *


class QWinJumpList(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qwinjumplist.html

    **Detailed Description**

    An application can use Jump Lists to provide users with faster access to
    files or to display shortcuts to tasks or commands.
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qwinjumplist.html#QWinJumpList

        **QWinJumpList::QWinJumpList(QObject * parent = nullptr)**

        Constructs a QWinJumpList with the parent object **parent**.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qwinjumplist.html#clear

        **[slot] void QWinJumpList::clear()**

        Clears the jump list.

        **See also** **QWinJumpListCategory::clear** ().
        """
        ...

    @typing.overload
    def addCategory(self, category: "QWinJumpListCategory") -> None:
        """
        https://doc.qt.io/qt-5/qwinjumplist.html#addCategory

        **void QWinJumpList::addCategory(QWinJumpListCategory * category )**

        Adds a custom **category** to the jump list.
        """
        ...

    @typing.overload
    def addCategory(
        self, title: str, items: typing.Iterable["QWinJumpListItem"] = ...
    ) -> "QWinJumpListCategory":
        """
        https://doc.qt.io/qt-5/qwinjumplist.html#addCategory-1

        **QWinJumpListCategory *QWinJumpList::addCategory(const QString & title
        , const QList<QWinJumpListItem *> items = QList<QWinJumpListItem *>())**

        This function overloads addCategory().

        Creates a custom category with provided **title** and optional **items**
        , and adds it to the jump list.
        """
        ...

    def categories(self) -> typing.List["QWinJumpListCategory"]:
        """
        https://doc.qt.io/qt-5/qwinjumplist.html#categories

        **QList<QWinJumpListCategory *> QWinJumpList::categories() const**

        Returns the custom categories in the jump list.
        """
        ...

    def tasks(self) -> "QWinJumpListCategory":
        """
        https://doc.qt.io/qt-5/qwinjumplist.html#tasks

        **QWinJumpListCategory *QWinJumpList::tasks() const**

        Returns the tasks category in the jump list.
        """
        ...

    def frequent(self) -> "QWinJumpListCategory":
        """
        https://doc.qt.io/qt-5/qwinjumplist.html#frequent

        **QWinJumpListCategory *QWinJumpList::frequent() const**

        Returns the frequent items category in the jump list.
        """
        ...

    def recent(self) -> "QWinJumpListCategory":
        """
        https://doc.qt.io/qt-5/qwinjumplist.html#recent

        **QWinJumpListCategory *QWinJumpList::recent() const**

        Returns the recent items category in the jump list.
        """
        ...

    def setIdentifier(self, identifier: str) -> None:
        """
        https://doc.qt.io/qt-5/qwinjumplist.html#identifier-prop

        **identifier : QString**

        This property holds the jump list identifier

        Specifies an optional explicit unique identifier for the application
        jump list.

        The default value is empty; a system-defined internal identifier is used
        instead. See **Application User Model IDs**  on MSDN for further
        details.

        **Note:** The identifier cannot have more than `128` characters and
        cannot contain spaces. A too long identifier is automatically truncated
        to `128` characters, and spaces are replaced by underscores.

        **Access functions:**

        QString **identifier** () const
        void **setIdentifier** (const QString
        & **identifier** )

        **Member Function Documentation**
        """
        ...

    def identifier(self) -> str:
        """
        https://doc.qt.io/qt-5/qwinjumplist.html#identifier-prop

        **identifier : QString**

        This property holds the jump list identifier

        Specifies an optional explicit unique identifier for the application
        jump list.

        The default value is empty; a system-defined internal identifier is used
        instead. See **Application User Model IDs**  on MSDN for further
        details.

        **Note:** The identifier cannot have more than `128` characters and
        cannot contain spaces. A too long identifier is automatically truncated
        to `128` characters, and spaces are replaced by underscores.

        **Access functions:**

        QString **identifier** () const
        void **setIdentifier** (const QString
        & **identifier** )

        **Member Function Documentation**
        """
        ...
