"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *
from PyQt5 import sip


class QWizard(QDialog):
    """
    https://doc.qt.io/qt-5/qwizard.html

    **Detailed Description**

    A wizard (also called an assistant on macOS) is a special type of input
    dialog that consists of a sequence of pages. A wizard's purpose is to guide
    the user through a process step by step. Wizards are useful for complex or
    infrequent tasks that users may find difficult to learn.

    QWizard inherits **QDialog**  and represents a wizard. Each page is a
    **QWizardPage**  (a **QWidget**  subclass). To create your own wizards, you
    can use these classes directly, or you can subclass them for more control.

    Topics:

    **A Trivial Example**

    The following example illustrates how to create wizard pages and add them to
    a wizard. For more advanced examples, see **Class Wizard**  and **License
    Wizard** .

    **QWizardPage**  *createIntroPage()
        {
            **QWizardPage**  *page =
    new **QWizardPage** ;
            page->setTitle("Introduction");
    **QLabel**  *label = new **QLabel** ("This wizard will help you register
    your copy "
                                       "of Super Product Two.");
    label->setWordWrap(true);

            **QVBoxLayout**  *layout = new
    **QVBoxLayout** ;
            layout->addWidget(label);
    page->setLayout(layout);

            return page;
        }
    **QWizardPage**  *createRegistrationPage()
        {
            ...
        }
    **QWizardPage**  *createConclusionPage()
        {
            ...
        }
    int main(int argc, char *argv[])
        {
            **QCoreApplication**
    ::setAttribute(Qt::AA_UseHighDpiPixmaps);

            **QApplication**
    app(argc, argv);

        #ifndef QT_NO_TRANSLATION
            **QString**
    translatorFileName = QLatin1String("qtbase_");
            translatorFileName +=
    **QLocale** ::system().name();
            **QTranslator**  *translator = new
    **QTranslator** (&app);
            if (translator->load(translatorFileName,
    **QLibraryInfo** ::location(**QLibraryInfo** ::TranslationsPath)))
    app.installTranslator(translator);
        #endif

            **QWizard**
    wizard;
            wizard.addPage(createIntroPage());
    wizard.addPage(createRegistrationPage());
    wizard.addPage(createConclusionPage());
    wizard.setWindowTitle("Trivial Wizard");
            wizard.show();
    return app.exec();
        }

    **Wizard Look and Feel**

    QWizard supports four wizard looks:

    * **ClassicStyle**
      * **ModernStyle**
      * **MacStyle**
      * **AeroStyle**

    You can explicitly set the look to use using **setWizardStyle** () (e.g., if
    you want the same look on all platforms).

    **ClassicStyle** **ModernStyle** **MacStyle** **AeroStyle**
    ![](images/qtwizard-classic1.png)![](images/qtwizard-
    modern1.png)![](images/qtwizard-mac1.png)![](images/qtwizard-aero1.png)
    ![](images/qtwizard-classic2.png)![](images/qtwizard-
    modern2.png)![](images/qtwizard-mac2.png)![](images/qtwizard-aero2.png)

    Note: **AeroStyle**  has effect only on a Windows Vista system with alpha
    compositing enabled. **ModernStyle**  is used as a fallback when this
    condition is not met.

    In addition to the wizard style, there are several options that control the
    look and feel of the wizard. These can be set using **setOption** () or
    **setOptions** (). For example, **HaveHelpButton**  makes QWizard show a
    **Help** button along with the other wizard buttons.

    You can even change the order of the wizard buttons to any arbitrary order
    using **setButtonLayout** (), and you can add up to three custom buttons
    (e.g., a **Print** button) to the button row. This is achieved by calling
    **setButton** () or **setButtonText** () with **CustomButton1** ,
    **CustomButton2** , or **CustomButton3**  to set up the button, and by
    enabling the **HaveCustomButton1** , **HaveCustomButton2** , or
    **HaveCustomButton3**  options. Whenever the user clicks a custom button,
    **customButtonClicked** () is emitted. For example:

    wizard()->setButtonText(**QWizard** ::CustomButton1, tr("&Print"));
    wizard()->setOption(**QWizard** ::HaveCustomButton1, true);
    connect(wizard(), &**QWizard** ::customButtonClicked,
    this, &ConclusionPage::printButtonClicked);

    **Elements of a Wizard Page**

    Wizards consist of a sequence of **QWizardPage** s. At any time, only one
    page is shown. A page has the following attributes:

    * A **title** .
      * A **subTitle** .
      * A set of pixmaps, which may or may
    not be honored, depending on the wizard's style:
        * **WatermarkPixmap**
    (used by **ClassicStyle**  and **ModernStyle** )
        * **BannerPixmap**
    (used by **ModernStyle** )
        * **LogoPixmap**  (used by **ClassicStyle**
    and **ModernStyle** )
        * **BackgroundPixmap**  (used by **MacStyle** )

    The diagram belows shows how QWizard renders these attributes, assuming they
    are all present and **ModernStyle**  is used:

    ![](images/qtwizard-nonmacpage.png)

    When a **subTitle**  is set, QWizard displays it in a header, in which case
    it also uses the **BannerPixmap**  and the **LogoPixmap**  to decorate the
    header. The **WatermarkPixmap**  is displayed on the left side, below the
    header. At the bottom, there is a row of buttons allowing the user to
    navigate through the pages.

    The page itself (the **QWizardPage**  widget) occupies the area between the
    header, the watermark, and the button row. Typically, the page is a
    **QWizardPage**  on which a **QGridLayout**  is installed, with standard
    child widgets (**QLabel** s, **QLineEdit** s, etc.).

    If the wizard's style is **MacStyle** , the page looks radically different:

    ![](images/qtwizard-macpage.png)

    The watermark, banner, and logo pixmaps are ignored by the **MacStyle** . If
    the **BackgroundPixmap**  is set, it is used as the background for the
    wizard; otherwise, a default "assistant" image is used.

    The title and subtitle are set by calling **QWizardPage::setTitle** () and
    **QWizardPage::setSubTitle** () on the individual pages. They may be plain
    text or HTML (see **titleFormat**  and **subTitleFormat** ). The pixmaps can
    be set globally for the entire wizard using **setPixmap** (), or on a per-
    page basis using **QWizardPage::setPixmap** ().

    **Registering and Using Fields**

    In many wizards, the contents of a page may affect the default values of the
    fields of a later page. To make it easy to communicate between pages,
    QWizard supports a "field" mechanism that allows you to register a field
    (e.g., a **QLineEdit** ) on a page and to access its value from any page. It
    is also possible to specify mandatory fields (i.e., fields that must be
    filled before the user can advance to the next page).

    To register a field, call **QWizardPage::registerField** () field. For
    example:

    ClassInfoPage::ClassInfoPage(**QWidget**  *parent)
            : **QWizardPage**
    (parent)
        {
            ...
            classNameLabel = new **QLabel**
    (tr("&Class name:"));
            classNameLineEdit = new **QLineEdit** ;
    classNameLabel->setBuddy(classNameLineEdit);

            baseClassLabel =
    new **QLabel** (tr("B&ase class:"));
            baseClassLineEdit = new
    **QLineEdit** ;
            baseClassLabel->setBuddy(baseClassLineEdit);
    qobjectMacroCheckBox = new **QCheckBox** (tr("Generate Q_OBJECT &macro"));
    registerField("className*", classNameLineEdit);
    registerField("baseClass", baseClassLineEdit);
    registerField("qobjectMacro", qobjectMacroCheckBox);
            ...
        }

    The above code registers three fields, `className`, `baseClass`, and
    `qobjectMacro`, which are associated with three child widgets. The asterisk
    (`*`) next to `className` denotes a mandatory field.

    The fields of any page are accessible from any other page. For example:

    void OutputFilesPage::initializePage()
        {
            **QString**  className
    = field("className").toString();
    headerLineEdit->setText(className.toLower() + ".h");
    implementationLineEdit->setText(className.toLower() + ".cpp");
    outputDirLineEdit->setText(**QDir** ::toNativeSeparators(**QDir**
    ::tempPath()));
        }

    Here, we call **QWizardPage::field** () to access the contents of the
    `className` field (which was defined in the `ClassInfoPage`) and use it to
    initialize the `OutputFilePage`. The field's contents is returned as a
    **QVariant** .

    When we create a field using **QWizardPage::registerField** (), we pass a
    unique field name and a widget. We can also provide a Qt property name and a
    "changed" signal (a signal that is emitted when the property changes) as
    third and fourth arguments; however, this is not necessary for the most
    common Qt widgets, such as **QLineEdit** , **QCheckBox** , and **QComboBox**
    , because QWizard knows which properties to look for.

    If an asterisk (`*`) is appended to the name when the property is
    registered, the field is a **mandatory field**. When a page has mandatory
    fields, the **Next** and/or **Finish** buttons are enabled only when all
    mandatory fields are filled.

    To consider a field "filled", QWizard simply checks that the field's current
    value doesn't equal the original value (the value it had when
    **initializePage** () was called). For **QLineEdit**  and
    **QAbstractSpinBox**  subclasses, QWizard also checks that
    **hasAcceptableInput()**  returns true, to honor any validator or mask.

    QWizard's mandatory field mechanism is provided for convenience. A more
    powerful (but also more cumbersome) alternative is to reimplement
    **QWizardPage::isComplete** () and to emit the
    **QWizardPage::completeChanged** () signal whenever the page becomes
    complete or incomplete.

    The enabled/disabled state of the **Next** and/or **Finish** buttons is one
    way to perform validation on the user input. Another way is to reimplement
    **validateCurrentPage** () (or **QWizardPage::validatePage** ()) to perform
    some last-minute validation (and show an error message if the user has
    entered incomplete or invalid information). If the function returns `true`,
    the next page is shown (or the wizard finishes); otherwise, the current page
    stays up.

    **Creating Linear Wizards**

    Most wizards have a linear structure, with page 1 followed by page 2 and so
    on until the last page. The **Class Wizard**  example is such a wizard. With
    QWizard, linear wizards are created by instantiating the **QWizardPage** s
    and inserting them using **addPage** (). By default, the pages are shown in
    the order in which they were added. For example:

    ClassWizard::ClassWizard(**QWidget**  *parent)
            : **QWizard**
    (parent)
        {
            addPage(new IntroPage);
            addPage(new
    ClassInfoPage);
            addPage(new CodeStylePage);
            addPage(new
    OutputFilesPage);
            addPage(new ConclusionPage);
            ...
        }

    When a page is about to be shown, QWizard calls **initializePage** () (which
    in turn calls **QWizardPage::initializePage** ()) to fill the page with
    default values. By default, this function does nothing, but it can be
    reimplemented to initialize the page's contents based on other pages' fields
    (see the **example above** ).

    If the user presses **Back** , **cleanupPage** () is called (which in turn
    calls **QWizardPage::cleanupPage** ()). The default implementation resets
    the page's fields to their original values (the values they had before
    **initializePage** () was called). If you want the **Back** button to be
    non-destructive and keep the values entered by the user, simply enable the
    **IndependentPages**  option.

    **Creating Non-Linear Wizards**

    Some wizards are more complex in that they allow different traversal paths
    based on the information provided by the user. The **License Wizard**
    example illustrates this. It provides five wizard pages; depending on which
    options are selected, the user can reach different pages.

    ![](images/licensewizard-flow.png)

    In complex wizards, pages are identified by IDs. These IDs are typically
    defined using an enum. For example:

    class LicenseWizard : public **QWizard**
        {
            ...
            enum {
    Page_Intro, Page_Evaluate, Page_Register, Page_Details,
    Page_Conclusion };
            ...
        };

    The pages are inserted using **setPage** (), which takes an ID and an
    instance of **QWizardPage**  (or of a subclass):

    LicenseWizard::LicenseWizard(**QWidget**  *parent)
            : **QWizard**
    (parent)
        {
            setPage(Page_Intro, new IntroPage);
    setPage(Page_Evaluate, new EvaluatePage);
            setPage(Page_Register, new
    RegisterPage);
            setPage(Page_Details, new DetailsPage);
    setPage(Page_Conclusion, new ConclusionPage);
            ...
        }

    By default, the pages are shown in increasing ID order. To provide a dynamic
    order that depends on the options chosen by the user, we must reimplement
    **QWizardPage::nextId** (). For example:

    int IntroPage::nextId() const
        {
            if
    (evaluateRadioButton->isChecked()) {
                return
    LicenseWizard::Page_Evaluate;
            } else {
                return
    LicenseWizard::Page_Register;
            }
        }

        int
    EvaluatePage::nextId() const
        {
            return
    LicenseWizard::Page_Conclusion;
        }

        int RegisterPage::nextId()
    const
        {
            if (upgradeKeyLineEdit->text().isEmpty()) {
    return LicenseWizard::Page_Details;
            } else {
                return
    LicenseWizard::Page_Conclusion;
            }
        }

        int
    DetailsPage::nextId() const
        {
            return
    LicenseWizard::Page_Conclusion;
        }

        int ConclusionPage::nextId()
    const
        {
            return -1;
        }

    It would also be possible to put all the logic in one place, in a
    **QWizard::nextId** () reimplementation. For example:

    int LicenseWizard::nextId() const
        {
            switch (currentId()) {
    case Page_Intro:
                if (field("intro.evaluate").toBool()) {
    return Page_Evaluate;
                } else {
                    return
    Page_Register;
                }
            case Page_Evaluate:
                return
    Page_Conclusion;
            case Page_Register:
                if
    (field("register.upgradeKey").toString().isEmpty()) {
                    return
    Page_Details;
                } else {
                    return Page_Conclusion;
    }
            case Page_Details:
                return Page_Conclusion;
    case Page_Conclusion:
            default:
                return -1;
            }
    }

    To start at another page than the page with the lowest ID, call
    **setStartId** ().

    To test whether a page has been visited or not, call **hasVisitedPage** ().
    For example:

    void ConclusionPage::initializePage()
        {
            **QString**
    licenseText;

            if
    (wizard()->hasVisitedPage(LicenseWizard::Page_Evaluate)) {
    licenseText = tr("<u>Evaluation License Agreement:</u> "
    "You can use this software for 30 days and make one "
    "backup, but you are not allowed to distribute it.");
            } else if
    (wizard()->hasVisitedPage(LicenseWizard::Page_Details)) {
    licenseText = tr("<u>First-Time License Agreement:</u> "
    "You can use this software subject to the license "
    "you will receive by email.");
            } else {
                licenseText =
    tr("<u>Upgrade License Agreement:</u> "
                                 "This
    software is licensed under the terms of your "
    "current license.");
            }
            bottomLabel->setText(licenseText);
    }

    **See also** **QWizardPage** , **Class Wizard Example** , and **License
    Wizard Example** .
    """

    class WizardOption(int):
        IndependentPages: QWizard = ...
        IgnoreSubTitles: QWizard = ...
        ExtendedWatermarkPixmap: QWizard = ...
        NoDefaultButton: QWizard = ...
        NoBackButtonOnStartPage: QWizard = ...
        NoBackButtonOnLastPage: QWizard = ...
        DisabledBackButtonOnLastPage: QWizard = ...
        HaveNextButtonOnLastPage: QWizard = ...
        HaveFinishButtonOnEarlyPages: QWizard = ...
        NoCancelButton: QWizard = ...
        CancelButtonOnLeft: QWizard = ...
        HaveHelpButton: QWizard = ...
        HelpButtonOnRight: QWizard = ...
        HaveCustomButton1: QWizard = ...
        HaveCustomButton2: QWizard = ...
        HaveCustomButton3: QWizard = ...
        NoCancelButtonOnLastPage: QWizard = ...

    class WizardStyle(int):
        ClassicStyle: QWizard = ...
        ModernStyle: QWizard = ...
        MacStyle: QWizard = ...
        AeroStyle: QWizard = ...

    class WizardPixmap(int):
        WatermarkPixmap: QWizard = ...
        LogoPixmap: QWizard = ...
        BannerPixmap: QWizard = ...
        BackgroundPixmap: QWizard = ...

    class WizardButton(int):
        BackButton: QWizard = ...
        NextButton: QWizard = ...
        CommitButton: QWizard = ...
        FinishButton: QWizard = ...
        CancelButton: QWizard = ...
        HelpButton: QWizard = ...
        CustomButton1: QWizard = ...
        CustomButton2: QWizard = ...
        CustomButton3: QWizard = ...
        Stretch: QWizard = ...

    class WizardOptions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QWizard.WizardOptions", "QWizard.WizardOption"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QWizard.WizardOptions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QWizard.WizardOptions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(
        self,
        parent: typing.Optional[QWidget] = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#QWizard

        **QWizard::QWizard(QWidget * parent = nullptr, Qt::WindowFlags flags =
        Qt::WindowFlags())**

        Constructs a wizard with the given **parent** and window **flags**.

        **See also** **parent** () and **windowFlags** ().
        """
        ...

    def visitedIds(self) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qwizard.html#visitedIds

        **QList<int> QWizard::visitedIds() const**

        Returns the list of IDs of visited pages, in the order in which the
        pages were visited.

        This function was introduced in Qt 5.15.

        **See also** **hasVisitedPage** ().
        """
        ...

    def sideWidget(self) -> QWidget:
        """
        https://doc.qt.io/qt-5/qwizard.html#sideWidget

        **QWidget *QWizard::sideWidget() const**

        Returns the widget on the left side of the wizard or `nullptr`.

        By default, no side widget is present.

        This function was introduced in Qt 4.7.

        **See also** **setSideWidget** ().
        """
        ...

    def setSideWidget(self, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#setSideWidget

        **void QWizard::setSideWidget(QWidget * widget )**

        Sets the given **widget** to be shown on the left side of the wizard.
        For styles which use the **WatermarkPixmap**  (**ClassicStyle**  and
        **ModernStyle** ) the side widget is displayed on top of the watermark,
        for other styles or when the watermark is not provided the side widget
        is displayed on the left side of the wizard.

        Passing `nullptr` shows no side widget.

        When the **widget** is not `nullptr` the wizard reparents it.

        Any previous side widget is hidden.

        You may call setSideWidget() with the same widget at different times.

        All widgets set here will be deleted by the wizard when it is destroyed
        unless you separately reparent the widget after setting some other side
        widget (or `nullptr`).

        By default, no side widget is present.

        This function was introduced in Qt 4.7.

        **See also** **sideWidget** ().
        """
        ...

    def pageIds(self) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qwizard.html#pageIds

        **QList<int> QWizard::pageIds() const**

        Returns the list of page IDs.

        This function was introduced in Qt 4.5.
        """
        ...

    def removePage(self, id: int) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#removePage

        **void QWizard::removePage(int id )**

        Removes the page with the given **id**. **cleanupPage** () will be
        called if necessary.

        **Note:** Removing a page may influence the value of the **startId**
        property.

        This function was introduced in Qt 4.5.

        **See also** **addPage** (), **setPage** (), **pageRemoved** (), and
        **startId** ().
        """
        ...

    def cleanupPage(self, id: int) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#cleanupPage

        **[virtual protected] void QWizard::cleanupPage(int id )**

        This virtual function is called by **QWizard**  to clean up page **id**
        just before the user leaves it by clicking **Back** (unless the
        **QWizard::IndependentPages**  option is set).

        The default implementation calls **QWizardPage::cleanupPage** () on
        page( **id** ).

        **See also** **QWizardPage::cleanupPage** () and **initializePage** ().
        """
        ...

    def initializePage(self, id: int) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#initializePage

        **[virtual protected] void QWizard::initializePage(int id )**

        This virtual function is called by **QWizard**  to prepare page **id**
        just before it is shown either as a result of **QWizard::restart** ()
        being called, or as a result of the user clicking **Next**. (However, if
        the **QWizard::IndependentPages**  option is set, this function is only
        called the first time the page is shown.)

        By reimplementing this function, you can ensure that the page's fields
        are properly initialized based on fields from previous pages.

        The default implementation calls **QWizardPage::initializePage** () on
        page( **id** ).

        **See also** **QWizardPage::initializePage** () and **cleanupPage** ().
        """
        ...

    def done(self, result: int) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#done

        **[override virtual protected] void QWizard::done(int result )**

        Reimplements: **QDialog::done** (int r).
        """
        ...

    def paintEvent(self, event: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#paintEvent

        **[override virtual protected] void QWizard::paintEvent(QPaintEvent *
        event )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def resizeEvent(self, event: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#resizeEvent

        **[override virtual protected] void QWizard::resizeEvent(QResizeEvent *
        event )**

        Reimplements: **QDialog::resizeEvent** (QResizeEvent *).
        """
        ...

    def event(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qwizard.html#event

        **[override virtual protected] bool QWizard::event(QEvent * event )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def restart(self) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#restart

        **[slot] void QWizard::restart()**

        Restarts the wizard at the start page. This function is called
        automatically when the wizard is shown.

        **See also** **startId** ().
        """
        ...

    def next(self) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#next

        **[slot] void QWizard::next()**

        Advances to the next page.

        This is equivalent to pressing the **Next** or **Commit** button.

        **See also** **nextId** (), **back** (), **accept** (), **reject** (),
        and **restart** ().
        """
        ...

    def back(self) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#back

        **[slot] void QWizard::back()**

        Goes back to the previous page.

        This is equivalent to pressing the **Back** button.

        **See also** **next** (), **accept** (), **reject** (), and **restart**
        ().
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qwizard.html#sizeHint

        **[override virtual] QSize QWizard::sizeHint() const**

        Reimplements: **QDialog::sizeHint** () const.
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#setVisible

        **[override virtual] void QWizard::setVisible(bool visible )**

        Reimplements: **QDialog::setVisible** (bool visible).
        """
        ...

    def setDefaultProperty(
        self, className: str, property: str, changedSignal: PYQT_SIGNAL
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#setDefaultProperty

        **void QWizard::setDefaultProperty(const char * className , const char *
        property , const char * changedSignal )**

        Sets the default property for **className** to be **property** , and the
        associated change signal to be **changedSignal**.

        The default property is used when an instance of **className** (or of
        one of its subclasses) is passed to **QWizardPage::registerField** ()
        and no property is specified.

        **QWizard**  knows the most common Qt widgets. For these (or their
        subclasses), you don't need to specify a **property** or a
        **changedSignal**. The table below lists these widgets:

        WidgetPropertyChange Notification Signal
        **QAbstractButton** bool
        **checked** **toggled()**
        **QAbstractSlider** int **value**
        **valueChanged()**
        **QComboBox** int **currentIndex**
        **currentIndexChanged()**
        **QDateTimeEdit** **QDateTime**
        **dateTime** **dateTimeChanged()**
        **QLineEdit** **QString**  **text**
        **textChanged()**
        **QListWidget** int **currentRow**
        **currentRowChanged()**
        **QSpinBox** int **value** **valueChanged()**

        **See also** **QWizardPage::registerField** ().
        """
        ...

    def pixmap(self, which: "QWizard.WizardPixmap") -> QtGui.QPixmap:
        """
        https://doc.qt.io/qt-5/qwizard.html#pixmap

        **QPixmap QWizard::pixmap(QWizard::WizardPixmap which ) const**

        Returns the pixmap set for role **which**.

        By default, the only pixmap that is set is the **BackgroundPixmap**  on
        macOS version 10.13 and earlier.

        **See also** **setPixmap** (), **QWizardPage::pixmap** (), and
        **Elements of a Wizard Page** .
        """
        ...

    def setPixmap(self, which: "QWizard.WizardPixmap", pixmap: QtGui.QPixmap) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#setPixmap

        **void QWizard::setPixmap(QWizard::WizardPixmap which , const QPixmap &
        pixmap )**

        Sets the pixmap for role **which** to **pixmap**.

        The pixmaps are used by **QWizard**  when displaying a page. Which
        pixmaps are actually used depend on the **wizard style** .

        Pixmaps can also be set for a specific page using
        **QWizardPage::setPixmap** ().

        **See also** **pixmap** (), **QWizardPage::setPixmap** (), and
        **Elements of a Wizard Page** .
        """
        ...

    def subTitleFormat(self) -> QtCore.Qt.TextFormat:
        """
        https://doc.qt.io/qt-5/qwizard.html#subTitleFormat-prop

        **subTitleFormat : Qt::TextFormat**

        This property holds the text format used by page subtitles

        The default format is **Qt::AutoText** .

        **Access functions:**

        Qt::TextFormat **subTitleFormat** () const
        void **setSubTitleFormat**
        (Qt::TextFormat **format** )

        **See also** **QWizardPage::title**  and **titleFormat** .
        """
        ...

    def setSubTitleFormat(self, format: QtCore.Qt.TextFormat) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#subTitleFormat-prop

        **subTitleFormat : Qt::TextFormat**

        This property holds the text format used by page subtitles

        The default format is **Qt::AutoText** .

        **Access functions:**

        Qt::TextFormat **subTitleFormat** () const
        void **setSubTitleFormat**
        (Qt::TextFormat **format** )

        **See also** **QWizardPage::title**  and **titleFormat** .
        """
        ...

    def titleFormat(self) -> QtCore.Qt.TextFormat:
        """
        https://doc.qt.io/qt-5/qwizard.html#titleFormat-prop

        **titleFormat : Qt::TextFormat**

        This property holds the text format used by page titles

        The default format is **Qt::AutoText** .

        **Access functions:**

        Qt::TextFormat **titleFormat** () const
        void **setTitleFormat**
        (Qt::TextFormat **format** )

        **See also** **QWizardPage::title**  and **subTitleFormat** .
        """
        ...

    def setTitleFormat(self, format: QtCore.Qt.TextFormat) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#titleFormat-prop

        **titleFormat : Qt::TextFormat**

        This property holds the text format used by page titles

        The default format is **Qt::AutoText** .

        **Access functions:**

        Qt::TextFormat **titleFormat** () const
        void **setTitleFormat**
        (Qt::TextFormat **format** )

        **See also** **QWizardPage::title**  and **subTitleFormat** .
        """
        ...

    def button(self, which: "QWizard.WizardButton") -> QAbstractButton:
        """
        https://doc.qt.io/qt-5/qwizard.html#button

        **QAbstractButton *QWizard::button(QWizard::WizardButton which ) const**

        Returns the button corresponding to role **which**.

        **See also** **setButton** () and **setButtonText** ().
        """
        ...

    def setButton(self, which: "QWizard.WizardButton", button: QAbstractButton) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#setButton

        **void QWizard::setButton(QWizard::WizardButton which , QAbstractButton
        * button )**

        Sets the button corresponding to role **which** to **button**.

        To add extra buttons to the wizard (e.g., a **Print** button), one way
        is to call setButton() with **CustomButton1**  to **CustomButton3** ,
        and make the buttons visible using the **HaveCustomButton1**  to
        **HaveCustomButton3**  options.

        **See also** **button** (), **setButtonText** (), **setButtonLayout**
        (), and **options** .
        """
        ...

    def setButtonLayout(self, layout: typing.Iterable["QWizard.WizardButton"]) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#setButtonLayout

        **void QWizard::setButtonLayout(const QList<QWizard::WizardButton> &
        layout )**

        Sets the order in which buttons are displayed to **layout** , where
        **layout** is a list of **WizardButton** s.

        The default layout depends on the options (e.g., whether
        **HelpButtonOnRight** ) that are set. You can call this function if you
        need more control over the buttons' layout than what **options**
        already provides.

        You can specify horizontal stretches in the layout using **Stretch** .

        Example:

        MyWizard::MyWizard(**QWidget**  *parent)
                : **QWizard** (parent)
        {
                ...
                **QList** <**QWizard** ::WizardButton> layout;
        layout << **QWizard** ::Stretch << **QWizard** ::BackButton <<
        **QWizard** ::CancelButton
                       << **QWizard** ::NextButton <<
        **QWizard** ::FinishButton;
                setButtonLayout(layout);
                ...
        }

        **See also** **setButton** (), **setButtonText** (), and **setOptions**
        ().
        """
        ...

    def buttonText(self, which: "QWizard.WizardButton") -> str:
        """
        https://doc.qt.io/qt-5/qwizard.html#buttonText

        **QString QWizard::buttonText(QWizard::WizardButton which ) const**

        Returns the text on button **which**.

        If a text has ben set using **setButtonText** (), this text is returned.

        By default, the text on buttons depends on the **wizardStyle** . For
        example, on macOS, the **Next** button is called **Continue**.

        **See also** **button** (), **setButton** (), **setButtonText** (),
        **QWizardPage::buttonText** (), and **QWizardPage::setButtonText** ().
        """
        ...

    def setButtonText(self, which: "QWizard.WizardButton", text: str) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#setButtonText

        **void QWizard::setButtonText(QWizard::WizardButton which , const
        QString & text )**

        Sets the text on button **which** to be **text**.

        By default, the text on buttons depends on the **wizardStyle** . For
        example, on macOS, the **Next** button is called **Continue**.

        To add extra buttons to the wizard (e.g., a **Print** button), one way
        is to call setButtonText() with **CustomButton1** , **CustomButton2** ,
        or **CustomButton3**  to set their text, and make the buttons visible
        using the **HaveCustomButton1** , **HaveCustomButton2** , and/or
        **HaveCustomButton3**  options.

        Button texts may also be set on a per-page basis using
        **QWizardPage::setButtonText** ().

        **See also** **buttonText** (), **setButton** (), **button** (),
        **setButtonLayout** (), **setOptions** (), and
        **QWizardPage::setButtonText** ().
        """
        ...

    def options(self) -> "QWizard.WizardOptions":
        """
        https://doc.qt.io/qt-5/qwizard.html#options-prop

        **options : WizardOptions**

        This property holds the various options that affect the look and feel of
        the wizard

        By default, the following options are set (depending on the platform):

        * Windows: **HelpButtonOnRight** .
          * macOS: **NoDefaultButton**  and
        **NoCancelButton** .
          * X11 and QWS (Qt for Embedded Linux): none.

        **Access functions:**

        QWizard::WizardOptions **options** () const
        void **setOptions**
        (QWizard::WizardOptions **options** )

        **See also** **wizardStyle** .
        """
        ...

    def setOptions(
        self, options: typing.Union["QWizard.WizardOptions", "QWizard.WizardOption"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#options-prop

        **options : WizardOptions**

        This property holds the various options that affect the look and feel of
        the wizard

        By default, the following options are set (depending on the platform):

        * Windows: **HelpButtonOnRight** .
          * macOS: **NoDefaultButton**  and
        **NoCancelButton** .
          * X11 and QWS (Qt for Embedded Linux): none.

        **Access functions:**

        QWizard::WizardOptions **options** () const
        void **setOptions**
        (QWizard::WizardOptions **options** )

        **See also** **wizardStyle** .
        """
        ...

    def testOption(self, option: "QWizard.WizardOption") -> bool:
        """
        https://doc.qt.io/qt-5/qwizard.html#testOption

        **bool QWizard::testOption(QWizard::WizardOption option ) const**

        Returns `true` if the given **option** is enabled; otherwise, returns
        false.

        **See also** **options** , **setOption** (), and **setWizardStyle** ().
        """
        ...

    def setOption(self, option: "QWizard.WizardOption", on: bool = ...) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#setOption

        **void QWizard::setOption(QWizard::WizardOption option , bool on =
        true)**

        Sets the given **option** to be enabled if **on** is true; otherwise,
        clears the given **option**.

        **See also** **options** , **testOption** (), and **setWizardStyle** ().
        """
        ...

    def wizardStyle(self) -> "QWizard.WizardStyle":
        """
        https://doc.qt.io/qt-5/qwizard.html#wizardStyle-prop

        **wizardStyle : WizardStyle**

        This property holds the look and feel of the wizard

        By default, **QWizard**  uses the **AeroStyle**  on a Windows Vista
        system with alpha compositing enabled, regardless of the current widget
        style. If this is not the case, the default wizard style depends on the
        current widget style as follows: **MacStyle**  is the default if the
        current widget style is QMacStyle, **ModernStyle**  is the default if
        the current widget style is QWindowsStyle, and **ClassicStyle**  is the
        default in all other cases.

        **Access functions:**

        QWizard::WizardStyle **wizardStyle** () const
        void **setWizardStyle**
        (QWizard::WizardStyle **style** )

        **See also** **Wizard Look and Feel**  and **options** .

        **Member Function Documentation**
        """
        ...

    def setWizardStyle(self, style: "QWizard.WizardStyle") -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#wizardStyle-prop

        **wizardStyle : WizardStyle**

        This property holds the look and feel of the wizard

        By default, **QWizard**  uses the **AeroStyle**  on a Windows Vista
        system with alpha compositing enabled, regardless of the current widget
        style. If this is not the case, the default wizard style depends on the
        current widget style as follows: **MacStyle**  is the default if the
        current widget style is QMacStyle, **ModernStyle**  is the default if
        the current widget style is QWindowsStyle, and **ClassicStyle**  is the
        default in all other cases.

        **Access functions:**

        QWizard::WizardStyle **wizardStyle** () const
        void **setWizardStyle**
        (QWizard::WizardStyle **style** )

        **See also** **Wizard Look and Feel**  and **options** .

        **Member Function Documentation**
        """
        ...

    def field(self, name: str) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qwizard.html#field

        **QVariant QWizard::field(const QString & name ) const**

        Returns the value of the field called **name**.

        This function can be used to access fields on any page of the wizard.

        **See also** **QWizardPage::registerField** (), **QWizardPage::field**
        (), and **setField** ().
        """
        ...

    def setField(self, name: str, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#setField

        **void QWizard::setField(const QString & name , const QVariant & value
        )**

        Sets the value of the field called **name** to **value**.

        This function can be used to set fields on any page of the wizard.

        **See also** **QWizardPage::registerField** (),
        **QWizardPage::setField** (), and **field** ().
        """
        ...

    def nextId(self) -> int:
        """
        https://doc.qt.io/qt-5/qwizard.html#nextId

        **[virtual] int QWizard::nextId() const**

        This virtual function is called by **QWizard**  to find out which page
        to show when the user clicks the **Next** button.

        The return value is the ID of the next page, or -1 if no page follows.

        The default implementation calls **QWizardPage::nextId** () on the
        **currentPage** ().

        By reimplementing this function, you can specify a dynamic page order.

        **See also** **QWizardPage::nextId** () and **currentPage** ().
        """
        ...

    def validateCurrentPage(self) -> bool:
        """
        https://doc.qt.io/qt-5/qwizard.html#validateCurrentPage

        **[virtual] bool QWizard::validateCurrentPage()**

        This virtual function is called by **QWizard**  when the user clicks
        **Next** or **Finish** to perform some last-minute validation. If it
        returns `true`, the next page is shown (or the wizard finishes);
        otherwise, the current page stays up.

        The default implementation calls **QWizardPage::validatePage** () on the
        **currentPage** ().

        When possible, it is usually better style to disable the **Next** or
        **Finish** button (by specifying **mandatory fields**  or by
        reimplementing **QWizardPage::isComplete** ()) than to reimplement
        validateCurrentPage().

        **See also** **QWizardPage::validatePage** () and **currentPage** ().
        """
        ...

    def currentId(self) -> int:
        """
        https://doc.qt.io/qt-5/qwizard.html#currentId-prop

        **currentId : const int**

        This property holds the ID of the current page

        This property cannot be set directly. To change the current page, call
        **next** (), **back** (), or **restart** ().

        By default, this property has a value of -1, indicating that no page is
        currently shown.

        **Access functions:**

        int **currentId** () const

        **Notifier signal:**

        void ****currentIdChanged** ** (int **id** )

        **See also** **currentPage** ().
        """
        ...

    def currentPage(self) -> "QWizardPage":
        """
        https://doc.qt.io/qt-5/qwizard.html#currentPage

        **QWizardPage *QWizard::currentPage() const**

        Returns a pointer to the current page, or `nullptr` if there is no
        current page (e.g., before the wizard is shown).

        This is equivalent to calling page(**currentId** ()).

        **See also** **page** (), **currentId** (), and **restart** ().
        """
        ...

    def startId(self) -> int:
        """
        https://doc.qt.io/qt-5/qwizard.html#startId-prop

        **startId : int**

        This property holds the ID of the first page

        If this property isn't explicitly set, this property defaults to the
        lowest page ID in this wizard, or -1 if no page has been inserted yet.

        **Access functions:**

        int **startId** () const
        void **setStartId** (int **id** )

        **See also** **restart** () and **nextId** ().
        """
        ...

    def setStartId(self, id: int) -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#startId-prop

        **startId : int**

        This property holds the ID of the first page

        If this property isn't explicitly set, this property defaults to the
        lowest page ID in this wizard, or -1 if no page has been inserted yet.

        **Access functions:**

        int **startId** () const
        void **setStartId** (int **id** )

        **See also** **restart** () and **nextId** ().
        """
        ...

    def visitedPages(self) -> typing.List[int]:
        ...

    def hasVisitedPage(self, id: int) -> bool:
        """
        https://doc.qt.io/qt-5/qwizard.html#hasVisitedPage

        **bool QWizard::hasVisitedPage(int id ) const**

        Returns `true` if the page history contains page **id** ; otherwise,
        returns `false`.

        Pressing **Back** marks the current page as "unvisited" again.

        **See also** **visitedPages** ().
        """
        ...

    def page(self, id: int) -> "QWizardPage":
        """
        https://doc.qt.io/qt-5/qwizard.html#page

        **QWizardPage *QWizard::page(int id ) const**

        Returns the page with the given **id** , or `nullptr` if there is no
        such page.

        **See also** **addPage** () and **setPage** ().
        """
        ...

    def setPage(self, id: int, page: "QWizardPage") -> None:
        """
        https://doc.qt.io/qt-5/qwizard.html#setPage

        **void QWizard::setPage(int id , QWizardPage * page )**

        Adds the given **page** to the wizard with the given **id**.

        **Note:** Adding a page may influence the value of the **startId**
        property in case it was not set explicitly.

        **See also** **addPage** (), **page** (), and **pageAdded** ().
        """
        ...

    def addPage(self, page: "QWizardPage") -> int:
        """
        https://doc.qt.io/qt-5/qwizard.html#addPage

        **int QWizard::addPage(QWizardPage * page )**

        Adds the given **page** to the wizard, and returns the page's ID.

        The ID is guaranteed to be larger than any other ID in the **QWizard**
        so far.

        **See also** **setPage** (), **page** (), and **pageAdded** ().
        """
        ...

    @property
    def currentIdChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwizard.html#currentIdChanged

        **[signal] void QWizard::currentIdChanged(int id )**

        This signal is emitted when the current page changes, with the new
        current **id**.

        **Note:** Notifier signal for property **currentId** .

        **See also** **currentId** () and **currentPage** ().
        """
        ...

    @property
    def customButtonClicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwizard.html#customButtonClicked

        **[signal] void QWizard::customButtonClicked(int which )**

        This signal is emitted when the user clicks a custom button. **which**
        can be **CustomButton1** , **CustomButton2** , or **CustomButton3** .

        By default, no custom button is shown. Call **setOption** () with
        **HaveCustomButton1** , **HaveCustomButton2** , or **HaveCustomButton3**
        to have one, and use **setButtonText** () or **setButton** () to
        configure it.

        **See also** **helpRequested** ().
        """
        ...

    @property
    def helpRequested(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwizard.html#helpRequested

        **[signal] void QWizard::helpRequested()**

        This signal is emitted when the user clicks the **Help** button.

        By default, no **Help** button is shown. Call **setOption**
        (**HaveHelpButton** , true) to have one.

        Example:

        LicenseWizard::LicenseWizard(**QWidget**  *parent)
                : **QWizard**
        (parent)
            {
                ...
                setOption(HaveHelpButton, true);
        connect(this, &**QWizard** ::helpRequested, this,
        &LicenseWizard::showHelp);
                ...
            }

            void
        LicenseWizard::showHelp()
            {
                static **QString**
        lastHelpMessage;

                **QString**  message;

                switch
        (currentId()) {
                case Page_Intro:
                    message = tr("The
        decision you make here will affect which page you "
        "get to see next.");
                    break;
                ...
                default:
        message = tr("This help is likely not to be of any help.");
                }
        **QMessageBox** ::information(this, tr("License Wizard Help"), message);
        }

        **See also** **customButtonClicked** ().
        """
        ...

    @property
    def pageAdded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwizard.html#pageAdded

        **[signal] void QWizard::pageAdded(int id )**

        This signal is emitted whenever a page is added to the wizard. The
        page's **id** is passed as parameter.

        This function was introduced in Qt 4.7.

        **See also** **addPage** (), **setPage** (), and **startId** ().
        """
        ...

    @property
    def pageRemoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwizard.html#pageRemoved

        **[signal] void QWizard::pageRemoved(int id )**

        This signal is emitted whenever a page is removed from the wizard. The
        page's **id** is passed as parameter.

        This function was introduced in Qt 4.7.

        **See also** **removePage** () and **startId** ().
        """
        ...
