"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5.QtWidgets import *


class QUndoView(QListView):
    """
    https://doc.qt.io/qt-5/qundoview.html

    **Detailed Description**

    QUndoView is a **QListView**  which displays the list of commands pushed on
    an undo stack. The most recently executed command is always selected.
    Selecting a different command results in a call to **QUndoStack::setIndex**
    (), rolling the state of the document backwards or forward to the new
    command.

    The stack can be set explicitly with **setStack** (). Alternatively, a
    **QUndoGroup**  object can be set with **setGroup** (). The view will then
    update itself automatically whenever the active stack of the group changes.

    ![](images/qundoview.png)
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qundoview.html#QUndoView

        **QUndoView::QUndoView(QWidget * parent = nullptr)**

        Constructs a new view with parent **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, stack: QUndoStack, parent: typing.Optional[QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qundoview.html#QUndoView-1

        **QUndoView::QUndoView(QUndoStack * stack , QWidget * parent =
        nullptr)**

        Constructs a new view with parent **parent** and sets the observed stack
        to **stack**.
        """
        ...

    @typing.overload
    def __init__(
        self, group: QUndoGroup, parent: typing.Optional[QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qundoview.html#QUndoView-2

        **QUndoView::QUndoView(QUndoGroup * group , QWidget * parent =
        nullptr)**

        Constructs a new view with parent **parent** and sets the observed group
        to **group**.

        The view will update itself autmiatically whenever the active stack of
        the group changes.
        """
        ...

    def setGroup(self, group: QUndoGroup) -> None:
        """
        https://doc.qt.io/qt-5/qundoview.html#setGroup

        **[slot] void QUndoView::setGroup(QUndoGroup * group )**

        Sets the group displayed by this view to **group**. If **group** is
        `nullptr`, the view will be empty.

        The view will update itself automatically whenever the active stack of
        the group changes.

        **See also** **group** () and **setStack** ().
        """
        ...

    def setStack(self, stack: QUndoStack) -> None:
        """
        https://doc.qt.io/qt-5/qundoview.html#setStack

        **[slot] void QUndoView::setStack(QUndoStack * stack )**

        Sets the stack displayed by this view to **stack**. If **stack** is
        `nullptr`, the view will be empty.

        If the view was previously looking at a **QUndoGroup** , the group is
        set to `nullptr`.

        **See also** **stack** () and **setGroup** ().
        """
        ...

    def cleanIcon(self) -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-5/qundoview.html#cleanIcon-prop

        **cleanIcon : QIcon**

        This property holds the icon used to represent the clean state.

        A stack may have a clean state set with **QUndoStack::setClean** ().
        This is usually the state of the document at the point it was saved.
        **QUndoView**  can display an icon in the list of commands to show the
        clean state. If this property is a null icon, no icon is shown. The
        default value is the null icon.

        **Access functions:**

        QIcon **cleanIcon** () const
        void **setCleanIcon** (const QIcon &
        **icon** )
        """
        ...

    def setCleanIcon(self, icon: QtGui.QIcon) -> None:
        """
        https://doc.qt.io/qt-5/qundoview.html#cleanIcon-prop

        **cleanIcon : QIcon**

        This property holds the icon used to represent the clean state.

        A stack may have a clean state set with **QUndoStack::setClean** ().
        This is usually the state of the document at the point it was saved.
        **QUndoView**  can display an icon in the list of commands to show the
        clean state. If this property is a null icon, no icon is shown. The
        default value is the null icon.

        **Access functions:**

        QIcon **cleanIcon** () const
        void **setCleanIcon** (const QIcon &
        **icon** )
        """
        ...

    def emptyLabel(self) -> str:
        """
        https://doc.qt.io/qt-5/qundoview.html#emptyLabel-prop

        **emptyLabel : QString**

        This property holds the label used for the empty state.

        The empty label is the topmost element in the list of commands, which
        represents the state of the document before any commands were pushed on
        the stack. The default is the string "<empty>".

        **Access functions:**

        QString **emptyLabel** () const
        void **setEmptyLabel** (const QString
        & **label** )

        **Member Function Documentation**
        """
        ...

    def setEmptyLabel(self, label: str) -> None:
        """
        https://doc.qt.io/qt-5/qundoview.html#emptyLabel-prop

        **emptyLabel : QString**

        This property holds the label used for the empty state.

        The empty label is the topmost element in the list of commands, which
        represents the state of the document before any commands were pushed on
        the stack. The default is the string "<empty>".

        **Access functions:**

        QString **emptyLabel** () const
        void **setEmptyLabel** (const QString
        & **label** )

        **Member Function Documentation**
        """
        ...

    def group(self) -> QUndoGroup:
        """
        https://doc.qt.io/qt-5/qundoview.html#group

        **QUndoGroup *QUndoView::group() const**

        Returns the group displayed by this view.

        If the view is not looking at group, this function returns `nullptr`.

        **See also** **setGroup** () and **setStack** ().
        """
        ...

    def stack(self) -> QUndoStack:
        """
        https://doc.qt.io/qt-5/qundoview.html#stack

        **QUndoStack *QUndoView::stack() const**

        Returns the stack currently displayed by this view. If the view is
        looking at a **QUndoGroup** , this the group's active stack.

        **See also** **setStack** () and **setGroup** ().
        """
        ...
