"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *
from PyQt5 import sip


class QToolTip(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qtooltip.html

    **Detailed Description**

    The tip is a short piece of text reminding the user of the widget's
    function. It is drawn immediately below the given position in a distinctive
    black-on-yellow color combination. The tip can be any **rich text**
    formatted string.

    Rich text displayed in a tool tip is implicitly word-wrapped unless
    specified differently with `<p style='white-space:pre'>`.

    The simplest and most common way to set a widget's tool tip is by calling
    its **QWidget::setToolTip** () function.

    It is also possible to show different tool tips for different regions of a
    widget, by using a **QHelpEvent**  of type **QEvent::ToolTip** . Intercept
    the help event in your widget's **event()**  function and call
    **QToolTip::showText** () with the text you want to display. The
    **Tooltips**  example illustrates this technique.

    If you are calling **QToolTip::hideText** (), or **QToolTip::showText** ()
    with an empty string, as a result of a **ToolTip** -event you should also
    call **ignore()**  on the event, to signal that you don't want to start any
    tooltip specific modes.

    Note that, if you want to show tooltips in an item view, the model/view
    architecture provides functionality to set an item's tool tip; e.g., the
    **QTableWidgetItem::setToolTip** () function. However, if you want to
    provide custom tool tips in an item view, you must intercept the help event
    in the **QAbstractItemView::viewportEvent** () function and handle it
    yourself.

    The default tool tip color and font can be customized with **setPalette** ()
    and **setFont** (). When a tooltip is currently on display, **isVisible** ()
    returns `true` and **text** () the currently visible text.

    **Note:** Tool tips use the inactive color group of **QPalette** , because
    tool tips are not active windows.

    **See also** **QWidget::toolTip** , **QAction::toolTip** , and **Tool Tips
    Example** .
    """

    def __init__(self, a0: "QToolTip") -> None:
        ...

    @staticmethod
    def text() -> str:
        """
        https://doc.qt.io/qt-5/qtooltip.html#text

        **[static] QString QToolTip::text()**

        Returns the tooltip text, if a tooltip is visible, or an empty string if
        a tooltip is not visible.

        This function was introduced in Qt 4.4.
        """
        ...

    @staticmethod
    def isVisible() -> bool:
        """
        https://doc.qt.io/qt-5/qtooltip.html#isVisible

        **[static] bool QToolTip::isVisible()**

        Returns `true` if this tooltip is currently shown.

        This function was introduced in Qt 4.4.

        **See also** **showText** ().
        """
        ...

    @staticmethod
    def setFont(a0: QtGui.QFont) -> None:
        """
        https://doc.qt.io/qt-5/qtooltip.html#setFont

        **[static] void QToolTip::setFont(const QFont & font )**

        Sets the **font** used to render tooltips.

        This function was introduced in Qt 4.2.

        **See also** **font** ().
        """
        ...

    @staticmethod
    def font() -> QtGui.QFont:
        """
        https://doc.qt.io/qt-5/qtooltip.html#font

        **[static] QFont QToolTip::font()**

        Returns the font used to render tooltips.

        This function was introduced in Qt 4.2.

        **See also** **setFont** ().
        """
        ...

    @staticmethod
    def setPalette(a0: QtGui.QPalette) -> None:
        """
        https://doc.qt.io/qt-5/qtooltip.html#setPalette

        **[static] void QToolTip::setPalette(const QPalette & palette )**

        Sets the **palette** used to render tooltips.

        **Note:** Tool tips use the inactive color group of **QPalette** ,
        because tool tips are not active windows.

        This function was introduced in Qt 4.2.

        **See also** **palette** ().
        """
        ...

    @staticmethod
    def hideText() -> None:
        """
        https://doc.qt.io/qt-5/qtooltip.html#hideText

        **[static] void QToolTip::hideText()**

        Hides the tool tip. This is the same as calling **showText** () with an
        empty string.

        This function was introduced in Qt 4.2.

        **See also** **showText** ().
        """
        ...

    @staticmethod
    def palette() -> QtGui.QPalette:
        """
        https://doc.qt.io/qt-5/qtooltip.html#palette

        **[static] QPalette QToolTip::palette()**

        Returns the palette used to render tooltips.

        **Note:** Tool tips use the inactive color group of **QPalette** ,
        because tool tips are not active windows.

        **See also** **setPalette** ().
        """
        ...

    @typing.overload
    @staticmethod
    def showText(
        pos: QtCore.QPoint, text: str, widget: typing.Optional[QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtooltip.html#showText

        **[static] void QToolTip::showText(const QPoint & pos , const QString &
        text , QWidget * w , const QRect & rect )**

        Shows **text** as a tool tip, with the global position **pos** as the
        point of interest. The tool tip will be shown with a platform specific
        offset from this point of interest.

        If you specify a non-empty rect the tip will be hidden as soon as you
        move your cursor out of this area.

        The **rect** is in the coordinates of the widget you specify with **w**.
        If the **rect** is not empty you must specify a widget. Otherwise this
        argument can be `nullptr` but it is used to determine the appropriate
        screen on multi-head systems.

        If **text** is empty the tool tip is hidden. If the text is the same as
        the currently shown tooltip, the tip will **not** move. You can force
        moving by first hiding the tip with an empty text, and then showing the
        new tip at the new position.
        """
        ...

    @typing.overload
    @staticmethod
    def showText(pos: QtCore.QPoint, text: str, w: QWidget, rect: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qtooltip.html#showText-1

        **[static] void QToolTip::showText(const QPoint & pos , const QString &
        text , QWidget * w = nullptr)**

        This is an overloaded function.

        This is analogous to calling **QToolTip::showText** ( **pos** , **text**
        , **w** , QRect())
        """
        ...

    @typing.overload
    @staticmethod
    def showText(
        pos: QtCore.QPoint, text: str, w: QWidget, rect: QtCore.QRect, msecShowTime: int
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtooltip.html#showText-2

        **[static] void QToolTip::showText(const QPoint & pos , const QString &
        text , QWidget * w , const QRect & rect , int msecDisplayTime )**

        This is an overloaded function.

        This is similar to **QToolTip::showText** ( **pos** , **text** , **w** ,
        **rect** ) but with an extra parameter **msecDisplayTime** that
        specifies how long the tool tip will be displayed, in milliseconds.

        This function was introduced in Qt 5.2.
        """
        ...
