"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import sip


class QTableWidgetSelectionRange(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qtablewidgetselectionrange.html

    **Detailed Description**

    The QTableWidgetSelectionRange class stores the top left and bottom right
    rows and columns of a selection range in a table. The selections in the
    table may consist of several selection ranges.

    **Note:** If the item within the selection range is marked as not
    selectable, e.g., `itemFlags() & Qt::ItemIsSelectable == 0` then it will not
    appear in the selection range.

    **See also** **QTableWidget** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidgetselectionrange.html#QTableWidgetSelec
        tionRange

        **QTableWidgetSelectionRange::QTableWidgetSelectionRange()**

        Constructs an table selection range, i.e. a range whose **rowCount** ()
        and **columnCount** () are 0.
        """
        ...

    @typing.overload
    def __init__(self, top: int, left: int, bottom: int, right: int) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidgetselectionrange.html#QTableWidgetSelec
        tionRange-1

        **QTableWidgetSelectionRange::QTableWidgetSelectionRange(int top , int
        left , int bottom , int right )**

        Constructs the table selection range from the given **top** , **left** ,
        **bottom** and **right** table rows and columns.

        **See also** **topRow** (), **leftColumn** (), **bottomRow** (), and
        **rightColumn** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QTableWidgetSelectionRange") -> None:
        """
        https://doc.qt.io/qt-5/qtablewidgetselectionrange.html#QTableWidgetSelec
        tionRange-2

        **QTableWidgetSelectionRange::QTableWidgetSelectionRange(const
        QTableWidgetSelectionRange & other )**

        Constructs a the table selection range by copying the given **other**
        table selection range.
        """
        ...

    def columnCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidgetselectionrange.html#columnCount

        **int QTableWidgetSelectionRange::columnCount() const**

        Returns the number of columns in the range.

        This is equivalent to **rightColumn** () - **leftColumn** () + 1.

        This function was introduced in Qt 4.1.

        **See also** **rowCount** (), **leftColumn** (), and **rightColumn** ().
        """
        ...

    def rowCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidgetselectionrange.html#rowCount

        **int QTableWidgetSelectionRange::rowCount() const**

        Returns the number of rows in the range.

        This is equivalent to **bottomRow** () - **topRow** () + 1.

        This function was introduced in Qt 4.1.

        **See also** **columnCount** (), **topRow** (), and **bottomRow** ().
        """
        ...

    def rightColumn(self) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidgetselectionrange.html#rightColumn

        **int QTableWidgetSelectionRange::rightColumn() const**

        Returns the right column of the range.

        **See also** **leftColumn** (), **bottomRow** (), and **columnCount**
        ().
        """
        ...

    def leftColumn(self) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidgetselectionrange.html#leftColumn

        **int QTableWidgetSelectionRange::leftColumn() const**

        Returns the left column of the range.

        **See also** **rightColumn** (), **topRow** (), and **columnCount** ().
        """
        ...

    def bottomRow(self) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidgetselectionrange.html#bottomRow

        **int QTableWidgetSelectionRange::bottomRow() const**

        Returns the bottom row of the range.

        **See also** **topRow** (), **rightColumn** (), and **rowCount** ().
        """
        ...

    def topRow(self) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidgetselectionrange.html#topRow

        **int QTableWidgetSelectionRange::topRow() const**

        Returns the top row of the range.

        **See also** **bottomRow** (), **leftColumn** (), and **rowCount** ().
        """
        ...
