"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QTabBar(QWidget):
    """
    https://doc.qt.io/qt-5/qtabbar.html

    **Detailed Description**

    QTabBar is straightforward to use; it draws the tabs using one of the
    predefined **shapes** , and emits a signal when a tab is selected. It can be
    subclassed to tailor the look and feel. Qt also provides a ready-made
    **QTabWidget** .

    Each tab has a **tabText** (), an optional **tabIcon** (), an optional
    **tabToolTip** (), optional **tabWhatsThis** () and optional **tabData** ().
    The tabs's attributes can be changed with **setTabText** (), **setTabIcon**
    (), **setTabToolTip** (), **setTabWhatsThis**  and **setTabData** (). Each
    tabs can be enabled or disabled individually with **setTabEnabled** ().

    Each tab can display text in a distinct color. The current text color for a
    tab can be found with the **tabTextColor** () function. Set the text color
    for a particular tab with **setTabTextColor** ().

    Tabs are added using **addTab** (), or inserted at particular positions
    using **insertTab** (). The total number of tabs is given by **count** ().
    Tabs can be removed from the tab bar with **removeTab** (). Combining
    **removeTab** () and **insertTab** () allows you to move tabs to different
    positions.

    The **shape**  property defines the tabs' appearance. The choice of shape is
    a matter of taste, although tab dialogs (for preferences and similar)
    invariably use **RoundedNorth** . Tab controls in windows other than dialogs
    almost always use either **RoundedSouth**  or **TriangularSouth** . Many
    spreadsheets and other tab controls in which all the pages are essentially
    similar use **TriangularSouth** , whereas **RoundedSouth**  is used mostly
    when the pages are different (e.g. a multi-page tool palette). The default
    in QTabBar is **RoundedNorth** .

    The most important part of QTabBar's API is the **currentChanged** ()
    signal. This is emitted whenever the current tab changes (even at startup,
    when the current tab changes from 'none'). There is also a slot,
    **setCurrentIndex** (), which can be used to select a tab programmatically.
    The function **currentIndex** () returns the index of the current tab,
    **count**  holds the number of tabs.

    QTabBar creates automatic mnemonic keys in the manner of **QAbstractButton**
    ; e.g. if a tab's label is "&Graphics", Alt+G becomes a shortcut key for
    switching to that tab.

    The following virtual functions may need to be reimplemented in order to
    tailor the look and feel or store extra data with each tab:

    * **tabSizeHint** () calcuates the size of a tab.
      * **tabInserted** ()
    notifies that a new tab was added.
      * **tabRemoved** () notifies that a tab
    was removed.
      * **tabLayoutChange** () notifies that the tabs have been re-
    laid out.
      * **paintEvent** () paints all tabs.

    For subclasses, you might also need the **tabRect** () functions which
    returns the visual geometry of a single tab.

    ![Screenshot of a Fusion style tab bar](images/fusion-tabbar.png)A tab bar
    shown in the **Fusion widget style** .
    ![Screenshot of a truncated Fusion
    tab bar](images/fusion-tabbar-truncated.png)A truncated tab bar shown in the
    Fusion widget style.

    **See also** **QTabWidget** .
    """

    class SelectionBehavior(int):
        SelectLeftTab: QTabBar = ...
        SelectRightTab: QTabBar = ...
        SelectPreviousTab: QTabBar = ...

    class ButtonPosition(int):
        LeftSide: QTabBar = ...
        RightSide: QTabBar = ...

    class Shape(int):
        RoundedNorth: QTabBar = ...
        RoundedSouth: QTabBar = ...
        RoundedWest: QTabBar = ...
        RoundedEast: QTabBar = ...
        TriangularNorth: QTabBar = ...
        TriangularSouth: QTabBar = ...
        TriangularWest: QTabBar = ...
        TriangularEast: QTabBar = ...

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#QTabBar

        **QTabBar::QTabBar(QWidget * parent = nullptr)**

        Creates a new tab bar with the given **parent**.
        """
        ...

    def setTabVisible(self, index: int, visible: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#setTabVisible

        **void QTabBar::setTabVisible(int index , bool visible )**

        If **visible** is true, make the tab at position **index** visible,
        otherwise make it hidden.

        This function was introduced in Qt 5.15.

        **See also** **isTabVisible** ().
        """
        ...

    def isTabVisible(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-5/qtabbar.html#isTabVisible

        **bool QTabBar::isTabVisible(int index ) const**

        Returns true if the tab at position **index** is visible; otherwise
        returns false.

        This function was introduced in Qt 5.15.
        """
        ...

    def setAccessibleTabName(self, index: int, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#setAccessibleTabName

        **void QTabBar::setAccessibleTabName(int index , const QString & name
        )**

        Sets the **accessibleName**  of the tab at position **index** to
        **name**.

        **See also** **accessibleTabName** ().
        """
        ...

    def accessibleTabName(self, index: int) -> str:
        """
        https://doc.qt.io/qt-5/qtabbar.html#accessibleTabName

        **QString QTabBar::accessibleTabName(int index ) const**

        Returns the **accessibleName**  of the tab at position **index** , or an
        empty string if **index** is out of range.

        **See also** **setAccessibleTabName** ().
        """
        ...

    def timerEvent(self, event: QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#timerEvent

        **[override virtual protected] void QTabBar::timerEvent(QTimerEvent *
        event )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    def setChangeCurrentOnDrag(self, change: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#changeCurrentOnDrag-prop

        **changeCurrentOnDrag : bool**

        If true, then the current tab is automatically changed when dragging
        over the tabbar.

        **Note:** You should also set **acceptDrops**  property to true to make
        this feature work.

        By default, this property is false.

        This property was introduced in Qt 5.4.

        **Access functions:**

        bool **changeCurrentOnDrag** () const
        void **setChangeCurrentOnDrag**
        (bool **change** )
        """
        ...

    def changeCurrentOnDrag(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtabbar.html#changeCurrentOnDrag-prop

        **changeCurrentOnDrag : bool**

        If true, then the current tab is automatically changed when dragging
        over the tabbar.

        **Note:** You should also set **acceptDrops**  property to true to make
        this feature work.

        By default, this property is false.

        This property was introduced in Qt 5.4.

        **Access functions:**

        bool **changeCurrentOnDrag** () const
        void **setChangeCurrentOnDrag**
        (bool **change** )
        """
        ...

    def setAutoHide(self, hide: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#autoHide-prop

        **autoHide : bool**

        If true, the tab bar is automatically hidden when it contains less than
        2 tabs.

        By default, this property is false.

        This property was introduced in Qt 5.4.

        **Access functions:**

        bool **autoHide** () const
        void **setAutoHide** (bool **hide** )

        **See also** **QWidget::visible** .
        """
        ...

    def autoHide(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtabbar.html#autoHide-prop

        **autoHide : bool**

        If true, the tab bar is automatically hidden when it contains less than
        2 tabs.

        By default, this property is false.

        This property was introduced in Qt 5.4.

        **Access functions:**

        bool **autoHide** () const
        void **setAutoHide** (bool **hide** )

        **See also** **QWidget::visible** .
        """
        ...

    def minimumTabSizeHint(self, index: int) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qtabbar.html#minimumTabSizeHint

        **[virtual protected] QSize QTabBar::minimumTabSizeHint(int index )
        const**

        Returns the minimum tab size hint for the tab at position **index**.

        This function was introduced in Qt 5.0.
        """
        ...

    def wheelEvent(self, event: QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#wheelEvent

        **[override virtual protected] void QTabBar::wheelEvent(QWheelEvent *
        event )**

        Reimplements: **QWidget::wheelEvent** (QWheelEvent *event).
        """
        ...

    def hideEvent(self, a0: QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#hideEvent

        **[override virtual protected] void QTabBar::hideEvent( QHideEvent * )**

        Reimplements: **QWidget::hideEvent** (QHideEvent *event).
        """
        ...

    def setDocumentMode(self, set: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#documentMode-prop

        **documentMode : bool**

        This property holds whether or not the tab bar is rendered in a mode
        suitable for the main window.

        This property is used as a hint for styles to draw the tabs in a
        different way then they would normally look in a tab widget. On macOS
        this will look similar to the tabs in Safari or Sierra's Terminal.app.

        This property was introduced in Qt 4.5.

        **Access functions:**

        bool **documentMode** () const
        void **setDocumentMode** (bool **set**
        )

        **See also** **QTabWidget::documentMode** .
        """
        ...

    def documentMode(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtabbar.html#documentMode-prop

        **documentMode : bool**

        This property holds whether or not the tab bar is rendered in a mode
        suitable for the main window.

        This property is used as a hint for styles to draw the tabs in a
        different way then they would normally look in a tab widget. On macOS
        this will look similar to the tabs in Safari or Sierra's Terminal.app.

        This property was introduced in Qt 4.5.

        **Access functions:**

        bool **documentMode** () const
        void **setDocumentMode** (bool **set**
        )

        **See also** **QTabWidget::documentMode** .
        """
        ...

    def setMovable(self, movable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#movable-prop

        **movable : bool**

        This property holds whether the user can move the tabs within the tabbar
        area.

        By default, this property is `false`;

        This property was introduced in Qt 4.5.

        **Access functions:**

        bool **isMovable** () const
        void **setMovable** (bool **movable** )
        """
        ...

    def isMovable(self) -> bool:
        ...

    def setExpanding(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#expanding-prop

        **expanding : bool**

        When expanding is true **QTabBar**  will expand the tabs to use the
        empty space.

        By default the value is true.

        This property was introduced in Qt 4.5.

        **Access functions:**

        bool **expanding** () const
        void **setExpanding** (bool **enabled** )

        **See also** **QTabWidget::documentMode** .
        """
        ...

    def expanding(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtabbar.html#expanding-prop

        **expanding : bool**

        When expanding is true **QTabBar**  will expand the tabs to use the
        empty space.

        By default the value is true.

        This property was introduced in Qt 4.5.

        **Access functions:**

        bool **expanding** () const
        void **setExpanding** (bool **enabled** )

        **See also** **QTabWidget::documentMode** .
        """
        ...

    def setSelectionBehaviorOnRemove(
        self, behavior: "QTabBar.SelectionBehavior"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#selectionBehaviorOnRemove-prop

        **selectionBehaviorOnRemove : SelectionBehavior**

        What tab should be set as current when **removeTab**  is called if the
        removed tab is also the current tab.

        By default the value is **SelectRightTab** .

        This property was introduced in Qt 4.5.

        **Access functions:**

        QTabBar::SelectionBehavior **selectionBehaviorOnRemove** () const
        void
        **setSelectionBehaviorOnRemove** (QTabBar::SelectionBehavior
        **behavior** )

        **See also** **removeTab** ().
        """
        ...

    def selectionBehaviorOnRemove(self) -> "QTabBar.SelectionBehavior":
        """
        https://doc.qt.io/qt-5/qtabbar.html#selectionBehaviorOnRemove-prop

        **selectionBehaviorOnRemove : SelectionBehavior**

        What tab should be set as current when **removeTab**  is called if the
        removed tab is also the current tab.

        By default the value is **SelectRightTab** .

        This property was introduced in Qt 4.5.

        **Access functions:**

        QTabBar::SelectionBehavior **selectionBehaviorOnRemove** () const
        void
        **setSelectionBehaviorOnRemove** (QTabBar::SelectionBehavior
        **behavior** )

        **See also** **removeTab** ().
        """
        ...

    def tabButton(self, index: int, position: "QTabBar.ButtonPosition") -> QWidget:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabButton

        **QWidget *QTabBar::tabButton(int index , QTabBar::ButtonPosition
        position ) const**

        Returns the widget set a tab **index** and **position** or `nullptr` if
        one is not set.

        **See also** **setTabButton** ().
        """
        ...

    def setTabButton(
        self, index: int, position: "QTabBar.ButtonPosition", widget: QWidget
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#setTabButton

        **void QTabBar::setTabButton(int index , QTabBar::ButtonPosition
        position , QWidget * widget )**

        Sets **widget** on the tab **index**. The widget is placed on the left
        or right hand side depending upon the **position**.

        Any previously set widget in **position** is hidden.

        The tab bar will take ownership of the widget and so all widgets set
        here will be deleted by the tab bar when it is destroyed unless you
        separately reparent the widget after setting some other widget (or
        `nullptr`).

        This function was introduced in Qt 4.5.

        **See also** **tabButton** () and **tabsClosable** ().
        """
        ...

    def setTabsClosable(self, closable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabsClosable-prop

        **tabsClosable : bool**

        This property holds whether or not a tab bar should place close buttons
        on each tab

        When tabsClosable is set to true a close button will appear on the tab
        on either the left or right hand side depending upon the style. When the
        button is clicked the tab the signal **tabCloseRequested**  will be
        emitted.

        By default the value is false.

        This property was introduced in Qt 4.5.

        **Access functions:**

        bool **tabsClosable** () const
        void **setTabsClosable** (bool
        **closable** )

        **See also** **setTabButton** () and **tabRemoved** ().
        """
        ...

    def tabsClosable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabsClosable-prop

        **tabsClosable : bool**

        This property holds whether or not a tab bar should place close buttons
        on each tab

        When tabsClosable is set to true a close button will appear on the tab
        on either the left or right hand side depending upon the style. When the
        button is clicked the tab the signal **tabCloseRequested**  will be
        emitted.

        By default the value is false.

        This property was introduced in Qt 4.5.

        **Access functions:**

        bool **tabsClosable** () const
        void **setTabsClosable** (bool
        **closable** )

        **See also** **setTabButton** () and **tabRemoved** ().
        """
        ...

    def moveTab(self, from_: int, to: int) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#moveTab

        **void QTabBar::moveTab(int from , int to )**

        Moves the item at index position **from** to index position **to**.

        This function was introduced in Qt 4.5.

        **See also** **tabMoved** () and **tabLayoutChange** ().
        """
        ...

    def changeEvent(self, a0: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#changeEvent

        **[override virtual protected] void QTabBar::changeEvent(QEvent * event
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#keyPressEvent

        **[override virtual protected] void QTabBar::keyPressEvent(QKeyEvent *
        event )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#mouseReleaseEvent

        **[override virtual protected] void
        QTabBar::mouseReleaseEvent(QMouseEvent * event )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#mouseMoveEvent

        **[override virtual protected] void QTabBar::mouseMoveEvent(QMouseEvent
        * event )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#mousePressEvent

        **[override virtual protected] void QTabBar::mousePressEvent(QMouseEvent
        * event )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#paintEvent

        **[override virtual protected] void QTabBar::paintEvent( QPaintEvent *
        )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def showEvent(self, a0: QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#showEvent

        **[override virtual protected] void QTabBar::showEvent( QShowEvent * )**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#resizeEvent

        **[override virtual protected] void QTabBar::resizeEvent( QResizeEvent *
        )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qtabbar.html#event

        **[override virtual protected] bool QTabBar::event(QEvent * event )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def tabLayoutChange(self) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabLayoutChange

        **[virtual protected] void QTabBar::tabLayoutChange()**

        This virtual handler is called whenever the tab layout changes.

        **See also** **tabRect** ().
        """
        ...

    def tabRemoved(self, index: int) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabRemoved

        **[virtual protected] void QTabBar::tabRemoved(int index )**

        This virtual handler is called after a tab was removed from position
        **index**.

        **See also** **tabInserted** ().
        """
        ...

    def tabInserted(self, index: int) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabInserted

        **[virtual protected] void QTabBar::tabInserted(int index )**

        This virtual handler is called after a new tab was added or inserted at
        position **index**.

        **See also** **tabRemoved** ().
        """
        ...

    def tabSizeHint(self, index: int) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabSizeHint

        **[virtual protected] QSize QTabBar::tabSizeHint(int index ) const**

        Returns the size hint for the tab at position **index**.
        """
        ...

    def initStyleOption(self, option: QStyleOptionTab, tabIndex: int) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#initStyleOption

        **[protected] void QTabBar::initStyleOption(QStyleOptionTab * option ,
        int tabIndex ) const**

        Initialize **option** with the values from the tab at **tabIndex**. This
        method is useful for subclasses when they need a **QStyleOptionTab** ,
        but don't want to fill in all the information themselves.

        **See also** **QStyleOption::initFrom** () and
        **QTabWidget::initStyleOption** ().
        """
        ...

    def setCurrentIndex(self, index: int) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index of the tab bar's visible tab

        The current index is -1 if there is no current tab.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentChanged** ** (int **index** )
        """
        ...

    def usesScrollButtons(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtabbar.html#usesScrollButtons-prop

        **usesScrollButtons : bool**

        This property holds whether or not a tab bar should use buttons to
        scroll tabs when it has many tabs.

        When there are too many tabs in a tab bar for its size, the tab bar can
        either choose to expand its size or to add buttons that allow you to
        scroll through the tabs.

        By default the value is style dependant.

        This property was introduced in Qt 4.2.

        **Access functions:**

        bool **usesScrollButtons** () const
        void **setUsesScrollButtons**
        (bool **useButtons** )

        **See also** **elideMode** , **QTabWidget::usesScrollButtons** , and
        **QStyle::SH_TabBar_PreferNoArrows** .

        **Member Function Documentation**
        """
        ...

    def setUsesScrollButtons(self, useButtons: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#usesScrollButtons-prop

        **usesScrollButtons : bool**

        This property holds whether or not a tab bar should use buttons to
        scroll tabs when it has many tabs.

        When there are too many tabs in a tab bar for its size, the tab bar can
        either choose to expand its size or to add buttons that allow you to
        scroll through the tabs.

        By default the value is style dependant.

        This property was introduced in Qt 4.2.

        **Access functions:**

        bool **usesScrollButtons** () const
        void **setUsesScrollButtons**
        (bool **useButtons** )

        **See also** **elideMode** , **QTabWidget::usesScrollButtons** , and
        **QStyle::SH_TabBar_PreferNoArrows** .

        **Member Function Documentation**
        """
        ...

    def setElideMode(self, a0: QtCore.Qt.TextElideMode) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#elideMode-prop

        **elideMode : Qt::TextElideMode**

        how to elide text in the tab bar

        This property controls how items are elided when there is not enough
        space to show them for a given tab bar size.

        By default the value is style dependent.

        This property was introduced in Qt 4.2.

        **Access functions:**

        Qt::TextElideMode **elideMode** () const
        void **setElideMode**
        (Qt::TextElideMode **mode** )

        **See also** **QTabWidget::elideMode** , **usesScrollButtons** , and
        **QStyle::SH_TabBar_ElideMode** .
        """
        ...

    def elideMode(self) -> QtCore.Qt.TextElideMode:
        """
        https://doc.qt.io/qt-5/qtabbar.html#elideMode-prop

        **elideMode : Qt::TextElideMode**

        how to elide text in the tab bar

        This property controls how items are elided when there is not enough
        space to show them for a given tab bar size.

        By default the value is style dependent.

        This property was introduced in Qt 4.2.

        **Access functions:**

        Qt::TextElideMode **elideMode** () const
        void **setElideMode**
        (Qt::TextElideMode **mode** )

        **See also** **QTabWidget::elideMode** , **usesScrollButtons** , and
        **QStyle::SH_TabBar_ElideMode** .
        """
        ...

    def setIconSize(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#iconSize-prop

        **iconSize : QSize**

        This property holds the size for icons in the tab bar

        The default value is style-dependent. `iconSize` is a maximum size;
        icons that are smaller are not scaled up.

        This property was introduced in Qt 4.1.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )

        **See also** **QTabWidget::iconSize** .
        """
        ...

    def iconSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qtabbar.html#iconSize-prop

        **iconSize : QSize**

        This property holds the size for icons in the tab bar

        The default value is style-dependent. `iconSize` is a maximum size;
        icons that are smaller are not scaled up.

        This property was introduced in Qt 4.1.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )

        **See also** **QTabWidget::iconSize** .
        """
        ...

    def drawBase(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtabbar.html#drawBase-prop

        **drawBase : bool**

        defines whether or not tab bar should draw its base.

        If true then **QTabBar**  draws a base in relation to the styles
        overlab. Otherwise only the tabs are drawn.

        **Access functions:**

        bool **drawBase** () const
        void **setDrawBase** (bool **drawTheBase**
        )

        **See also** **QStyle::pixelMetric** (),
        **QStyle::PM_TabBarBaseOverlap** , and **QStyleOptionTabBarBase** .
        """
        ...

    def setDrawBase(self, drawTheBase: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#drawBase-prop

        **drawBase : bool**

        defines whether or not tab bar should draw its base.

        If true then **QTabBar**  draws a base in relation to the styles
        overlab. Otherwise only the tabs are drawn.

        **Access functions:**

        bool **drawBase** () const
        void **setDrawBase** (bool **drawTheBase**
        )

        **See also** **QStyle::pixelMetric** (),
        **QStyle::PM_TabBarBaseOverlap** , and **QStyleOptionTabBarBase** .
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qtabbar.html#minimumSizeHint

        **[override virtual] QSize QTabBar::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qtabbar.html#sizeHint

        **[override virtual] QSize QTabBar::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    def __len__(self) -> int:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qtabbar.html#count-prop

        **count : const int**

        This property holds the number of tabs in the tab bar

        **Access functions:**

        int **count** () const
        """
        ...

    def currentIndex(self) -> int:
        """
        https://doc.qt.io/qt-5/qtabbar.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index of the tab bar's visible tab

        The current index is -1 if there is no current tab.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentChanged** ** (int **index** )
        """
        ...

    def tabRect(self, index: int) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabRect

        **QRect QTabBar::tabRect(int index ) const**

        Returns the visual rectangle of the tab at position **index** , or a
        null rectangle if **index** is hidden, or out of range.
        """
        ...

    def tabAt(self, pos: QtCore.QPoint) -> int:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabAt

        **int QTabBar::tabAt(const QPoint & position ) const**

        Returns the index of the tab that covers **position** or -1 if no tab
        covers **position** ;

        This function was introduced in Qt 4.3.
        """
        ...

    def tabData(self, index: int) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabData

        **QVariant QTabBar::tabData(int index ) const**

        Returns the data of the tab at position **index** , or a null variant if
        **index** is out of range.

        **See also** **setTabData** ().
        """
        ...

    def setTabData(self, index: int, data: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#setTabData

        **void QTabBar::setTabData(int index , const QVariant & data )**

        Sets the data of the tab at position **index** to **data**.

        **See also** **tabData** ().
        """
        ...

    def tabWhatsThis(self, index: int) -> str:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabWhatsThis

        **QString QTabBar::tabWhatsThis(int index ) const**

        Returns the What's This help text of the tab at position **index** , or
        an empty string if **index** is out of range.

        This function was introduced in Qt 4.1.

        **See also** **setTabWhatsThis** ().
        """
        ...

    def setTabWhatsThis(self, index: int, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#setTabWhatsThis

        **void QTabBar::setTabWhatsThis(int index , const QString & text )**

        Sets the What's This help text of the tab at position **index** to
        **text**.

        This function was introduced in Qt 4.1.

        **See also** **tabWhatsThis** ().
        """
        ...

    def tabToolTip(self, index: int) -> str:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabToolTip

        **QString QTabBar::tabToolTip(int index ) const**

        Returns the tool tip of the tab at position **index** , or an empty
        string if **index** is out of range.

        **See also** **setTabToolTip** ().
        """
        ...

    def setTabToolTip(self, index: int, tip: str) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#setTabToolTip

        **void QTabBar::setTabToolTip(int index , const QString & tip )**

        Sets the tool tip of the tab at position **index** to **tip**.

        **See also** **tabToolTip** ().
        """
        ...

    def setTabIcon(self, index: int, icon: QtGui.QIcon) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#setTabIcon

        **void QTabBar::setTabIcon(int index , const QIcon & icon )**

        Sets the icon of the tab at position **index** to **icon**.

        **See also** **tabIcon** ().
        """
        ...

    def tabIcon(self, index: int) -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabIcon

        **QIcon QTabBar::tabIcon(int index ) const**

        Returns the icon of the tab at position **index** , or a null icon if
        **index** is out of range.

        **See also** **setTabIcon** ().
        """
        ...

    def setTabTextColor(
        self,
        index: int,
        color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#setTabTextColor

        **void QTabBar::setTabTextColor(int index , const QColor & color )**

        Sets the color of the text in the tab with the given **index** to the
        specified **color**.

        If an invalid color is specified, the tab will use the **QTabBar**
        foreground role instead.

        **See also** **tabTextColor** ().
        """
        ...

    def tabTextColor(self, index: int) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabTextColor

        **QColor QTabBar::tabTextColor(int index ) const**

        Returns the text color of the tab with the given **index** , or a
        invalid color if **index** is out of range.

        **See also** **setTabTextColor** ().
        """
        ...

    def setTabText(self, index: int, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#setTabText

        **void QTabBar::setTabText(int index , const QString & text )**

        Sets the text of the tab at position **index** to **text**.

        **See also** **tabText** ().
        """
        ...

    def tabText(self, index: int) -> str:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabText

        **QString QTabBar::tabText(int index ) const**

        Returns the text of the tab at position **index** , or an empty string
        if **index** is out of range.

        **See also** **setTabText** ().
        """
        ...

    def setTabEnabled(self, index: int, a1: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#setTabEnabled

        **void QTabBar::setTabEnabled(int index , bool enabled )**

        If **enabled** is true then the tab at position **index** is enabled;
        otherwise the item at position **index** is disabled.

        **See also** **isTabEnabled** ().
        """
        ...

    def isTabEnabled(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-5/qtabbar.html#isTabEnabled

        **bool QTabBar::isTabEnabled(int index ) const**

        Returns `true` if the tab at position **index** is enabled; otherwise
        returns `false`.
        """
        ...

    def removeTab(self, index: int) -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#removeTab

        **void QTabBar::removeTab(int index )**

        Removes the tab at position **index**.

        **See also** **SelectionBehavior** .
        """
        ...

    @typing.overload
    def insertTab(self, index: int, text: str) -> int:
        """
        https://doc.qt.io/qt-5/qtabbar.html#insertTab

        **int QTabBar::insertTab(int index , const QString & text )**

        Inserts a new tab with text **text** at position **index**. If **index**
        is out of range, the new tab is appened. Returns the new tab's index.
        """
        ...

    @typing.overload
    def insertTab(self, index: int, icon: QtGui.QIcon, text: str) -> int:
        """
        https://doc.qt.io/qt-5/qtabbar.html#insertTab-1

        **int QTabBar::insertTab(int index , const QIcon & icon , const QString
        & text )**

        This is an overloaded function.

        Inserts a new tab with icon **icon** and text **text** at position
        **index**. If **index** is out of range, the new tab is appended.
        Returns the new tab's index.

        If the **QTabBar**  was empty before this function is called, the
        inserted tab becomes the current tab.

        Inserting a new tab at an index less than or equal to the current index
        will increment the current index, but keep the current tab.
        """
        ...

    @typing.overload
    def addTab(self, text: str) -> int:
        """
        https://doc.qt.io/qt-5/qtabbar.html#addTab

        **int QTabBar::addTab(const QString & text )**

        Adds a new tab with text **text**. Returns the new tab's index.
        """
        ...

    @typing.overload
    def addTab(self, icon: QtGui.QIcon, text: str) -> int:
        """
        https://doc.qt.io/qt-5/qtabbar.html#addTab-1

        **int QTabBar::addTab(const QIcon & icon , const QString & text )**

        This is an overloaded function.

        Adds a new tab with icon **icon** and text **text**. Returns the new
        tab's index.
        """
        ...

    def setShape(self, shape: "QTabBar.Shape") -> None:
        """
        https://doc.qt.io/qt-5/qtabbar.html#shape-prop

        **shape : Shape**

        This property holds the shape of the tabs in the tab bar

        Possible values for this property are described by the Shape enum.

        **Access functions:**

        QTabBar::Shape **shape** () const
        void **setShape** (QTabBar::Shape
        **shape** )
        """
        ...

    def shape(self) -> "QTabBar.Shape":
        """
        https://doc.qt.io/qt-5/qtabbar.html#shape-prop

        **shape : Shape**

        This property holds the shape of the tabs in the tab bar

        Possible values for this property are described by the Shape enum.

        **Access functions:**

        QTabBar::Shape **shape** () const
        void **setShape** (QTabBar::Shape
        **shape** )
        """
        ...

    @property
    def currentChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtabbar.html#currentChanged

        **[signal] void QTabBar::currentChanged(int index )**

        This signal is emitted when the tab bar's current tab changes. The new
        current has the given **index** , or -1 if there isn't a new one (for
        example, if there are no tab in the **QTabBar** )

        **Note:** Notifier signal for property **currentIndex** .
        """
        ...

    @property
    def tabBarClicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabBarClicked

        **[signal] void QTabBar::tabBarClicked(int index )**

        This signal is emitted when user clicks on a tab at an **index**.

        **index** is the index of a clicked tab, or -1 if no tab is under the
        cursor.

        This function was introduced in Qt 5.2.
        """
        ...

    @property
    def tabBarDoubleClicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabBarDoubleClicked

        **[signal] void QTabBar::tabBarDoubleClicked(int index )**

        This signal is emitted when the user double clicks on a tab at
        **index**.

        **index** refers to the tab clicked, or -1 if no tab is under the
        cursor.

        This function was introduced in Qt 5.2.
        """
        ...

    @property
    def tabCloseRequested(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabCloseRequested

        **[signal] void QTabBar::tabCloseRequested(int index )**

        This signal is emitted when the close button on a tab is clicked. The
        **index** is the index that should be removed.

        This function was introduced in Qt 4.5.

        **See also** **setTabsClosable** ().
        """
        ...

    @property
    def tabMoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtabbar.html#tabMoved

        **[signal] void QTabBar::tabMoved(int from , int to )**

        This signal is emitted when the tab has moved the tab at index position
        **from** to index position **to**.

        note: **QTabWidget**  will automatically move the page when this signal
        is emitted from its tab bar.

        This function was introduced in Qt 4.5.

        **See also** **moveTab** ().
        """
        ...
