"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QSlider(QAbstractSlider):
    """
    https://doc.qt.io/qt-5/qslider.html

    **Detailed Description**

    ![](images/windows-slider.png)

    The slider is the classic widget for controlling a bounded value. It lets
    the user move a slider handle along a horizontal or vertical groove and
    translates the handle's position into an integer value within the legal
    range.

    QSlider has very few of its own functions; most of the functionality is in
    **QAbstractSlider** . The most useful functions are **setValue** () to set
    the slider directly to some value; **triggerAction** () to simulate the
    effects of clicking (useful for shortcut keys); **setSingleStep** (),
    **setPageStep** () to set the steps; and **setMinimum** () and
    **setMaximum** () to define the range of the scroll bar.

    QSlider provides methods for controlling tickmarks. You can use
    **setTickPosition** () to indicate where you want the tickmarks to be,
    **setTickInterval** () to indicate how many of them you want. the currently
    set tick position and interval can be queried using the **tickPosition** ()
    and **tickInterval** () functions, respectively.

    QSlider inherits a comprehensive set of signals:

    SignalDescription
    **valueChanged** ()Emitted when the slider's value has
    changed. The tracking() determines whether this signal is emitted during
    user interaction.
    **sliderPressed** ()Emitted when the user starts to drag
    the slider.
    **sliderMoved** ()Emitted when the user drags the slider.
    **sliderReleased** ()Emitted when the user releases the slider.

    QSlider only provides integer ranges. Note that although QSlider handles
    very large numbers, it becomes difficult for users to use a slider
    accurately for very large ranges.

    A slider accepts focus on Tab and provides both a mouse wheel and a keyboard
    interface. The keyboard interface is the following:

    * Left/Right move a horizontal slider by one single step.
      * Up/Down move a
    vertical slider by one single step.
      * PageUp moves up one page.
      *
    PageDown moves down one page.
      * Home moves to the start (mininum).
      * End
    moves to the end (maximum).

    **See also** **QScrollBar** , **QSpinBox** , **QDial** , **GUI Design
    Handbook: Slider** , and **Sliders Example** .
    """

    class TickPosition(int):
        NoTicks: QSlider = ...
        TicksAbove: QSlider = ...
        TicksLeft: QSlider = ...
        TicksBelow: QSlider = ...
        TicksRight: QSlider = ...
        TicksBothSides: QSlider = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qslider.html#QSlider

        **QSlider::QSlider(QWidget * parent = nullptr)**

        Constructs a vertical slider with the given **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, orientation: QtCore.Qt.Orientation, parent: typing.Optional[QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qslider.html#QSlider-1

        **QSlider::QSlider(Qt::Orientation orientation , QWidget * parent =
        nullptr)**

        Constructs a slider with the given **parent**. The **orientation**
        parameter determines whether the slider is horizontal or vertical; the
        valid values are **Qt::Vertical**  and **Qt::Horizontal** .
        """
        ...

    def mouseMoveEvent(self, ev: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qslider.html#mouseMoveEvent

        **[override virtual protected] void QSlider::mouseMoveEvent(QMouseEvent
        * ev )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(self, ev: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qslider.html#mouseReleaseEvent

        **[override virtual protected] void
        QSlider::mouseReleaseEvent(QMouseEvent * ev )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, ev: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qslider.html#mousePressEvent

        **[override virtual protected] void QSlider::mousePressEvent(QMouseEvent
        * ev )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def paintEvent(self, ev: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qslider.html#paintEvent

        **[override virtual protected] void QSlider::paintEvent(QPaintEvent * ev
        )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def initStyleOption(self, option: "QStyleOptionSlider") -> None:
        """
        https://doc.qt.io/qt-5/qslider.html#initStyleOption

        **[protected] void QSlider::initStyleOption(QStyleOptionSlider * option
        ) const**

        Initialize **option** with the values from this **QSlider** . This
        method is useful for subclasses when they need a **QStyleOptionSlider**
        , but don't want to fill in all the information themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def event(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qslider.html#event

        **[override virtual] bool QSlider::event(QEvent * event )**

        Reimplements: **QAbstractSlider::event** (QEvent *e).
        """
        ...

    def tickInterval(self) -> int:
        """
        https://doc.qt.io/qt-5/qslider.html#tickInterval-prop

        **tickInterval : int**

        This property holds the interval between tickmarks

        This is a value interval, not a pixel interval. If it is 0, the slider
        will choose between **singleStep**  and **pageStep** .

        The default value is 0.

        **Access functions:**

        int **tickInterval** () const
        void **setTickInterval** (int **ti** )

        **See also** **tickPosition** , **singleStep** , and **pageStep** .
        """
        ...

    def setTickInterval(self, ti: int) -> None:
        """
        https://doc.qt.io/qt-5/qslider.html#tickInterval-prop

        **tickInterval : int**

        This property holds the interval between tickmarks

        This is a value interval, not a pixel interval. If it is 0, the slider
        will choose between **singleStep**  and **pageStep** .

        The default value is 0.

        **Access functions:**

        int **tickInterval** () const
        void **setTickInterval** (int **ti** )

        **See also** **tickPosition** , **singleStep** , and **pageStep** .
        """
        ...

    def tickPosition(self) -> "QSlider.TickPosition":
        """
        https://doc.qt.io/qt-5/qslider.html#tickPosition-prop

        **tickPosition : TickPosition**

        This property holds the tickmark position for this slider

        The valid values are described by the **QSlider::TickPosition**  enum.

        The default value is **QSlider::NoTicks** .

        **Access functions:**

        QSlider::TickPosition **tickPosition** () const
        void
        **setTickPosition** (QSlider::TickPosition **position** )

        **See also** **tickInterval** .

        **Member Function Documentation**
        """
        ...

    def setTickPosition(self, position: "QSlider.TickPosition") -> None:
        """
        https://doc.qt.io/qt-5/qslider.html#tickPosition-prop

        **tickPosition : TickPosition**

        This property holds the tickmark position for this slider

        The valid values are described by the **QSlider::TickPosition**  enum.

        The default value is **QSlider::NoTicks** .

        **Access functions:**

        QSlider::TickPosition **tickPosition** () const
        void
        **setTickPosition** (QSlider::TickPosition **position** )

        **See also** **tickInterval** .

        **Member Function Documentation**
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qslider.html#minimumSizeHint

        **[override virtual] QSize QSlider::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qslider.html#sizeHint

        **[override virtual] QSize QSlider::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...
