"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QScrollArea(QAbstractScrollArea):
    """
    https://doc.qt.io/qt-5/qscrollarea.html

    **Detailed Description**

    A scroll area is used to display the contents of a child widget within a
    frame. If the widget exceeds the size of the frame, the view can provide
    scroll bars so that the entire area of the child widget can be viewed. The
    child widget must be specified with **setWidget** (). For example:

    **QLabel**  *imageLabel = new **QLabel** ;
        **QImage**
    image("happyguy.png");
        imageLabel->setPixmap(**QPixmap**
    ::fromImage(image));

        scrollArea = new **QScrollArea** ;
    scrollArea->setBackgroundRole(**QPalette** ::Dark);
    scrollArea->setWidget(imageLabel);

    The code above creates a scroll area (shown in the images below) containing
    an image label. When scaling the image, the scroll area can provide the
    necessary scroll bars:

    ![](images/qscrollarea-noscrollbars.png)![](images/qscrollarea-
    onescrollbar.png)![](images/qscrollarea-twoscrollbars.png)

    The scroll bars appearance depends on the currently set **scroll bar
    policies** . You can control the appearance of the scroll bars using the
    inherited functionality from **QAbstractScrollArea** .

    For example, you can set the
    **QAbstractScrollArea::horizontalScrollBarPolicy**  and
    **QAbstractScrollArea::verticalScrollBarPolicy**  properties. Or if you want
    the scroll bars to adjust dynamically when the contents of the scroll area
    changes, you can use the **horizontalScrollBar()**  and
    **verticalScrollBar()**  functions (which enable you to access the scroll
    bars) and set the scroll bars' values whenever the scroll area's contents
    change, using the **QScrollBar::setValue** () function.

    You can retrieve the child widget using the **widget** () function. The view
    can be made to be resizable with the **setWidgetResizable** () function. The
    alignment of the widget can be specified with **setAlignment** ().

    Two convenience functions **ensureVisible** () and **ensureWidgetVisible**
    () ensure a certain region of the contents is visible inside the viewport,
    by scrolling the contents if necessary.

    **Size Hints and Layouts**

    When using a scroll area to display the contents of a custom widget, it is
    important to ensure that the **size hint**  of the child widget is set to a
    suitable value. If a standard **QWidget**  is used for the child widget, it
    may be necessary to call **QWidget::setMinimumSize** () to ensure that the
    contents of the widget are shown correctly within the scroll area.

    If a scroll area is used to display the contents of a widget that contains
    child widgets arranged in a layout, it is important to realize that the size
    policy of the layout will also determine the size of the widget. This is
    especially useful to know if you intend to dynamically change the contents
    of the layout. In such cases, setting the layout's **size constraint**
    property to one which provides constraints on the minimum and/or maximum
    size of the layout (e.g., **QLayout::SetMinAndMaxSize** ) will cause the
    size of the scroll area to be updated whenever the contents of the layout
    changes.

    For a complete example using the QScrollArea class, see the **Image Viewer**
    example. The example shows how to combine **QLabel**  and QScrollArea to
    display an image.

    **See also** **QAbstractScrollArea** , **QScrollBar** , and **Image Viewer
    Example** .
    """

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#QScrollArea

        **QScrollArea::QScrollArea(QWidget * parent = nullptr)**

        Constructs an empty scroll area with the given **parent**.

        **See also** **setWidget** ().
        """
        ...

    def viewportSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#viewportSizeHint

        **[override virtual protected] QSize QScrollArea::viewportSizeHint()
        const**

        Reimplements: **QAbstractScrollArea::viewportSizeHint** () const.
        """
        ...

    def scrollContentsBy(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#scrollContentsBy

        **[override virtual protected] void QScrollArea::scrollContentsBy(int dx
        , int dy )**

        Reimplements: **QAbstractScrollArea::scrollContentsBy** (int dx, int
        dy).
        """
        ...

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#resizeEvent

        **[override virtual protected] void QScrollArea::resizeEvent(
        QResizeEvent * )**

        Reimplements: **QAbstractScrollArea::resizeEvent** (QResizeEvent
        *event).
        """
        ...

    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#eventFilter

        **[override virtual protected] bool QScrollArea::eventFilter(QObject * o
        , QEvent * e )**

        Reimplements: **QObject::eventFilter** (QObject *watched, QEvent
        *event).
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#event

        **[override virtual protected] bool QScrollArea::event(QEvent * e )**

        Reimplements: **QAbstractScrollArea::event** (QEvent *event).
        """
        ...

    def ensureWidgetVisible(
        self, childWidget: QWidget, xMargin: int = ..., yMargin: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#ensureWidgetVisible

        **void QScrollArea::ensureWidgetVisible(QWidget * childWidget , int
        xmargin = 50, int ymargin = 50)**

        Scrolls the contents of the scroll area so that the **childWidget** of
        **QScrollArea::widget** () is visible inside the viewport with margins
        specified in pixels by **xmargin** and **ymargin**. If the specified
        point cannot be reached, the contents are scrolled to the nearest valid
        position. The default value for both margins is 50 pixels.

        This function was introduced in Qt 4.2.
        """
        ...

    def ensureVisible(
        self, x: int, y: int, xMargin: int = ..., yMargin: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#ensureVisible

        **void QScrollArea::ensureVisible(int x , int y , int xmargin = 50, int
        ymargin = 50)**

        Scrolls the contents of the scroll area so that the point ( **x** ,
        **y** ) is visible inside the region of the viewport with margins
        specified in pixels by **xmargin** and **ymargin**. If the specified
        point cannot be reached, the contents are scrolled to the nearest valid
        position. The default value for both margins is 50 pixels.
        """
        ...

    def focusNextPrevChild(self, next: bool) -> bool:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#focusNextPrevChild

        **[override virtual] bool QScrollArea::focusNextPrevChild(bool next )**

        Reimplements: **QWidget::focusNextPrevChild** (bool next).
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#sizeHint

        **[override virtual] QSize QScrollArea::sizeHint() const**

        Reimplements: **QAbstractScrollArea::sizeHint** () const.
        """
        ...

    def setAlignment(
        self, a0: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#alignment-prop

        **alignment : Qt::Alignment**

        This property holds the alignment of the scroll area's widget

        A valid alignment is a combination of the following flags:

        * `Qt::AlignLeft`
          * `Qt::AlignHCenter`
          * `Qt::AlignRight`
          *
        `Qt::AlignTop`
          * `Qt::AlignVCenter`
          * `Qt::AlignBottom`

        By default, the widget stays rooted to the top-left corner of the scroll
        area.

        This property was introduced in Qt 4.2.

        **Access functions:**

        Qt::Alignment **alignment** () const
        void **setAlignment** (
        **Qt::Alignment** )
        """
        ...

    def alignment(self) -> QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#alignment-prop

        **alignment : Qt::Alignment**

        This property holds the alignment of the scroll area's widget

        A valid alignment is a combination of the following flags:

        * `Qt::AlignLeft`
          * `Qt::AlignHCenter`
          * `Qt::AlignRight`
          *
        `Qt::AlignTop`
          * `Qt::AlignVCenter`
          * `Qt::AlignBottom`

        By default, the widget stays rooted to the top-left corner of the scroll
        area.

        This property was introduced in Qt 4.2.

        **Access functions:**

        Qt::Alignment **alignment** () const
        void **setAlignment** (
        **Qt::Alignment** )
        """
        ...

    def setWidgetResizable(self, resizable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#widgetResizable-prop

        **widgetResizable : bool**

        This property holds whether the scroll area should resize the view
        widget

        If this property is set to false (the default), the scroll area honors
        the size of its widget. Regardless of this property, you can
        programmatically resize the widget using **widget** ()->**resize** (),
        and the scroll area will automatically adjust itself to the new size.

        If this property is set to true, the scroll area will automatically
        resize the widget in order to avoid scroll bars where they can be
        avoided, or to take advantage of extra space.

        **Access functions:**

        bool **widgetResizable** () const
        void **setWidgetResizable** (bool
        **resizable** )

        **Member Function Documentation**
        """
        ...

    def widgetResizable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#widgetResizable-prop

        **widgetResizable : bool**

        This property holds whether the scroll area should resize the view
        widget

        If this property is set to false (the default), the scroll area honors
        the size of its widget. Regardless of this property, you can
        programmatically resize the widget using **widget** ()->**resize** (),
        and the scroll area will automatically adjust itself to the new size.

        If this property is set to true, the scroll area will automatically
        resize the widget in order to avoid scroll bars where they can be
        avoided, or to take advantage of extra space.

        **Access functions:**

        bool **widgetResizable** () const
        void **setWidgetResizable** (bool
        **resizable** )

        **Member Function Documentation**
        """
        ...

    def takeWidget(self) -> QWidget:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#takeWidget

        **QWidget *QScrollArea::takeWidget()**

        Removes the scroll area's widget, and passes ownership of the widget to
        the caller.

        **See also** **widget** ().
        """
        ...

    def setWidget(self, w: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#setWidget

        **void QScrollArea::setWidget(QWidget * widget )**

        Sets the scroll area's **widget**.

        The **widget** becomes a child of the scroll area, and will be destroyed
        when the scroll area is deleted or when a new widget is set.

        The widget's **autoFillBackground**  property will be set to `true`.

        If the scroll area is visible when the **widget** is added, you must
        **show()**  it explicitly.

        Note that You must add the layout of **widget** before you call this
        function; if you add it later, the **widget** will not be visible -
        regardless of when you **show()**  the scroll area. In this case, you
        can also not **show()**  the **widget** later.

        **See also** **widget** ().
        """
        ...

    def widget(self) -> QWidget:
        """
        https://doc.qt.io/qt-5/qscrollarea.html#widget

        **QWidget *QScrollArea::widget() const**

        Returns the scroll area's widget, or `nullptr` if there is none.

        **See also** **setWidget** ().
        """
        ...
