"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QPushButton(QAbstractButton):
    """
    https://doc.qt.io/qt-5/qpushbutton.html

    **Detailed Description**

    ![](images/windows-pushbutton.png)

    The push button, or command button, is perhaps the most commonly used widget
    in any graphical user interface. Push (click) a button to command the
    computer to perform some action, or to answer a question. Typical buttons
    are OK, Apply, Cancel, Close, Yes, No and Help.

    A command button is rectangular and typically displays a text label
    describing its action. A shortcut key can be specified by preceding the
    preferred character with an ampersand in the text. For example:

    **QPushButton**  *button = new **QPushButton** ("&Download", this);

    In this example the shortcut is **Alt+D**. See the **QShortcut**
    documentation for details (to display an actual ampersand, use '&&').

    Push buttons display a textual label, and optionally a small icon. These can
    be set using the constructors and changed later using **setText** () and
    **setIcon** (). If the button is disabled, the appearance of the text and
    icon will be manipulated with respect to the GUI style to make the button
    look "disabled".

    A push button emits the signal **clicked** () when it is activated by the
    mouse, the Spacebar or by a keyboard shortcut. Connect to this signal to
    perform the button's action. Push buttons also provide less commonly used
    signals, for example **pressed** () and **released** ().

    Command buttons in dialogs are by default auto-default buttons, i.e., they
    become the default push button automatically when they receive the keyboard
    input focus. A default button is a push button that is activated when the
    user presses the Enter or Return key in a dialog. You can change this with
    **setAutoDefault** (). Note that auto-default buttons reserve a little extra
    space which is necessary to draw a default-button indicator. If you do not
    want this space around your buttons, call **setAutoDefault** (false).

    Being so central, the button widget has grown to accommodate a great many
    variations in the past decade. The Microsoft style guide now shows about ten
    different states of Windows push buttons and the text implies that there are
    dozens more when all the combinations of features are taken into
    consideration.

    The most important modes or states are:

    * Available or not (grayed out, disabled).
      * Standard push button,
    toggling push button or menu button.
      * On or off (only for toggling push
    buttons).
      * Default or normal. The default button in a dialog can
    generally be "clicked" using the Enter or Return key.
      * Auto-repeat or
    not.
      * Pressed down or not.

    As a general rule, use a push button when the application or dialog window
    performs an action when the user clicks on it (such as Apply, Cancel, Close
    and Help) **and** when the widget is supposed to have a wide, rectangular
    shape with a text label. Small, typically square buttons that change the
    state of the window rather than performing an action (such as the buttons in
    the top-right corner of the **QFileDialog** ) are not command buttons, but
    tool buttons. Qt provides a special class (**QToolButton** ) for these
    buttons.

    If you need toggle behavior (see **setCheckable** ()) or a button that auto-
    repeats the activation signal when being pushed down like the arrows in a
    scroll bar (see **setAutoRepeat** ()), a command button is probably not what
    you want. When in doubt, use a tool button.

    **Note:** On macOS when a push button's width becomes smaller than 50 or its
    height becomes smaller than 30, the button's corners are changed from round
    to square. Use the **setMinimumSize** () function to prevent this behavior.

    A variation of a command button is a menu button. These provide not just one
    command, but several, since when they are clicked they pop up a menu of
    options. Use the method **setMenu** () to associate a popup menu with a push
    button.

    Other classes of buttons are option buttons (see **QRadioButton** ) and
    check boxes (see **QCheckBox** ).

    In Qt, the **QAbstractButton**  base class provides most of the modes and
    other API, and QPushButton provides GUI logic. See **QAbstractButton**  for
    more information about the API.

    **See also** **QToolButton** , **QRadioButton** , **QCheckBox** , and **GUI
    Design Handbook: Push Button** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#QPushButton

        **QPushButton::QPushButton(QWidget * parent = nullptr)**

        Constructs a push button with no text and a **parent**.
        """
        ...

    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#QPushButton-1

        **QPushButton::QPushButton(const QString & text , QWidget * parent =
        nullptr)**

        Constructs a push button with the parent **parent** and the text
        **text**.
        """
        ...

    @typing.overload
    def __init__(
        self, icon: QtGui.QIcon, text: str, parent: typing.Optional[QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#QPushButton-2

        **QPushButton::QPushButton(const QIcon & icon , const QString & text ,
        QWidget * parent = nullptr)**

        Constructs a push button with an **icon** and a **text** , and a
        **parent**.

        Note that you can also pass a **QPixmap**  object as an icon (thanks to
        the implicit type conversion provided by C++).
        """
        ...

    def hitButton(self, pos: QtCore.QPoint) -> bool:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#hitButton

        **[override virtual protected] bool QPushButton::hitButton(const QPoint
        & pos ) const**

        Reimplements: **QAbstractButton::hitButton** (const QPoint &pos) const.
        """
        ...

    def focusOutEvent(self, a0: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#focusOutEvent

        **[override virtual protected] void
        QPushButton::focusOutEvent(QFocusEvent * e )**

        Reimplements: **QAbstractButton::focusOutEvent** (QFocusEvent *e).
        """
        ...

    def focusInEvent(self, a0: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#focusInEvent

        **[override virtual protected] void
        QPushButton::focusInEvent(QFocusEvent * e )**

        Reimplements: **QAbstractButton::focusInEvent** (QFocusEvent *e).
        """
        ...

    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#keyPressEvent

        **[override virtual protected] void QPushButton::keyPressEvent(QKeyEvent
        * e )**

        Reimplements: **QAbstractButton::keyPressEvent** (QKeyEvent *e).
        """
        ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#paintEvent

        **[override virtual protected] void QPushButton::paintEvent( QPaintEvent
        * )**

        Reimplements: **QAbstractButton::paintEvent** (QPaintEvent *e).
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#event

        **[override virtual protected] bool QPushButton::event(QEvent * e )**

        Reimplements: **QAbstractButton::event** (QEvent *e).
        """
        ...

    def initStyleOption(self, option: "QStyleOptionButton") -> None:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#initStyleOption

        **[protected] void QPushButton::initStyleOption(QStyleOptionButton *
        option ) const**

        Initialize **option** with the values from this **QPushButton** . This
        method is useful for subclasses when they need a **QStyleOptionButton**
        , but don't want to fill in all the information themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def showMenu(self) -> None:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#showMenu

        **[slot] void QPushButton::showMenu()**

        Shows (pops up) the associated popup menu. If there is no such menu,
        this function does nothing. This function does not return until the
        popup menu has been closed by the user.
        """
        ...

    def isFlat(self) -> bool:
        ...

    def setFlat(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#flat-prop

        **flat : bool**

        This property holds whether the button border is raised

        This property's default is false. If this property is set, most styles
        will not paint the button background unless the button is being pressed.
        **setAutoFillBackground** () can be used to ensure that the background
        is filled using the **QPalette::Button**  brush.

        **Access functions:**

        bool **isFlat** () const
        void **setFlat** ( **bool** )

        **Member Function Documentation**
        """
        ...

    def menu(self) -> "QMenu":
        """
        https://doc.qt.io/qt-5/qpushbutton.html#menu

        **QMenu *QPushButton::menu() const**

        Returns the button's associated popup menu or `nullptr` if no popup menu
        has been set.

        **See also** **setMenu** ().
        """
        ...

    def setMenu(self, menu: "QMenu") -> None:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#setMenu

        **void QPushButton::setMenu(QMenu * menu )**

        Associates the popup menu **menu** with this push button. This turns the
        button into a menu button, which in some styles will produce a small
        triangle to the right of the button's text.

        Ownership of the menu is **not** transferred to the push button.

        ![Screenshot of a Fusion style push button with popup
        menu.](images/fusion-pushbutton-menu.png)

        A push button with popup menus shown in the **Fusion widget style** .

        **See also** **menu** ().
        """
        ...

    def setDefault(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#default-prop

        **default : bool**

        This property holds whether the push button is the default button

        Default and autodefault buttons decide what happens when the user
        presses enter in a dialog.

        A button with this property set to true (i.e., the dialog's **default**
        button,) will automatically be pressed when the user presses enter, with
        one exception: if an **autoDefault** button currently has focus, the
        **autoDefault**  button is pressed. When the dialog has **autoDefault**
        buttons but no default button, pressing enter will press either the
        **autoDefault**  button that currently has focus, or if no button has
        focus, the next **autoDefault**  button in the focus chain.

        In a dialog, only one push button at a time can be the default button.
        This button is then displayed with an additional frame (depending on the
        GUI style).

        The default button behavior is provided only in dialogs. Buttons can
        always be clicked from the keyboard by pressing Spacebar when the button
        has focus.

        If the default property is set to false on the current default button
        while the dialog is visible, a new default will automatically be
        assigned the next time a push button in the dialog receives focus.

        This property's default is false.

        **Access functions:**

        bool **isDefault** () const
        void **setDefault** ( **bool** )
        """
        ...

    def isDefault(self) -> bool:
        ...

    def setAutoDefault(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#autoDefault-prop

        **autoDefault : bool**

        This property holds whether the push button is an auto default button

        If this property is set to true then the push button is an auto default
        button.

        In some GUI styles a default button is drawn with an extra frame around
        it, up to 3 pixels or more. Qt automatically keeps this space free
        around auto-default buttons, i.e., auto-default buttons may have a
        slightly larger size hint.

        This property's default is true for buttons that have a **QDialog**
        parent; otherwise it defaults to false.

        See the **default**  property for details of how **default**  and auto-
        default interact.

        **Access functions:**

        bool **autoDefault** () const
        void **setAutoDefault** ( **bool** )
        """
        ...

    def autoDefault(self) -> bool:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#autoDefault-prop

        **autoDefault : bool**

        This property holds whether the push button is an auto default button

        If this property is set to true then the push button is an auto default
        button.

        In some GUI styles a default button is drawn with an extra frame around
        it, up to 3 pixels or more. Qt automatically keeps this space free
        around auto-default buttons, i.e., auto-default buttons may have a
        slightly larger size hint.

        This property's default is true for buttons that have a **QDialog**
        parent; otherwise it defaults to false.

        See the **default**  property for details of how **default**  and auto-
        default interact.

        **Access functions:**

        bool **autoDefault** () const
        void **setAutoDefault** ( **bool** )
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#minimumSizeHint

        **[override virtual] QSize QPushButton::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qpushbutton.html#sizeHint

        **[override virtual] QSize QPushButton::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...
