"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore


class QMouseEventTransition(QtCore.QEventTransition):
    """
    https://doc.qt.io/qt-5/qmouseeventtransition.html

    **Detailed Description**

    QMouseEventTransition is part of **The State Machine Framework** .

    **See also** **QState::addTransition** ().
    """

    @typing.overload
    def __init__(self, sourceState: typing.Optional[QtCore.QState] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmouseeventtransition.html#QMouseEventTransition

        **QMouseEventTransition::QMouseEventTransition(QState * sourceState =
        nullptr)**

        Constructs a new mouse event transition with the given **sourceState**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        object: QtCore.QObject,
        type: QtCore.QEvent.Type,
        button: QtCore.Qt.MouseButton,
        sourceState: typing.Optional[QtCore.QState] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmouseeventtransition.html#QMouseEventTransition-
        1

        **QMouseEventTransition::QMouseEventTransition(QObject * object ,
        QEvent::Type type , Qt::MouseButton button , QState * sourceState =
        nullptr)**

        Constructs a new mouse event transition for events of the given **type**
        for the given **object** , with the given **button** and
        **sourceState**.
        """
        ...

    def eventTest(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qmouseeventtransition.html#eventTest

        **[override virtual protected] bool
        QMouseEventTransition::eventTest(QEvent * event )**

        Reimplements: **QEventTransition::eventTest** (QEvent *event).
        """
        ...

    def onTransition(self, event: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmouseeventtransition.html#onTransition

        **[override virtual protected] void
        QMouseEventTransition::onTransition(QEvent * event )**

        Reimplements: **QEventTransition::onTransition** (QEvent *event).
        """
        ...

    def setHitTestPath(self, path: QtGui.QPainterPath) -> None:
        """
        https://doc.qt.io/qt-5/qmouseeventtransition.html#setHitTestPath

        **void QMouseEventTransition::setHitTestPath(const QPainterPath & path
        )**

        Sets the hit test path for this mouse event transition to **path**. If a
        valid path has been set, the transition will only trigger if the mouse
        event position (**QMouseEvent::pos** ()) is inside the path.

        **See also** **hitTestPath** () and **QPainterPath::contains** ().
        """
        ...

    def hitTestPath(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-5/qmouseeventtransition.html#hitTestPath

        **QPainterPath QMouseEventTransition::hitTestPath() const**

        Returns the hit test path for this mouse event transition.

        **See also** **setHitTestPath** ().
        """
        ...

    def setModifierMask(
        self,
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmouseeventtransition.html#setModifierMask

        **void QMouseEventTransition::setModifierMask(Qt::KeyboardModifiers
        modifierMask )**

        Sets the keyboard modifier mask that this mouse event transition will
        check for to **modifierMask**.

        **Note:** Setter function for property **modifierMask** .

        **See also** **modifierMask** ().
        """
        ...

    def modifierMask(self) -> QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-5/qmouseeventtransition.html#modifierMask

        **Qt::KeyboardModifiers QMouseEventTransition::modifierMask() const**

        Returns the keyboard modifier mask that this mouse event transition
        checks for.

        **Note:** Getter function for property modifierMask.

        **See also** **setModifierMask** ().
        """
        ...

    def setButton(self, button: QtCore.Qt.MouseButton) -> None:
        """
        https://doc.qt.io/qt-5/qmouseeventtransition.html#setButton

        **void QMouseEventTransition::setButton(Qt::MouseButton button )**

        Sets the **button** that this mouse event transition will check for.

        **Note:** Setter function for property **button** .

        **See also** **button** ().
        """
        ...

    def button(self) -> QtCore.Qt.MouseButton:
        """
        https://doc.qt.io/qt-5/qmouseeventtransition.html#button

        **Qt::MouseButton QMouseEventTransition::button() const**

        Returns the button that this mouse event transition checks for.

        **Note:** Getter function for property button.

        **See also** **setButton** ().
        """
        ...
