"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QMenu(QWidget):
    """
    https://doc.qt.io/qt-5/qmenu.html

    **Detailed Description**

    ![](images/fusion-menu.png)

    A menu widget is a selection menu. It can be either a pull-down menu in a
    menu bar or a standalone context menu. Pull-down menus are shown by the menu
    bar when the user clicks on the respective item or presses the specified
    shortcut key. Use **QMenuBar::addMenu** () to insert a menu into a menu bar.
    Context menus are usually invoked by some special keyboard key or by right-
    clicking. They can be executed either asynchronously with **popup** () or
    synchronously with **exec** (). Menus can also be invoked in response to
    button presses; these are just like context menus except for how they are
    invoked.

    **Actions**

    A menu consists of a list of action items. Actions are added with the
    **addAction** (), **addActions** () and **insertAction** () functions. An
    action is represented vertically and rendered by **QStyle** . In addition,
    actions can have a text label, an optional icon drawn on the very left side,
    and shortcut key sequence such as "Ctrl+X".

    The existing actions held by a menu can be found with **actions** ().

    There are four kinds of action items: separators, actions that show a
    submenu, widgets, and actions that perform an action. Separators are
    inserted with **addSeparator** (), submenus with **addMenu** (), and all
    other items are considered action items.

    When inserting action items you usually specify a receiver and a slot. The
    receiver will be notifed whenever the item is **triggered()** . In addition,
    QMenu provides two signals, **triggered** () and **hovered** (), which
    signal the **QAction**  that was triggered from the menu.

    You clear a menu with **clear** () and remove individual action items with
    **removeAction** ().

    A QMenu can also provide a tear-off menu. A tear-off menu is a top-level
    window that contains a copy of the menu. This makes it possible for the user
    to "tear off" frequently used menus and position them in a convenient place
    on the screen. If you want this functionality for a particular menu, insert
    a tear-off handle with **setTearOffEnabled** (). When using tear-off menus,
    bear in mind that the concept isn't typically used on Microsoft Windows so
    some users may not be familiar with it. Consider using a **QToolBar**
    instead.

    Widgets can be inserted into menus with the **QWidgetAction**  class.
    Instances of this class are used to hold widgets, and are inserted into
    menus with the **addAction** () overload that takes a **QAction** . If the
    **QWidgetAction**  fires the **triggered** () signal, the menu will close.

    **Warning:** To make QMenu visible on the screen, **exec** () or **popup**
    () should be used instead of **show** ().

    **QMenu on macOS with Qt Build Against Cocoa**

    QMenu can be inserted only once in a menu/menubar. Subsequent insertions
    will have no effect or will result in a disabled menu item.

    See the **Menus**  example for an example of how to use **QMenuBar**  and
    QMenu in your application.

    **Important inherited functions:** **addAction** (), **removeAction** (),
    **clear** (), **addSeparator** (), and **addMenu** ().

    **See also** **QMenuBar** , **GUI Design Handbook: Menu, Drop-Down and Pop-
    Up** , **Application Example** , and **Menus Example** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#QMenu

        **QMenu::QMenu(QWidget * parent = nullptr)**

        Constructs a menu with parent **parent**.

        Although a popup menu is always a top-level widget, if a parent is
        passed the popup menu will be deleted when that parent is destroyed (as
        with any other **QObject** ).
        """
        ...

    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#QMenu-1

        **QMenu::QMenu(const QString & title , QWidget * parent = nullptr)**

        Constructs a menu with a **title** and a **parent**.

        Although a popup menu is always a top-level widget, if a parent is
        passed the popup menu will be deleted when that parent is destroyed (as
        with any other **QObject** ).

        **See also** **title** .
        """
        ...

    @typing.overload
    def showTearOffMenu(self) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#showTearOffMenu

        **void QMenu::showTearOffMenu(const QPoint & pos )**

        This function will forcibly show the torn off menu making it appear on
        the user's desktop at the specified **global** position **pos**.

        This function was introduced in Qt 5.7.

        **See also** **hideTearOffMenu** (), **isTearOffMenuVisible** (), and
        **isTearOffEnabled** ().
        """
        ...

    @typing.overload
    def showTearOffMenu(self, pos: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#showTearOffMenu-1

        **void QMenu::showTearOffMenu()**

        This is an overloaded function.

        This function will forcibly show the torn off menu making it appear on
        the user's desktop under the mouse currsor.

        This function was introduced in Qt 5.7.

        **See also** **hideTearOffMenu** (), **isTearOffMenuVisible** (), and
        **isTearOffEnabled** ().
        """
        ...

    def setToolTipsVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#toolTipsVisible-prop

        **toolTipsVisible : bool**

        This property holds whether tooltips of menu actions should be visible

        This property specifies whether action menu entries show their tooltip.

        By default, this property is `false`.

        This property was introduced in Qt 5.1.

        **Access functions:**

        bool **toolTipsVisible** () const
        void **setToolTipsVisible** (bool
        **visible** )

        **Member Function Documentation**
        """
        ...

    def toolTipsVisible(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmenu.html#toolTipsVisible-prop

        **toolTipsVisible : bool**

        This property holds whether tooltips of menu actions should be visible

        This property specifies whether action menu entries show their tooltip.

        By default, this property is `false`.

        This property was introduced in Qt 5.1.

        **Access functions:**

        bool **toolTipsVisible** () const
        void **setToolTipsVisible** (bool
        **visible** )

        **Member Function Documentation**
        """
        ...

    @typing.overload
    def insertSection(self, before: QAction, text: str) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#insertSection

        **QAction *QMenu::insertSection(QAction * before , const QString & text
        )**

        This convenience function creates a new title action, i.e. an action
        with **QAction::isSeparator** () returning true but also having **text**
        hint. The function inserts the newly created action into this menu's
        list of actions before action **before** and returns it.

        The rendering of the hint is style and platform dependent. Widget styles
        can use the text information in the rendering for sections, or can
        choose to ignore it and render sections like simple separators.

        **QMenu**  takes ownership of the returned **QAction** .

        This function was introduced in Qt 5.1.

        **See also** **QWidget::insertAction** () and **addSection** ().
        """
        ...

    @typing.overload
    def insertSection(self, before: QAction, icon: QtGui.QIcon, text: str) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#insertSection-1

        **QAction *QMenu::insertSection(QAction * before , const QIcon & icon ,
        const QString & text )**

        This convenience function creates a new title action, i.e. an action
        with **QAction::isSeparator** () returning true but also having **text**
        and **icon** hints. The function inserts the newly created action into
        this menu's list of actions before action **before** and returns it.

        The rendering of the hints is style and platform dependent. Widget
        styles can use the text and icon information in the rendering for
        sections, or can choose to ignore them and render sections like simple
        separators.

        **QMenu**  takes ownership of the returned **QAction** .

        This function was introduced in Qt 5.1.

        **See also** **QWidget::insertAction** () and **addSection** ().
        """
        ...

    @typing.overload
    def addSection(self, text: str) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#addSection

        **QAction *QMenu::addSection(const QString & text )**

        This convenience function creates a new section action, i.e. an action
        with **QAction::isSeparator** () returning true but also having **text**
        hint, and adds the new action to this menu's list of actions. It returns
        the newly created action.

        The rendering of the hint is style and platform dependent. Widget styles
        can use the text information in the rendering for sections, or can
        choose to ignore it and render sections like simple separators.

        **QMenu**  takes ownership of the returned **QAction** .

        This function was introduced in Qt 5.1.

        **See also** **QWidget::addAction** ().
        """
        ...

    @typing.overload
    def addSection(self, icon: QtGui.QIcon, text: str) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#addSection-1

        **QAction *QMenu::addSection(const QIcon & icon , const QString & text
        )**

        This convenience function creates a new section action, i.e. an action
        with **QAction::isSeparator** () returning true but also having **text**
        and **icon** hints, and adds the new action to this menu's list of
        actions. It returns the newly created action.

        The rendering of the hints is style and platform dependent. Widget
        styles can use the text and icon information in the rendering for
        sections, or can choose to ignore them and render sections like simple
        separators.

        **QMenu**  takes ownership of the returned **QAction** .

        This function was introduced in Qt 5.1.

        **See also** **QWidget::addAction** ().
        """
        ...

    def setSeparatorsCollapsible(self, collapse: bool) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#separatorsCollapsible-prop

        **separatorsCollapsible : bool**

        This property holds whether consecutive separators should be collapsed

        This property specifies whether consecutive separators in the menu
        should be visually collapsed to a single one. Separators at the
        beginning or the end of the menu are also hidden.

        By default, this property is `true`.

        This property was introduced in Qt 4.2.

        **Access functions:**

        bool **separatorsCollapsible** () const
        void
        **setSeparatorsCollapsible** (bool **collapse** )
        """
        ...

    def separatorsCollapsible(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmenu.html#separatorsCollapsible-prop

        **separatorsCollapsible : bool**

        This property holds whether consecutive separators should be collapsed

        This property specifies whether consecutive separators in the menu
        should be visually collapsed to a single one. Separators at the
        beginning or the end of the menu are also hidden.

        By default, this property is `true`.

        This property was introduced in Qt 4.2.

        **Access functions:**

        bool **separatorsCollapsible** () const
        void
        **setSeparatorsCollapsible** (bool **collapse** )
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmenu.html#isEmpty

        **bool QMenu::isEmpty() const**

        Returns `true` if there are no visible actions inserted into the menu,
        false otherwise.

        This function was introduced in Qt 4.2.

        **See also** **QWidget::actions** ().
        """
        ...

    def focusNextPrevChild(self, next: bool) -> bool:
        """
        https://doc.qt.io/qt-5/qmenu.html#focusNextPrevChild

        **[override virtual protected] bool QMenu::focusNextPrevChild(bool next
        )**

        Reimplements: **QWidget::focusNextPrevChild** (bool next).
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qmenu.html#event

        **[override virtual protected] bool QMenu::event(QEvent * e )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def timerEvent(self, a0: QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#timerEvent

        **[override virtual protected] void QMenu::timerEvent(QTimerEvent * e
        )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    def actionEvent(self, a0: QtGui.QActionEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#actionEvent

        **[override virtual protected] void QMenu::actionEvent(QActionEvent * e
        )**

        Reimplements: **QWidget::actionEvent** (QActionEvent *event).
        """
        ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#paintEvent

        **[override virtual protected] void QMenu::paintEvent(QPaintEvent * e
        )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def hideEvent(self, a0: QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#hideEvent

        **[override virtual protected] void QMenu::hideEvent( QHideEvent * )**

        Reimplements: **QWidget::hideEvent** (QHideEvent *event).
        """
        ...

    def leaveEvent(self, a0: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#leaveEvent

        **[override virtual protected] void QMenu::leaveEvent( QEvent * )**

        Reimplements: **QWidget::leaveEvent** (QEvent *event).
        """
        ...

    def enterEvent(self, a0: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#enterEvent

        **[override virtual protected] void QMenu::enterEvent( QEvent * )**

        Reimplements: **QWidget::enterEvent** (QEvent *event).
        """
        ...

    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#wheelEvent

        **[override virtual protected] void QMenu::wheelEvent(QWheelEvent * e
        )**

        Reimplements: **QWidget::wheelEvent** (QWheelEvent *event).
        """
        ...

    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#mouseMoveEvent

        **[override virtual protected] void QMenu::mouseMoveEvent(QMouseEvent *
        e )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#mousePressEvent

        **[override virtual protected] void QMenu::mousePressEvent(QMouseEvent *
        e )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#mouseReleaseEvent

        **[override virtual protected] void QMenu::mouseReleaseEvent(QMouseEvent
        * e )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#keyPressEvent

        **[override virtual protected] void QMenu::keyPressEvent(QKeyEvent * e
        )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def changeEvent(self, a0: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#changeEvent

        **[override virtual protected] void QMenu::changeEvent(QEvent * e )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def initStyleOption(self, option: "QStyleOptionMenuItem", action: QAction) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#initStyleOption

        **[protected] void QMenu::initStyleOption(QStyleOptionMenuItem * option
        , const QAction * action ) const**

        Initialize **option** with the values from this menu and information
        from **action**. This method is useful for subclasses when they need a
        **QStyleOptionMenuItem** , but don't want to fill in all the information
        themselves.

        **See also** **QStyleOption::initFrom** () and
        **QMenuBar::initStyleOption** ().
        """
        ...

    def columnCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qmenu.html#columnCount

        **[protected] int QMenu::columnCount() const**

        If a menu does not fit on the screen it lays itself out so that it does
        fit. It is style dependent what layout means (for example, on Windows it
        will use multiple columns).

        This functions returns the number of columns necessary.
        """
        ...

    def setNoReplayFor(self, widget: QWidget) -> None:
        ...

    def setIcon(self, icon: QtGui.QIcon) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#icon-prop

        **icon : QIcon**

        This property holds the icon of the menu

        This is equivalent to the **QAction::icon**  property of the
        **menuAction** ().

        By default, if no icon is explicitly set, this property contains a null
        icon.

        **Access functions:**

        QIcon **icon** () const
        void **setIcon** (const QIcon & **icon** )
        """
        ...

    def icon(self) -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-5/qmenu.html#icon-prop

        **icon : QIcon**

        This property holds the icon of the menu

        This is equivalent to the **QAction::icon**  property of the
        **menuAction** ().

        By default, if no icon is explicitly set, this property contains a null
        icon.

        **Access functions:**

        QIcon **icon** () const
        void **setIcon** (const QIcon & **icon** )
        """
        ...

    def setTitle(self, title: str) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#title-prop

        **title : QString**

        This property holds the title of the menu

        This is equivalent to the **QAction::text**  property of the
        **menuAction** ().

        By default, this property contains an empty string.

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &
        **title** )
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-5/qmenu.html#title-prop

        **title : QString**

        This property holds the title of the menu

        This is equivalent to the **QAction::text**  property of the
        **menuAction** ().

        By default, this property contains an empty string.

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &
        **title** )
        """
        ...

    def menuAction(self) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#menuAction

        **QAction *QMenu::menuAction() const**

        Returns the action associated with this menu.
        """
        ...

    def actionAt(self, a0: QtCore.QPoint) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#actionAt

        **QAction *QMenu::actionAt(const QPoint & pt ) const**

        Returns the item at **pt** ; returns `nullptr` if there is no item
        there.
        """
        ...

    def actionGeometry(self, a0: QAction) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qmenu.html#actionGeometry

        **QRect QMenu::actionGeometry(QAction * act ) const**

        Returns the geometry of action **act**.
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qmenu.html#sizeHint

        **[override virtual] QSize QMenu::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    @typing.overload
    def exec(self) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#exec

        **QAction *QMenu::exec()**

        Executes this menu synchronously.

        This is equivalent to `exec(pos())`.

        This returns the triggered **QAction**  in either the popup menu or one
        of its submenus, or `nullptr` if no item was triggered (normally because
        the user pressed Esc).

        In most situations you'll want to specify the position yourself, for
        example, the current mouse position:

        exec(**QCursor** ::pos());

        or aligned to a widget:

        exec(somewidget.mapToGlobal(**QPoint** (0,0)));

        or in reaction to a **QMouseEvent**  *e:

        exec(e->globalPos());
        """
        ...

    @typing.overload
    def exec(
        self, pos: QtCore.QPoint, action: typing.Optional[QAction] = ...
    ) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#exec-1

        **QAction *QMenu::exec(const QPoint & p , QAction * action = nullptr)**

        This is an overloaded function.

        Executes this menu synchronously.

        Pops up the menu so that the action **action** will be at the specified
        **global** position **p**. To translate a widget's local coordinates
        into global coordinates, use **QWidget::mapToGlobal** ().

        This returns the triggered **QAction**  in either the popup menu or one
        of its submenus, or `nullptr` if no item was triggered (normally because
        the user pressed Esc).

        Note that all signals are emitted as usual. If you connect a **QAction**
        to a slot and call the menu's exec(), you get the result both via the
        signal-slot connection and in the return value of exec().

        Common usage is to position the menu at the current mouse position:

        exec(**QCursor** ::pos());

        or aligned to a widget:

        exec(somewidget.mapToGlobal(**QPoint** (0, 0)));

        or in reaction to a **QMouseEvent**  *e:

        exec(e->globalPos());

        When positioning a menu with exec() or **popup** (), bear in mind that
        you cannot rely on the menu's current **size** (). For performance
        reasons, the menu adapts its size only when necessary. So in many cases,
        the size before and after the show is different. Instead, use
        **sizeHint** () which calculates the proper size depending on the menu's
        current contents.

        **See also** **popup** () and **QWidget::mapToGlobal** ().
        """
        ...

    @typing.overload
    @staticmethod
    def exec(
        actions: typing.Iterable[QAction],
        pos: QtCore.QPoint,
        at: typing.Optional[QAction] = ...,
        parent: typing.Optional[QWidget] = ...,
    ) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#exec-2

        **[static] QAction *QMenu::exec(QList<QAction *> actions , const QPoint
        & pos , QAction * at = nullptr, QWidget * parent = nullptr)**

        This is an overloaded function.

        Executes a menu synchronously.

        The menu's actions are specified by the list of **actions**. The menu
        will pop up so that the specified action, **at** , appears at global
        position **pos**. If **at** is not specified then the menu appears at
        position **pos**. **parent** is the menu's parent widget; specifying the
        parent will provide context when **pos** alone is not enough to decide
        where the menu should go (e.g., with multiple desktops or when the
        parent is embedded in **QGraphicsView** ).

        The function returns the triggered **QAction**  in either the popup menu
        or one of its submenus, or `nullptr` if no item was triggered (normally
        because the user pressed Esc).

        This is equivalent to:

        **QMenu**  menu;
            **QAction**  *at = actions[0]; // Assumes actions
        is not empty
            for (**QAction**  *a : **qAsConst** (actions))
        menu.addAction(a);
            menu.exec(pos, at);

        **See also** **popup** () and **QWidget::mapToGlobal** ().
        """
        ...

    @typing.overload
    def exec_(self) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#exec

        **QAction *QMenu::exec()**

        Executes this menu synchronously.

        This is equivalent to `exec(pos())`.

        This returns the triggered **QAction**  in either the popup menu or one
        of its submenus, or `nullptr` if no item was triggered (normally because
        the user pressed Esc).

        In most situations you'll want to specify the position yourself, for
        example, the current mouse position:

        exec(**QCursor** ::pos());

        or aligned to a widget:

        exec(somewidget.mapToGlobal(**QPoint** (0,0)));

        or in reaction to a **QMouseEvent**  *e:

        exec(e->globalPos());
        """
        ...

    @typing.overload
    def exec_(
        self, p: QtCore.QPoint, action: typing.Optional[QAction] = ...
    ) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#exec

        **QAction *QMenu::exec()**

        Executes this menu synchronously.

        This is equivalent to `exec(pos())`.

        This returns the triggered **QAction**  in either the popup menu or one
        of its submenus, or `nullptr` if no item was triggered (normally because
        the user pressed Esc).

        In most situations you'll want to specify the position yourself, for
        example, the current mouse position:

        exec(**QCursor** ::pos());

        or aligned to a widget:

        exec(somewidget.mapToGlobal(**QPoint** (0,0)));

        or in reaction to a **QMouseEvent**  *e:

        exec(e->globalPos());
        """
        ...

    @typing.overload
    @staticmethod
    def exec_(
        actions: typing.Iterable[QAction],
        pos: QtCore.QPoint,
        at: typing.Optional[QAction] = ...,
        parent: typing.Optional[QWidget] = ...,
    ) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#exec

        **QAction *QMenu::exec()**

        Executes this menu synchronously.

        This is equivalent to `exec(pos())`.

        This returns the triggered **QAction**  in either the popup menu or one
        of its submenus, or `nullptr` if no item was triggered (normally because
        the user pressed Esc).

        In most situations you'll want to specify the position yourself, for
        example, the current mouse position:

        exec(**QCursor** ::pos());

        or aligned to a widget:

        exec(somewidget.mapToGlobal(**QPoint** (0,0)));

        or in reaction to a **QMouseEvent**  *e:

        exec(e->globalPos());
        """
        ...

    def popup(self, p: QtCore.QPoint, action: typing.Optional[QAction] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#popup

        **void QMenu::popup(const QPoint & p , QAction * atAction = nullptr)**

        Displays the menu so that the action **atAction** will be at the
        specified **global** position **p**. To translate a widget's local
        coordinates into global coordinates, use **QWidget::mapToGlobal** ().

        When positioning a menu with **exec** () or popup(), bear in mind that
        you cannot rely on the menu's current **size** (). For performance
        reasons, the menu adapts its size only when necessary, so in many cases,
        the size before and after the show is different. Instead, use
        **sizeHint** () which calculates the proper size depending on the menu's
        current contents.

        **See also** **QWidget::mapToGlobal** () and **exec** ().
        """
        ...

    def activeAction(self) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#activeAction

        **QAction *QMenu::activeAction() const**

        Returns the currently highlighted action, or `nullptr` if no action is
        currently highlighted.

        **See also** **setActiveAction** ().
        """
        ...

    def setActiveAction(self, act: QAction) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#setActiveAction

        **void QMenu::setActiveAction(QAction * act )**

        Sets the currently highlighted action to **act**.

        **See also** **activeAction** ().
        """
        ...

    def defaultAction(self) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#defaultAction

        **QAction *QMenu::defaultAction() const**

        Returns the current default action.

        **See also** **setDefaultAction** ().
        """
        ...

    def setDefaultAction(self, a0: QAction) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#setDefaultAction

        **void QMenu::setDefaultAction(QAction * act )**

        This sets the default action to **act**. The default action may have a
        visual cue, depending on the current **QStyle** . A default action
        usually indicates what will happen by default when a drop occurs.

        **See also** **defaultAction** ().
        """
        ...

    def hideTearOffMenu(self) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#hideTearOffMenu

        **void QMenu::hideTearOffMenu()**

        This function will forcibly hide the torn off menu making it disappear
        from the user's desktop.

        **See also** **showTearOffMenu** (), **isTearOffMenuVisible** (), and
        **isTearOffEnabled** ().
        """
        ...

    def isTearOffMenuVisible(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmenu.html#isTearOffMenuVisible

        **bool QMenu::isTearOffMenuVisible() const**

        When a menu is torn off a second menu is shown to display the menu
        contents in a new window. When the menu is in this mode and the menu is
        visible returns `true`; otherwise false.

        **See also** **showTearOffMenu** (), **hideTearOffMenu** (), and
        **isTearOffEnabled** ().
        """
        ...

    def isTearOffEnabled(self) -> bool:
        ...

    def setTearOffEnabled(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#tearOffEnabled-prop

        **tearOffEnabled : bool**

        This property holds whether the menu supports being torn off

        When true, the menu contains a special tear-off item (often shown as a
        dashed line at the top of the menu) that creates a copy of the menu when
        it is triggered.

        This "torn-off" copy lives in a separate window. It contains the same
        menu items as the original menu, with the exception of the tear-off
        handle.

        By default, this property is `false`.

        **Access functions:**

        bool **isTearOffEnabled** () const
        void **setTearOffEnabled** (
        **bool** )
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#clear

        **void QMenu::clear()**

        Removes all the menu's actions. Actions owned by the menu and not shown
        in any other widget are deleted.

        **See also** **removeAction** ().
        """
        ...

    def insertSeparator(self, before: QAction) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#insertSeparator

        **QAction *QMenu::insertSeparator(QAction * before )**

        This convenience function creates a new separator action, i.e. an action
        with **QAction::isSeparator** () returning true. The function inserts
        the newly created action into this menu's list of actions before action
        **before** and returns it.

        **QMenu**  takes ownership of the returned **QAction** .

        **See also** **QWidget::insertAction** () and **addSeparator** ().
        """
        ...

    def insertMenu(self, before: QAction, menu: "QMenu") -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#insertMenu

        **QAction *QMenu::insertMenu(QAction * before , QMenu * menu )**

        This convenience function inserts **menu** before action **before** and
        returns the menus **menuAction** ().

        **See also** **QWidget::insertAction** () and **addMenu** ().
        """
        ...

    def addSeparator(self) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#addSeparator

        **QAction *QMenu::addSeparator()**

        This convenience function creates a new separator action, i.e. an action
        with **QAction::isSeparator** () returning true, and adds the new action
        to this menu's list of actions. It returns the newly created action.

        **QMenu**  takes ownership of the returned **QAction** .

        **See also** **QWidget::addAction** ().
        """
        ...

    @typing.overload
    def addMenu(self, menu: "QMenu") -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#addMenu

        **QAction *QMenu::addMenu(QMenu * menu )**

        This convenience function adds **menu** as a submenu to this menu. It
        returns **menu** 's **menuAction** (). This menu does not take ownership
        of **menu**.

        **See also** **QWidget::addAction** () and **QMenu::menuAction** ().
        """
        ...

    @typing.overload
    def addMenu(self, title: str) -> "QMenu":
        """
        https://doc.qt.io/qt-5/qmenu.html#addMenu-1

        **QMenu *QMenu::addMenu(const QString & title )**

        Appends a new **QMenu**  with **title** to the menu. The menu takes
        ownership of the menu. Returns the new menu.

        **See also** **QWidget::addAction** () and **QMenu::menuAction** ().
        """
        ...

    @typing.overload
    def addMenu(self, icon: QtGui.QIcon, title: str) -> "QMenu":
        """
        https://doc.qt.io/qt-5/qmenu.html#addMenu-2

        **QMenu *QMenu::addMenu(const QIcon & icon , const QString & title )**

        Appends a new **QMenu**  with **icon** and **title** to the menu. The
        menu takes ownership of the menu. Returns the new menu.

        **See also** **QWidget::addAction** () and **QMenu::menuAction** ().
        """
        ...

    @typing.overload
    def addAction(self, action: QAction) -> None:
        """
        https://doc.qt.io/qt-5/qmenu.html#addAction

        **QAction *QMenu::addAction(const QString & text )**

        This convenience function creates a new action with **text**. The
        function adds the newly created action to the menu's list of actions,
        and returns it.

        **QMenu**  takes ownership of the returned **QAction** .

        **See also** **QWidget::addAction** ().
        """
        ...

    @typing.overload
    def addAction(self, text: str) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#addAction-1

        **QAction *QMenu::addAction(const QIcon & icon , const QString & text
        )**

        This is an overloaded function.

        This convenience function creates a new action with an **icon** and some
        **text**. The function adds the newly created action to the menu's list
        of actions, and returns it.

        **QMenu**  takes ownership of the returned **QAction** .

        **See also** **QWidget::addAction** ().
        """
        ...

    @typing.overload
    def addAction(self, icon: QtGui.QIcon, text: str) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#addAction-2

        **QAction *QMenu::addAction(const QString & text , const QObject *
        receiver , const char * member , const QKeySequence & shortcut = 0)**

        This is an overloaded function.

        This convenience function creates a new action with the text **text**
        and an optional shortcut **shortcut**. The action's **triggered()**
        signal is connected to the **receiver** 's **member** slot. The function
        adds the newly created action to the menu's list of actions and returns
        it.

        **QMenu**  takes ownership of the returned **QAction** .

        **See also** **QWidget::addAction** ().
        """
        ...

    @typing.overload
    def addAction(
        self,
        text: str,
        slot: PYQT_SLOT,
        shortcut: typing.Union[
            QtGui.QKeySequence, QtGui.QKeySequence.StandardKey, str, int
        ] = ...,
    ) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#addAction-3

        **QAction *QMenu::addAction(const QIcon & icon , const QString & text ,
        const QObject * receiver , const char * member , const QKeySequence &
        shortcut = 0)**

        This is an overloaded function.

        This convenience function creates a new action with an **icon** and some
        **text** and an optional shortcut **shortcut**. The action's
        **triggered()**  signal is connected to the **member** slot of the
        **receiver** object. The function adds the newly created action to the
        menu's list of actions, and returns it.

        **QMenu**  takes ownership of the returned **QAction** .

        **See also** **QWidget::addAction** ().
        """
        ...

    @typing.overload
    def addAction(
        self,
        icon: QtGui.QIcon,
        text: str,
        slot: PYQT_SLOT,
        shortcut: typing.Union[
            QtGui.QKeySequence, QtGui.QKeySequence.StandardKey, str, int
        ] = ...,
    ) -> QAction:
        """
        https://doc.qt.io/qt-5/qmenu.html#addAction-4

        **template <typename Functor> QAction *QMenu::addAction(const QString &
        text , Functor functor , const QKeySequence & shortcut = 0)**

        This is an overloaded function.

        This convenience function creates a new action with the text **text**
        and an optional shortcut **shortcut**. The action's **triggered()**
        signal is connected to the **functor**. The function adds the newly
        created action to the menu's list of actions and returns it.

        **QMenu**  takes ownership of the returned **QAction** .

        This function was introduced in Qt 5.6.
        """
        ...

    @property
    def aboutToHide(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmenu.html#aboutToHide

        **[signal] void QMenu::aboutToHide()**

        This signal is emitted just before the menu is hidden from the user.

        This function was introduced in Qt 4.2.

        **See also** **aboutToShow** () and **hide** ().
        """
        ...

    @property
    def aboutToShow(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmenu.html#aboutToShow

        **[signal] void QMenu::aboutToShow()**

        This signal is emitted just before the menu is shown to the user.

        **See also** **aboutToHide** () and **show** ().
        """
        ...

    @property
    def hovered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmenu.html#hovered

        **[signal] void QMenu::hovered(QAction * action )**

        This signal is emitted when a menu action is highlighted; **action** is
        the action that caused the signal to be emitted.

        Often this is used to update status information.

        **See also** **triggered** () and **QAction::hovered** ().
        """
        ...

    @property
    def triggered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmenu.html#triggered

        **[signal] void QMenu::triggered(QAction * action )**

        This signal is emitted when an action in this menu is triggered.

        **action** is the action that caused the signal to be emitted.

        Normally, you connect each menu action's **triggered()**  signal to its
        own custom slot, but sometimes you will want to connect several actions
        to a single slot, for example, when you have a group of closely related
        actions, such as "left justify", "center", "right justify".

        **Note:** This signal is emitted for the main parent menu in a
        hierarchy. Hence, only the parent menu needs to be connected to a slot;
        sub-menus need not be connected.

        **See also** **hovered** () and **QAction::triggered** ().
        """
        ...
