"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *
from PyQt5 import sip


class QMdiArea(QAbstractScrollArea):
    """
    https://doc.qt.io/qt-5/qmdiarea.html

    **Detailed Description**

    QMdiArea functions, essentially, like a window manager for MDI windows. For
    instance, it draws the windows it manages on itself and arranges them in a
    cascading or tile pattern. QMdiArea is commonly used as the center widget in
    a **QMainWindow**  to create MDI applications, but can also be placed in any
    layout. The following code adds an area to a main window:

    **QMainWindow**  *mainWindow = new **QMainWindow** ;
    mainWindow->setCentralWidget(mdiArea);

    Unlike the window managers for top-level windows, all window flags
    (**Qt::WindowFlags** ) are supported by QMdiArea as long as the flags are
    supported by the current widget style. If a specific flag is not supported
    by the style (e.g., the **WindowShadeButtonHint** ), you can still shade the
    window with showShaded().

    Subwindows in QMdiArea are instances of **QMdiSubWindow** . They are added
    to an MDI area with **addSubWindow** (). It is common to pass a **QWidget**
    , which is set as the internal widget, to this function, but it is also
    possible to pass a **QMdiSubWindow**  directly.The class inherits
    **QWidget** , and you can use the same API as with a normal top-level window
    when programming. **QMdiSubWindow**  also has behavior that is specific to
    MDI windows. See the **QMdiSubWindow**  class description for more details.

    A subwindow becomes active when it gets the keyboard focus, or when
    **setFocus** () is called. The user activates a window by moving focus in
    the usual ways. The MDI area emits the **subWindowActivated** () signal when
    the active window changes, and the **activeSubWindow** () function returns
    the active subwindow.

    The convenience function **subWindowList** () returns a list of all
    subwindows. This information could be used in a popup menu containing a list
    of windows, for example.

    The subwindows are sorted by the current **WindowOrder** . This is used for
    the **subWindowList** () and for **activateNextSubWindow** () and
    **activatePreviousSubWindow** (). Also, it is used when cascading or tiling
    the windows with **cascadeSubWindows** () and **tileSubWindows** ().

    QMdiArea provides two built-in layout strategies for subwindows:
    **cascadeSubWindows** () and **tileSubWindows** (). Both are slots and are
    easily connected to menu entries.

    ![](images/mdi-cascade.png)![](images/mdi-tile.png)

    **Note:** The default scroll bar property for QMdiArea is
    **Qt::ScrollBarAlwaysOff** .

    **See also** **QMdiSubWindow** .
    """

    class WindowOrder(int):
        CreationOrder: QMdiArea = ...
        StackingOrder: QMdiArea = ...
        ActivationHistoryOrder: QMdiArea = ...

    class ViewMode(int):
        SubWindowView: QMdiArea = ...
        TabbedView: QMdiArea = ...

    class AreaOption(int):
        DontMaximizeSubWindowOnActivation: QMdiArea = ...

    class AreaOptions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QMdiArea.AreaOptions", "QMdiArea.AreaOption"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QMdiArea.AreaOptions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QMdiArea.AreaOptions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#QMdiArea

        **QMdiArea::QMdiArea(QWidget * parent = nullptr)**

        Constructs an empty mdi area. **parent** is passed to **QWidget** 's
        constructor.
        """
        ...

    def tabsMovable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#tabsMovable-prop

        **tabsMovable : bool**

        This property holds whether the user can move the tabs within the tabbar
        area in tabbed view mode.

        Tabs are not movable by default.

        This property was introduced in Qt 4.8.

        **Access functions:**

        bool **tabsMovable** () const
        void **setTabsMovable** (bool
        **movable** )

        **See also** **QTabBar::movable**  and **setViewMode** ().
        """
        ...

    def setTabsMovable(self, movable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#tabsMovable-prop

        **tabsMovable : bool**

        This property holds whether the user can move the tabs within the tabbar
        area in tabbed view mode.

        Tabs are not movable by default.

        This property was introduced in Qt 4.8.

        **Access functions:**

        bool **tabsMovable** () const
        void **setTabsMovable** (bool
        **movable** )

        **See also** **QTabBar::movable**  and **setViewMode** ().
        """
        ...

    def tabsClosable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#tabsClosable-prop

        **tabsClosable : bool**

        This property holds whether the tab bar should place close buttons on
        each tab in tabbed view mode.

        Tabs are not closable by default.

        This property was introduced in Qt 4.8.

        **Access functions:**

        bool **tabsClosable** () const
        void **setTabsClosable** (bool
        **closable** )

        **See also** **QTabBar::tabsClosable**  and **setViewMode** ().
        """
        ...

    def setTabsClosable(self, closable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#tabsClosable-prop

        **tabsClosable : bool**

        This property holds whether the tab bar should place close buttons on
        each tab in tabbed view mode.

        Tabs are not closable by default.

        This property was introduced in Qt 4.8.

        **Access functions:**

        bool **tabsClosable** () const
        void **setTabsClosable** (bool
        **closable** )

        **See also** **QTabBar::tabsClosable**  and **setViewMode** ().
        """
        ...

    def setDocumentMode(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#documentMode-prop

        **documentMode : bool**

        This property holds whether the tab bar is set to document mode in
        tabbed view mode.

        Document mode is disabled by default.

        This property was introduced in Qt 4.5.

        **Access functions:**

        bool **documentMode** () const
        void **setDocumentMode** (bool
        **enabled** )

        **See also** **QTabBar::documentMode**  and **setViewMode** ().
        """
        ...

    def documentMode(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#documentMode-prop

        **documentMode : bool**

        This property holds whether the tab bar is set to document mode in
        tabbed view mode.

        Document mode is disabled by default.

        This property was introduced in Qt 4.5.

        **Access functions:**

        bool **documentMode** () const
        void **setDocumentMode** (bool
        **enabled** )

        **See also** **QTabBar::documentMode**  and **setViewMode** ().
        """
        ...

    def tabPosition(self) -> "QTabWidget.TabPosition":
        """
        https://doc.qt.io/qt-5/qmdiarea.html#tabPosition-prop

        **tabPosition : QTabWidget::TabPosition**

        This property holds the position of the tabs in tabbed view mode.

        Possible values for this property are described by the
        **QTabWidget::TabPosition**  enum.

        This property was introduced in Qt 4.4.

        **Access functions:**

        QTabWidget::TabPosition **tabPosition** () const
        void
        **setTabPosition** (QTabWidget::TabPosition **position** )

        **See also** **QTabWidget::TabPosition**  and **setViewMode** ().
        """
        ...

    def setTabPosition(self, position: "QTabWidget.TabPosition") -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#tabPosition-prop

        **tabPosition : QTabWidget::TabPosition**

        This property holds the position of the tabs in tabbed view mode.

        Possible values for this property are described by the
        **QTabWidget::TabPosition**  enum.

        This property was introduced in Qt 4.4.

        **Access functions:**

        QTabWidget::TabPosition **tabPosition** () const
        void
        **setTabPosition** (QTabWidget::TabPosition **position** )

        **See also** **QTabWidget::TabPosition**  and **setViewMode** ().
        """
        ...

    def tabShape(self) -> "QTabWidget.TabShape":
        """
        https://doc.qt.io/qt-5/qmdiarea.html#tabShape-prop

        **tabShape : QTabWidget::TabShape**

        This property holds the shape of the tabs in tabbed view mode.

        Possible values for this property are **QTabWidget::Rounded**  (default)
        or **QTabWidget::Triangular** .

        This property was introduced in Qt 4.4.

        **Access functions:**

        QTabWidget::TabShape **tabShape** () const
        void **setTabShape**
        (QTabWidget::TabShape **shape** )

        **See also** **QTabWidget::TabShape**  and **setViewMode** ().
        """
        ...

    def setTabShape(self, shape: "QTabWidget.TabShape") -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#tabShape-prop

        **tabShape : QTabWidget::TabShape**

        This property holds the shape of the tabs in tabbed view mode.

        Possible values for this property are **QTabWidget::Rounded**  (default)
        or **QTabWidget::Triangular** .

        This property was introduced in Qt 4.4.

        **Access functions:**

        QTabWidget::TabShape **tabShape** () const
        void **setTabShape**
        (QTabWidget::TabShape **shape** )

        **See also** **QTabWidget::TabShape**  and **setViewMode** ().
        """
        ...

    def viewMode(self) -> "QMdiArea.ViewMode":
        """
        https://doc.qt.io/qt-5/qmdiarea.html#viewMode-prop

        **viewMode : ViewMode**

        This property holds the way sub-windows are displayed in the
        **QMdiArea** .

        By default, the **SubWindowView**  is used to display sub-windows.

        This property was introduced in Qt 4.4.

        **Access functions:**

        QMdiArea::ViewMode **viewMode** () const
        void **setViewMode**
        (QMdiArea::ViewMode **mode** )

        **See also** **ViewMode** , **setTabShape** (), and **setTabPosition**
        ().

        **Member Function Documentation**
        """
        ...

    def setViewMode(self, mode: "QMdiArea.ViewMode") -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#viewMode-prop

        **viewMode : ViewMode**

        This property holds the way sub-windows are displayed in the
        **QMdiArea** .

        By default, the **SubWindowView**  is used to display sub-windows.

        This property was introduced in Qt 4.4.

        **Access functions:**

        QMdiArea::ViewMode **viewMode** () const
        void **setViewMode**
        (QMdiArea::ViewMode **mode** )

        **See also** **ViewMode** , **setTabShape** (), and **setTabPosition**
        ().

        **Member Function Documentation**
        """
        ...

    def setActivationOrder(self, order: "QMdiArea.WindowOrder") -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#activationOrder-prop

        **activationOrder : WindowOrder**

        This property holds the ordering criteria for subwindow lists

        This property specifies the ordering criteria for the list of subwindows
        returned by **subWindowList** (). By default, it is the window creation
        order.

        This property was introduced in Qt 4.4.

        **Access functions:**

        QMdiArea::WindowOrder **activationOrder** () const
        void
        **setActivationOrder** (QMdiArea::WindowOrder **order** )

        **See also** **subWindowList** ().
        """
        ...

    def activationOrder(self) -> "QMdiArea.WindowOrder":
        """
        https://doc.qt.io/qt-5/qmdiarea.html#activationOrder-prop

        **activationOrder : WindowOrder**

        This property holds the ordering criteria for subwindow lists

        This property specifies the ordering criteria for the list of subwindows
        returned by **subWindowList** (). By default, it is the window creation
        order.

        This property was introduced in Qt 4.4.

        **Access functions:**

        QMdiArea::WindowOrder **activationOrder** () const
        void
        **setActivationOrder** (QMdiArea::WindowOrder **order** )

        **See also** **subWindowList** ().
        """
        ...

    def scrollContentsBy(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#scrollContentsBy

        **[override virtual protected] void QMdiArea::scrollContentsBy(int dx ,
        int dy )**

        Reimplements: **QAbstractScrollArea::scrollContentsBy** (int dx, int
        dy).
        """
        ...

    def viewportEvent(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#viewportEvent

        **[override virtual protected] bool QMdiArea::viewportEvent(QEvent *
        event )**

        Reimplements: **QAbstractScrollArea::viewportEvent** (QEvent *event).
        """
        ...

    def showEvent(self, showEvent: QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#showEvent

        **[override virtual protected] void QMdiArea::showEvent(QShowEvent *
        showEvent )**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...

    def timerEvent(self, timerEvent: QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#timerEvent

        **[override virtual protected] void QMdiArea::timerEvent(QTimerEvent *
        timerEvent )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    def resizeEvent(self, resizeEvent: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#resizeEvent

        **[override virtual protected] void QMdiArea::resizeEvent(QResizeEvent *
        resizeEvent )**

        Reimplements: **QAbstractScrollArea::resizeEvent** (QResizeEvent
        *event).
        """
        ...

    def childEvent(self, childEvent: QtCore.QChildEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#childEvent

        **[override virtual protected] void QMdiArea::childEvent(QChildEvent *
        childEvent )**

        Reimplements: **QObject::childEvent** (QChildEvent *event).
        """
        ...

    def paintEvent(self, paintEvent: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#paintEvent

        **[override virtual protected] void QMdiArea::paintEvent(QPaintEvent *
        paintEvent )**

        Reimplements: **QAbstractScrollArea::paintEvent** (QPaintEvent *event).
        """
        ...

    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#eventFilter

        **[override virtual protected] bool QMdiArea::eventFilter(QObject *
        object , QEvent * event )**

        Reimplements: **QObject::eventFilter** (QObject *watched, QEvent
        *event).
        """
        ...

    def event(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#event

        **[override virtual protected] bool QMdiArea::event(QEvent * event )**

        Reimplements: **QAbstractScrollArea::event** (QEvent *event).
        """
        ...

    def setupViewport(self, viewport: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#setupViewport

        **[override virtual protected slot] void QMdiArea::setupViewport(QWidget
        * viewport )**

        Reimplements: **QAbstractScrollArea::setupViewport** (QWidget
        *viewport).

        This slot is called by **QAbstractScrollArea**  after **setViewport** ()
        has been called. Reimplement this function in a subclass of **QMdiArea**
        to initialize the new **viewport** before it is used.

        **See also** **setViewport** ().
        """
        ...

    def activatePreviousSubWindow(self) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#activatePreviousSubWindow

        **[slot] void QMdiArea::activatePreviousSubWindow()**

        Gives the keyboard focus to another window in the list of child windows.
        The window activated will be the previous one determined by the current
        **activation order** .

        **See also** **activateNextSubWindow** () and **QMdiArea::WindowOrder**
        .
        """
        ...

    def activateNextSubWindow(self) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#activateNextSubWindow

        **[slot] void QMdiArea::activateNextSubWindow()**

        Gives the keyboard focus to another window in the list of child windows.
        The window activated will be the next one determined by the current
        **activation order** .

        **See also** **activatePreviousSubWindow** () and
        **QMdiArea::WindowOrder** .
        """
        ...

    def closeAllSubWindows(self) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#closeAllSubWindows

        **[slot] void QMdiArea::closeAllSubWindows()**

        Closes all subwindows by sending a **QCloseEvent**  to each window. You
        may receive **subWindowActivated** () signals from subwindows before
        they are closed (if the MDI area activates the subwindow when another is
        closing).

        Subwindows that ignore the close event will remain open.

        **See also** **closeActiveSubWindow** ().
        """
        ...

    def closeActiveSubWindow(self) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#closeActiveSubWindow

        **[slot] void QMdiArea::closeActiveSubWindow()**

        Closes the active subwindow.

        **See also** **closeAllSubWindows** ().
        """
        ...

    def cascadeSubWindows(self) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#cascadeSubWindows

        **[slot] void QMdiArea::cascadeSubWindows()**

        Arranges all the child windows in a cascade pattern.

        **See also** **tileSubWindows** ().
        """
        ...

    def tileSubWindows(self) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#tileSubWindows

        **[slot] void QMdiArea::tileSubWindows()**

        Arranges all child windows in a tile pattern.

        **See also** **cascadeSubWindows** ().
        """
        ...

    def setActiveSubWindow(self, window: "QMdiSubWindow") -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#setActiveSubWindow

        **[slot] void QMdiArea::setActiveSubWindow(QMdiSubWindow * window )**

        Activates the subwindow **window**. If **window** is `nullptr`, any
        current active window is deactivated.

        **See also** **activeSubWindow** ().
        """
        ...

    def testOption(self, opton: "QMdiArea.AreaOption") -> bool:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#testOption

        **bool QMdiArea::testOption(QMdiArea::AreaOption option ) const**

        Returns `true` if **option** is enabled; otherwise returns `false`.

        **See also** **AreaOption**  and **setOption** ().
        """
        ...

    def setOption(self, option: "QMdiArea.AreaOption", on: bool = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#setOption

        **void QMdiArea::setOption(QMdiArea::AreaOption option , bool on =
        true)**

        If **on** is true, **option** is enabled on the MDI area; otherwise it
        is disabled. See **AreaOption**  for the effect of each option.

        **See also** **AreaOption**  and **testOption** ().
        """
        ...

    def setBackground(
        self,
        background: typing.Union[
            QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#background-prop

        **background : QBrush**

        This property holds the background brush for the workspace

        This property sets the background brush for the workspace area itself.
        By default, it is a gray color, but can be any brush (e.g., colors,
        gradients or pixmaps).

        **Access functions:**

        QBrush **background** () const
        void **setBackground** (const QBrush &
        **background** )
        """
        ...

    def background(self) -> QtGui.QBrush:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#background-prop

        **background : QBrush**

        This property holds the background brush for the workspace

        This property sets the background brush for the workspace area itself.
        By default, it is a gray color, but can be any brush (e.g., colors,
        gradients or pixmaps).

        **Access functions:**

        QBrush **background** () const
        void **setBackground** (const QBrush &
        **background** )
        """
        ...

    def removeSubWindow(self, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#removeSubWindow

        **void QMdiArea::removeSubWindow(QWidget * widget )**

        Removes **widget** from the MDI area. The **widget** must be either a
        **QMdiSubWindow**  or a widget that is the internal widget of a
        subwindow. Note **widget** is never actually deleted by **QMdiArea** .
        If a **QMdiSubWindow**  is passed in, its parent is set to `nullptr` and
        it is removed; but if an internal widget is passed in, the child widget
        is set to `nullptr` and the **QMdiSubWindow**  is **not** removed.

        **See also** **addSubWindow** ().
        """
        ...

    def currentSubWindow(self) -> "QMdiSubWindow":
        """
        https://doc.qt.io/qt-5/qmdiarea.html#currentSubWindow

        **QMdiSubWindow *QMdiArea::currentSubWindow() const**

        Returns a pointer to the current subwindow, or `nullptr` if there is no
        current subwindow.

        This function will return the same as **activeSubWindow** () if the
        **QApplication**  containing **QMdiArea**  is active.

        **See also** **activeSubWindow** () and **QApplication::activeWindow**
        ().
        """
        ...

    def subWindowList(
        self, order: "QMdiArea.WindowOrder" = ...
    ) -> typing.List["QMdiSubWindow"]:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#subWindowList

        **QList<QMdiSubWindow *> QMdiArea::subWindowList(QMdiArea::WindowOrder
        order = CreationOrder) const**

        Returns a list of all subwindows in the MDI area. If **order** is
        **CreationOrder**  (the default), the windows are sorted in the order in
        which they were inserted into the workspace. If **order** is
        **StackingOrder** , the windows are listed in their stacking order, with
        the topmost window as the last item in the list. If **order** is
        **ActivationHistoryOrder** , the windows are listed according to their
        recent activation history.

        **See also** **WindowOrder** .
        """
        ...

    def addSubWindow(
        self,
        widget: QWidget,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> "QMdiSubWindow":
        """
        https://doc.qt.io/qt-5/qmdiarea.html#addSubWindow

        **QMdiSubWindow *QMdiArea::addSubWindow(QWidget * widget ,
        Qt::WindowFlags windowFlags = Qt::WindowFlags())**

        Adds **widget** as a new subwindow to the MDI area. If **windowFlags**
        are non-zero, they will override the flags set on the widget.

        The **widget** can be either a **QMdiSubWindow**  or another **QWidget**
        (in which case the MDI area will create a subwindow and set the
        **widget** as the internal widget).

        **Note:** Once the subwindow has been added, its parent will be the
        **viewport widget** of the **QMdiArea** .

        **QMdiArea**  mdiArea;
                **QMdiSubWindow**  *subWindow1 = new
        **QMdiSubWindow** ;
                subWindow1->setWidget(internalWidget1);
        subWindow1->setAttribute(Qt::WA_DeleteOnClose);
        mdiArea.addSubWindow(subWindow1);

                **QMdiSubWindow**
        *subWindow2 =
                    mdiArea.addSubWindow(internalWidget2);

        When you create your own subwindow, you must set the
        **Qt::WA_DeleteOnClose**  widget attribute if you want the window to be
        deleted when closed in the MDI area. If not, the window will be hidden
        and the MDI area will not activate the next subwindow.

        Returns the **QMdiSubWindow**  that is added to the MDI area.

        **See also** **removeSubWindow** ().
        """
        ...

    def activeSubWindow(self) -> "QMdiSubWindow":
        """
        https://doc.qt.io/qt-5/qmdiarea.html#activeSubWindow

        **QMdiSubWindow *QMdiArea::activeSubWindow() const**

        Returns a pointer to the current active subwindow. If no window is
        currently active, `nullptr` is returned.

        Subwindows are treated as top-level windows with respect to window
        state, i.e., if a widget outside the MDI area is the active window, no
        subwindow will be active. Note that if a widget in the window in which
        the MDI area lives gains focus, the window will be activated.

        **See also** **setActiveSubWindow** () and **Qt::WindowState** .
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#minimumSizeHint

        **[override virtual] QSize QMdiArea::minimumSizeHint() const**

        Reimplements: **QAbstractScrollArea::minimumSizeHint** () const.
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#sizeHint

        **[override virtual] QSize QMdiArea::sizeHint() const**

        Reimplements: **QAbstractScrollArea::sizeHint** () const.
        """
        ...

    @property
    def subWindowActivated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmdiarea.html#subWindowActivated

        **[signal] void QMdiArea::subWindowActivated(QMdiSubWindow * window )**

        **QMdiArea**  emits this signal after **window** has been activated.
        When **window** is `nullptr`, **QMdiArea**  has just deactivated its
        last active window, and there are no active windows on the workspace.

        **See also** **QMdiArea::activeSubWindow** ().
        """
        ...
