"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore


class QKeyEventTransition(QtCore.QEventTransition):
    """
    https://doc.qt.io/qt-5/qkeyeventtransition.html

    **Detailed Description**

    QKeyEventTransition is part of **The State Machine Framework** .

    **See also** **QState::addTransition** ().
    """

    @typing.overload
    def __init__(self, sourceState: typing.Optional[QtCore.QState] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qkeyeventtransition.html#QKeyEventTransition

        **QKeyEventTransition::QKeyEventTransition(QState * sourceState =
        nullptr)**

        Constructs a new key event transition with the given **sourceState**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        object: QtCore.QObject,
        type: QtCore.QEvent.Type,
        key: int,
        sourceState: typing.Optional[QtCore.QState] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qkeyeventtransition.html#QKeyEventTransition-1

        **QKeyEventTransition::QKeyEventTransition(QObject * object ,
        QEvent::Type type , int key , QState * sourceState = nullptr)**

        Constructs a new key event transition for events of the given **type**
        for the given **object** , with the given **key** and **sourceState**.
        """
        ...

    def eventTest(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qkeyeventtransition.html#eventTest

        **[override virtual protected] bool
        QKeyEventTransition::eventTest(QEvent * event )**

        Reimplements: **QEventTransition::eventTest** (QEvent *event).
        """
        ...

    def onTransition(self, event: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qkeyeventtransition.html#onTransition

        **[override virtual protected] void
        QKeyEventTransition::onTransition(QEvent * event )**

        Reimplements: **QEventTransition::onTransition** (QEvent *event).
        """
        ...

    def setModifierMask(
        self,
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qkeyeventtransition.html#setModifierMask

        **void QKeyEventTransition::setModifierMask(Qt::KeyboardModifiers
        modifierMask )**

        Sets the keyboard modifier mask that this key event transition will
        check for to **modifierMask**.

        **Note:** Setter function for property **modifierMask** .

        **See also** **modifierMask** ().
        """
        ...

    def modifierMask(self) -> QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-5/qkeyeventtransition.html#modifierMask

        **Qt::KeyboardModifiers QKeyEventTransition::modifierMask() const**

        Returns the keyboard modifier mask that this key event transition checks
        for.

        **Note:** Getter function for property modifierMask.

        **See also** **setModifierMask** ().
        """
        ...

    def setKey(self, key: int) -> None:
        """
        https://doc.qt.io/qt-5/qkeyeventtransition.html#setKey

        **void QKeyEventTransition::setKey(int key )**

        Sets the **key** that this key event transition will check for.

        **Note:** Setter function for property **key** .

        **See also** **key** ().
        """
        ...

    def key(self) -> int:
        """
        https://doc.qt.io/qt-5/qkeyeventtransition.html#key

        **int QKeyEventTransition::key() const**

        Returns the key that this key event transition checks for.

        **Note:** Getter function for property key.

        **See also** **setKey** ().
        """
        ...
