"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QHeaderView(QAbstractItemView):
    """
    https://doc.qt.io/qt-5/qheaderview.html

    **Detailed Description**

    A QHeaderView displays the headers used in item views such as the
    **QTableView**  and **QTreeView**  classes. It takes the place of Qt3's
    `QHeader` class previously used for the same purpose, but uses the Qt's
    model/view architecture for consistency with the item view classes.

    The QHeaderView class is one of the **Model/View Classes**  and is part of
    Qt's **model/view framework** .

    The header gets the data for each section from the model using the
    **QAbstractItemModel::headerData** () function. You can set the data by
    using **QAbstractItemModel::setHeaderData** ().

    Each header has an **orientation** () and a number of sections, given by the
    **count** () function. A section refers to a part of the header - either a
    row or a column, depending on the orientation.

    Sections can be moved and resized using **moveSection** () and
    **resizeSection** (); they can also be hidden and shown with **hideSection**
    () and **showSection** ().

    Each section of a header is described by a section ID, specified by its
    section(), and can be located at a particular **visualIndex** () in the
    header. A section can have a sort indicator set with **setSortIndicator**
    (); this indicates whether the items in the associated item view will be
    sorted in the order given by the section.

    For a horizontal header the section is equivalent to a column in the model,
    and for a vertical header the section is equivalent to a row in the model.

    **Moving Header Sections**

    A header can be fixed in place, or made movable with **setSectionsMovable**
    (). It can be made clickable with **setSectionsClickable** (), and has
    resizing behavior in accordance with **setSectionResizeMode** ().

    **Note:** Double-clicking on a header to resize a section only applies for
    visible rows.

    A header will emit **sectionMoved** () if the user moves a section,
    **sectionResized** () if the user resizes a section, and **sectionClicked**
    () as well as **sectionHandleDoubleClicked** () in response to mouse clicks.
    A header will also emit **sectionCountChanged** ().

    You can identify a section using the **logicalIndex** () and
    **logicalIndexAt** () functions, or by its index position, using the
    **visualIndex** () and **visualIndexAt** () functions. The visual index will
    change if a section is moved, but the logical index will not change.

    **Appearance**

    **QTableWidget**  and **QTableView**  create default headers. If you want
    the headers to be visible, you can use **setVisible()** .

    Not all **ItemDataRole** s will have an effect on a QHeaderView. If you need
    to draw other roles, you can subclass QHeaderView and reimplement
    **paintEvent()** . QHeaderView respects the following item data roles,
    unless they are in conflict with the style (which can happen for styles that
    follow the desktop theme):

    **TextAlignmentRole** , **DisplayRole** , **FontRole** , **DecorationRole**
    , **ForegroundRole** , and **BackgroundRole** .

    **Note:** Each header renders the data for each section itself, and does not
    rely on a delegate. As a result, calling a header's **setItemDelegate** ()
    function will have no effect.

    **See also** **Model/View Programming** , **QListView** , **QTableView** ,
    and **QTreeView** .
    """

    class ResizeMode(int):
        Interactive: QHeaderView = ...
        Fixed: QHeaderView = ...
        Stretch: QHeaderView = ...
        ResizeToContents: QHeaderView = ...
        Custom: QHeaderView = ...

    def __init__(
        self, orientation: QtCore.Qt.Orientation, parent: typing.Optional[QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#QHeaderView

        **QHeaderView::QHeaderView(Qt::Orientation orientation , QWidget *
        parent = nullptr)**

        Creates a new generic header with the given **orientation** and
        **parent**.
        """
        ...

    def isFirstSectionMovable(self) -> bool:
        ...

    def setFirstSectionMovable(self, movable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#firstSectionMovable-prop

        **firstSectionMovable : bool**

        This property holds whether the first column can be moved by the user

        This property controls whether the first column can be moved by the
        user. In a **QTreeView** , the first column holds the tree structure and
        is therefore non-movable by default, even after **setSectionsMovable**
        (true).

        It can be made movable again, for instance in the case of flat lists
        without a tree structure, by calling this method. In such a scenario, it
        is recommended to call **QTreeView::setRootIsDecorated** (false) as
        well.

        Setting it to true has no effect unless **setSectionsMovable** (true) is
        called as well.

        This property was introduced in Qt 5.11.

        **Access functions:**

        bool **isFirstSectionMovable** () const
        void
        **setFirstSectionMovable** (bool **movable** )

        **See also** **setSectionsMovable** ().
        """
        ...

    def resetDefaultSectionSize(self) -> None:
        ...

    def setMaximumSectionSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#maximumSectionSize-prop

        **maximumSectionSize : int**

        This property holds the maximum size of the header sections.

        The maximum section size is the largest section size allowed. The
        default value for this property is 1048575, which is also the largest
        possible size for a section. Setting maximum to -1 will reset the value
        to the largest section size.

        With exception of stretch this property is honored by all **resize
        modes**

        This property was introduced in Qt 5.2.

        **Access functions:**

        int **maximumSectionSize** () const
        void **setMaximumSectionSize**
        (int **size** )

        **See also** **setSectionResizeMode** () and **defaultSectionSize** .
        """
        ...

    def maximumSectionSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#maximumSectionSize-prop

        **maximumSectionSize : int**

        This property holds the maximum size of the header sections.

        The maximum section size is the largest section size allowed. The
        default value for this property is 1048575, which is also the largest
        possible size for a section. Setting maximum to -1 will reset the value
        to the largest section size.

        With exception of stretch this property is honored by all **resize
        modes**

        This property was introduced in Qt 5.2.

        **Access functions:**

        int **maximumSectionSize** () const
        void **setMaximumSectionSize**
        (int **size** )

        **See also** **setSectionResizeMode** () and **defaultSectionSize** .
        """
        ...

    def resizeContentsPrecision(self) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#resizeContentsPrecision

        **int QHeaderView::resizeContentsPrecision() const**

        Returns how precise **QHeaderView**  will calculate on
        **ResizeToContents** .

        This function was introduced in Qt 5.2.

        **See also** **setResizeContentsPrecision** () and
        **setSectionResizeMode** ().
        """
        ...

    def setResizeContentsPrecision(self, precision: int) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#setResizeContentsPrecision

        **void QHeaderView::setResizeContentsPrecision(int precision )**

        Sets how precise **QHeaderView**  should calculate the size when
        **ResizeToContents**  is used. A low value will provide a less accurate
        but fast auto resize while a higher value will provide a more accurate
        resize that however can be slow.

        The number **precision** specifies how many sections that should be
        consider when calculating the preferred size.

        The default value is 1000 meaning that a horizontal column with auto-
        resize will look at maximum 1000 rows on calculating when doing an auto
        resize.

        Special value 0 means that it will look at only the visible area.
        Special value -1 will imply looking at all elements.

        This value is used in **QTableView::sizeHintForColumn** (),
        **QTableView::sizeHintForRow** () and **QTreeView::sizeHintForColumn**
        (). Reimplementing these functions can make this function not having an
        effect.

        This function was introduced in Qt 5.2.

        **See also** **resizeContentsPrecision** (), **setSectionResizeMode**
        (), **resizeSections** (), **QTableView::sizeHintForColumn** (),
        **QTableView::sizeHintForRow** (), and **QTreeView::sizeHintForColumn**
        ().
        """
        ...

    def setVisible(self, v: bool) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#setVisible

        **[override virtual] void QHeaderView::setVisible(bool v )**

        Reimplements an access function for property: **QWidget::visible** .
        """
        ...

    @typing.overload
    def setSectionResizeMode(
        self, logicalIndex: int, mode: "QHeaderView.ResizeMode"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#setSectionResizeMode

        **void QHeaderView::setSectionResizeMode(QHeaderView::ResizeMode mode
        )**

        Sets the constraints on how the header can be resized to those described
        by the given **mode**.

        This function was introduced in Qt 5.0.

        **See also** **sectionResizeMode** (), **length** (), and
        **sectionResized** ().
        """
        ...

    @typing.overload
    def setSectionResizeMode(self, mode: "QHeaderView.ResizeMode") -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#setSectionResizeMode-1

        **void QHeaderView::setSectionResizeMode(int logicalIndex ,
        QHeaderView::ResizeMode mode )**

        Sets the constraints on how the section specified by **logicalIndex** in
        the header can be resized to those described by the given **mode**. The
        logical index should exist at the time this function is called.

        **Note:** This setting will be ignored for the last section if the
        **stretchLastSection**  property is set to true. This is the default for
        the horizontal headers provided by **QTreeView** .

        This function was introduced in Qt 5.0.

        **See also** **setStretchLastSection** () and
        **resizeContentsPrecision** ().
        """
        ...

    def sectionResizeMode(self, logicalIndex: int) -> "QHeaderView.ResizeMode":
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionResizeMode

        **QHeaderView::ResizeMode QHeaderView::sectionResizeMode(int
        logicalIndex ) const**

        Returns the resize mode that applies to the section specified by the
        given **logicalIndex**.

        This function was introduced in Qt 5.0.

        **See also** **setSectionResizeMode** ().
        """
        ...

    def sectionsClickable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionsClickable

        **bool QHeaderView::sectionsClickable() const**

        Returns `true` if the header is clickable; otherwise returns `false`. A
        clickable header could be set up to allow the user to change the
        representation of the data in the view related to the header.

        This function was introduced in Qt 5.0.

        **See also** **setSectionsClickable** ().
        """
        ...

    def setSectionsClickable(self, clickable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#setSectionsClickable

        **void QHeaderView::setSectionsClickable(bool clickable )**

        If **clickable** is true, the header will respond to single clicks.

        This function was introduced in Qt 5.0.

        **See also** **sectionsClickable** (), **sectionClicked** (),
        **sectionPressed** (), and **setSortIndicatorShown** ().
        """
        ...

    def sectionsMovable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionsMovable

        **bool QHeaderView::sectionsMovable() const**

        Returns `true` if the header can be moved by the user; otherwise returns
        false.

        By default, sections are movable in **QTreeView**  (except for the first
        one), and not movable in **QTableView** .

        This function was introduced in Qt 5.0.

        **See also** **setSectionsMovable** ().
        """
        ...

    def setSectionsMovable(self, movable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#setSectionsMovable

        **void QHeaderView::setSectionsMovable(bool movable )**

        If **movable** is true, the header sections may be moved by the user;
        otherwise they are fixed in place.

        When used in combination with **QTreeView** , the first column is not
        movable (since it contains the tree structure), by default. You can make
        it movable with **setFirstSectionMovable** (true).

        This function was introduced in Qt 5.0.

        **See also** **sectionsMovable** (), **sectionMoved** (), and
        **setFirstSectionMovable** ().
        """
        ...

    def initStyleOption(self, option: "QStyleOptionHeader") -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#initStyleOption

        **[protected] void QHeaderView::initStyleOption(QStyleOptionHeader *
        option ) const**

        Initialize **option** with the values from this **QHeaderView** . This
        method is useful for subclasses when they need a **QStyleOptionHeader**
        , but do not want to fill in all the information themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def setOffsetToLastSection(self) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#setOffsetToLastSection

        **[slot] void QHeaderView::setOffsetToLastSection()**

        Sets the offset to make the last section visible.

        This function was introduced in Qt 4.2.

        **See also** **setOffset** (), **sectionPosition** (), and
        **setOffsetToSectionPosition** ().
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#reset

        **[override virtual] void QHeaderView::reset()**

        Reimplements: **QAbstractItemView::reset** ().
        """
        ...

    def restoreState(
        self, state: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qheaderview.html#restoreState

        **bool QHeaderView::restoreState(const QByteArray & state )**

        Restores the **state** of this header view. This function returns `true`
        if the state was restored; otherwise returns false.

        This function was introduced in Qt 4.3.

        **See also** **saveState** ().
        """
        ...

    def saveState(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qheaderview.html#saveState

        **QByteArray QHeaderView::saveState() const**

        Saves the current state of this header view.

        To restore the saved state, pass the return value to **restoreState**
        ().

        This function was introduced in Qt 4.3.

        **See also** **restoreState** ().
        """
        ...

    def setMinimumSectionSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#minimumSectionSize-prop

        **minimumSectionSize : int**

        This property holds the minimum size of the header sections.

        The minimum section size is the smallest section size allowed. If the
        minimum section size is set to -1, **QHeaderView**  will use the maximum
        of the **global strut**  or the **font metrics**  size.

        This property is honored by all **resize modes** .

        This property was introduced in Qt 4.2.

        **Access functions:**

        int **minimumSectionSize** () const
        void **setMinimumSectionSize**
        (int **size** )

        **See also** **setSectionResizeMode** () and **defaultSectionSize** .
        """
        ...

    def minimumSectionSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#minimumSectionSize-prop

        **minimumSectionSize : int**

        This property holds the minimum size of the header sections.

        The minimum section size is the smallest section size allowed. If the
        minimum section size is set to -1, **QHeaderView**  will use the maximum
        of the **global strut**  or the **font metrics**  size.

        This property is honored by all **resize modes** .

        This property was introduced in Qt 4.2.

        **Access functions:**

        int **minimumSectionSize** () const
        void **setMinimumSectionSize**
        (int **size** )

        **See also** **setSectionResizeMode** () and **defaultSectionSize** .
        """
        ...

    def setCascadingSectionResizes(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#cascadingSectionResizes-prop

        **cascadingSectionResizes : bool**

        This property holds whether interactive resizing will be cascaded to the
        following sections once the section being resized by the user has
        reached its minimum size

        This property only affects sections that have **Interactive**  as their
        resize mode.

        The default value is false.

        This property was introduced in Qt 4.2.

        **Access functions:**

        bool **cascadingSectionResizes** () const
        void
        **setCascadingSectionResizes** (bool **enable** )

        **See also** **setSectionResizeMode** ().
        """
        ...

    def cascadingSectionResizes(self) -> bool:
        """
        https://doc.qt.io/qt-5/qheaderview.html#cascadingSectionResizes-prop

        **cascadingSectionResizes : bool**

        This property holds whether interactive resizing will be cascaded to the
        following sections once the section being resized by the user has
        reached its minimum size

        This property only affects sections that have **Interactive**  as their
        resize mode.

        The default value is false.

        This property was introduced in Qt 4.2.

        **Access functions:**

        bool **cascadingSectionResizes** () const
        void
        **setCascadingSectionResizes** (bool **enable** )

        **See also** **setSectionResizeMode** ().
        """
        ...

    def swapSections(self, first: int, second: int) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#swapSections

        **void QHeaderView::swapSections(int first , int second )**

        Swaps the section at visual index **first** with the section at visual
        index **second**.

        This function was introduced in Qt 4.2.

        **See also** **moveSection** ().
        """
        ...

    def sectionsHidden(self) -> bool:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionsHidden

        **bool QHeaderView::sectionsHidden() const**

        Returns `true` if sections in the header has been hidden; otherwise
        returns false;

        This function was introduced in Qt 4.1.

        **See also** **setSectionHidden** ().
        """
        ...

    def setDefaultAlignment(
        self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#defaultAlignment-prop

        **defaultAlignment : Qt::Alignment**

        This property holds the default alignment of the text in each header
        section

        This property was introduced in Qt 4.1.

        **Access functions:**

        Qt::Alignment **defaultAlignment** () const
        void
        **setDefaultAlignment** (Qt::Alignment **alignment** )
        """
        ...

    def defaultAlignment(self) -> QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-5/qheaderview.html#defaultAlignment-prop

        **defaultAlignment : Qt::Alignment**

        This property holds the default alignment of the text in each header
        section

        This property was introduced in Qt 4.1.

        **Access functions:**

        Qt::Alignment **defaultAlignment** () const
        void
        **setDefaultAlignment** (Qt::Alignment **alignment** )
        """
        ...

    def setDefaultSectionSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#defaultSectionSize-prop

        **defaultSectionSize : int**

        This property holds the default size of the header sections before
        resizing.

        This property only affects sections that have **Interactive**  or
        **Fixed**  as their resize mode.

        By default, the value of this property is style dependent. Thus, when
        the style changes, this property updates from it. Calling
        setDefaultSectionSize() stops the updates, calling
        resetDefaultSectionSize() will restore default behavior.

        **Access functions:**

        int **defaultSectionSize** () const
        void **setDefaultSectionSize**
        (int **size** )
        void **resetDefaultSectionSize** ()

        **See also** **setSectionResizeMode** () and **minimumSectionSize** .
        """
        ...

    def defaultSectionSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#defaultSectionSize-prop

        **defaultSectionSize : int**

        This property holds the default size of the header sections before
        resizing.

        This property only affects sections that have **Interactive**  or
        **Fixed**  as their resize mode.

        By default, the value of this property is style dependent. Thus, when
        the style changes, this property updates from it. Calling
        setDefaultSectionSize() stops the updates, calling
        resetDefaultSectionSize() will restore default behavior.

        **Access functions:**

        int **defaultSectionSize** () const
        void **setDefaultSectionSize**
        (int **size** )
        void **resetDefaultSectionSize** ()

        **See also** **setSectionResizeMode** () and **minimumSectionSize** .
        """
        ...

    def hiddenSectionCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#hiddenSectionCount

        **int QHeaderView::hiddenSectionCount() const**

        Returns the number of sections in the header that has been hidden.

        This function was introduced in Qt 4.1.

        **See also** **setSectionHidden** () and **isSectionHidden** ().
        """
        ...

    def showSection(self, alogicalIndex: int) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#showSection

        **void QHeaderView::showSection(int logicalIndex )**

        Shows the section specified by **logicalIndex**.

        **See also** **hideSection** (), **isSectionHidden** (),
        **hiddenSectionCount** (), and **setSectionHidden** ().
        """
        ...

    def hideSection(self, alogicalIndex: int) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#hideSection

        **void QHeaderView::hideSection(int logicalIndex )**

        Hides the section specified by **logicalIndex**.

        **See also** **showSection** (), **isSectionHidden** (),
        **hiddenSectionCount** (), and **setSectionHidden** ().
        """
        ...

    def visualRegionForSelection(
        self, selection: QtCore.QItemSelection
    ) -> QtGui.QRegion:
        ...

    def setSelection(
        self,
        rect: QtCore.QRect,
        flags: typing.Union[
            QtCore.QItemSelectionModel.SelectionFlags,
            QtCore.QItemSelectionModel.SelectionFlag,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#setSelection

        **[override virtual protected] void QHeaderView::setSelection(const
        QRect & rect , QItemSelectionModel::SelectionFlags flags )**

        Reimplements: **QAbstractItemView::setSelection** (const QRect &rect,
        QItemSelectionModel::SelectionFlags flags).

        Selects the items in the given **rect** according to the specified
        **flags**.

        The base class implementation does nothing.
        """
        ...

    def moveCursor(
        self,
        a0: QAbstractItemView.CursorAction,
        a1: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier],
    ) -> QtCore.QModelIndex:
        ...

    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool:
        ...

    def indexAt(self, p: QtCore.QPoint) -> QtCore.QModelIndex:
        ...

    def scrollTo(
        self, index: QtCore.QModelIndex, hint: QAbstractItemView.ScrollHint
    ) -> None:
        ...

    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect:
        ...

    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None:
        ...

    def dataChanged(
        self,
        topLeft: QtCore.QModelIndex,
        bottomRight: QtCore.QModelIndex,
        roles: typing.Iterable[int] = ...,
    ) -> None:
        ...

    def scrollContentsBy(self, dx: int, dy: int) -> None:
        ...

    def updateGeometries(self) -> None:
        ...

    def verticalOffset(self) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#verticalOffset

        **[override virtual protected] int QHeaderView::verticalOffset() const**

        Reimplements: **QAbstractItemView::verticalOffset** () const.

        Returns the vertical offset of the header. This is 0 for horizontal
        headers.

        **See also** **offset** ().
        """
        ...

    def horizontalOffset(self) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#horizontalOffset

        **[override virtual protected] int QHeaderView::horizontalOffset()
        const**

        Reimplements: **QAbstractItemView::horizontalOffset** () const.

        Returns the horizontal offset of the header. This is 0 for vertical
        headers.

        **See also** **offset** ().
        """
        ...

    def sectionSizeFromContents(self, logicalIndex: int) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionSizeFromContents

        **[virtual protected] QSize QHeaderView::sectionSizeFromContents(int
        logicalIndex ) const**

        Returns the size of the contents of the section specified by the given
        **logicalIndex**.

        **See also** **defaultSectionSize** ().
        """
        ...

    def paintSection(
        self, painter: QtGui.QPainter, rect: QtCore.QRect, logicalIndex: int
    ) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#paintSection

        **[virtual protected] void QHeaderView::paintSection(QPainter * painter
        , const QRect & rect , int logicalIndex ) const**

        Paints the section specified by the given **logicalIndex** , using the
        given **painter** and **rect**.

        Normally, you do not have to call this function.
        """
        ...

    def mouseDoubleClickEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QHeaderView::mouseDoubleClickEvent(QMouseEvent * e )**

        Reimplements: **QAbstractItemView::mouseDoubleClickEvent** (QMouseEvent
        *event).
        """
        ...

    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#mouseReleaseEvent

        **[override virtual protected] void
        QHeaderView::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QAbstractItemView::mouseReleaseEvent** (QMouseEvent
        *event).
        """
        ...

    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#mouseMoveEvent

        **[override virtual protected] void
        QHeaderView::mouseMoveEvent(QMouseEvent * e )**

        Reimplements: **QAbstractItemView::mouseMoveEvent** (QMouseEvent
        *event).
        """
        ...

    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#mousePressEvent

        **[override virtual protected] void
        QHeaderView::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QAbstractItemView::mousePressEvent** (QMouseEvent
        *event).
        """
        ...

    def paintEvent(self, e: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#paintEvent

        **[override virtual protected] void QHeaderView::paintEvent(QPaintEvent
        * e )**

        Reimplements: **QAbstractScrollArea::paintEvent** (QPaintEvent *event).
        """
        ...

    def viewportEvent(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qheaderview.html#viewportEvent

        **[override virtual protected] bool QHeaderView::viewportEvent(QEvent *
        e )**

        Reimplements: **QAbstractItemView::viewportEvent** (QEvent *event).
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qheaderview.html#event

        **[override virtual protected] bool QHeaderView::event(QEvent * e )**

        Reimplements: **QAbstractItemView::event** (QEvent *event).
        """
        ...

    def currentChanged(
        self, current: QtCore.QModelIndex, old: QtCore.QModelIndex
    ) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#currentChanged

        **[override virtual protected] void QHeaderView::currentChanged(const
        QModelIndex & current , const QModelIndex & old )**

        Reimplements: **QAbstractItemView::currentChanged** (const QModelIndex
        &current, const QModelIndex &previous).
        """
        ...

    @typing.overload
    def initializeSections(self) -> None:
        ...

    @typing.overload
    def initializeSections(self, start: int, end: int) -> None:
        ...

    def initialize(self) -> None:
        ...

    def sectionsAboutToBeRemoved(
        self, parent: QtCore.QModelIndex, logicalFirst: int, logicalLast: int
    ) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionsAboutToBeRemoved

        **[protected slot] void QHeaderView::sectionsAboutToBeRemoved(const
        QModelIndex & parent , int logicalFirst , int logicalLast )**

        This slot is called when sections are removed from the **parent**.
        **logicalFirst** and **logicalLast** signify where the sections were
        removed.

        If only one section is removed, **logicalFirst** and **logicalLast**
        will be the same.
        """
        ...

    def sectionsInserted(
        self, parent: QtCore.QModelIndex, logicalFirst: int, logicalLast: int
    ) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionsInserted

        **[protected slot] void QHeaderView::sectionsInserted(const QModelIndex
        & parent , int logicalFirst , int logicalLast )**

        This slot is called when sections are inserted into the **parent**.
        **logicalFirst** and **logicalLast** indices signify where the new
        sections were inserted.

        If only one section is inserted, **logicalFirst** and **logicalLast**
        will be the same.
        """
        ...

    @typing.overload
    def resizeSections(self) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#resizeSections

        **void QHeaderView::resizeSections(QHeaderView::ResizeMode mode )**

        Resizes the sections according to the given **mode** , ignoring the
        current resize mode.

        **See also** **sectionResized** ().
        """
        ...

    @typing.overload
    def resizeSections(self, mode: "QHeaderView.ResizeMode") -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#resizeSections-1

        **[protected slot] void QHeaderView::resizeSections()**

        Resizes the sections according to their size hints. Normally, you do not
        have to call this function.
        """
        ...

    def updateSection(self, logicalIndex: int) -> None:
        ...

    def setOffsetToSectionPosition(self, visualIndex: int) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#setOffsetToSectionPosition

        **[slot] void QHeaderView::setOffsetToSectionPosition(int
        visualSectionNumber )**

        Sets the offset to the start of the section at the given
        **visualSectionNumber**. **visualSectionNumber** is the actual visible
        section when hiddenSections are not considered. That is not always the
        same as **visualIndex** ().

        This function was introduced in Qt 4.2.

        **See also** **setOffset** () and **sectionPosition** ().
        """
        ...

    def headerDataChanged(
        self, orientation: QtCore.Qt.Orientation, logicalFirst: int, logicalLast: int
    ) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#headerDataChanged

        **[slot] void QHeaderView::headerDataChanged(Qt::Orientation orientation
        , int logicalFirst , int logicalLast )**

        Updates the changed header sections with the given **orientation** ,
        from **logicalFirst** to **logicalLast** inclusive.
        """
        ...

    def setOffset(self, offset: int) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#setOffset

        **[slot] void QHeaderView::setOffset(int offset )**

        Sets the header's offset to **offset**.

        **See also** **offset** () and **length** ().
        """
        ...

    def sectionsMoved(self) -> bool:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionsMoved

        **bool QHeaderView::sectionsMoved() const**

        Returns `true` if sections in the header has been moved; otherwise
        returns false;

        **See also** **moveSection** ().
        """
        ...

    def setStretchLastSection(self, stretch: bool) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#stretchLastSection-prop

        **stretchLastSection : bool**

        This property holds whether the last visible section in the header takes
        up all the available space

        The default value is false.

        **Note:** The horizontal headers provided by **QTreeView**  are
        configured with this property set to true, ensuring that the view does
        not waste any of the space assigned to it for its header. If this value
        is set to true, this property will override the resize mode set on the
        last section in the header.

        **Access functions:**

        bool **stretchLastSection** () const
        void **setStretchLastSection**
        (bool **stretch** )

        **See also** **setSectionResizeMode** ().

        **Member Function Documentation**
        """
        ...

    def stretchLastSection(self) -> bool:
        """
        https://doc.qt.io/qt-5/qheaderview.html#stretchLastSection-prop

        **stretchLastSection : bool**

        This property holds whether the last visible section in the header takes
        up all the available space

        The default value is false.

        **Note:** The horizontal headers provided by **QTreeView**  are
        configured with this property set to true, ensuring that the view does
        not waste any of the space assigned to it for its header. If this value
        is set to true, this property will override the resize mode set on the
        last section in the header.

        **Access functions:**

        bool **stretchLastSection** () const
        void **setStretchLastSection**
        (bool **stretch** )

        **See also** **setSectionResizeMode** ().

        **Member Function Documentation**
        """
        ...

    def sortIndicatorOrder(self) -> QtCore.Qt.SortOrder:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sortIndicatorOrder

        **Qt::SortOrder QHeaderView::sortIndicatorOrder() const**

        Returns the order for the sort indicator. If no section has a sort
        indicator the return value of this function is undefined.

        **See also** **setSortIndicator** () and **sortIndicatorSection** ().
        """
        ...

    def sortIndicatorSection(self) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sortIndicatorSection

        **int QHeaderView::sortIndicatorSection() const**

        Returns the logical index of the section that has a sort indicator. By
        default this is section 0.

        **See also** **setSortIndicator** (), **sortIndicatorOrder** (), and
        **setSortIndicatorShown** ().
        """
        ...

    def setSortIndicator(self, logicalIndex: int, order: QtCore.Qt.SortOrder) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#setSortIndicator

        **void QHeaderView::setSortIndicator(int logicalIndex , Qt::SortOrder
        order )**

        Sets the sort indicator for the section specified by the given
        **logicalIndex** in the direction specified by **order** , and removes
        the sort indicator from any other section that was showing it.

        **logicalIndex** may be -1, in which case no sort indicator will be
        shown and the model will return to its natural, unsorted order. Note
        that not all models support this and may even crash in this case.

        **See also** **sortIndicatorSection** () and **sortIndicatorOrder** ().
        """
        ...

    def isSortIndicatorShown(self) -> bool:
        ...

    def setSortIndicatorShown(self, show: bool) -> None:
        ...

    def stretchSectionCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#stretchSectionCount

        **int QHeaderView::stretchSectionCount() const**

        Returns the number of sections that are set to resize mode stretch. In
        views, this can be used to see if the headerview needs to resize the
        sections when the view's geometry changes.

        This function was introduced in Qt 4.1.

        **See also** **stretchLastSection** .
        """
        ...

    def highlightSections(self) -> bool:
        """
        https://doc.qt.io/qt-5/qheaderview.html#highlightSections-prop

        **highlightSections : bool**

        This property holds whether the sections containing selected items are
        highlighted

        By default, this property is `false`.

        **Access functions:**

        bool **highlightSections** () const
        void **setHighlightSections**
        (bool **highlight** )
        """
        ...

    def setHighlightSections(self, highlight: bool) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#highlightSections-prop

        **highlightSections : bool**

        This property holds whether the sections containing selected items are
        highlighted

        By default, this property is `false`.

        **Access functions:**

        bool **highlightSections** () const
        void **setHighlightSections**
        (bool **highlight** )
        """
        ...

    def logicalIndex(self, visualIndex: int) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#logicalIndex

        **int QHeaderView::logicalIndex(int visualIndex ) const**

        Returns the logicalIndex for the section at the given **visualIndex**
        position, or -1 if **visualIndex**  < 0 or **visualIndex**  >=
        **QHeaderView::count** ().

        Note that the **visualIndex**  is not affected by hidden sections.

        **See also** **visualIndex** () and **sectionPosition** ().
        """
        ...

    def visualIndex(self, logicalIndex: int) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#visualIndex

        **int QHeaderView::visualIndex(int logicalIndex ) const**

        Returns the visual index position of the section specified by the given
        **logicalIndex** , or -1 otherwise.

        Hidden sections still have valid visual indexes.

        **See also** **logicalIndex** ().
        """
        ...

    def __len__(self) -> int:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#count

        **int QHeaderView::count() const**

        Returns the number of sections in the header.

        **See also** **sectionCountChanged** () and **length** ().
        """
        ...

    def setSectionHidden(self, logicalIndex: int, hide: bool) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#setSectionHidden

        **void QHeaderView::setSectionHidden(int logicalIndex , bool hide )**

        If **hide** is true the section specified by **logicalIndex** is hidden;
        otherwise the section is shown.

        **See also** **isSectionHidden** () and **hiddenSectionCount** ().
        """
        ...

    def isSectionHidden(self, logicalIndex: int) -> bool:
        """
        https://doc.qt.io/qt-5/qheaderview.html#isSectionHidden

        **bool QHeaderView::isSectionHidden(int logicalIndex ) const**

        Returns `true` if the section specified by **logicalIndex** is
        explicitly hidden from the user; otherwise returns `false`.

        **See also** **hideSection** (), **showSection** (),
        **setSectionHidden** (), and **hiddenSectionCount** ().
        """
        ...

    def resizeSection(self, logicalIndex: int, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#resizeSection

        **void QHeaderView::resizeSection(int logicalIndex , int size )**

        Resizes the section specified by **logicalIndex** to **size** measured
        in pixels. The size parameter must be a value larger or equal to zero. A
        size equal to zero is however not recommended. In that situation
        **hideSection**  should be used instead.

        **See also** **sectionResized** (), **sectionSize** (), and
        **hideSection** ().
        """
        ...

    def moveSection(self, from_: int, to: int) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#moveSection

        **void QHeaderView::moveSection(int from , int to )**

        Moves the section at visual index **from** to occupy visual index
        **to**.

        **See also** **sectionsMoved** ().
        """
        ...

    def sectionViewportPosition(self, logicalIndex: int) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionViewportPosition

        **int QHeaderView::sectionViewportPosition(int logicalIndex ) const**

        Returns the section viewport position of the given **logicalIndex**.

        If the section is hidden, the return value is undefined.

        **See also** **sectionPosition** () and **isSectionHidden** ().
        """
        ...

    def sectionPosition(self, logicalIndex: int) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionPosition

        **int QHeaderView::sectionPosition(int logicalIndex ) const**

        Returns the section position of the given **logicalIndex** , or -1 if
        the section is hidden. The position is measured in pixels from the first
        visible item's top-left corner to the top-left corner of the item with
        **logicalIndex**. The measurement is along the x-axis for horizontal
        headers and along the y-axis for vertical headers.

        **See also** **sectionViewportPosition** ().
        """
        ...

    def sectionSize(self, logicalIndex: int) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionSize

        **int QHeaderView::sectionSize(int logicalIndex ) const**

        Returns the width (or height for vertical headers) of the given
        **logicalIndex**.

        **See also** **length** (), **setSectionResizeMode** (), and
        **defaultSectionSize** ().
        """
        ...

    @typing.overload
    def logicalIndexAt(self, position: int) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#logicalIndexAt

        **int QHeaderView::logicalIndexAt(int position ) const**

        Returns the section that covers the given **position** in the viewport.

        **See also** **visualIndexAt** () and **isSectionHidden** ().
        """
        ...

    @typing.overload
    def logicalIndexAt(self, ax: int, ay: int) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#logicalIndexAt-1

        **int QHeaderView::logicalIndexAt(int x , int y ) const**

        Returns the logical index of the section at the given coordinate. If the
        header is horizontal **x** will be used, otherwise **y** will be used to
        find the logical index.
        """
        ...

    @typing.overload
    def logicalIndexAt(self, apos: QtCore.QPoint) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#logicalIndexAt-2

        **int QHeaderView::logicalIndexAt(const QPoint & pos ) const**

        Returns the logical index of the section at the position given in
        **pos**. If the header is horizontal the x-coordinate will be used,
        otherwise the y-coordinate will be used to find the logical index.

        **See also** **sectionPosition** ().
        """
        ...

    def visualIndexAt(self, position: int) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#visualIndexAt

        **int QHeaderView::visualIndexAt(int position ) const**

        Returns the visual index of the section that covers the given
        **position** in the viewport.

        **See also** **logicalIndexAt** ().
        """
        ...

    def sectionSizeHint(self, logicalIndex: int) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionSizeHint

        **int QHeaderView::sectionSizeHint(int logicalIndex ) const**

        Returns a suitable size hint for the section specified by
        **logicalIndex**.

        **Qt::SizeHintRole**

        **See also** **sizeHint** (), **defaultSectionSize** (),
        **minimumSectionSize** (), and **maximumSectionSize** ().
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sizeHint

        **[override virtual] QSize QHeaderView::sizeHint() const**

        Reimplements: **QAbstractScrollArea::sizeHint** () const.

        Returns a suitable size hint for this header.

        **See also** **sectionSizeHint** ().
        """
        ...

    def length(self) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#length

        **int QHeaderView::length() const**

        Returns the length along the orientation of the header.

        **See also** **sizeHint** (), **setSectionResizeMode** (), and
        **offset** ().
        """
        ...

    def offset(self) -> int:
        """
        https://doc.qt.io/qt-5/qheaderview.html#offset

        **int QHeaderView::offset() const**

        Returns the offset of the header: this is the header's left-most (or
        top-most for vertical headers) visible pixel.

        **See also** **setOffset** ().
        """
        ...

    def orientation(self) -> QtCore.Qt.Orientation:
        """
        https://doc.qt.io/qt-5/qheaderview.html#orientation

        **Qt::Orientation QHeaderView::orientation() const**

        Returns the orientation of the header.

        **See also** **Qt::Orientation** .
        """
        ...

    def setModel(self, model: QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-5/qheaderview.html#setModel

        **[override virtual] void QHeaderView::setModel(QAbstractItemModel *
        model )**

        Reimplements: **QAbstractItemView::setModel** (QAbstractItemModel
        *model).
        """
        ...

    @property
    def geometriesChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qheaderview.html#geometriesChanged

        **[signal] void QHeaderView::geometriesChanged()**

        This signal is emitted when the header's geometries have changed.

        This function was introduced in Qt 4.2.
        """
        ...

    @property
    def sectionClicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionClicked

        **[signal] void QHeaderView::sectionClicked(int logicalIndex )**

        This signal is emitted when a section is clicked. The section's logical
        index is specified by **logicalIndex**.

        Note that the **sectionPressed**  signal will also be emitted.

        **See also** **setSectionsClickable** () and **sectionPressed** ().
        """
        ...

    @property
    def sectionCountChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionCountChanged

        **[signal] void QHeaderView::sectionCountChanged(int oldCount , int
        newCount )**

        This signal is emitted when the number of sections changes, i.e., when
        sections are added or deleted. The original count is specified by
        **oldCount** , and the new count by **newCount**.

        **See also** **count** (), **length** (), and **headerDataChanged** ().
        """
        ...

    @property
    def sectionDoubleClicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionDoubleClicked

        **[signal] void QHeaderView::sectionDoubleClicked(int logicalIndex )**

        This signal is emitted when a section is double-clicked. The section's
        logical index is specified by **logicalIndex**.

        **See also** **setSectionsClickable** ().
        """
        ...

    @property
    def sectionEntered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionEntered

        **[signal] void QHeaderView::sectionEntered(int logicalIndex )**

        This signal is emitted when the cursor moves over the section and the
        left mouse button is pressed. The section's logical index is specified
        by **logicalIndex**.

        This function was introduced in Qt 4.3.

        **See also** **setSectionsClickable** () and **sectionPressed** ().
        """
        ...

    @property
    def sectionHandleDoubleClicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionHandleDoubleClicked

        **[signal] void QHeaderView::sectionHandleDoubleClicked(int logicalIndex
        )**

        This signal is emitted when a section is double-clicked. The section's
        logical index is specified by **logicalIndex**.

        **See also** **setSectionsClickable** ().
        """
        ...

    @property
    def sectionMoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionMoved

        **[signal] void QHeaderView::sectionMoved(int logicalIndex , int
        oldVisualIndex , int newVisualIndex )**

        This signal is emitted when a section is moved. The section's logical
        index is specified by **logicalIndex** , the old index by
        **oldVisualIndex** , and the new index position by **newVisualIndex**.

        **See also** **moveSection** ().
        """
        ...

    @property
    def sectionPressed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionPressed

        **[signal] void QHeaderView::sectionPressed(int logicalIndex )**

        This signal is emitted when a section is pressed. The section's logical
        index is specified by **logicalIndex**.

        **See also** **setSectionsClickable** ().
        """
        ...

    @property
    def sectionResized(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sectionResized

        **[signal] void QHeaderView::sectionResized(int logicalIndex , int
        oldSize , int newSize )**

        This signal is emitted when a section is resized. The section's logical
        number is specified by **logicalIndex** , the old size by **oldSize** ,
        and the new size by **newSize**.

        **See also** **resizeSection** ().
        """
        ...

    @property
    def sortIndicatorChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qheaderview.html#sortIndicatorChanged

        **[signal] void QHeaderView::sortIndicatorChanged(int logicalIndex ,
        Qt::SortOrder order )**

        This signal is emitted when the section containing the sort indicator or
        the order indicated is changed. The section's logical index is specified
        by **logicalIndex** and the sort order is specified by **order**.

        This function was introduced in Qt 4.3.

        **See also** **setSortIndicator** ().
        """
        ...
