"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QGraphicsTextItem(QGraphicsObject):
    """
    https://doc.qt.io/qt-5/qgraphicstextitem.html

    **Detailed Description**

    If you only need to show plain text in an item, consider using
    **QGraphicsSimpleTextItem**  instead.

    To set the item's text, pass a **QString**  to QGraphicsTextItem's
    constructor, or call **setHtml** ()/**setPlainText** ().

    QGraphicsTextItem uses the text's formatted size and the associated font to
    provide a reasonable implementation of **boundingRect** (), **shape** (),
    and **contains** (). You can set the font by calling **setFont** ().

    It is possible to make the item editable by setting the
    **Qt::TextEditorInteraction**  flag using **setTextInteractionFlags** ().

    The item's preferred text width can be set using **setTextWidth** () and
    obtained using **textWidth** ().

    **Note:** In order to align HTML text in the center, the item's text width
    must be set. Otherwise, you can call **adjustSize** () after setting the
    item's text.

    ![](images/graphicsview-textitem.png)

    **Note:** QGraphicsTextItem accepts **hover events**  by default. You can
    change this with **setAcceptHoverEvents()** .

    **See also** **QGraphicsSimpleTextItem** , **QGraphicsPathItem** ,
    **QGraphicsRectItem** , **QGraphicsEllipseItem** , **QGraphicsPixmapItem** ,
    **QGraphicsPolygonItem** , **QGraphicsLineItem** , and **Graphics View
    Framework** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#QGraphicsTextItem

        **QGraphicsTextItem::QGraphicsTextItem(QGraphicsItem * parent =
        nullptr)**

        Constructs a QGraphicsTextItem. **parent** is passed to
        **QGraphicsItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#QGraphicsTextItem-1

        **QGraphicsTextItem::QGraphicsTextItem(const QString & text ,
        QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsTextItem, using **text** as the default plain
        text. **parent** is passed to **QGraphicsItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    def inputMethodQuery(self, query: QtCore.Qt.InputMethodQuery) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#inputMethodQuery

        **[override virtual protected] QVariant
        QGraphicsTextItem::inputMethodQuery(Qt::InputMethodQuery query ) const**

        Reimplements: **QGraphicsItem::inputMethodQuery** (Qt::InputMethodQuery
        query) const.
        """
        ...

    def hoverLeaveEvent(self, event: "QGraphicsSceneHoverEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#hoverLeaveEvent

        **[override virtual protected] void
        QGraphicsTextItem::hoverLeaveEvent(QGraphicsSceneHoverEvent * event )**

        Reimplements: **QGraphicsItem::hoverLeaveEvent**
        (QGraphicsSceneHoverEvent *event).
        """
        ...

    def hoverMoveEvent(self, event: "QGraphicsSceneHoverEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#hoverMoveEvent

        **[override virtual protected] void
        QGraphicsTextItem::hoverMoveEvent(QGraphicsSceneHoverEvent * event )**

        Reimplements: **QGraphicsItem::hoverMoveEvent**
        (QGraphicsSceneHoverEvent *event).
        """
        ...

    def hoverEnterEvent(self, event: "QGraphicsSceneHoverEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#hoverEnterEvent

        **[override virtual protected] void
        QGraphicsTextItem::hoverEnterEvent(QGraphicsSceneHoverEvent * event )**

        Reimplements: **QGraphicsItem::hoverEnterEvent**
        (QGraphicsSceneHoverEvent *event).
        """
        ...

    def inputMethodEvent(self, event: QtGui.QInputMethodEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#inputMethodEvent

        **[override virtual protected] void
        QGraphicsTextItem::inputMethodEvent(QInputMethodEvent * event )**

        Reimplements: **QGraphicsItem::inputMethodEvent** (QInputMethodEvent
        *event).
        """
        ...

    def dropEvent(self, event: "QGraphicsSceneDragDropEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#dropEvent

        **[override virtual protected] void
        QGraphicsTextItem::dropEvent(QGraphicsSceneDragDropEvent * event )**

        Reimplements: **QGraphicsItem::dropEvent** (QGraphicsSceneDragDropEvent
        *event).
        """
        ...

    def dragMoveEvent(self, event: "QGraphicsSceneDragDropEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#dragMoveEvent

        **[override virtual protected] void
        QGraphicsTextItem::dragMoveEvent(QGraphicsSceneDragDropEvent * event )**

        Reimplements: **QGraphicsItem::dragMoveEvent**
        (QGraphicsSceneDragDropEvent *event).
        """
        ...

    def dragLeaveEvent(self, event: "QGraphicsSceneDragDropEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#dragLeaveEvent

        **[override virtual protected] void
        QGraphicsTextItem::dragLeaveEvent(QGraphicsSceneDragDropEvent * event
        )**

        Reimplements: **QGraphicsItem::dragLeaveEvent**
        (QGraphicsSceneDragDropEvent *event).
        """
        ...

    def dragEnterEvent(self, event: "QGraphicsSceneDragDropEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#dragEnterEvent

        **[override virtual protected] void
        QGraphicsTextItem::dragEnterEvent(QGraphicsSceneDragDropEvent * event
        )**

        Reimplements: **QGraphicsItem::dragEnterEvent**
        (QGraphicsSceneDragDropEvent *event).
        """
        ...

    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#focusOutEvent

        **[override virtual protected] void
        QGraphicsTextItem::focusOutEvent(QFocusEvent * event )**

        Reimplements: **QGraphicsItem::focusOutEvent** (QFocusEvent *event).
        """
        ...

    def focusInEvent(self, event: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#focusInEvent

        **[override virtual protected] void
        QGraphicsTextItem::focusInEvent(QFocusEvent * event )**

        Reimplements: **QGraphicsItem::focusInEvent** (QFocusEvent *event).
        """
        ...

    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#keyReleaseEvent

        **[override virtual protected] void
        QGraphicsTextItem::keyReleaseEvent(QKeyEvent * event )**

        Reimplements: **QGraphicsItem::keyReleaseEvent** (QKeyEvent *event).
        """
        ...

    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#keyPressEvent

        **[override virtual protected] void
        QGraphicsTextItem::keyPressEvent(QKeyEvent * event )**

        Reimplements: **QGraphicsItem::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def contextMenuEvent(self, event: "QGraphicsSceneContextMenuEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#contextMenuEvent

        **[override virtual protected] void
        QGraphicsTextItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *
        event )**

        Reimplements: **QGraphicsItem::contextMenuEvent**
        (QGraphicsSceneContextMenuEvent *event).
        """
        ...

    def mouseDoubleClickEvent(self, event: "QGraphicsSceneMouseEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QGraphicsTextItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *
        event )**

        Reimplements: **QGraphicsItem::mouseDoubleClickEvent**
        (QGraphicsSceneMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(self, event: "QGraphicsSceneMouseEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#mouseReleaseEvent

        **[override virtual protected] void
        QGraphicsTextItem::mouseReleaseEvent(QGraphicsSceneMouseEvent * event
        )**

        Reimplements: **QGraphicsItem::mouseReleaseEvent**
        (QGraphicsSceneMouseEvent *event).
        """
        ...

    def mouseMoveEvent(self, event: "QGraphicsSceneMouseEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#mouseMoveEvent

        **[override virtual protected] void
        QGraphicsTextItem::mouseMoveEvent(QGraphicsSceneMouseEvent * event )**

        Reimplements: **QGraphicsItem::mouseMoveEvent**
        (QGraphicsSceneMouseEvent *event).
        """
        ...

    def mousePressEvent(self, event: "QGraphicsSceneMouseEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#mousePressEvent

        **[override virtual protected] void
        QGraphicsTextItem::mousePressEvent(QGraphicsSceneMouseEvent * event )**

        Reimplements: **QGraphicsItem::mousePressEvent**
        (QGraphicsSceneMouseEvent *event).
        """
        ...

    def sceneEvent(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#sceneEvent

        **[override virtual protected] bool QGraphicsTextItem::sceneEvent(QEvent
        * event )**

        Reimplements: **QGraphicsItem::sceneEvent** (QEvent *event).
        """
        ...

    def textCursor(self) -> QtGui.QTextCursor:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#textCursor-prop

        **textCursor : QTextCursor**

        This property represents the visible text cursor in an editable text
        item.

        By default, if the item's text has not been set, this property contains
        a null text cursor; otherwise it contains a text cursor placed at the
        start of the item's document.

        **Access functions:**

        QTextCursor **textCursor** () const
        void **setTextCursor** (const
        QTextCursor & **cursor** )

        **Member Function Documentation**
        """
        ...

    def setTextCursor(self, cursor: QtGui.QTextCursor) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#textCursor-prop

        **textCursor : QTextCursor**

        This property represents the visible text cursor in an editable text
        item.

        By default, if the item's text has not been set, this property contains
        a null text cursor; otherwise it contains a text cursor placed at the
        start of the item's document.

        **Access functions:**

        QTextCursor **textCursor** () const
        void **setTextCursor** (const
        QTextCursor & **cursor** )

        **Member Function Documentation**
        """
        ...

    def openExternalLinks(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#openExternalLinks-prop

        **openExternalLinks : bool**

        Specifies whether **QGraphicsTextItem**  should automatically open links
        using **QDesktopServices::openUrl** () instead of emitting the
        **linkActivated**  signal.

        The default value is false.

        **Access functions:**

        bool **openExternalLinks** () const
        void **setOpenExternalLinks**
        (bool **open** )
        """
        ...

    def setOpenExternalLinks(self, open: bool) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#openExternalLinks-prop

        **openExternalLinks : bool**

        Specifies whether **QGraphicsTextItem**  should automatically open links
        using **QDesktopServices::openUrl** () instead of emitting the
        **linkActivated**  signal.

        The default value is false.

        **Access functions:**

        bool **openExternalLinks** () const
        void **setOpenExternalLinks**
        (bool **open** )
        """
        ...

    def tabChangesFocus(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#tabChangesFocus

        **bool QGraphicsTextItem::tabChangesFocus() const**

        Returns `true` if the **Tab** key will cause the widget to change focus;
        otherwise, false is returned.

        By default, this behavior is disabled, and this function will return
        false.

        This function was introduced in Qt 4.5.

        **See also** **setTabChangesFocus** ().
        """
        ...

    def setTabChangesFocus(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#setTabChangesFocus

        **void QGraphicsTextItem::setTabChangesFocus(bool b )**

        If **b** is true, the **Tab** key will cause the widget to change focus;
        otherwise, the tab key will insert a tab into the document.

        In some occasions text edits should not allow the user to input
        tabulators or change indentation using the **Tab** key, as this breaks
        the focus chain. The default is false.

        This function was introduced in Qt 4.5.

        **See also** **tabChangesFocus** (), **ItemIsFocusable** , and
        **textInteractionFlags** ().
        """
        ...

    def textInteractionFlags(self) -> QtCore.Qt.TextInteractionFlags:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#textInteractionFlags

        **Qt::TextInteractionFlags QGraphicsTextItem::textInteractionFlags()
        const**

        Returns the current text interaction flags.

        **See also** **setTextInteractionFlags** ().
        """
        ...

    def setTextInteractionFlags(
        self,
        flags: typing.Union[
            QtCore.Qt.TextInteractionFlags, QtCore.Qt.TextInteractionFlag
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#setTextInteractionFlags

        **void
        QGraphicsTextItem::setTextInteractionFlags(Qt::TextInteractionFlags
        flags )**

        Sets the flags **flags** to specify how the text item should react to
        user input.

        The default for a **QGraphicsTextItem**  is **Qt::NoTextInteraction** .
        This function also affects the **ItemIsFocusable**  **QGraphicsItem**
        flag by setting it if **flags** is different from
        **Qt::NoTextInteraction**  and clearing it otherwise.

        By default, the text is read-only. To transform the item into an editor,
        set the **Qt::TextEditable**  flag.

        **See also** **textInteractionFlags** ().
        """
        ...

    def document(self) -> QtGui.QTextDocument:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#document

        **QTextDocument *QGraphicsTextItem::document() const**

        Returns the item's text document.

        **See also** **setDocument** ().
        """
        ...

    def setDocument(self, document: QtGui.QTextDocument) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#setDocument

        **void QGraphicsTextItem::setDocument(QTextDocument * document )**

        Sets the text document **document** on the item.

        **See also** **document** ().
        """
        ...

    def adjustSize(self) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#adjustSize

        **void QGraphicsTextItem::adjustSize()**

        Adjusts the text item to a reasonable size.
        """
        ...

    def textWidth(self) -> float:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#textWidth

        **qreal QGraphicsTextItem::textWidth() const**

        Returns the text width.

        The width is calculated with the **QTextDocument**  that
        **QGraphicsTextItem**  keeps internally.

        **See also** **setTextWidth** () and **QTextDocument::textWidth** ().
        """
        ...

    def setTextWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#setTextWidth

        **void QGraphicsTextItem::setTextWidth(qreal width )**

        Sets the preferred width for the item's text. If the actual text is
        wider than the specified width then it will be broken into multiple
        lines.

        If **width** is set to -1 then the text will not be broken into multiple
        lines unless it is enforced through an explicit line break or a new
        paragraph.

        The default value is -1.

        Note that **QGraphicsTextItem**  keeps a **QTextDocument**  internally,
        which is used to calculate the text width.

        **See also** **textWidth** () and **QTextDocument::setTextWidth** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#type

        **[override virtual] int QGraphicsTextItem::type() const**

        Reimplements: **QGraphicsItem::type** () const.
        """
        ...

    def opaqueArea(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#opaqueArea

        **[override virtual] QPainterPath QGraphicsTextItem::opaqueArea()
        const**

        Reimplements: **QGraphicsItem::opaqueArea** () const.
        """
        ...

    def isObscuredBy(self, item: QGraphicsItem) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#isObscuredBy

        **[override virtual] bool QGraphicsTextItem::isObscuredBy(const
        QGraphicsItem * item ) const**

        Reimplements: **QGraphicsItem::isObscuredBy** (const QGraphicsItem
        *item) const.
        """
        ...

    def paint(
        self,
        painter: QtGui.QPainter,
        option: "QStyleOptionGraphicsItem",
        widget: QWidget,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#paint

        **[override virtual] void QGraphicsTextItem::paint(QPainter * painter ,
        const QStyleOptionGraphicsItem * option , QWidget * widget )**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#contains

        **[override virtual] bool QGraphicsTextItem::contains(const QPointF &
        point ) const**

        Reimplements: **QGraphicsItem::contains** (const QPointF &point) const.
        """
        ...

    def shape(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#shape

        **[override virtual] QPainterPath QGraphicsTextItem::shape() const**

        Reimplements: **QGraphicsItem::shape** () const.
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#boundingRect

        **[override virtual] QRectF QGraphicsTextItem::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect** () const.
        """
        ...

    def defaultTextColor(self) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#defaultTextColor

        **QColor QGraphicsTextItem::defaultTextColor() const**

        Returns the default text color that is used for unformatted text.

        **See also** **setDefaultTextColor** ().
        """
        ...

    def setDefaultTextColor(
        self, c: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#setDefaultTextColor

        **void QGraphicsTextItem::setDefaultTextColor(const QColor & col )**

        Sets the color for unformatted text to **col**.

        **See also** **defaultTextColor** ().
        """
        ...

    def setFont(self, font: QtGui.QFont) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#setFont

        **void QGraphicsTextItem::setFont(const QFont & font )**

        Sets the font used to render the text item to **font**.

        **See also** **font** ().
        """
        ...

    def font(self) -> QtGui.QFont:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#font

        **QFont QGraphicsTextItem::font() const**

        Returns the item's font, which is used to render the text.

        **See also** **setFont** ().
        """
        ...

    def setPlainText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#setPlainText

        **void QGraphicsTextItem::setPlainText(const QString & text )**

        Sets the item's text to **text**. If the item has keyboard input focus,
        this function will also call **ensureVisible** () to ensure that the
        text is visible in all viewports.

        **See also** **toHtml** () and **hasFocus** ().
        """
        ...

    def toPlainText(self) -> str:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#toPlainText

        **QString QGraphicsTextItem::toPlainText() const**

        Returns the item's text converted to plain text, or an empty **QString**
        if no text has been set.

        **See also** **setPlainText** ().
        """
        ...

    def setHtml(self, html: str) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#setHtml

        **void QGraphicsTextItem::setHtml(const QString & text )**

        Sets the item's text to **text** , assuming that text is HTML formatted.
        If the item has keyboard input focus, this function will also call
        **ensureVisible** () to ensure that the text is visible in all
        viewports.

        **See also** **toHtml** (), **hasFocus** (), and
        **QGraphicsSimpleTextItem** .
        """
        ...

    def toHtml(self) -> str:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#toHtml

        **QString QGraphicsTextItem::toHtml() const**

        Returns the item's text converted to HTML, or an empty **QString**  if
        no text has been set.

        **See also** **setHtml** ().
        """
        ...

    @property
    def linkActivated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#linkActivated

        **[signal] void QGraphicsTextItem::linkActivated(const QString & link
        )**

        This signal is emitted when the user clicks on a link on a text item
        that enables **Qt::LinksAccessibleByMouse**  or
        **Qt::LinksAccessibleByKeyboard** . **link** is the link that was
        clicked.

        **See also** **setTextInteractionFlags** ().
        """
        ...

    @property
    def linkHovered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicstextitem.html#linkHovered

        **[signal] void QGraphicsTextItem::linkHovered(const QString & link )**

        This signal is emitted when the user hovers over a link on a text item
        that enables **Qt::LinksAccessibleByMouse** . **link** is the link that
        was hovered over.

        **See also** **setTextInteractionFlags** ().
        """
        ...
