"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QGraphicsRectItem(QAbstractGraphicsShapeItem):
    """
    https://doc.qt.io/qt-5/qgraphicsrectitem.html

    **Detailed Description**

    To set the item's rectangle, pass a **QRectF**  to QGraphicsRectItem's
    constructor, or call the **setRect** () function. The **rect** () function
    returns the current rectangle.

    ![](images/graphicsview-rectitem.png)

    QGraphicsRectItem uses the rectangle and the pen width to provide a
    reasonable implementation of **boundingRect** (), **shape** (), and
    **contains** (). The **paint** () function draws the rectangle using the
    item's associated pen and brush, which you can set by calling the **setPen**
    () and **setBrush** () functions.

    **Note:** The rendering of invalid rectangles, such as those with negative
    widths or heights, is undefined. If you cannot be sure that you are using
    valid rectangles (for example, if you are creating rectangles using data
    from an unreliable source) then you should use **QRectF::normalized** () to
    create normalized rectangles, and use those instead.

    **See also** **QGraphicsPathItem** , **QGraphicsEllipseItem** ,
    **QGraphicsPolygonItem** , **QGraphicsTextItem** , **QGraphicsLineItem** ,
    **QGraphicsPixmapItem** , and **Graphics View Framework** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsrectitem.html#QGraphicsRectItem

        **QGraphicsRectItem::QGraphicsRectItem(QGraphicsItem * parent =
        nullptr)**

        Constructs a QGraphicsRectItem. **parent** is passed to
        **QAbstractGraphicsShapeItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    @typing.overload
    def __init__(
        self, rect: QtCore.QRectF, parent: typing.Optional[QGraphicsItem] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsrectitem.html#QGraphicsRectItem-1

        **QGraphicsRectItem::QGraphicsRectItem(const QRectF & rect ,
        QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsRectItem, using **rect** as the default rectangle.
        **parent** is passed to **QAbstractGraphicsShapeItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        x: float,
        y: float,
        w: float,
        h: float,
        parent: typing.Optional[QGraphicsItem] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsrectitem.html#QGraphicsRectItem-2

        **QGraphicsRectItem::QGraphicsRectItem(qreal x , qreal y , qreal width ,
        qreal height , QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsRectItem with a default rectangle defined by (
        **x** , **y** ) and the given **width** and **height**.

        **parent** is passed to **QAbstractGraphicsShapeItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-5/qgraphicsrectitem.html#type

        **[override virtual] int QGraphicsRectItem::type() const**

        Reimplements: **QGraphicsItem::type** () const.
        """
        ...

    def opaqueArea(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-5/qgraphicsrectitem.html#opaqueArea

        **[override virtual] QPainterPath QGraphicsRectItem::opaqueArea()
        const**

        Reimplements: **QAbstractGraphicsShapeItem::opaqueArea** () const.
        """
        ...

    def isObscuredBy(self, item: QGraphicsItem) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicsrectitem.html#isObscuredBy

        **[override virtual] bool QGraphicsRectItem::isObscuredBy(const
        QGraphicsItem * item ) const**

        Reimplements: **QAbstractGraphicsShapeItem::isObscuredBy** (const
        QGraphicsItem *item) const.
        """
        ...

    def paint(
        self,
        painter: QtGui.QPainter,
        option: "QStyleOptionGraphicsItem",
        widget: typing.Optional[QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsrectitem.html#paint

        **[override virtual] void QGraphicsRectItem::paint(QPainter * painter ,
        const QStyleOptionGraphicsItem * option , QWidget * widget = nullptr)**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicsrectitem.html#contains

        **[override virtual] bool QGraphicsRectItem::contains(const QPointF &
        point ) const**

        Reimplements: **QGraphicsItem::contains** (const QPointF &point) const.
        """
        ...

    def shape(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-5/qgraphicsrectitem.html#shape

        **[override virtual] QPainterPath QGraphicsRectItem::shape() const**

        Reimplements: **QGraphicsItem::shape** () const.
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qgraphicsrectitem.html#boundingRect

        **[override virtual] QRectF QGraphicsRectItem::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect** () const.
        """
        ...

    @typing.overload
    def setRect(self, rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsrectitem.html#setRect

        **void QGraphicsRectItem::setRect(const QRectF & rectangle )**

        Sets the item's rectangle to be the given **rectangle**.

        **See also** **rect** ().
        """
        ...

    @typing.overload
    def setRect(self, ax: float, ay: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsrectitem.html#setRect-1

        **void QGraphicsRectItem::setRect(qreal x , qreal y , qreal width ,
        qreal height )**

        Sets the item's rectangle to the rectangle defined by ( **x** , **y** )
        and the given **width** and **height**.

        This convenience function is equivalent to calling `setRect(QRectF(x, y,
        width, height))`

        **See also** **rect** ().
        """
        ...

    def rect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qgraphicsrectitem.html#rect

        **QRectF QGraphicsRectItem::rect() const**

        Returns the item's rectangle.

        **See also** **setRect** ().
        """
        ...
