"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QGraphicsPolygonItem(QAbstractGraphicsShapeItem):
    """
    https://doc.qt.io/qt-5/qgraphicspolygonitem.html

    **Detailed Description**

    To set the item's polygon, pass a **QPolygonF**  to QGraphicsPolygonItem's
    constructor, or call the **setPolygon** () function. The **polygon** ()
    function returns the current polygon.

    ![](images/graphicsview-polygonitem.png)

    QGraphicsPolygonItem uses the polygon and the pen width to provide a
    reasonable implementation of **boundingRect** (), **shape** (), and
    **contains** (). The **paint** () function draws the polygon using the
    item's associated pen and brush, which you can set by calling the **setPen**
    () and **setBrush** () functions.

    **See also** **QGraphicsPathItem** , **QGraphicsRectItem** ,
    **QGraphicsEllipseItem** , **QGraphicsTextItem** , **QGraphicsLineItem** ,
    **QGraphicsPixmapItem** , and **Graphics View Framework** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicspolygonitem.html#QGraphicsPolygonItem

        **QGraphicsPolygonItem::QGraphicsPolygonItem(QGraphicsItem * parent =
        nullptr)**

        Constructs a QGraphicsPolygonItem. **parent** is passed to
        **QAbstractGraphicsShapeItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    @typing.overload
    def __init__(
        self, polygon: QtGui.QPolygonF, parent: typing.Optional[QGraphicsItem] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicspolygonitem.html#QGraphicsPolygonItem-1

        **QGraphicsPolygonItem::QGraphicsPolygonItem(const QPolygonF & polygon ,
        QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsPolygonItem with **polygon** as the default
        polygon. **parent** is passed to **QAbstractGraphicsShapeItem** 's
        constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-5/qgraphicspolygonitem.html#type

        **[override virtual] int QGraphicsPolygonItem::type() const**

        Reimplements: **QGraphicsItem::type** () const.
        """
        ...

    def opaqueArea(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-5/qgraphicspolygonitem.html#opaqueArea

        **[override virtual] QPainterPath QGraphicsPolygonItem::opaqueArea()
        const**

        Reimplements: **QAbstractGraphicsShapeItem::opaqueArea** () const.
        """
        ...

    def isObscuredBy(self, item: QGraphicsItem) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicspolygonitem.html#isObscuredBy

        **[override virtual] bool QGraphicsPolygonItem::isObscuredBy(const
        QGraphicsItem * item ) const**

        Reimplements: **QAbstractGraphicsShapeItem::isObscuredBy** (const
        QGraphicsItem *item) const.
        """
        ...

    def paint(
        self,
        painter: QtGui.QPainter,
        option: "QStyleOptionGraphicsItem",
        widget: typing.Optional[QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicspolygonitem.html#paint

        **[override virtual] void QGraphicsPolygonItem::paint(QPainter * painter
        , const QStyleOptionGraphicsItem * option , QWidget * widget =
        nullptr)**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicspolygonitem.html#contains

        **[override virtual] bool QGraphicsPolygonItem::contains(const QPointF &
        point ) const**

        Reimplements: **QGraphicsItem::contains** (const QPointF &point) const.
        """
        ...

    def shape(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-5/qgraphicspolygonitem.html#shape

        **[override virtual] QPainterPath QGraphicsPolygonItem::shape() const**

        Reimplements: **QGraphicsItem::shape** () const.
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qgraphicspolygonitem.html#boundingRect

        **[override virtual] QRectF QGraphicsPolygonItem::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect** () const.
        """
        ...

    def setFillRule(self, rule: QtCore.Qt.FillRule) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicspolygonitem.html#setFillRule

        **void QGraphicsPolygonItem::setFillRule(Qt::FillRule rule )**

        Sets the fill rule of the polygon to **rule**. The default fill rule is
        **Qt::OddEvenFill** .

        **See also** **fillRule** (), **QPainterPath::fillRule** (), and
        **QPainter::drawPolygon** ().
        """
        ...

    def fillRule(self) -> QtCore.Qt.FillRule:
        """
        https://doc.qt.io/qt-5/qgraphicspolygonitem.html#fillRule

        **Qt::FillRule QGraphicsPolygonItem::fillRule() const**

        Returns the fill rule of the polygon. The default fill rule is
        **Qt::OddEvenFill** .

        **See also** **setFillRule** (), **QPainterPath::fillRule** (), and
        **QPainter::drawPolygon** ().
        """
        ...

    def setPolygon(self, polygon: QtGui.QPolygonF) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicspolygonitem.html#setPolygon

        **void QGraphicsPolygonItem::setPolygon(const QPolygonF & polygon )**

        Sets the item's polygon to be the given **polygon**.

        **See also** **polygon** ().
        """
        ...

    def polygon(self) -> QtGui.QPolygonF:
        """
        https://doc.qt.io/qt-5/qgraphicspolygonitem.html#polygon

        **QPolygonF QGraphicsPolygonItem::polygon() const**

        Returns the item's polygon, or an empty polygon if no polygon has been
        set.

        **See also** **setPolygon** ().
        """
        ...
