"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QGraphicsDropShadowEffect(QGraphicsEffect):
    """
    https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html

    **Detailed Description**

    A drop shadow effect renders the source with a drop shadow. The color of the
    drop shadow can be modified using the **setColor** () function. The drop
    shadow offset can be modified using the **setOffset** () function and the
    blur radius of the drop shadow can be changed with the **setBlurRadius** ()
    function.

    By default, the drop shadow is a semi-transparent dark gray (**QColor** (63,
    63, 63, 180)) shadow, blurred with a radius of 1 at an offset of 8 pixels
    towards the lower right. The drop shadow offset is specified in device
    coordinates.

    ![](images/graphicseffect-drop-shadow.png)

    **See also** **QGraphicsBlurEffect** , **QGraphicsColorizeEffect** , and
    **QGraphicsOpacityEffect** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#QGraphicsDropShado
        wEffect

        **QGraphicsDropShadowEffect::QGraphicsDropShadowEffect(QObject * parent
        = nullptr)**

        Constructs a new QGraphicsDropShadowEffect instance. The **parent**
        parameter is passed to **QGraphicsEffect** 's constructor.
        """
        ...

    def draw(self, painter: QtGui.QPainter) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#draw

        **[override virtual protected] void
        QGraphicsDropShadowEffect::draw(QPainter * painter )**

        Reimplements: **QGraphicsEffect::draw** (QPainter *painter).
        """
        ...

    def setColor(
        self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#color-prop

        **color : QColor**

        This property holds the color of the drop shadow.

        By default, the drop color is a semi-transparent dark gray (**QColor**
        (63, 63, 63, 180)).

        **Access functions:**

        QColor **color** () const
        void **setColor** (const QColor & **color**
        )

        **Notifier signal:**

        void ****colorChanged** ** (const QColor & **color** )

        **See also** **offset** () and **blurRadius** ().
        """
        ...

    def setBlurRadius(self, blurRadius: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#blurRadius-prop

        **blurRadius : qreal**

        This property holds the blur radius in pixels of the drop shadow.

        Using a smaller radius results in a sharper shadow, whereas using a
        bigger radius results in a more blurred shadow.

        By default, the blur radius is 1 pixel.

        **Access functions:**

        qreal **blurRadius** () const
        void **setBlurRadius** (qreal
        **blurRadius** )

        **Notifier signal:**

        void ****blurRadiusChanged** ** (qreal **blurRadius** )

        **See also** **color** () and **offset** ().
        """
        ...

    def setYOffset(self, dy: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#yOffset-prop

        **yOffset : qreal**

        This property holds the vertical shadow offset in pixels.

        By default, the vertical shadow offset is 8 pixels.

        **Access functions:**

        qreal **yOffset** () const
        void **setYOffset** (qreal **dy** )

        **Notifier signal:**

        void ****offsetChanged** ** (const QPointF & **offset** )

        **See also** **xOffset** () and **offset** ().

        **Member Function Documentation**
        """
        ...

    def setXOffset(self, dx: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#xOffset-prop

        **xOffset : qreal**

        This property holds the horizontal shadow offset in pixels.

        By default, the horizontal shadow offset is 8 pixels.

        **Access functions:**

        qreal **xOffset** () const
        void **setXOffset** (qreal **dx** )

        **Notifier signal:**

        void ****offsetChanged** ** (const QPointF & **offset** )

        **See also** **yOffset** () and **offset** ().
        """
        ...

    @typing.overload
    def setOffset(self, ofs: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#offset-prop

        **offset : QPointF**

        This property holds the shadow offset in pixels.

        By default, the offset is 8 pixels towards the lower right.

        The offset is given in device coordinates, which means it is unaffected
        by scale.

        **Access functions:**

        QPointF **offset** () const
        void **setOffset** (const QPointF &
        **ofs** )
        void **setOffset** (qreal **dx** , qreal **dy** )
        void
        **setOffset** (qreal **d** )

        **Notifier signal:**

        void ****offsetChanged** ** (const QPointF & **offset** )

        **See also** **xOffset** (), **yOffset** (), **blurRadius** (), and
        **color** ().
        """
        ...

    @typing.overload
    def setOffset(self, dx: float, dy: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#offset-prop

        **offset : QPointF**

        This property holds the shadow offset in pixels.

        By default, the offset is 8 pixels towards the lower right.

        The offset is given in device coordinates, which means it is unaffected
        by scale.

        **Access functions:**

        QPointF **offset** () const
        void **setOffset** (const QPointF &
        **ofs** )
        void **setOffset** (qreal **dx** , qreal **dy** )
        void
        **setOffset** (qreal **d** )

        **Notifier signal:**

        void ****offsetChanged** ** (const QPointF & **offset** )

        **See also** **xOffset** (), **yOffset** (), **blurRadius** (), and
        **color** ().
        """
        ...

    @typing.overload
    def setOffset(self, d: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#offset-prop

        **offset : QPointF**

        This property holds the shadow offset in pixels.

        By default, the offset is 8 pixels towards the lower right.

        The offset is given in device coordinates, which means it is unaffected
        by scale.

        **Access functions:**

        QPointF **offset** () const
        void **setOffset** (const QPointF &
        **ofs** )
        void **setOffset** (qreal **dx** , qreal **dy** )
        void
        **setOffset** (qreal **d** )

        **Notifier signal:**

        void ****offsetChanged** ** (const QPointF & **offset** )

        **See also** **xOffset** (), **yOffset** (), **blurRadius** (), and
        **color** ().
        """
        ...

    def color(self) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#color-prop

        **color : QColor**

        This property holds the color of the drop shadow.

        By default, the drop color is a semi-transparent dark gray (**QColor**
        (63, 63, 63, 180)).

        **Access functions:**

        QColor **color** () const
        void **setColor** (const QColor & **color**
        )

        **Notifier signal:**

        void ****colorChanged** ** (const QColor & **color** )

        **See also** **offset** () and **blurRadius** ().
        """
        ...

    def blurRadius(self) -> float:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#blurRadius-prop

        **blurRadius : qreal**

        This property holds the blur radius in pixels of the drop shadow.

        Using a smaller radius results in a sharper shadow, whereas using a
        bigger radius results in a more blurred shadow.

        By default, the blur radius is 1 pixel.

        **Access functions:**

        qreal **blurRadius** () const
        void **setBlurRadius** (qreal
        **blurRadius** )

        **Notifier signal:**

        void ****blurRadiusChanged** ** (qreal **blurRadius** )

        **See also** **color** () and **offset** ().
        """
        ...

    def yOffset(self) -> float:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#yOffset-prop

        **yOffset : qreal**

        This property holds the vertical shadow offset in pixels.

        By default, the vertical shadow offset is 8 pixels.

        **Access functions:**

        qreal **yOffset** () const
        void **setYOffset** (qreal **dy** )

        **Notifier signal:**

        void ****offsetChanged** ** (const QPointF & **offset** )

        **See also** **xOffset** () and **offset** ().

        **Member Function Documentation**
        """
        ...

    def xOffset(self) -> float:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#xOffset-prop

        **xOffset : qreal**

        This property holds the horizontal shadow offset in pixels.

        By default, the horizontal shadow offset is 8 pixels.

        **Access functions:**

        qreal **xOffset** () const
        void **setXOffset** (qreal **dx** )

        **Notifier signal:**

        void ****offsetChanged** ** (const QPointF & **offset** )

        **See also** **yOffset** () and **offset** ().
        """
        ...

    def offset(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#offset-prop

        **offset : QPointF**

        This property holds the shadow offset in pixels.

        By default, the offset is 8 pixels towards the lower right.

        The offset is given in device coordinates, which means it is unaffected
        by scale.

        **Access functions:**

        QPointF **offset** () const
        void **setOffset** (const QPointF &
        **ofs** )
        void **setOffset** (qreal **dx** , qreal **dy** )
        void
        **setOffset** (qreal **d** )

        **Notifier signal:**

        void ****offsetChanged** ** (const QPointF & **offset** )

        **See also** **xOffset** (), **yOffset** (), **blurRadius** (), and
        **color** ().
        """
        ...

    def boundingRectFor(self, rect: QtCore.QRectF) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#boundingRectFor

        **[override virtual] QRectF
        QGraphicsDropShadowEffect::boundingRectFor(const QRectF & rect ) const**

        Reimplements: **QGraphicsEffect::boundingRectFor** (const QRectF &rect)
        const.
        """
        ...

    @property
    def blurRadiusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#blurRadiusChanged

        **[signal] void QGraphicsDropShadowEffect::blurRadiusChanged(qreal
        blurRadius )**

        This signal is emitted whenever the effect's blur radius changes. The
        **blurRadius** parameter holds the effect's new blur radius.

        **Note:** Notifier signal for property **blurRadius** .
        """
        ...

    @property
    def colorChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#colorChanged

        **[signal] void QGraphicsDropShadowEffect::colorChanged(const QColor &
        color )**

        This signal is emitted whenever the effect's color changes. The
        **color** parameter holds the effect's new color.

        **Note:** Notifier signal for property **color** .
        """
        ...

    @property
    def offsetChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsdropshadoweffect.html#offsetChanged

        **[signal] void QGraphicsDropShadowEffect::offsetChanged(const QPointF &
        offset )**

        This signal is emitted whenever the effect's shadow offset changes. The
        **offset** parameter holds the effect's new shadow offset.

        **Note:** Notifier signal for property **offset** . Notifier signal for
        property **xOffset** . Notifier signal for property **yOffset** .
        """
        ...
