"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QGraphicsColorizeEffect(QGraphicsEffect):
    """
    https://doc.qt.io/qt-5/qgraphicscolorizeeffect.html

    **Detailed Description**

    A colorize effect renders the source with a tint of its **color** (). The
    color can be modified using the **setColor** () function.

    By default, the color is light blue (**QColor** (0, 0, 192)).

    ![](images/graphicseffect-colorize.png)

    **See also** **QGraphicsDropShadowEffect** , **QGraphicsBlurEffect** , and
    **QGraphicsOpacityEffect** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicscolorizeeffect.html#QGraphicsColorizeEff
        ect

        **QGraphicsColorizeEffect::QGraphicsColorizeEffect(QObject * parent =
        nullptr)**

        Constructs a new QGraphicsColorizeEffect instance. The **parent**
        parameter is passed to **QGraphicsEffect** 's constructor.
        """
        ...

    def draw(self, painter: QtGui.QPainter) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicscolorizeeffect.html#draw

        **[override virtual protected] void
        QGraphicsColorizeEffect::draw(QPainter * painter )**

        Reimplements: **QGraphicsEffect::draw** (QPainter *painter).
        """
        ...

    def setStrength(self, strength: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicscolorizeeffect.html#strength-prop

        **strength : qreal**

        This property holds the strength of the effect.

        By default, the strength is 1.0. A strength 0.0 equals to no effect,
        while 1.0 means full colorization.

        **Access functions:**

        qreal **strength** () const
        void **setStrength** (qreal **strength** )

        **Notifier signal:**

        void ****strengthChanged** ** (qreal **strength** )

        **Member Function Documentation**
        """
        ...

    def setColor(self, c: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicscolorizeeffect.html#color-prop

        **color : QColor**

        This property holds the color of the effect.

        By default, the color is light blue (**QColor** (0, 0, 192)).

        **Access functions:**

        QColor **color** () const
        void **setColor** (const QColor & **c** )

        **Notifier signal:**

        void ****colorChanged** ** (const QColor & **color** )
        """
        ...

    def strength(self) -> float:
        """
        https://doc.qt.io/qt-5/qgraphicscolorizeeffect.html#strength-prop

        **strength : qreal**

        This property holds the strength of the effect.

        By default, the strength is 1.0. A strength 0.0 equals to no effect,
        while 1.0 means full colorization.

        **Access functions:**

        qreal **strength** () const
        void **setStrength** (qreal **strength** )

        **Notifier signal:**

        void ****strengthChanged** ** (qreal **strength** )

        **Member Function Documentation**
        """
        ...

    def color(self) -> QtGui.QColor:
        """
        https://doc.qt.io/qt-5/qgraphicscolorizeeffect.html#color-prop

        **color : QColor**

        This property holds the color of the effect.

        By default, the color is light blue (**QColor** (0, 0, 192)).

        **Access functions:**

        QColor **color** () const
        void **setColor** (const QColor & **c** )

        **Notifier signal:**

        void ****colorChanged** ** (const QColor & **color** )
        """
        ...

    @property
    def colorChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicscolorizeeffect.html#colorChanged

        **[signal] void QGraphicsColorizeEffect::colorChanged(const QColor &
        color )**

        This signal is emitted whenever the effect's color changes. The
        **color** parameter holds the effect's new color.

        **Note:** Notifier signal for property **color** .
        """
        ...

    @property
    def strengthChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicscolorizeeffect.html#strengthChanged

        **[signal] void QGraphicsColorizeEffect::strengthChanged(qreal strength
        )**

        This signal is emitted whenever **setStrength** () changes the colorize
        strength property. **strength** contains the new strength value of the
        colorize effect.

        **Note:** Notifier signal for property **strength** .
        """
        ...
