"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtWidgets import *
from PyQt5 import sip


class QFileDialog(QDialog):
    """
    https://doc.qt.io/qt-5/qfiledialog.html

    **Detailed Description**

    The QFileDialog class enables a user to traverse the file system in order to
    select one or many files or a directory.

    The easiest way to create a QFileDialog is to use the static functions.

    fileName = **QFileDialog** ::getOpenFileName(this,
            tr("Open Image"),
    "/home/jana", tr("Image Files (*.png *.jpg *.bmp)"));

    In the above example, a modal QFileDialog is created using a static
    function. The dialog initially displays the contents of the "/home/jana"
    directory, and displays files matching the patterns given in the string
    "Image Files (*.png *.jpg *.bmp)". The parent of the file dialog is set to
    **this** , and the window title is set to "Open Image".

    If you want to use multiple filters, separate each one with **two**
    semicolons. For example:

    "Images (*.png *.xpm *.jpg);;Text files (*.txt);;XML files (*.xml)"

    You can create your own QFileDialog without using the static functions. By
    calling **setFileMode** (), you can specify what the user must select in the
    dialog:

    **QFileDialog**  dialog(this);
        dialog.setFileMode(**QFileDialog**
    ::AnyFile);

    In the above example, the mode of the file dialog is set to **AnyFile** ,
    meaning that the user can select any file, or even specify a file that
    doesn't exist. This mode is useful for creating a "Save As" file dialog. Use
    **ExistingFile**  if the user must select an existing file, or **Directory**
    if only a directory may be selected. See the **QFileDialog::FileMode**  enum
    for the complete list of modes.

    The **fileMode**  property contains the mode of operation for the dialog;
    this indicates what types of objects the user is expected to select. Use
    **setNameFilter** () to set the dialog's file filter. For example:

    dialog.setNameFilter(tr("Images (*.png *.xpm *.jpg)"));

    In the above example, the filter is set to `"Images (*.png *.xpm *.jpg)"`,
    this means that only files with the extension `png`, `xpm`, or `jpg` will be
    shown in the QFileDialog. You can apply several filters by using
    **setNameFilters** (). Use **selectNameFilter** () to select one of the
    filters you've given as the file dialog's default filter.

    The file dialog has two view modes: **List**  and **Detail** . **List**
    presents the contents of the current directory as a list of file and
    directory names. **Detail**  also displays a list of file and directory
    names, but provides additional information alongside each name, such as the
    file size and modification date. Set the mode with **setViewMode** ():

    dialog.setViewMode(**QFileDialog** ::Detail);

    The last important function you will need to use when creating your own file
    dialog is **selectedFiles** ().

    **QStringList**  fileNames;
        if (dialog.exec())
            fileNames =
    dialog.selectedFiles();

    In the above example, a modal file dialog is created and shown. If the user
    clicked OK, the file they selected is put in `fileName`.

    The dialog's working directory can be set with **setDirectory** (). Each
    file in the current directory can be selected using the **selectFile** ()
    function.

    The **Standard Dialogs**  example shows how to use QFileDialog as well as
    other built-in Qt dialogs.

    By default, a platform-native file dialog will be used if the platform has
    one. In that case, the widgets which would otherwise be used to construct
    the dialog will not be instantiated, so related accessors such as **layout**
    () and **itemDelegate** () will return null. You can set the
    **DontUseNativeDialog**  option to ensure that the widget-based
    implementation will be used instead of the native dialog.

    **See also** **QDir** , **QFileInfo** , **QFile** , **QColorDialog** ,
    **QFontDialog** , **Standard Dialogs Example** , and **Application Example**
    .
    """

    class Option(int):
        ShowDirsOnly: QFileDialog = ...
        DontResolveSymlinks: QFileDialog = ...
        DontConfirmOverwrite: QFileDialog = ...
        DontUseSheet: QFileDialog = ...
        DontUseNativeDialog: QFileDialog = ...
        ReadOnly: QFileDialog = ...
        HideNameFilterDetails: QFileDialog = ...
        DontUseCustomDirectoryIcons: QFileDialog = ...

    class DialogLabel(int):
        LookIn: QFileDialog = ...
        FileName: QFileDialog = ...
        FileType: QFileDialog = ...
        Accept: QFileDialog = ...
        Reject: QFileDialog = ...

    class AcceptMode(int):
        AcceptOpen: QFileDialog = ...
        AcceptSave: QFileDialog = ...

    class FileMode(int):
        AnyFile: QFileDialog = ...
        ExistingFile: QFileDialog = ...
        Directory: QFileDialog = ...
        ExistingFiles: QFileDialog = ...
        DirectoryOnly: QFileDialog = ...

    class ViewMode(int):
        Detail: QFileDialog = ...
        List: QFileDialog = ...

    class Options(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QFileDialog.Options", "QFileDialog.Option"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QFileDialog.Options") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QFileDialog.Options":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(
        self,
        parent: QWidget,
        f: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#QFileDialog

        **QFileDialog::QFileDialog(QWidget * parent , Qt::WindowFlags flags )**

        Constructs a file dialog with the given **parent** and widget **flags**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        parent: typing.Optional[QWidget] = ...,
        caption: str = ...,
        directory: str = ...,
        filter: str = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#QFileDialog-1

        **QFileDialog::QFileDialog(QWidget * parent = nullptr, const QString &
        caption = QString(), const QString & directory = QString(), const
        QString & filter = QString())**

        Constructs a file dialog with the given **parent** and **caption** that
        initially displays the contents of the specified **directory**. The
        contents of the directory are filtered before being shown in the dialog,
        using a semicolon-separated list of filters specified by **filter**.
        """
        ...

    @staticmethod
    def saveFileContent(
        fileContent: typing.Union[QtCore.QByteArray, bytes, bytearray],
        fileNameHint: str = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#saveFileContent

        **[static] void QFileDialog::saveFileContent(const QByteArray &
        fileContent , const QString & fileNameHint = QString())**

        This is a convenience static function that saves **fileContent** to a
        file, using a file name and location chosen by the user.
        **fileNameHint** can be provided to suggest a file name to the user.

        This function is used to save files to the local file system on Qt for
        WebAssembly, where the web sandbox places restrictions on how such
        access may happen. Its implementation will make the browser display a
        native file dialog, where the user makes the file selection.

        It can also be used on other platforms, where it will fall back to using
        **QFileDialog** .

        The function is asynchronous and returns immediately.

        **QByteArray**  imageData; // obtained from e.g. QImage::save()
        **QFileDialog** ::saveFile("myimage.png", imageData);

        This function was introduced in Qt 5.14.
        """
        ...

    def selectedMimeTypeFilter(self) -> str:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#selectedMimeTypeFilter

        **QString QFileDialog::selectedMimeTypeFilter() const**

        Returns The mimetype of the file that the user selected in the file
        dialog.

        This function was introduced in Qt 5.9.
        """
        ...

    def supportedSchemes(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#supportedSchemes-prop

        **supportedSchemes : QStringList**

        This property holds the URL schemes that the file dialog should allow
        navigating to.

        Setting this property allows to restrict the type of URLs the user will
        be able to select. It is a way for the application to declare the
        protocols it will support to fetch the file content. An empty list means
        that no restriction is applied (the default). Supported for local files
        ("file" scheme) is implicit and always enabled; it is not necessary to
        include it in the restriction.

        This property was introduced in Qt 5.6.

        **Access functions:**

        QStringList **supportedSchemes** () const
        void **setSupportedSchemes**
        (const QStringList & **schemes** )
        """
        ...

    def setSupportedSchemes(self, schemes: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#supportedSchemes-prop

        **supportedSchemes : QStringList**

        This property holds the URL schemes that the file dialog should allow
        navigating to.

        Setting this property allows to restrict the type of URLs the user will
        be able to select. It is a way for the application to declare the
        protocols it will support to fetch the file content. An empty list means
        that no restriction is applied (the default). Supported for local files
        ("file" scheme) is implicit and always enabled; it is not necessary to
        include it in the restriction.

        This property was introduced in Qt 5.6.

        **Access functions:**

        QStringList **supportedSchemes** () const
        void **setSupportedSchemes**
        (const QStringList & **schemes** )
        """
        ...

    @staticmethod
    def getSaveFileUrl(
        parent: typing.Optional[QWidget] = ...,
        caption: str = ...,
        directory: QtCore.QUrl = ...,
        filter: str = ...,
        initialFilter: str = ...,
        options: typing.Union["QFileDialog.Options", "QFileDialog.Option"] = ...,
        supportedSchemes: typing.Iterable[str] = ...,
    ) -> typing.Tuple[QtCore.QUrl, str]:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#getSaveFileUrl

        **[static] QUrl QFileDialog::getSaveFileUrl(QWidget * parent = nullptr,
        const QString & caption = QString(), const QUrl & dir = QUrl(), const
        QString & filter = QString(), QString * selectedFilter = nullptr,
        QFileDialog::Options options = Options(), const QStringList &
        supportedSchemes = QStringList())**

        This is a convenience static function that returns a file selected by
        the user. The file does not have to exist. If the user presses Cancel,
        it returns an empty url.

        The function is used similarly to **QFileDialog::getSaveFileName** ().
        In particular **parent** , **caption** , **dir** , **filter** ,
        **selectedFilter** and **options** are used in the exact same way.

        The main difference with **QFileDialog::getSaveFileName** () comes from
        the ability offered to the user to select a remote file. That's why the
        return type and the type of **dir** is **QUrl** .

        The **supportedSchemes** argument allows to restrict the type of URLs
        the user will be able to select. It is a way for the application to
        declare the protocols it will support to save the file content. An empty
        list means that no restriction is applied (the default). Supported for
        local files ("file" scheme) is implicit and always enabled; it is not
        necessary to include it in the restriction.

        When possible, this static function will use the native file dialog and
        not a **QFileDialog** . On platforms which don't support selecting
        remote files, Qt will allow to select only local files.

        This function was introduced in Qt 5.2.

        **See also** **getSaveFileName** (), **getOpenFileUrl** (),
        **getOpenFileUrls** (), and **getExistingDirectoryUrl** ().
        """
        ...

    @staticmethod
    def getOpenFileUrls(
        parent: typing.Optional[QWidget] = ...,
        caption: str = ...,
        directory: QtCore.QUrl = ...,
        filter: str = ...,
        initialFilter: str = ...,
        options: typing.Union["QFileDialog.Options", "QFileDialog.Option"] = ...,
        supportedSchemes: typing.Iterable[str] = ...,
    ) -> typing.Tuple[typing.List[QtCore.QUrl], str]:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#getOpenFileUrls

        **[static] QList<QUrl> QFileDialog::getOpenFileUrls(QWidget * parent =
        nullptr, const QString & caption = QString(), const QUrl & dir = QUrl(),
        const QString & filter = QString(), QString * selectedFilter = nullptr,
        QFileDialog::Options options = Options(), const QStringList &
        supportedSchemes = QStringList())**

        This is a convenience static function that will return one or more
        existing files selected by the user. If the user presses Cancel, it
        returns an empty list.

        The function is used similarly to **QFileDialog::getOpenFileNames** ().
        In particular **parent** , **caption** , **dir** , **filter** ,
        **selectedFilter** and **options** are used in the exact same way.

        The main difference with **QFileDialog::getOpenFileNames** () comes from
        the ability offered to the user to select remote files. That's why the
        return type and the type of **dir** are respectively **QList** <**QUrl**
        > and **QUrl** .

        The **supportedSchemes** argument allows to restrict the type of URLs
        the user will be able to select. It is a way for the application to
        declare the protocols it will support to fetch the file content. An
        empty list means that no restriction is applied (the default). Supported
        for local files ("file" scheme) is implicit and always enabled; it is
        not necessary to include it in the restriction.

        When possible, this static function will use the native file dialog and
        not a **QFileDialog** . On platforms which don't support selecting
        remote files, Qt will allow to select only local files.

        This function was introduced in Qt 5.2.

        **See also** **getOpenFileNames** (), **getOpenFileUrl** (),
        **getSaveFileUrl** (), and **getExistingDirectoryUrl** ().
        """
        ...

    @staticmethod
    def getOpenFileUrl(
        parent: typing.Optional[QWidget] = ...,
        caption: str = ...,
        directory: QtCore.QUrl = ...,
        filter: str = ...,
        initialFilter: str = ...,
        options: typing.Union["QFileDialog.Options", "QFileDialog.Option"] = ...,
        supportedSchemes: typing.Iterable[str] = ...,
    ) -> typing.Tuple[QtCore.QUrl, str]:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#getOpenFileUrl

        **[static] QUrl QFileDialog::getOpenFileUrl(QWidget * parent = nullptr,
        const QString & caption = QString(), const QUrl & dir = QUrl(), const
        QString & filter = QString(), QString * selectedFilter = nullptr,
        QFileDialog::Options options = Options(), const QStringList &
        supportedSchemes = QStringList())**

        This is a convenience static function that returns an existing file
        selected by the user. If the user presses Cancel, it returns an empty
        url.

        The function is used similarly to **QFileDialog::getOpenFileName** ().
        In particular **parent** , **caption** , **dir** , **filter** ,
        **selectedFilter** and **options** are used in the exact same way.

        The main difference with **QFileDialog::getOpenFileName** () comes from
        the ability offered to the user to select a remote file. That's why the
        return type and the type of **dir** is **QUrl** .

        The **supportedSchemes** argument allows to restrict the type of URLs
        the user will be able to select. It is a way for the application to
        declare the protocols it will support to fetch the file content. An
        empty list means that no restriction is applied (the default). Supported
        for local files ("file" scheme) is implicit and always enabled; it is
        not necessary to include it in the restriction.

        When possible, this static function will use the native file dialog and
        not a **QFileDialog** . On platforms which don't support selecting
        remote files, Qt will allow to select only local files.

        This function was introduced in Qt 5.2.

        **See also** **getOpenFileName** (), **getOpenFileUrls** (),
        **getSaveFileUrl** (), and **getExistingDirectoryUrl** ().
        """
        ...

    def selectMimeTypeFilter(self, filter: str) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#selectMimeTypeFilter

        **void QFileDialog::selectMimeTypeFilter(const QString & filter )**

        Sets the current MIME type **filter**.

        This function was introduced in Qt 5.2.
        """
        ...

    def mimeTypeFilters(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#mimeTypeFilters

        **QStringList QFileDialog::mimeTypeFilters() const**

        Returns the MIME type filters that are in operation on this file dialog.

        This function was introduced in Qt 5.2.

        **See also** **setMimeTypeFilters** ().
        """
        ...

    def setMimeTypeFilters(self, filters: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setMimeTypeFilters

        **void QFileDialog::setMimeTypeFilters(const QStringList & filters )**

        Sets the **filters** used in the file dialog, from a list of MIME types.

        Convenience method for **setNameFilters** (). Uses **QMimeType**  to
        create a name filter from the glob patterns and description defined in
        each MIME type.

        Use application/octet-stream for the "All files (*)" filter, since that
        is the base MIME type for all files.

        Calling setMimeTypeFilters overrides any previously set name filters,
        and changes the return value of **nameFilters** ().

        **QStringList**  mimeTypeFilters({"image/jpeg", // will show "JPEG image
        (*.jpeg *.jpg *.jpe)
                                         "image/png",  //
        will show "PNG image (*.png)"
        "application/octet-stream" // will show "All files (*)"
        });

            **QFileDialog**  dialog(this);
        dialog.setMimeTypeFilters(mimeTypeFilters);
            dialog.exec();

        This function was introduced in Qt 5.2.

        **See also** **mimeTypeFilters** ().
        """
        ...

    def selectedUrls(self) -> typing.List[QtCore.QUrl]:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#selectedUrls

        **QList<QUrl> QFileDialog::selectedUrls() const**

        Returns a list of urls containing the selected files in the dialog. If
        no files are selected, or the mode is not **ExistingFiles**  or
        **ExistingFile** , selectedUrls() contains the current path in the
        viewport.

        This function was introduced in Qt 5.2.

        **See also** **selectedNameFilter** () and **selectUrl** ().
        """
        ...

    def selectUrl(self, url: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#selectUrl

        **void QFileDialog::selectUrl(const QUrl & url )**

        Selects the given **url** in the file dialog.

        **Note:** The non-native **QFileDialog**  supports only local files.

        This function was introduced in Qt 5.2.

        **See also** **selectedUrls** ().
        """
        ...

    def directoryUrl(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#directoryUrl

        **QUrl QFileDialog::directoryUrl() const**

        Returns the url of the directory currently being displayed in the
        dialog.

        This function was introduced in Qt 5.2.

        **See also** **setDirectoryUrl** ().
        """
        ...

    def setDirectoryUrl(self, directory: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setDirectoryUrl

        **void QFileDialog::setDirectoryUrl(const QUrl & directory )**

        Sets the file dialog's current **directory** url.

        **Note:** The non-native **QFileDialog**  supports only local files.

        **Note:** On Windows, it is possible to pass URLs representing one of
        the **virtual folders** , such as "Computer" or "Network". This is done
        by passing a **QUrl**  using the scheme `clsid` followed by the CLSID
        value with the curly braces removed. For example the URL
        `clsid:374DE290-123F-4565-9164-39C4925E467B` denotes the download
        location. For a complete list of possible values, see the MSDN
        documentation on **KNOWNFOLDERID** . This feature was added in Qt 5.5.

        This function was introduced in Qt 5.2.

        **See also** **directoryUrl** () and **QUuid** .
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setVisible

        **[override virtual] void QFileDialog::setVisible(bool visible )**

        Reimplements: **QDialog::setVisible** (bool visible).
        """
        ...

    @typing.overload
    def open(self) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#open

        **void QFileDialog::open(QObject * receiver , const char * member )**

        This function connects one of its signals to the slot specified by
        **receiver** and **member**. The specific signal depends is
        **filesSelected** () if **fileMode**  is **ExistingFiles**  and
        **fileSelected** () if **fileMode**  is anything else.

        The signal will be disconnected from the slot when the dialog is closed.

        This function was introduced in Qt 4.5.
        """
        ...

    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#open

        **void QFileDialog::open(QObject * receiver , const char * member )**

        This function connects one of its signals to the slot specified by
        **receiver** and **member**. The specific signal depends is
        **filesSelected** () if **fileMode**  is **ExistingFiles**  and
        **fileSelected** () if **fileMode**  is anything else.

        The signal will be disconnected from the slot when the dialog is closed.

        This function was introduced in Qt 4.5.
        """
        ...

    def options(self) -> "QFileDialog.Options":
        """
        https://doc.qt.io/qt-5/qfiledialog.html#options-prop

        **options : Options**

        This property holds the various options that affect the look and feel of
        the dialog

        By default, all options are disabled.

        Options (particularly the DontUseNativeDialogs option) should be set
        before changing dialog properties or showing the dialog.

        Setting options while the dialog is visible is not guaranteed to have an
        immediate effect on the dialog (depending on the option and on the
        platform).

        Setting options after changing other properties may cause these values
        to have no effect.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QFileDialog::Options **options** () const
        void **setOptions**
        (QFileDialog::Options **options** )

        **See also** **setOption** () and **testOption** ().
        """
        ...

    def setOptions(
        self, options: typing.Union["QFileDialog.Options", "QFileDialog.Option"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#options-prop

        **options : Options**

        This property holds the various options that affect the look and feel of
        the dialog

        By default, all options are disabled.

        Options (particularly the DontUseNativeDialogs option) should be set
        before changing dialog properties or showing the dialog.

        Setting options while the dialog is visible is not guaranteed to have an
        immediate effect on the dialog (depending on the option and on the
        platform).

        Setting options after changing other properties may cause these values
        to have no effect.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QFileDialog::Options **options** () const
        void **setOptions**
        (QFileDialog::Options **options** )

        **See also** **setOption** () and **testOption** ().
        """
        ...

    def testOption(self, option: "QFileDialog.Option") -> bool:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#testOption

        **bool QFileDialog::testOption(QFileDialog::Option option ) const**

        Returns `true` if the given **option** is enabled; otherwise, returns
        false.

        This function was introduced in Qt 4.5.

        **See also** **options**  and **setOption** ().
        """
        ...

    def setOption(self, option: "QFileDialog.Option", on: bool = ...) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setOption

        **void QFileDialog::setOption(QFileDialog::Option option , bool on =
        true)**

        Sets the given **option** to be enabled if **on** is true; otherwise,
        clears the given **option**.

        Options (particularly the DontUseNativeDialogs option) should be set
        before changing dialog properties or showing the dialog.

        Setting options while the dialog is visible is not guaranteed to have an
        immediate effect on the dialog (depending on the option and on the
        platform).

        Setting options after changing other properties may cause these values
        to have no effect.

        This function was introduced in Qt 4.5.

        **See also** **options**  and **testOption** ().
        """
        ...

    def setFilter(
        self, filters: typing.Union[QtCore.QDir.Filters, QtCore.QDir.Filter]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setFilter

        **void QFileDialog::setFilter(QDir::Filters filters )**

        Sets the filter used by the model to **filters**. The filter is used to
        specify the kind of files that should be shown.

        This function was introduced in Qt 4.4.

        **See also** **filter** ().
        """
        ...

    def filter(self) -> QtCore.QDir.Filters:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#filter

        **QDir::Filters QFileDialog::filter() const**

        Returns the filter that is used when displaying files.

        This function was introduced in Qt 4.4.

        **See also** **setFilter** ().
        """
        ...

    def selectedNameFilter(self) -> str:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#selectedNameFilter

        **QString QFileDialog::selectedNameFilter() const**

        Returns the filter that the user selected in the file dialog.

        This function was introduced in Qt 4.4.

        **See also** **selectedFiles** ().
        """
        ...

    def selectNameFilter(self, filter: str) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#selectNameFilter

        **void QFileDialog::selectNameFilter(const QString & filter )**

        Sets the current file type **filter**. Multiple filters can be passed in
        **filter** by separating them with semicolons or spaces.

        This function was introduced in Qt 4.4.

        **See also** **setNameFilter** (), **setNameFilters** (), and
        **selectedNameFilter** ().
        """
        ...

    def nameFilters(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#nameFilters

        **QStringList QFileDialog::nameFilters() const**

        Returns the file type filters that are in operation on this file dialog.

        This function was introduced in Qt 4.4.

        **See also** **setNameFilters** ().
        """
        ...

    def setNameFilters(self, filters: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setNameFilters

        **void QFileDialog::setNameFilters(const QStringList & filters )**

        Sets the **filters** used in the file dialog.

        Note that the filter ***.*** is not portable, because the historical
        assumption that the file extension determines the file type is not
        consistent on every operating system. It is possible to have a file with
        no dot in its name (for example, `Makefile`). In a native Windows file
        dialog, ***.*** will match such files, while in other types of file
        dialogs it may not. So it is better to use ***** if you mean to select
        any file.

        const **QStringList**  filters({"Image files (*.png *.xpm *.jpg)",
        "Text files (*.txt)",
                                       "Any files (*)"
        });
            **QFileDialog**  dialog(this);
        dialog.setNameFilters(filters);
            dialog.exec();

        **setMimeTypeFilters** () has the advantage of providing all possible
        name filters for each file type. For example, JPEG images have three
        possible extensions; if your application can open such files, selecting
        the `image/jpeg` mime type as a filter will allow you to open all of
        them.

        This function was introduced in Qt 4.4.

        **See also** **nameFilters** ().
        """
        ...

    def setNameFilter(self, filter: str) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setNameFilter

        **void QFileDialog::setNameFilter(const QString & filter )**

        Sets the filter used in the file dialog to the given **filter**.

        If **filter** contains a pair of parentheses containing one or more
        filename-wildcard patterns, separated by spaces, then only the text
        contained in the parentheses is used as the filter. This means that
        these calls are all equivalent:

        dialog.setNameFilter("All C++ files (*.cpp *.cc *.C *.cxx *.c++)");
        dialog.setNameFilter("*.cpp *.cc *.C *.cxx *.c++");

        **Note:** With Android's native file dialog, the mime type matching the
        given name filter is used because only mime types are supported.

        This function was introduced in Qt 4.4.

        **See also** **setMimeTypeFilters** () and **setNameFilters** ().
        """
        ...

    def proxyModel(self) -> QtCore.QAbstractProxyModel:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#proxyModel

        **QAbstractProxyModel *QFileDialog::proxyModel() const**

        Returns the proxy model used by the file dialog. By default no proxy is
        set.

        **See also** **setProxyModel** ().
        """
        ...

    def setProxyModel(self, model: QtCore.QAbstractProxyModel) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setProxyModel

        **void QFileDialog::setProxyModel(QAbstractProxyModel * proxyModel )**

        Sets the model for the views to the given **proxyModel**. This is useful
        if you want to modify the underlying model; for example, to add columns,
        filter data or add drives.

        Any existing proxy model will be removed, but not deleted. The file
        dialog will take ownership of the **proxyModel**.

        This function was introduced in Qt 4.3.

        **See also** **proxyModel** ().
        """
        ...

    def restoreState(
        self, state: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#restoreState

        **bool QFileDialog::restoreState(const QByteArray & state )**

        Restores the dialogs's layout, history and current directory to the
        **state** specified.

        Typically this is used in conjunction with **QSettings**  to restore the
        size from a past session.

        Returns `false` if there are errors

        This function was introduced in Qt 4.3.
        """
        ...

    def saveState(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#saveState

        **QByteArray QFileDialog::saveState() const**

        Saves the state of the dialog's layout, history and current directory.

        Typically this is used in conjunction with **QSettings**  to remember
        the size for a future session. A version number is stored as part of the
        data.

        This function was introduced in Qt 4.3.
        """
        ...

    def sidebarUrls(self) -> typing.List[QtCore.QUrl]:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#sidebarUrls

        **QList<QUrl> QFileDialog::sidebarUrls() const**

        Returns a list of urls that are currently in the sidebar

        This function was introduced in Qt 4.3.

        **See also** **setSidebarUrls** ().
        """
        ...

    def setSidebarUrls(self, urls: typing.Iterable[QtCore.QUrl]) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setSidebarUrls

        **void QFileDialog::setSidebarUrls(const QList<QUrl> & urls )**

        Sets the **urls** that are located in the sidebar.

        For instance:

        **QList** <**QUrl** > urls;
                urls << **QUrl**
        ::fromLocalFile("/Users/foo/Code/qt5")
                     << **QUrl**
        ::fromLocalFile(**QStandardPaths**
        ::standardLocations(**QStandardPaths** ::MusicLocation).first());
        **QFileDialog**  dialog;
                dialog.setSidebarUrls(urls);
        dialog.setFileMode(**QFileDialog** ::AnyFile);
                if(dialog.exec())
        {
                    // ...
                }

        The file dialog will then look like this:

        ![](images/filedialogurls.png)

        This function was introduced in Qt 4.3.

        **See also** **sidebarUrls** ().
        """
        ...

    def changeEvent(self, e: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#changeEvent

        **[override virtual protected] void QFileDialog::changeEvent(QEvent * e
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def accept(self) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#accept

        **[override virtual protected] void QFileDialog::accept()**

        Reimplements: **QDialog::accept** ().
        """
        ...

    def done(self, result: int) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#done

        **[override virtual protected] void QFileDialog::done(int result )**

        Reimplements: **QDialog::done** (int r).
        """
        ...

    @staticmethod
    def getSaveFileName(
        parent: typing.Optional[QWidget] = ...,
        caption: str = ...,
        directory: str = ...,
        filter: str = ...,
        initialFilter: str = ...,
        options: typing.Union["QFileDialog.Options", "QFileDialog.Option"] = ...,
    ) -> typing.Tuple[str, str]:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#getSaveFileName

        **[static] QString QFileDialog::getSaveFileName(QWidget * parent =
        nullptr, const QString & caption = QString(), const QString & dir =
        QString(), const QString & filter = QString(), QString * selectedFilter
        = nullptr, QFileDialog::Options options = Options())**

        This is a convenience static function that will return a file name
        selected by the user. The file does not have to exist.

        It creates a modal file dialog with the given **parent** widget. If
        **parent** is not `nullptr`, the dialog will be shown centered over the
        parent widget.

        **QString**  fileName = **QFileDialog** ::getSaveFileName(this, tr("Save
        File"),
                                       "/home/jana/untitled.png",
        tr("Images (*.png *.xpm *.jpg)"));

        The file dialog's working directory will be set to **dir**. If **dir**
        includes a file name, the file will be selected. Only files that match
        the **filter** are shown. The filter selected is set to
        **selectedFilter**. The parameters **dir** , **selectedFilter** , and
        **filter** may be empty strings. Multiple filters are separated with
        ';;'. For instance:

        "Images (*.png *.xpm *.jpg);;Text files (*.txt);;XML files (*.xml)"

        The **options** argument holds various options about how to run the
        dialog, see the **QFileDialog::Option**  enum for more information on
        the flags you can pass.

        The default filter can be chosen by setting **selectedFilter** to the
        desired value.

        The dialog's caption is set to **caption**. If **caption** is not
        specified, a default caption will be used.

        On Windows, and macOS, this static function will use the native file
        dialog and not a **QFileDialog** .

        On Windows the dialog will spin a blocking modal event loop that will
        not dispatch any QTimers, and if **parent** is not `nullptr` then it
        will position the dialog just below the parent's title bar. On macOS,
        with its native file dialog, the filter argument is ignored.

        On Unix/X11, the normal behavior of the file dialog is to resolve and
        follow symlinks. For example, if `/usr/tmp` is a symlink to `/var/tmp`,
        the file dialog will change to `/var/tmp` after entering `/usr/tmp`. If
        **options** includes **DontResolveSymlinks**  the file dialog will treat
        symlinks as regular directories.

        **Warning:** Do not delete **parent** during the execution of the
        dialog. If you want to do this, you should create the dialog yourself
        using one of the **QFileDialog**  constructors.

        **See also** **getOpenFileName** (), **getOpenFileNames** (), and
        **getExistingDirectory** ().
        """
        ...

    @staticmethod
    def getOpenFileNames(
        parent: typing.Optional[QWidget] = ...,
        caption: str = ...,
        directory: str = ...,
        filter: str = ...,
        initialFilter: str = ...,
        options: typing.Union["QFileDialog.Options", "QFileDialog.Option"] = ...,
    ) -> typing.Tuple[typing.List[str], str]:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#getOpenFileNames

        **[static] QStringList QFileDialog::getOpenFileNames(QWidget * parent =
        nullptr, const QString & caption = QString(), const QString & dir =
        QString(), const QString & filter = QString(), QString * selectedFilter
        = nullptr, QFileDialog::Options options = Options())**

        This is a convenience static function that will return one or more
        existing files selected by the user.

        **QStringList**  files = **QFileDialog** ::getOpenFileNames(
        this,
                                    "Select one or more files to open",
        "/home",
                                    "Images (*.png *.xpm *.jpg)");

        This function creates a modal file dialog with the given **parent**
        widget. If **parent** is not `nullptr`, the dialog will be shown
        centered over the parent widget.

        The file dialog's working directory will be set to **dir**. If **dir**
        includes a file name, the file will be selected. The filter is set to
        **filter** so that only those files which match the filter are shown.
        The filter selected is set to **selectedFilter**. The parameters **dir**
        , **selectedFilter** and **filter** may be empty strings. If you need
        multiple filters, separate them with ';;', for instance:

        "Images (*.png *.xpm *.jpg);;Text files (*.txt);;XML files (*.xml)"

        The dialog's caption is set to **caption**. If **caption** is not
        specified then a default caption will be used.

        On Windows, and macOS, this static function will use the native file
        dialog and not a **QFileDialog** .

        On Windows the dialog will spin a blocking modal event loop that will
        not dispatch any QTimers, and if **parent** is not `nullptr` then it
        will position the dialog just below the parent's title bar.

        On Unix/X11, the normal behavior of the file dialog is to resolve and
        follow symlinks. For example, if `/usr/tmp` is a symlink to `/var/tmp`,
        the file dialog will change to `/var/tmp` after entering `/usr/tmp`. The
        **options** argument holds various options about how to run the dialog,
        see the **QFileDialog::Option**  enum for more information on the flags
        you can pass.

        **Warning:** Do not delete **parent** during the execution of the
        dialog. If you want to do this, you should create the dialog yourself
        using one of the **QFileDialog**  constructors.

        **See also** **getOpenFileName** (), **getSaveFileName** (), and
        **getExistingDirectory** ().
        """
        ...

    @staticmethod
    def getOpenFileName(
        parent: typing.Optional[QWidget] = ...,
        caption: str = ...,
        directory: str = ...,
        filter: str = ...,
        initialFilter: str = ...,
        options: typing.Union["QFileDialog.Options", "QFileDialog.Option"] = ...,
    ) -> typing.Tuple[str, str]:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#getOpenFileName

        **[static] QString QFileDialog::getOpenFileName(QWidget * parent =
        nullptr, const QString & caption = QString(), const QString & dir =
        QString(), const QString & filter = QString(), QString * selectedFilter
        = nullptr, QFileDialog::Options options = Options())**

        This is a convenience static function that returns an existing file
        selected by the user. If the user presses Cancel, it returns a null
        string.

        **QString**  fileName = **QFileDialog** ::getOpenFileName(this, tr("Open
        File"),
                                                            "/home",
        tr("Images (*.png *.xpm *.jpg)"));

        The function creates a modal file dialog with the given **parent**
        widget. If **parent** is not `nullptr`, the dialog will be shown
        centered over the parent widget.

        The file dialog's working directory will be set to **dir**. If **dir**
        includes a file name, the file will be selected. Only files that match
        the given **filter** are shown. The filter selected is set to
        **selectedFilter**. The parameters **dir** , **selectedFilter** , and
        **filter** may be empty strings. If you want multiple filters, separate
        them with ';;', for example:

        "Images (*.png *.xpm *.jpg);;Text files (*.txt);;XML files (*.xml)"

        The **options** argument holds various options about how to run the
        dialog, see the **QFileDialog::Option**  enum for more information on
        the flags you can pass.

        The dialog's caption is set to **caption**. If **caption** is not
        specified then a default caption will be used.

        On Windows, and macOS, this static function will use the native file
        dialog and not a **QFileDialog** .

        On Windows the dialog will spin a blocking modal event loop that will
        not dispatch any QTimers, and if **parent** is not `nullptr` then it
        will position the dialog just below the parent's title bar.

        On Unix/X11, the normal behavior of the file dialog is to resolve and
        follow symlinks. For example, if `/usr/tmp` is a symlink to `/var/tmp`,
        the file dialog will change to `/var/tmp` after entering `/usr/tmp`. If
        **options** includes **DontResolveSymlinks** , the file dialog will
        treat symlinks as regular directories.

        **Warning:** Do not delete **parent** during the execution of the
        dialog. If you want to do this, you should create the dialog yourself
        using one of the **QFileDialog**  constructors.

        **See also** **getOpenFileNames** (), **getSaveFileName** (), and
        **getExistingDirectory** ().
        """
        ...

    @staticmethod
    def getExistingDirectoryUrl(
        parent: typing.Optional[QWidget] = ...,
        caption: str = ...,
        directory: QtCore.QUrl = ...,
        options: typing.Union["QFileDialog.Options", "QFileDialog.Option"] = ...,
        supportedSchemes: typing.Iterable[str] = ...,
    ) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#getExistingDirectoryUrl

        **[static] QUrl QFileDialog::getExistingDirectoryUrl(QWidget * parent =
        nullptr, const QString & caption = QString(), const QUrl & dir = QUrl(),
        QFileDialog::Options options = ShowDirsOnly, const QStringList &
        supportedSchemes = QStringList())**

        This is a convenience static function that will return an existing
        directory selected by the user. If the user presses Cancel, it returns
        an empty url.

        The function is used similarly to **QFileDialog::getExistingDirectory**
        (). In particular **parent** , **caption** , **dir** and **options** are
        used in the exact same way.

        The main difference with **QFileDialog::getExistingDirectory** () comes
        from the ability offered to the user to select a remote directory.
        That's why the return type and the type of **dir** is **QUrl** .

        The **supportedSchemes** argument allows to restrict the type of URLs
        the user will be able to select. It is a way for the application to
        declare the protocols it will support to fetch the file content. An
        empty list means that no restriction is applied (the default). Supported
        for local files ("file" scheme) is implicit and always enabled; it is
        not necessary to include it in the restriction.

        When possible, this static function will use the native file dialog and
        not a **QFileDialog** . On platforms which don't support selecting
        remote files, Qt will allow to select only local files.

        This function was introduced in Qt 5.2.

        **See also** **getExistingDirectory** (), **getOpenFileUrl** (),
        **getOpenFileUrls** (), and **getSaveFileUrl** ().
        """
        ...

    @staticmethod
    def getExistingDirectory(
        parent: typing.Optional[QWidget] = ...,
        caption: str = ...,
        directory: str = ...,
        options: typing.Union["QFileDialog.Options", "QFileDialog.Option"] = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#getExistingDirectory

        **[static] QString QFileDialog::getExistingDirectory(QWidget * parent =
        nullptr, const QString & caption = QString(), const QString & dir =
        QString(), QFileDialog::Options options = ShowDirsOnly)**

        This is a convenience static function that will return an existing
        directory selected by the user.

        **QString**  dir = **QFileDialog** ::getExistingDirectory(this, tr("Open
        Directory"),
        "/home",
        **QFileDialog** ::ShowDirsOnly
        | **QFileDialog** ::DontResolveSymlinks);

        This function creates a modal file dialog with the given **parent**
        widget. If **parent** is not `nullptr`, the dialog will be shown
        centered over the parent widget.

        The dialog's working directory is set to **dir** , and the caption is
        set to **caption**. Either of these may be an empty string in which case
        the current directory and a default caption will be used respectively.

        The **options** argument holds various options about how to run the
        dialog, see the **QFileDialog::Option**  enum for more information on
        the flags you can pass. To ensure a native file dialog, **ShowDirsOnly**
        must be set.

        On Windows and macOS, this static function will use the native file
        dialog and not a **QFileDialog** . However, the native Windows file
        dialog does not support displaying files in the directory chooser. You
        need to pass **DontUseNativeDialog**  to display files using a
        **QFileDialog** .

        On Unix/X11, the normal behavior of the file dialog is to resolve and
        follow symlinks. For example, if `/usr/tmp` is a symlink to `/var/tmp`,
        the file dialog will change to `/var/tmp` after entering `/usr/tmp`. If
        **options** includes **DontResolveSymlinks** , the file dialog will
        treat symlinks as regular directories.

        On Windows, the dialog will spin a blocking modal event loop that will
        not dispatch any QTimers, and if **parent** is not `nullptr` then it
        will position the dialog just below the parent's title bar.

        **Warning:** Do not delete **parent** during the execution of the
        dialog. If you want to do this, you should create the dialog yourself
        using one of the **QFileDialog**  constructors.

        **See also** **getOpenFileName** (), **getOpenFileNames** (), and
        **getSaveFileName** ().
        """
        ...

    def labelText(self, label: "QFileDialog.DialogLabel") -> str:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#labelText

        **QString QFileDialog::labelText(QFileDialog::DialogLabel label )
        const**

        Returns the text shown in the filedialog in the specified **label**.

        **See also** **setLabelText** ().
        """
        ...

    def setLabelText(self, label: "QFileDialog.DialogLabel", text: str) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setLabelText

        **void QFileDialog::setLabelText(QFileDialog::DialogLabel label , const
        QString & text )**

        Sets the **text** shown in the filedialog in the specified **label**.

        **See also** **labelText** ().
        """
        ...

    def iconProvider(self) -> "QFileIconProvider":
        """
        https://doc.qt.io/qt-5/qfiledialog.html#iconProvider

        **QFileIconProvider *QFileDialog::iconProvider() const**

        Returns the icon provider used by the filedialog.

        **See also** **setIconProvider** ().
        """
        ...

    def setIconProvider(self, provider: "QFileIconProvider") -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setIconProvider

        **void QFileDialog::setIconProvider(QFileIconProvider * provider )**

        Sets the icon provider used by the filedialog to the specified
        **provider**.

        **See also** **iconProvider** ().
        """
        ...

    def itemDelegate(self) -> QAbstractItemDelegate:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#itemDelegate

        **QAbstractItemDelegate *QFileDialog::itemDelegate() const**

        Returns the item delegate used to render the items in the views in the
        filedialog.

        **See also** **setItemDelegate** ().
        """
        ...

    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setItemDelegate

        **void QFileDialog::setItemDelegate(QAbstractItemDelegate * delegate )**

        Sets the item delegate used to render items in the views in the file
        dialog to the given **delegate**.

        **Warning:** You should not share the same instance of a delegate
        between views. Doing so can cause incorrect or unintuitive editing
        behavior since each view connected to a given delegate may receive the
        **closeEditor()**  signal, and attempt to access, modify or close an
        editor that has already been closed.

        Note that the model used is **QFileSystemModel** . It has custom item
        data roles, which is described by the **Roles**  enum. You can use a
        **QFileIconProvider**  if you only want custom icons.

        **See also** **itemDelegate** (), **setIconProvider** (), and
        **QFileSystemModel** .
        """
        ...

    def history(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#history

        **QStringList QFileDialog::history() const**

        Returns the browsing history of the filedialog as a list of paths.

        **See also** **setHistory** ().
        """
        ...

    def setHistory(self, paths: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setHistory

        **void QFileDialog::setHistory(const QStringList & paths )**

        Sets the browsing history of the filedialog to contain the given
        **paths**.

        **See also** **history** ().
        """
        ...

    def defaultSuffix(self) -> str:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#defaultSuffix-prop

        **defaultSuffix : QString**

        suffix added to the filename if no other suffix was specified

        This property specifies a string that will be added to the filename if
        it has no suffix already. The suffix is typically used to indicate the
        file type (e.g. "txt" indicates a text file).

        If the first character is a dot ('.'), it is removed.

        **Access functions:**

        QString **defaultSuffix** () const
        void **setDefaultSuffix** (const
        QString & **suffix** )
        """
        ...

    def setDefaultSuffix(self, suffix: str) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#defaultSuffix-prop

        **defaultSuffix : QString**

        suffix added to the filename if no other suffix was specified

        This property specifies a string that will be added to the filename if
        it has no suffix already. The suffix is typically used to indicate the
        file type (e.g. "txt" indicates a text file).

        If the first character is a dot ('.'), it is removed.

        **Access functions:**

        QString **defaultSuffix** () const
        void **setDefaultSuffix** (const
        QString & **suffix** )
        """
        ...

    def acceptMode(self) -> "QFileDialog.AcceptMode":
        """
        https://doc.qt.io/qt-5/qfiledialog.html#acceptMode-prop

        **acceptMode : AcceptMode**

        This property holds the accept mode of the dialog

        The action mode defines whether the dialog is for opening or saving
        files.

        By default, this property is set to **AcceptOpen** .

        **Access functions:**

        QFileDialog::AcceptMode **acceptMode** () const
        void **setAcceptMode**
        (QFileDialog::AcceptMode **mode** )

        **See also** **AcceptMode** .
        """
        ...

    def setAcceptMode(self, mode: "QFileDialog.AcceptMode") -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#acceptMode-prop

        **acceptMode : AcceptMode**

        This property holds the accept mode of the dialog

        The action mode defines whether the dialog is for opening or saving
        files.

        By default, this property is set to **AcceptOpen** .

        **Access functions:**

        QFileDialog::AcceptMode **acceptMode** () const
        void **setAcceptMode**
        (QFileDialog::AcceptMode **mode** )

        **See also** **AcceptMode** .
        """
        ...

    def fileMode(self) -> "QFileDialog.FileMode":
        """
        https://doc.qt.io/qt-5/qfiledialog.html#fileMode-prop

        **fileMode : FileMode**

        This property holds the file mode of the dialog

        The file mode defines the number and type of items that the user is
        expected to select in the dialog.

        By default, this property is set to **AnyFile** .

        This function will set the labels for the **FileName**  and **Accept**
        **DialogLabel** s. It is possible to set custom text after the call to
        setFileMode().

        **Access functions:**

        QFileDialog::FileMode **fileMode** () const
        void **setFileMode**
        (QFileDialog::FileMode **mode** )

        **See also** **FileMode** .
        """
        ...

    def setFileMode(self, mode: "QFileDialog.FileMode") -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#fileMode-prop

        **fileMode : FileMode**

        This property holds the file mode of the dialog

        The file mode defines the number and type of items that the user is
        expected to select in the dialog.

        By default, this property is set to **AnyFile** .

        This function will set the labels for the **FileName**  and **Accept**
        **DialogLabel** s. It is possible to set custom text after the call to
        setFileMode().

        **Access functions:**

        QFileDialog::FileMode **fileMode** () const
        void **setFileMode**
        (QFileDialog::FileMode **mode** )

        **See also** **FileMode** .
        """
        ...

    def viewMode(self) -> "QFileDialog.ViewMode":
        """
        https://doc.qt.io/qt-5/qfiledialog.html#viewMode-prop

        **viewMode : ViewMode**

        This property holds the way files and directories are displayed in the
        dialog

        By default, the `Detail` mode is used to display information about files
        and directories.

        **Access functions:**

        QFileDialog::ViewMode **viewMode** () const
        void **setViewMode**
        (QFileDialog::ViewMode **mode** )

        **See also** **ViewMode** .

        **Member Function Documentation**
        """
        ...

    def setViewMode(self, mode: "QFileDialog.ViewMode") -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#viewMode-prop

        **viewMode : ViewMode**

        This property holds the way files and directories are displayed in the
        dialog

        By default, the `Detail` mode is used to display information about files
        and directories.

        **Access functions:**

        QFileDialog::ViewMode **viewMode** () const
        void **setViewMode**
        (QFileDialog::ViewMode **mode** )

        **See also** **ViewMode** .

        **Member Function Documentation**
        """
        ...

    def selectedFiles(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#selectedFiles

        **QStringList QFileDialog::selectedFiles() const**

        Returns a list of strings containing the absolute paths of the selected
        files in the dialog. If no files are selected, or the mode is not
        **ExistingFiles**  or **ExistingFile** , selectedFiles() contains the
        current path in the viewport.

        **See also** **selectedNameFilter** () and **selectFile** ().
        """
        ...

    def selectFile(self, filename: str) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#selectFile

        **void QFileDialog::selectFile(const QString & filename )**

        Selects the given **filename** in the file dialog.

        **See also** **selectedFiles** ().
        """
        ...

    def directory(self) -> QtCore.QDir:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#directory

        **QDir QFileDialog::directory() const**

        Returns the directory currently being displayed in the dialog.

        **See also** **setDirectory** ().
        """
        ...

    @typing.overload
    def setDirectory(self, directory: str) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setDirectory

        **void QFileDialog::setDirectory(const QString & directory )**

        Sets the file dialog's current **directory**.

        **Note:** On iOS, if you set **directory** to **QStandardPaths::standard
        Locations(QStandardPaths::PicturesLocation).last()** , a native image
        picker dialog will be used for accessing the user's photo album. The
        filename returned can be loaded using **QFile**  and related APIs. For
        this to be enabled, the Info.plist assigned to **QMAKE_INFO_PLIST**  in
        the project file must contain the key `NSPhotoLibraryUsageDescription`.
        See Info.plist documentation from Apple for more information regarding
        this key. This feature was added in Qt 5.5.

        **See also** **directory** ().
        """
        ...

    @typing.overload
    def setDirectory(self, adirectory: QtCore.QDir) -> None:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#setDirectory-1

        **void QFileDialog::setDirectory(const QDir & directory )**

        This is an overloaded function.
        """
        ...

    @property
    def currentChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#currentChanged

        **[signal] void QFileDialog::currentChanged(const QString & path )**

        When the current file changes for local operations, this signal is
        emitted with the new file name as the **path** parameter.

        **See also** **filesSelected** ().
        """
        ...

    @property
    def currentUrlChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#currentUrlChanged

        **[signal] void QFileDialog::currentUrlChanged(const QUrl & url )**

        When the current file changes, this signal is emitted with the new file
        URL as the **url** parameter.

        This function was introduced in Qt 5.2.

        **See also** **urlsSelected** ().
        """
        ...

    @property
    def directoryEntered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#directoryEntered

        **[signal] void QFileDialog::directoryEntered(const QString & directory
        )**

        This signal is emitted for local operations when the user enters a
        **directory**.

        This function was introduced in Qt 4.3.
        """
        ...

    @property
    def directoryUrlEntered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#directoryUrlEntered

        **[signal] void QFileDialog::directoryUrlEntered(const QUrl & directory
        )**

        This signal is emitted when the user enters a **directory**.

        This function was introduced in Qt 5.2.
        """
        ...

    @property
    def fileSelected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#fileSelected

        **[signal] void QFileDialog::fileSelected(const QString & file )**

        When the selection changes for local operations and the dialog is
        accepted, this signal is emitted with the (possibly empty) selected
        **file**.

        **See also** **currentChanged** () and **QDialog::Accepted** .
        """
        ...

    @property
    def filesSelected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#filesSelected

        **[signal] void QFileDialog::filesSelected(const QStringList & selected
        )**

        When the selection changes for local operations and the dialog is
        accepted, this signal is emitted with the (possibly empty) list of
        **selected** files.

        **See also** **currentChanged** () and **QDialog::Accepted** .
        """
        ...

    @property
    def filterSelected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#filterSelected

        **[signal] void QFileDialog::filterSelected(const QString & filter )**

        This signal is emitted when the user selects a **filter**.

        This function was introduced in Qt 4.3.
        """
        ...

    @property
    def urlSelected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#urlSelected

        **[signal] void QFileDialog::urlSelected(const QUrl & url )**

        When the selection changes and the dialog is accepted, this signal is
        emitted with the (possibly empty) selected **url**.

        This function was introduced in Qt 5.2.

        **See also** **currentUrlChanged** () and **QDialog::Accepted** .
        """
        ...

    @property
    def urlsSelected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfiledialog.html#urlsSelected

        **[signal] void QFileDialog::urlsSelected(const QList<QUrl> & urls )**

        When the selection changes and the dialog is accepted, this signal is
        emitted with the (possibly empty) list of selected **urls**.

        This function was introduced in Qt 5.2.

        **See also** **currentUrlChanged** () and **QDialog::Accepted** .
        """
        ...
