"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QDial(QAbstractSlider):
    """
    https://doc.qt.io/qt-5/qdial.html

    **Detailed Description**

    ![](images/windows-dial.png)

    QDial is used when the user needs to control a value within a program-
    definable range, and the range either wraps around (for example, with angles
    measured from 0 to 359 degrees) or the dialog layout needs a square widget.

    Since QDial inherits from **QAbstractSlider** , the dial behaves in a
    similar way to a **slider** . When **wrapping** () is false (the default
    setting) there is no real difference between a slider and a dial. They both
    share the same signals, slots and member functions. Which one you use
    depends on the expectations of your users and on the type of application.

    The dial initially emits **valueChanged** () signals continuously while the
    slider is being moved; you can make it emit the signal less often by
    disabling the **tracking**  property. The **sliderMoved** () signal is
    emitted continuously even when tracking is disabled.

    The dial also emits **sliderPressed** () and **sliderReleased** () signals
    when the mouse button is pressed and released. Note that the dial's value
    can change without these signals being emitted since the keyboard and wheel
    can also be used to change the value.

    Unlike the slider, QDial attempts to draw a "nice" number of notches rather
    than one per line step. If possible, the number of notches drawn is one per
    line step, but if there aren't enough pixels to draw every one, QDial will
    skip notches to try and draw a uniform set (e.g. by drawing every second or
    third notch).

    Like the slider, the dial makes the **QAbstractSlider**  function
    **setValue** () available as a slot.

    The dial's keyboard interface is fairly simple: The **left** / **up** and
    **right** / **down** arrow keys adjust the dial's **value**  by the defined
    **singleStep** , **Page Up** and **Page Down** by the defined **pageStep** ,
    and the **Home** and **End** keys set the value to the defined **minimum**
    and **maximum**  values.

    If you are using the mouse wheel to adjust the dial, the increment value is
    determined by the lesser value of **wheelScrollLines**  multipled by
    **singleStep** , and **pageStep** .

    **See also** **QScrollBar** , **QSpinBox** , **QSlider** , **GUI Design
    Handbook: Slider** , and **Sliders Example** .
    """

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qdial.html#QDial

        **QDial::QDial(QWidget * parent = nullptr)**

        Constructs a dial.

        The **parent** argument is sent to the **QAbstractSlider**  constructor.
        """
        ...

    def sliderChange(self, change: QAbstractSlider.SliderChange) -> None:
        """
        https://doc.qt.io/qt-5/qdial.html#sliderChange

        **[override virtual protected] void
        QDial::sliderChange(QAbstractSlider::SliderChange change )**

        Reimplements: **QAbstractSlider::sliderChange**
        (QAbstractSlider::SliderChange change).
        """
        ...

    def mouseMoveEvent(self, me: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qdial.html#mouseMoveEvent

        **[override virtual protected] void QDial::mouseMoveEvent(QMouseEvent *
        e )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(self, me: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qdial.html#mouseReleaseEvent

        **[override virtual protected] void QDial::mouseReleaseEvent(QMouseEvent
        * e )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, me: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qdial.html#mousePressEvent

        **[override virtual protected] void QDial::mousePressEvent(QMouseEvent *
        e )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def paintEvent(self, pe: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qdial.html#paintEvent

        **[override virtual protected] void QDial::paintEvent(QPaintEvent * pe
        )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def resizeEvent(self, re: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qdial.html#resizeEvent

        **[override virtual protected] void QDial::resizeEvent(QResizeEvent * e
        )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qdial.html#event

        **[override virtual protected] bool QDial::event(QEvent * e )**

        Reimplements: **QAbstractSlider::event** (QEvent *e).
        """
        ...

    def initStyleOption(self, option: "QStyleOptionSlider") -> None:
        """
        https://doc.qt.io/qt-5/qdial.html#initStyleOption

        **[protected] void QDial::initStyleOption(QStyleOptionSlider * option )
        const**

        Initialize **option** with the values from this **QDial** . This method
        is useful for subclasses when they need a **QStyleOptionSlider** , but
        don't want to fill in all the information themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def setWrapping(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-5/qdial.html#wrapping-prop

        **wrapping : bool**

        This property holds whether wrapping is enabled

        If true, wrapping is enabled; otherwise some space is inserted at the
        bottom of the dial to separate the ends of the range of valid values.

        If enabled, the arrow can be oriented at any angle on the dial. If
        disabled, the arrow will be restricted to the upper part of the dial; if
        it is rotated into the space at the bottom of the dial, it will be
        clamped to the closest end of the valid range of values.

        By default this property is `false`.

        **Access functions:**

        bool **wrapping** () const
        void **setWrapping** (bool **on** )

        **Member Function Documentation**
        """
        ...

    def setNotchesVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-5/qdial.html#notchesVisible-prop

        **notchesVisible : bool**

        This property holds whether the notches are shown

        If the property is `true`, a series of notches are drawn around the dial
        to indicate the range of values available; otherwise no notches are
        shown.

        By default, this property is disabled.

        **Access functions:**

        bool **notchesVisible** () const
        void **setNotchesVisible** (bool
        **visible** )
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qdial.html#minimumSizeHint

        **[override virtual] QSize QDial::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qdial.html#sizeHint

        **[override virtual] QSize QDial::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    def notchesVisible(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdial.html#notchesVisible-prop

        **notchesVisible : bool**

        This property holds whether the notches are shown

        If the property is `true`, a series of notches are drawn around the dial
        to indicate the range of values available; otherwise no notches are
        shown.

        By default, this property is disabled.

        **Access functions:**

        bool **notchesVisible** () const
        void **setNotchesVisible** (bool
        **visible** )
        """
        ...

    def notchTarget(self) -> float:
        """
        https://doc.qt.io/qt-5/qdial.html#notchTarget-prop

        **notchTarget : qreal**

        This property holds the target number of pixels between notches

        The notch target is the number of pixels **QDial**  attempts to put
        between each notch.

        The actual size may differ from the target size.

        The default notch target is 3.7 pixels.

        **Access functions:**

        qreal **notchTarget** () const
        void **setNotchTarget** (double
        **target** )
        """
        ...

    def setNotchTarget(self, target: float) -> None:
        """
        https://doc.qt.io/qt-5/qdial.html#notchTarget-prop

        **notchTarget : qreal**

        This property holds the target number of pixels between notches

        The notch target is the number of pixels **QDial**  attempts to put
        between each notch.

        The actual size may differ from the target size.

        The default notch target is 3.7 pixels.

        **Access functions:**

        qreal **notchTarget** () const
        void **setNotchTarget** (double
        **target** )
        """
        ...

    def notchSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qdial.html#notchSize-prop

        **notchSize : const int**

        This property holds the current notch size

        The notch size is in range control units, not pixels, and if possible it
        is a multiple of **singleStep** () that results in an on-screen notch
        size near **notchTarget** ().

        By default, this property has a value of 1.

        **Access functions:**

        int **notchSize** () const

        **See also** **notchTarget** () and **singleStep** ().
        """
        ...

    def wrapping(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdial.html#wrapping-prop

        **wrapping : bool**

        This property holds whether wrapping is enabled

        If true, wrapping is enabled; otherwise some space is inserted at the
        bottom of the dial to separate the ends of the range of valid values.

        If enabled, the arrow can be oriented at any angle on the dial. If
        disabled, the arrow will be restricted to the upper part of the dial; if
        it is rotated into the space at the bottom of the dial, it will be
        clamped to the closest end of the valid range of values.

        By default this property is `false`.

        **Access functions:**

        bool **wrapping** () const
        void **setWrapping** (bool **on** )

        **Member Function Documentation**
        """
        ...
