"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QApplication(QtGui.QGuiApplication):
    """
    https://doc.qt.io/qt-5/qapplication.html

    **Detailed Description**

    QApplication specializes **QGuiApplication**  with some functionality needed
    for **QWidget** -based applications. It handles widget specific
    initialization, finalization.

    For any GUI application using Qt, there is precisely **one** QApplication
    object, no matter whether the application has 0, 1, 2 or more windows at any
    given time. For non-**QWidget**  based Qt applications, use
    **QGuiApplication**  instead, as it does not depend on the **QtWidgets**
    library.

    Some GUI applications provide a special batch mode ie. provide command line
    arguments for executing tasks without manual intervention. In such non-GUI
    mode, it is often sufficient to instantiate a plain **QCoreApplication**  to
    avoid unnecessarily initializing resources needed for a graphical user
    interface. The following example shows how to dynamically create an
    appropriate type of application instance:

    **QCoreApplication** * createApplication(int &argc, char *argv[])
        {
    for (int i = 1; i < argc; ++i) {
                if (!qstrcmp(argv[i], "-no-
    gui"))
                    return new **QCoreApplication** (argc, argv);
    }
            return new **QApplication** (argc, argv);
        }

        int
    main(int argc, char* argv[])
        {
            **QScopedPointer**
    <**QCoreApplication** > app(createApplication(argc, argv));

            if
    (qobject_cast<**QApplication**  *>(app.data())) {
               // start GUI
    version...
            } else {
               // start non-GUI version...
            }
    return app->exec();
        }

    The QApplication object is accessible through the **instance** () function
    that returns a pointer equivalent to the global **qApp**  pointer.

    QApplication's main areas of responsibility are:

    * It initializes the application with the user's desktop settings such as
    **palette** (), **font** () and **doubleClickInterval** (). It keeps track
    of these properties in case the user changes the desktop globally, for
    example through some kind of control panel.
      * It performs event handling,
    meaning that it receives events from the underlying window system and
    dispatches them to the relevant widgets. By using **sendEvent** () and
    **postEvent** () you can send your own events to widgets.
      * It parses
    common command line arguments and sets its internal state accordingly. See
    the **constructor documentation**  below for more details.
      * It defines
    the application's look and feel, which is encapsulated in a **QStyle**
    object. This can be changed at runtime with **setStyle** ().
      * It provides
    localization of strings that are visible to the user via **translate** ().
    * It provides some magical objects like the desktop() and the **clipboard**
    ().
      * It knows about the application's windows. You can ask which widget
    is at a certain position using **widgetAt** (), get a list of
    **topLevelWidgets** () and **closeAllWindows** (), etc.
      * It manages the
    application's mouse cursor handling, see **setOverrideCursor** ()

    Since the QApplication object does so much initialization, it **must** be
    created before any other objects related to the user interface are created.
    QApplication also deals with common command line arguments. Hence, it is
    usually a good idea to create it **before** any interpretation or
    modification of `argv` is done in the application itself.

    Groups of functions
    System settings**desktopSettingsAware** (),
    **setDesktopSettingsAware** (), **cursorFlashTime** (),
    **setCursorFlashTime** (), **doubleClickInterval** (),
    **setDoubleClickInterval** (), **setKeyboardInputInterval** (),
    **wheelScrollLines** (), **setWheelScrollLines** (), **palette** (),
    **setPalette** (), **font** (), **setFont** (), **fontMetrics** ().
    Event
    handling**exec** (), **processEvents** (), **exit** (), **quit** ().
    **sendEvent** (), **postEvent** (), **sendPostedEvents** (),
    **removePostedEvents** (), hasPendingEvents(), **notify** ().
    GUI
    Styles**style** (), **setStyle** ().
    Text handling**installTranslator**
    (), **removeTranslator** () **translate** ().
    Widgets**allWidgets** (),
    **topLevelWidgets** (), desktop(), **activePopupWidget** (),
    **activeModalWidget** (), **clipboard** (), **focusWidget** (),
    **activeWindow** (), **widgetAt** ().
    Advanced cursor
    handling**overrideCursor** (), **setOverrideCursor** (),
    **restoreOverrideCursor** ().
    Miscellaneous**closeAllWindows** (),
    **startingUp** (), **closingDown** ().

    **See also** **QCoreApplication** , **QAbstractEventDispatcher** ,
    **QEventLoop** , and **QSettings** .
    """

    class ColorSpec(int):
        NormalColor: QApplication = ...
        CustomColor: QApplication = ...
        ManyColor: QApplication = ...

    def __init__(self, argv: typing.List[str]) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#QApplication

        **QApplication::QApplication(int & argc , char ** argv )**

        Initializes the window system and constructs an application object with
        **argc** command line arguments in **argv**.

        **Warning:** The data referred to by **argc** and **argv** must stay
        valid for the entire lifetime of the QApplication object. In addition,
        **argc** must be greater than zero and **argv** must contain at least
        one valid character string.

        The global `qApp` pointer refers to this application object. Only one
        application object should be created.

        This application object must be constructed before any **paint devices**
        (including widgets, pixmaps, bitmaps etc.).

        **Note:** **argc** and **argv** might be changed as Qt removes command
        line arguments that it recognizes.

        All Qt programs automatically support the following command line
        options:

        * -style= **style** , sets the application GUI style. Possible values
        depend on your system configuration. If you compiled Qt with additional
        styles or have additional styles as plugins these will be available to
        the `-style` command line option. You can also set the style for all Qt
        applications by setting the `QT_STYLE_OVERRIDE` environment variable.
        * -style **style** , is the same as listed above.
          * -stylesheet=
        **stylesheet** , sets the application **styleSheet** . The value must be
        a path to a file that contains the Style Sheet.

         **Note:** Relative
        URLs in the Style Sheet file are relative to the Style Sheet file's
        path.

          * -stylesheet **stylesheet** , is the same as listed above.
          *
        -widgetcount, prints debug message at the end about number of widgets
        left undestroyed and maximum number of widgets existed at the same time
        * -reverse, sets the application's layout direction to
        **Qt::RightToLeft**
          * -qmljsdebugger=, activates the QML/JS debugger
        with a specified port. The value must be of format port:1234[,block],
        where block is optional and will make the application wait until a
        debugger connects to it.

        **See also** **QCoreApplication::arguments** ().
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qapplication.html#event

        **[override virtual protected] bool QApplication::event(QEvent * e )**

        Reimplements: **QGuiApplication::event** (QEvent *e).
        """
        ...

    def setStyleSheet(self, sheet: str) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#styleSheet-prop

        **styleSheet : QString**

        This property holds the application style sheet

        By default, this property returns an empty string unless the user
        specifies the `-stylesheet` option on the command line when running the
        application.

        This property was introduced in Qt 4.2.

        **Access functions:**

        QString **styleSheet** () const
        void **setStyleSheet** (const QString
        & **sheet** )

        **See also** **QWidget::setStyle** () and **Qt Style Sheets** .
        """
        ...

    def setAutoSipEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#autoSipEnabled-prop

        **autoSipEnabled : bool**

        toggles automatic SIP (software input panel) visibility

        Set this property to `true` to automatically display the SIP when
        entering widgets that accept keyboard input. This property only affects
        widgets with the WA_InputMethodEnabled attribute set, and is typically
        used to launch a virtual keyboard on devices which have very few or no
        keys.

        **The property only has an effect on platforms that use software input
        panels.**

        The default is platform dependent.

        This property was introduced in Qt 4.5.

        **Access functions:**

        bool **autoSipEnabled** () const
        void **setAutoSipEnabled** (const
        bool **enabled** )
        """
        ...

    @staticmethod
    def closeAllWindows() -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#closeAllWindows

        **[static slot] void QApplication::closeAllWindows()**

        Closes all top-level windows.

        This function is particularly useful for applications with many top-
        level windows. It could, for example, be connected to a **Exit** entry
        in the **File** menu:

        const **QIcon**  exitIcon = **QIcon** ::fromTheme("application-exit");
        **QAction**  *exitAct = fileMenu->addAction(exitIcon, tr("E&xit"),
        **qApp** , &**QApplication** ::closeAllWindows);
        exitAct->setShortcuts(**QKeySequence** ::Quit);
        exitAct->setStatusTip(tr("Exit the application"));
        fileMenu->addAction(exitAct);

        The windows are closed in random order, until one window does not accept
        the close event. The application quits when the last window was
        successfully closed; this can be turned off by setting
        **quitOnLastWindowClosed**  to false.

        **See also** **quitOnLastWindowClosed** , **lastWindowClosed** (),
        **QWidget::close** (), **QWidget::closeEvent** (), **lastWindowClosed**
        (), **QCoreApplication::quit** (), **topLevelWidgets** (), and
        **QWidget::isWindow** ().
        """
        ...

    @staticmethod
    def aboutQt() -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#aboutQt

        **[static slot] void QApplication::aboutQt()**

        Displays a simple message box about Qt. The message includes the version
        number of Qt being used by the application.

        This is useful for inclusion in the **Help** menu of an application, as
        shown in the **Menus**  example.

        This function is a convenience slot for **QMessageBox::aboutQt** ().
        """
        ...

    def styleSheet(self) -> str:
        """
        https://doc.qt.io/qt-5/qapplication.html#styleSheet-prop

        **styleSheet : QString**

        This property holds the application style sheet

        By default, this property returns an empty string unless the user
        specifies the `-stylesheet` option on the command line when running the
        application.

        This property was introduced in Qt 4.2.

        **Access functions:**

        QString **styleSheet** () const
        void **setStyleSheet** (const QString
        & **sheet** )

        **See also** **QWidget::setStyle** () and **Qt Style Sheets** .
        """
        ...

    def autoSipEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qapplication.html#autoSipEnabled-prop

        **autoSipEnabled : bool**

        toggles automatic SIP (software input panel) visibility

        Set this property to `true` to automatically display the SIP when
        entering widgets that accept keyboard input. This property only affects
        widgets with the WA_InputMethodEnabled attribute set, and is typically
        used to launch a virtual keyboard on devices which have very few or no
        keys.

        **The property only has an effect on platforms that use software input
        panels.**

        The default is platform dependent.

        This property was introduced in Qt 4.5.

        **Access functions:**

        bool **autoSipEnabled** () const
        void **setAutoSipEnabled** (const
        bool **enabled** )
        """
        ...

    def notify(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qapplication.html#notify

        **[override virtual] bool QApplication::notify(QObject * receiver ,
        QEvent * e )**

        Reimplements: **QGuiApplication::notify** (QObject *object, QEvent
        *event).
        """
        ...

    @staticmethod
    def exec() -> int:
        """
        https://doc.qt.io/qt-5/qapplication.html#exec

        **[static] int QApplication::exec()**

        Enters the main event loop and waits until **exit** () is called, then
        returns the value that was set to **exit** () (which is 0 if **exit** ()
        is called via **quit** ()).

        It is necessary to call this function to start event handling. The main
        event loop receives events from the window system and dispatches these
        to the application widgets.

        Generally, no user interaction can take place before calling exec(). As
        a special case, modal widgets like **QMessageBox**  can be used before
        calling exec(), because modal widgets call exec() to start a local event
        loop.

        To make your application perform idle processing, i.e., executing a
        special function whenever there are no pending events, use a **QTimer**
        with 0 timeout. More advanced idle processing schemes can be achieved
        using **processEvents** ().

        We recommend that you connect clean-up code to the **aboutToQuit()**
        signal, instead of putting it in your application's `main()` function.
        This is because, on some platforms the QApplication::exec() call may not
        return. For example, on the Windows platform, when the user logs off,
        the system terminates the process after Qt closes all top-level windows.
        Hence, there is **no guarantee** that the application will have time to
        exit its event loop and execute code at the end of the `main()`
        function, after the QApplication::exec() call.

        **See also** **quitOnLastWindowClosed** , **QCoreApplication::quit** (),
        **QCoreApplication::exit** (), **QCoreApplication::processEvents** (),
        and **QCoreApplication::exec** ().
        """
        ...

    @staticmethod
    def exec_() -> int:
        """
        https://doc.qt.io/qt-5/qapplication.html#exec

        **[static] int QApplication::exec()**

        Enters the main event loop and waits until **exit** () is called, then
        returns the value that was set to **exit** () (which is 0 if **exit** ()
        is called via **quit** ()).

        It is necessary to call this function to start event handling. The main
        event loop receives events from the window system and dispatches these
        to the application widgets.

        Generally, no user interaction can take place before calling exec(). As
        a special case, modal widgets like **QMessageBox**  can be used before
        calling exec(), because modal widgets call exec() to start a local event
        loop.

        To make your application perform idle processing, i.e., executing a
        special function whenever there are no pending events, use a **QTimer**
        with 0 timeout. More advanced idle processing schemes can be achieved
        using **processEvents** ().

        We recommend that you connect clean-up code to the **aboutToQuit()**
        signal, instead of putting it in your application's `main()` function.
        This is because, on some platforms the QApplication::exec() call may not
        return. For example, on the Windows platform, when the user logs off,
        the system terminates the process after Qt closes all top-level windows.
        Hence, there is **no guarantee** that the application will have time to
        exit its event loop and execute code at the end of the `main()`
        function, after the QApplication::exec() call.

        **See also** **quitOnLastWindowClosed** , **QCoreApplication::quit** (),
        **QCoreApplication::exit** (), **QCoreApplication::processEvents** (),
        and **QCoreApplication::exec** ().
        """
        ...

    @staticmethod
    def setEffectEnabled(a0: QtCore.Qt.UIEffect, enabled: bool = ...) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#setEffectEnabled

        **[static] void QApplication::setEffectEnabled(Qt::UIEffect effect ,
        bool enable = true)**

        Enables the UI effect **effect** if **enable** is true, otherwise the
        effect will not be used.

        **Note:** All effects are disabled on screens running at less than
        16-bit color depth.

        **See also** **isEffectEnabled** (), **Qt::UIEffect** , and
        **setDesktopSettingsAware** ().
        """
        ...

    @staticmethod
    def isEffectEnabled(a0: QtCore.Qt.UIEffect) -> bool:
        """
        https://doc.qt.io/qt-5/qapplication.html#isEffectEnabled

        **[static] bool QApplication::isEffectEnabled(Qt::UIEffect effect )**

        Returns `true` if **effect** is enabled; otherwise returns `false`.

        By default, Qt will try to use the desktop settings. To prevent this,
        call **setDesktopSettingsAware** (false).

        **Note:** All effects are disabled on screens running at less than
        16-bit color depth.

        **See also** **setEffectEnabled** () and **Qt::UIEffect** .
        """
        ...

    @staticmethod
    def startDragDistance() -> int:
        """
        https://doc.qt.io/qt-5/qapplication.html#startDragDistance-prop

        **startDragDistance : int**

        If you support drag and drop in your application, and want to start a
        drag and drop operation after the user has moved the cursor a certain
        distance with a button held down, you should use this property's value
        as the minimum distance required.

        For example, if the mouse position of the click is stored in `startPos`
        and the current position (e.g. in the mouse move event) is `currentPos`,
        you can find out if a drag should be started with code like this:

        if ((startPos - currentPos).manhattanLength() >=
        **QApplication** ::startDragDistance())
                startTheDrag();

        Qt uses this value internally, e.g. in **QFileDialog** .

        The default value (if the platform doesn't provide a different default)
        is 10 pixels.

        **Access functions:**

        int **startDragDistance** ()
        void **setStartDragDistance** (int **l**
        )

        **See also** **startDragTime** (), **QPoint::manhattanLength** (), and
        **Drag and Drop** .
        """
        ...

    @staticmethod
    def setStartDragDistance(l: int) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#startDragDistance-prop

        **startDragDistance : int**

        If you support drag and drop in your application, and want to start a
        drag and drop operation after the user has moved the cursor a certain
        distance with a button held down, you should use this property's value
        as the minimum distance required.

        For example, if the mouse position of the click is stored in `startPos`
        and the current position (e.g. in the mouse move event) is `currentPos`,
        you can find out if a drag should be started with code like this:

        if ((startPos - currentPos).manhattanLength() >=
        **QApplication** ::startDragDistance())
                startTheDrag();

        Qt uses this value internally, e.g. in **QFileDialog** .

        The default value (if the platform doesn't provide a different default)
        is 10 pixels.

        **Access functions:**

        int **startDragDistance** ()
        void **setStartDragDistance** (int **l**
        )

        **See also** **startDragTime** (), **QPoint::manhattanLength** (), and
        **Drag and Drop** .
        """
        ...

    @staticmethod
    def startDragTime() -> int:
        """
        https://doc.qt.io/qt-5/qapplication.html#startDragTime-prop

        **startDragTime : int**

        This property holds the time in milliseconds that a mouse button must be
        held down before a drag and drop operation will begin

        If you support drag and drop in your application, and want to start a
        drag and drop operation after the user has held down a mouse button for
        a certain amount of time, you should use this property's value as the
        delay.

        Qt also uses this delay internally, e.g. in **QTextEdit**  and
        **QLineEdit** , for starting a drag.

        The default value is 500 ms.

        **Access functions:**

        int **startDragTime** ()
        void **setStartDragTime** (int **ms** )

        **See also** **startDragDistance** () and **Drag and Drop** .
        """
        ...

    @staticmethod
    def setStartDragTime(ms: int) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#startDragTime-prop

        **startDragTime : int**

        This property holds the time in milliseconds that a mouse button must be
        held down before a drag and drop operation will begin

        If you support drag and drop in your application, and want to start a
        drag and drop operation after the user has held down a mouse button for
        a certain amount of time, you should use this property's value as the
        delay.

        Qt also uses this delay internally, e.g. in **QTextEdit**  and
        **QLineEdit** , for starting a drag.

        The default value is 500 ms.

        **Access functions:**

        int **startDragTime** ()
        void **setStartDragTime** (int **ms** )

        **See also** **startDragDistance** () and **Drag and Drop** .
        """
        ...

    @staticmethod
    def globalStrut() -> QtCore.QSize:
        ...

    @staticmethod
    def setGlobalStrut(a0: QtCore.QSize) -> None:
        ...

    @staticmethod
    def wheelScrollLines() -> int:
        """
        https://doc.qt.io/qt-5/qapplication.html#wheelScrollLines-prop

        **wheelScrollLines : int**

        This property holds the number of lines to scroll a widget, when the
        mouse wheel is rotated.

        If the value exceeds the widget's number of visible lines, the widget
        should interpret the scroll operation as a single **page up** or **page
        down**. If the widget is an **item view class** , then the result of
        scrolling one **line** depends on the setting of the widget's **scroll
        mode** . Scroll one **line** can mean **scroll one item**  or **scroll
        one pixel** .

        By default, this property has a value of 3.

        **Access functions:**

        int **wheelScrollLines** ()
        void **setWheelScrollLines** ( **int** )

        **See also** **QStyleHints::wheelScrollLines** ().
        """
        ...

    @staticmethod
    def setWheelScrollLines(a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#wheelScrollLines-prop

        **wheelScrollLines : int**

        This property holds the number of lines to scroll a widget, when the
        mouse wheel is rotated.

        If the value exceeds the widget's number of visible lines, the widget
        should interpret the scroll operation as a single **page up** or **page
        down**. If the widget is an **item view class** , then the result of
        scrolling one **line** depends on the setting of the widget's **scroll
        mode** . Scroll one **line** can mean **scroll one item**  or **scroll
        one pixel** .

        By default, this property has a value of 3.

        **Access functions:**

        int **wheelScrollLines** ()
        void **setWheelScrollLines** ( **int** )

        **See also** **QStyleHints::wheelScrollLines** ().
        """
        ...

    @staticmethod
    def keyboardInputInterval() -> int:
        """
        https://doc.qt.io/qt-5/qapplication.html#keyboardInputInterval-prop

        **keyboardInputInterval : int**

        This property holds the time limit in milliseconds that distinguishes a
        key press from two consecutive key presses

        The default value on X11 is 400 milliseconds. On Windows and Mac OS, the
        operating system's value is used.

        This property was introduced in Qt 4.2.

        **Access functions:**

        int **keyboardInputInterval** ()
        void **setKeyboardInputInterval** (
        **int** )
        """
        ...

    @staticmethod
    def setKeyboardInputInterval(a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#keyboardInputInterval-prop

        **keyboardInputInterval : int**

        This property holds the time limit in milliseconds that distinguishes a
        key press from two consecutive key presses

        The default value on X11 is 400 milliseconds. On Windows and Mac OS, the
        operating system's value is used.

        This property was introduced in Qt 4.2.

        **Access functions:**

        int **keyboardInputInterval** ()
        void **setKeyboardInputInterval** (
        **int** )
        """
        ...

    @staticmethod
    def doubleClickInterval() -> int:
        """
        https://doc.qt.io/qt-5/qapplication.html#doubleClickInterval-prop

        **doubleClickInterval : int**

        This property holds the time limit in milliseconds that distinguishes a
        double click from two consecutive mouse clicks

        The default value on X11 is 400 milliseconds. On Windows and Mac OS, the
        operating system's value is used.

        **Access functions:**

        int **doubleClickInterval** ()
        void **setDoubleClickInterval** (
        **int** )
        """
        ...

    @staticmethod
    def setDoubleClickInterval(a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#doubleClickInterval-prop

        **doubleClickInterval : int**

        This property holds the time limit in milliseconds that distinguishes a
        double click from two consecutive mouse clicks

        The default value on X11 is 400 milliseconds. On Windows and Mac OS, the
        operating system's value is used.

        **Access functions:**

        int **doubleClickInterval** ()
        void **setDoubleClickInterval** (
        **int** )
        """
        ...

    @staticmethod
    def cursorFlashTime() -> int:
        """
        https://doc.qt.io/qt-5/qapplication.html#cursorFlashTime-prop

        **cursorFlashTime : int**

        This property holds the text cursor's flash (blink) time in milliseconds

        The flash time is the time required to display, invert and restore the
        caret display. Usually the text cursor is displayed for half the cursor
        flash time, then hidden for the same amount of time, but this may vary.

        The default value on X11 is 1000 milliseconds. On Windows, the **Control
        Panel** value is used and setting this property sets the cursor flash
        time for all applications.

        We recommend that widgets do not cache this value as it may change at
        any time if the user changes the global desktop settings.

        **Note:** This property may hold a negative value, for instance if
        cursor blinking is disabled.

        **Access functions:**

        int **cursorFlashTime** ()
        void **setCursorFlashTime** ( **int** )
        """
        ...

    @staticmethod
    def setCursorFlashTime(a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#cursorFlashTime-prop

        **cursorFlashTime : int**

        This property holds the text cursor's flash (blink) time in milliseconds

        The flash time is the time required to display, invert and restore the
        caret display. Usually the text cursor is displayed for half the cursor
        flash time, then hidden for the same amount of time, but this may vary.

        The default value on X11 is 1000 milliseconds. On Windows, the **Control
        Panel** value is used and setting this property sets the cursor flash
        time for all applications.

        We recommend that widgets do not cache this value as it may change at
        any time if the user changes the global desktop settings.

        **Note:** This property may hold a negative value, for instance if
        cursor blinking is disabled.

        **Access functions:**

        int **cursorFlashTime** ()
        void **setCursorFlashTime** ( **int** )
        """
        ...

    @staticmethod
    def alert(widget: QWidget, msecs: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#alert

        **[static] void QApplication::alert(QWidget * widget , int msec = 0)**

        Causes an alert to be shown for **widget** if the window is not the
        active window. The alert is shown for **msec** miliseconds. If **msec**
        is zero (the default), then the alert is shown indefinitely until the
        window becomes active again.

        Currently this function does nothing on Qt for Embedded Linux.

        On macOS, this works more at the application level and will cause the
        application icon to bounce in the dock.

        On Windows, this causes the window's taskbar entry to flash for a time.
        If **msec** is zero, the flashing will stop and the taskbar entry will
        turn a different color (currently orange).

        On X11, this will cause the window to be marked as "demands attention",
        the window must not be hidden (i.e. not have hide() called on it, but be
        visible in some sort of way) in order for this to work.

        This function was introduced in Qt 4.3.
        """
        ...

    @staticmethod
    def beep() -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#beep

        **[static] void QApplication::beep()**

        Sounds the bell, using the default volume and sound. The function is
        **not** available in Qt for Embedded Linux.
        """
        ...

    @typing.overload
    @staticmethod
    def topLevelAt(p: QtCore.QPoint) -> QWidget:
        """
        https://doc.qt.io/qt-5/qapplication.html#topLevelAt

        **[static] QWidget *QApplication::topLevelAt(const QPoint & point )**

        Returns the top-level widget at the given **point** ; returns `nullptr`
        if there is no such widget.
        """
        ...

    @typing.overload
    @staticmethod
    def topLevelAt(x: int, y: int) -> QWidget:
        """
        https://doc.qt.io/qt-5/qapplication.html#topLevelAt-1

        **[static] QWidget *QApplication::topLevelAt(int x , int y )**

        This is an overloaded function.

        Returns the top-level widget at the point ( **x** , **y** ); returns 0
        if there is no such widget.
        """
        ...

    @typing.overload
    @staticmethod
    def widgetAt(p: QtCore.QPoint) -> QWidget:
        """
        https://doc.qt.io/qt-5/qapplication.html#widgetAt

        **[static] QWidget *QApplication::widgetAt(const QPoint & point )**

        Returns the widget at global screen position **point** , or `nullptr` if
        there is no Qt widget there.

        This function can be slow.

        **See also** **QCursor::pos** (), **QWidget::grabMouse** (), and
        **QWidget::grabKeyboard** ().
        """
        ...

    @typing.overload
    @staticmethod
    def widgetAt(x: int, y: int) -> QWidget:
        """
        https://doc.qt.io/qt-5/qapplication.html#widgetAt-1

        **[static] QWidget *QApplication::widgetAt(int x , int y )**

        This is an overloaded function.

        Returns the widget at global screen position ( **x** , **y** ), or
        `nullptr` if there is no Qt widget there.
        """
        ...

    @staticmethod
    def setActiveWindow(act: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#setActiveWindow

        **[static] void QApplication::setActiveWindow(QWidget * active )**

        Sets the active window to the **active** widget in response to a system
        event. The function is called from the platform specific event handlers.

        **Warning:** This function does **not** set the keyboard focus to the
        active widget. Call **QWidget::activateWindow** () instead.

        It sets the **activeWindow** () and **focusWidget** () attributes and
        sends proper **WindowActivate** /**WindowDeactivate**  and **FocusIn**
        /**FocusOut**  events to all appropriate widgets. The window will then
        be painted in active state (e.g. cursors in line edits will blink), and
        it will have tool tips enabled.

        **See also** **activeWindow** () and **QWidget::activateWindow** ().
        """
        ...

    @staticmethod
    def activeWindow() -> QWidget:
        """
        https://doc.qt.io/qt-5/qapplication.html#activeWindow

        **[static] QWidget *QApplication::activeWindow()**

        Returns the application top-level window that has the keyboard input
        focus, or `nullptr` if no application window has the focus. There might
        be an activeWindow() even if there is no **focusWidget** (), for example
        if no widget in that window accepts key events.

        **See also** **setActiveWindow** (), **QWidget::setFocus** (),
        **QWidget::hasFocus** (), and **focusWidget** ().
        """
        ...

    @staticmethod
    def focusWidget() -> QWidget:
        """
        https://doc.qt.io/qt-5/qapplication.html#focusWidget

        **[static] QWidget *QApplication::focusWidget()**

        Returns the application widget that has the keyboard input focus, or
        `nullptr` if no widget in this application has the focus.

        **See also** **QWidget::setFocus** (), **QWidget::hasFocus** (),
        **activeWindow** (), and **focusChanged** ().
        """
        ...

    @staticmethod
    def activeModalWidget() -> QWidget:
        """
        https://doc.qt.io/qt-5/qapplication.html#activeModalWidget

        **[static] QWidget *QApplication::activeModalWidget()**

        Returns the active modal widget.

        A modal widget is a special top-level widget which is a subclass of
        **QDialog**  that specifies the modal parameter of the constructor as
        true. A modal widget must be closed before the user can continue with
        other parts of the program.

        Modal widgets are organized in a stack. This function returns the active
        modal widget at the top of the stack.

        **See also** **activePopupWidget** () and **topLevelWidgets** ().
        """
        ...

    @staticmethod
    def activePopupWidget() -> QWidget:
        """
        https://doc.qt.io/qt-5/qapplication.html#activePopupWidget

        **[static] QWidget *QApplication::activePopupWidget()**

        Returns the active popup widget.

        A popup widget is a special top-level widget that sets the
        `Qt::WType_Popup` widget flag, e.g. the **QMenu**  widget. When the
        application opens a popup widget, all events are sent to the popup.
        Normal widgets and modal widgets cannot be accessed before the popup
        widget is closed.

        Only other popup widgets may be opened when a popup widget is shown. The
        popup widgets are organized in a stack. This function returns the active
        popup widget at the top of the stack.

        **See also** **activeModalWidget** () and **topLevelWidgets** ().
        """
        ...

    @staticmethod
    def desktop() -> "QDesktopWidget":
        ...

    @staticmethod
    def topLevelWidgets() -> typing.List[QWidget]:
        """
        https://doc.qt.io/qt-5/qapplication.html#topLevelWidgets

        **[static] QWidgetList QApplication::topLevelWidgets()**

        Returns a list of the top-level widgets (windows) in the application.

        **Note:** Some of the top-level widgets may be hidden, for example a
        tooltip if no tooltip is currently shown.

        Example:

        void showAllHiddenTopLevelWidgets()
            {
                const QWidgetList
        topLevelWidgets = **QApplication** ::topLevelWidgets();
                for
        (**QWidget**  *widget : topLevelWidgets) {
                    if
        (widget->isHidden())
                        widget->show();
                }
            }

        **See also** **allWidgets** (), **QWidget::isWindow** (), and
        **QWidget::isHidden** ().
        """
        ...

    @staticmethod
    def allWidgets() -> typing.List[QWidget]:
        """
        https://doc.qt.io/qt-5/qapplication.html#allWidgets

        **[static] QWidgetList QApplication::allWidgets()**

        Returns a list of all the widgets in the application.

        The list is empty (**QList::isEmpty** ()) if there are no widgets.

        **Note:** Some of the widgets may be hidden.

        Example:

        void updateAllWidgets()
            {
                const QWidgetList allWidgets =
        **QApplication** ::allWidgets();
                for (**QWidget**  *widget :
        allWidgets)
                    widget->update();
            }

        **See also** **topLevelWidgets** () and **QWidget::isVisible** ().
        """
        ...

    @staticmethod
    def windowIcon() -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-5/qapplication.html#windowIcon-prop

        **windowIcon : QIcon**

        This property holds the default window icon

        **Access functions:**

        QIcon **windowIcon** ()
        void **setWindowIcon** (const QIcon & **icon**
        )

        **See also** **QWidget::setWindowIcon** () and **Setting the Application
        Icon** .

        **Member Function Documentation**
        """
        ...

    @staticmethod
    def setWindowIcon(icon: QtGui.QIcon) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#windowIcon-prop

        **windowIcon : QIcon**

        This property holds the default window icon

        **Access functions:**

        QIcon **windowIcon** ()
        void **setWindowIcon** (const QIcon & **icon**
        )

        **See also** **QWidget::setWindowIcon** () and **Setting the Application
        Icon** .

        **Member Function Documentation**
        """
        ...

    @staticmethod
    def fontMetrics() -> QtGui.QFontMetrics:
        """
        https://doc.qt.io/qt-5/qapplication.html#fontMetrics

        **[static] QFontMetrics QApplication::fontMetrics()**

        Returns display (screen) font metrics for the application font.

        **See also** **font** (), **setFont** (), **QWidget::fontMetrics** (),
        and **QPainter::fontMetrics** ().
        """
        ...

    @staticmethod
    def setFont(a0: QtGui.QFont, className: typing.Optional[str] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#setFont

        **[static] void QApplication::setFont(const QFont & font , const char *
        className = nullptr)**

        Changes the default application font to **font**. If **className** is
        passed, the change applies only to classes that inherit **className**
        (as reported by **QObject::inherits** ()).

        On application start-up, the default font depends on the window system.
        It can vary depending on both the window system version and the locale.
        This function lets you override the default font; but overriding may be
        a bad idea because, for example, some locales need extra large fonts to
        support their special characters.

        **Warning:** Do not use this function in conjunction with **Qt Style
        Sheets** . The font of an application can be customized using the "font"
        style sheet property. To set a bold font for all QPushButtons, set the
        application **styleSheet** () as "**QPushButton**  { font: bold }"

        **See also** **font** (), **fontMetrics** (), and **QWidget::setFont**
        ().
        """
        ...

    @typing.overload
    @staticmethod
    def font() -> QtGui.QFont:
        """
        https://doc.qt.io/qt-5/qapplication.html#font

        **[static] QFont QApplication::font()**

        Returns the default application font.

        **See also** **setFont** (), **fontMetrics** (), and **QWidget::font**
        ().
        """
        ...

    @typing.overload
    @staticmethod
    def font(a0: QWidget) -> QtGui.QFont:
        """
        https://doc.qt.io/qt-5/qapplication.html#font-1

        **[static] QFont QApplication::font(const QWidget * widget )**

        This is an overloaded function.

        Returns the default font for the **widget**.

        **See also** **fontMetrics** () and **QWidget::setFont** ().
        """
        ...

    @typing.overload
    @staticmethod
    def font(className: str) -> QtGui.QFont:
        """
        https://doc.qt.io/qt-5/qapplication.html#font-2

        **[static] QFont QApplication::font(const char * className )**

        This is an overloaded function.

        Returns the font for widgets of the given **className**.

        **See also** **setFont** () and **QWidget::font** ().
        """
        ...

    @staticmethod
    def setPalette(a0: QtGui.QPalette, className: typing.Optional[str] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#setPalette

        **[static] void QApplication::setPalette(const QPalette & palette ,
        const char * className = nullptr)**

        Changes the application palette to **palette**.

        If **className** is passed, the change applies only to widgets that
        inherit **className** (as reported by **QObject::inherits** ()). If
        **className** is left 0, the change affects all widgets, thus overriding
        any previously set class specific palettes.

        The palette may be changed according to the current GUI style in
        **QStyle::polish** ().

        **Warning:** Do not use this function in conjunction with **Qt Style
        Sheets** . When using style sheets, the palette of a widget can be
        customized using the "color", "background-color", "selection-color",
        "selection-background-color" and "alternate-background-color".

        **Note:** Some styles do not use the palette for all drawing, for
        instance, if they make use of native theme engines. This is the case for
        the Windows Vista and macOS styles.

        **See also** **QWidget::setPalette** (), **palette** (), and
        **QStyle::polish** ().
        """
        ...

    @typing.overload
    @staticmethod
    def palette() -> QtGui.QPalette:
        """
        https://doc.qt.io/qt-5/qapplication.html#palette

        **[static] QPalette QApplication::palette(const QWidget * widget )**

        If a **widget** is passed, the default palette for the widget's class is
        returned. This may or may not be the application palette. In most cases
        there is no special palette for certain types of widgets, but one
        notable exception is the popup menu under Windows, if the user has
        defined a special background color for menus in the display settings.

        **See also** **setPalette** () and **QWidget::palette** ().
        """
        ...

    @typing.overload
    @staticmethod
    def palette(a0: QWidget) -> QtGui.QPalette:
        """
        https://doc.qt.io/qt-5/qapplication.html#palette-1

        **[static] QPalette QApplication::palette(const char * className )**

        This is an overloaded function.

        Returns the palette for widgets of the given **className**.

        **See also** **setPalette** () and **QWidget::palette** ().
        """
        ...

    @typing.overload
    @staticmethod
    def palette(className: str) -> QtGui.QPalette:
        """
        https://doc.qt.io/qt-5/qapplication.html#palette

        **[static] QPalette QApplication::palette(const QWidget * widget )**

        If a **widget** is passed, the default palette for the widget's class is
        returned. This may or may not be the application palette. In most cases
        there is no special palette for certain types of widgets, but one
        notable exception is the popup menu under Windows, if the user has
        defined a special background color for menus in the display settings.

        **See also** **setPalette** () and **QWidget::palette** ().
        """
        ...

    @staticmethod
    def setColorSpec(a0: int) -> None:
        ...

    @staticmethod
    def colorSpec() -> int:
        ...

    @typing.overload
    @staticmethod
    def setStyle(a0: "QStyle") -> None:
        """
        https://doc.qt.io/qt-5/qapplication.html#setStyle

        **[static] void QApplication::setStyle(QStyle * style )**

        Sets the application's GUI style to **style**. Ownership of the style
        object is transferred to **QApplication** , so **QApplication**  will
        delete the style object on application exit or when a new style is set
        and the old style is still the parent of the application object.

        Example usage:

        **QApplication** ::setStyle(**QStyleFactory** ::create("Fusion"));

        When switching application styles, the color palette is set back to the
        initial colors or the system defaults. This is necessary since certain
        styles have to adapt the color palette to be fully style-guide
        compliant.

        Setting the style before a palette has been set, i.e., before creating
        **QApplication** , will cause the application to use
        **QStyle::standardPalette** () for the palette.

        **Warning:** Qt style sheets are currently not supported for custom
        **QStyle**  subclasses. We plan to address this in some future release.

        **See also** **style** (), **QStyle** , **setPalette** (), and
        **desktopSettingsAware** ().
        """
        ...

    @typing.overload
    @staticmethod
    def setStyle(a0: str) -> "QStyle":
        """
        https://doc.qt.io/qt-5/qapplication.html#setStyle-1

        **[static] QStyle *QApplication::setStyle(const QString & style )**

        This is an overloaded function.

        Requests a **QStyle**  object for **style** from the **QStyleFactory** .

        The string must be one of the **QStyleFactory::keys** (), typically one
        of "windows", "windowsvista", "fusion", or "macintosh". Style names are
        case insensitive.

        Returns `nullptr` if an unknown **style** is passed, otherwise the
        **QStyle**  object returned is set as the application's GUI style.

        **Warning:** To ensure that the application's style is set correctly, it
        is best to call this function before the **QApplication**  constructor,
        if possible.
        """
        ...

    @staticmethod
    def style() -> "QStyle":
        """
        https://doc.qt.io/qt-5/qapplication.html#style

        **[static] QStyle *QApplication::style()**

        Returns the application's style object.

        **See also** **setStyle** () and **QStyle** .
        """
        ...

    @property
    def focusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qapplication.html#focusChanged

        **[signal] void QApplication::focusChanged(QWidget * old , QWidget * now
        )**

        This signal is emitted when the widget that has keyboard focus changed
        from **old** to **now** , i.e., because the user pressed the tab-key,
        clicked into a widget or changed the active window. Both **old** and
        **now** can be `nullptr`.

        The signal is emitted after both widget have been notified about the
        change through **QFocusEvent** .

        This function was introduced in Qt 4.1.

        **See also** **QWidget::setFocus** (), **QWidget::clearFocus** (), and
        **Qt::FocusReason** .
        """
        ...
