"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QAbstractSlider(QWidget):
    """
    https://doc.qt.io/qt-5/qabstractslider.html

    **Detailed Description**

    The class is designed as a common super class for widgets like
    **QScrollBar** , **QSlider**  and **QDial** .

    Here are the main properties of the class:

    1. **value** : The bounded integer that QAbstractSlider maintains.
      2.
    **minimum** : The lowest possible value.
      3. **maximum** : The highest
    possible value.
      4. **singleStep** : The smaller of two natural steps that
    an abstract sliders provides and typically corresponds to the user pressing
    an arrow key.
      5. **pageStep** : The larger of two natural steps that an
    abstract slider provides and typically corresponds to the user pressing
    PageUp or PageDown.
      6. **tracking** : Whether slider tracking is enabled.
    7. **sliderPosition** : The current position of the slider. If **tracking**
    is enabled (the default), this is identical to **value** .

    Unity (1) may be viewed as a third step size. **setValue** () lets you set
    the current value to any integer in the allowed range, not just **minimum**
    () + **n** * **singleStep** () for integer values of **n**. Some widgets may
    allow the user to set any value at all; others may just provide multiples of
    **singleStep** () or **pageStep** ().

    QAbstractSlider emits a comprehensive set of signals:

    SignalEmitted when
    **valueChanged** ()the value has changed. The
    **tracking**  determines whether this signal is emitted during user
    interaction.
    **sliderPressed** ()the user starts to drag the slider.
    **sliderMoved** ()the user drags the slider.
    **sliderReleased** ()the user
    releases the slider.
    **actionTriggered** ()a slider action was triggerd.
    **rangeChanged** ()a the range has changed.

    QAbstractSlider provides a virtual **sliderChange** () function that is well
    suited for updating the on-screen representation of sliders. By calling
    **triggerAction** (), subclasses trigger slider actions. Two helper
    functions **QStyle::sliderPositionFromValue** () and
    **QStyle::sliderValueFromPosition** () help subclasses and styles to map
    screen coordinates to logical range values.

    **See also** **QAbstractSpinBox** , **QSlider** , **QDial** , **QScrollBar**
    , and **Sliders Example** .
    """

    class SliderChange(int):
        SliderRangeChange: QAbstractSlider = ...
        SliderOrientationChange: QAbstractSlider = ...
        SliderStepsChange: QAbstractSlider = ...
        SliderValueChange: QAbstractSlider = ...

    class SliderAction(int):
        SliderNoAction: QAbstractSlider = ...
        SliderSingleStepAdd: QAbstractSlider = ...
        SliderSingleStepSub: QAbstractSlider = ...
        SliderPageStepAdd: QAbstractSlider = ...
        SliderPageStepSub: QAbstractSlider = ...
        SliderToMinimum: QAbstractSlider = ...
        SliderToMaximum: QAbstractSlider = ...
        SliderMove: QAbstractSlider = ...

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#QAbstractSlider

        **QAbstractSlider::QAbstractSlider(QWidget * parent = nullptr)**

        Constructs an abstract slider.

        The **parent** argument is sent to the **QWidget**  constructor.

        The **minimum**  defaults to 0, the **maximum**  to 99, with a
        **singleStep**  size of 1 and a **pageStep**  size of 10, and an initial
        **value**  of 0.
        """
        ...

    def changeEvent(self, e: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#changeEvent

        **[override virtual protected] void QAbstractSlider::changeEvent(QEvent
        * ev )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def wheelEvent(self, e: QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#wheelEvent

        **[override virtual protected] void
        QAbstractSlider::wheelEvent(QWheelEvent * e )**

        Reimplements: **QWidget::wheelEvent** (QWheelEvent *event).
        """
        ...

    def timerEvent(self, a0: QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#timerEvent

        **[override virtual protected] void
        QAbstractSlider::timerEvent(QTimerEvent * e )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    def keyPressEvent(self, ev: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#keyPressEvent

        **[override virtual protected] void
        QAbstractSlider::keyPressEvent(QKeyEvent * ev )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#event

        **[override virtual protected] bool QAbstractSlider::event(QEvent * e
        )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def sliderChange(self, change: "QAbstractSlider.SliderChange") -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#sliderChange

        **[virtual protected] void
        QAbstractSlider::sliderChange(QAbstractSlider::SliderChange change )**

        Reimplement this virtual function to track slider changes such as
        **SliderRangeChange** , **SliderOrientationChange** ,
        **SliderStepsChange** , or **SliderValueChange** . The default
        implementation only updates the display and ignores the **change**
        parameter.
        """
        ...

    def repeatAction(self) -> "QAbstractSlider.SliderAction":
        """
        https://doc.qt.io/qt-5/qabstractslider.html#repeatAction

        **[protected] QAbstractSlider::SliderAction
        QAbstractSlider::repeatAction() const**

        Returns the current repeat action.

        **See also** **setRepeatAction** ().
        """
        ...

    def setRepeatAction(
        self,
        action: "QAbstractSlider.SliderAction",
        thresholdTime: int = ...,
        repeatTime: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#setRepeatAction

        **[protected] void
        QAbstractSlider::setRepeatAction(QAbstractSlider::SliderAction action ,
        int thresholdTime = 500, int repeatTime = 50)**

        Sets action **action** to be triggered repetitively in intervals of
        **repeatTime** , after an initial delay of **thresholdTime**.

        **See also** **triggerAction** () and **repeatAction** ().
        """
        ...

    def setOrientation(self, a0: QtCore.Qt.Orientation) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#orientation-prop

        **orientation : Qt::Orientation**

        This property holds the orientation of the slider

        The orientation must be **Qt::Vertical**  (the default) or
        **Qt::Horizontal** .

        **Access functions:**

        Qt::Orientation **orientation** () const
        void **setOrientation** (
        **Qt::Orientation** )
        """
        ...

    def setValue(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#value-prop

        **value : int**

        This property holds the slider's current value

        The slider forces the value to be within the legal range: **minimum**
        <= `value` <= **maximum** .

        Changing the value also changes the **sliderPosition** .

        **Access functions:**

        int **value** () const
        void **setValue** ( **int** )

        **Notifier signal:**

        void ****valueChanged** ** (int **value** )

        **Member Function Documentation**
        """
        ...

    def triggerAction(self, action: "QAbstractSlider.SliderAction") -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#triggerAction

        **void QAbstractSlider::triggerAction(QAbstractSlider::SliderAction
        action )**

        Triggers a slider **action**. Possible actions are
        **SliderSingleStepAdd** , **SliderSingleStepSub** ,
        **SliderPageStepAdd** , **SliderPageStepSub** , **SliderToMinimum** ,
        **SliderToMaximum** , and **SliderMove** .

        **See also** **actionTriggered** ().
        """
        ...

    def value(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#value-prop

        **value : int**

        This property holds the slider's current value

        The slider forces the value to be within the legal range: **minimum**
        <= `value` <= **maximum** .

        Changing the value also changes the **sliderPosition** .

        **Access functions:**

        int **value** () const
        void **setValue** ( **int** )

        **Notifier signal:**

        void ****valueChanged** ** (int **value** )

        **Member Function Documentation**
        """
        ...

    def invertedControls(self) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#invertedControls-prop

        **invertedControls : bool**

        This property holds whether or not the slider inverts its wheel and key
        events.

        If this property is `false`, scrolling the mouse wheel "up" and using
        keys like page up will increase the slider's value towards its maximum.
        Otherwise pressing page up will move value towards the slider's minimum.

        **Access functions:**

        bool **invertedControls** () const
        void **setInvertedControls** (
        **bool** )
        """
        ...

    def setInvertedControls(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#invertedControls-prop

        **invertedControls : bool**

        This property holds whether or not the slider inverts its wheel and key
        events.

        If this property is `false`, scrolling the mouse wheel "up" and using
        keys like page up will increase the slider's value towards its maximum.
        Otherwise pressing page up will move value towards the slider's minimum.

        **Access functions:**

        bool **invertedControls** () const
        void **setInvertedControls** (
        **bool** )
        """
        ...

    def invertedAppearance(self) -> bool:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#invertedAppearance-prop

        **invertedAppearance : bool**

        This property holds whether or not a slider shows its values inverted.

        If this property is `false` (the default), the minimum and maximum will
        be shown in its classic position for the inherited widget. If the value
        is true, the minimum and maximum appear at their opposite location.

        Note: This property makes most sense for sliders and dials. For scroll
        bars, the visual effect of the scroll bar subcontrols depends on whether
        or not the styles understand inverted appearance; most styles ignore
        this property for scroll bars.

        **Access functions:**

        bool **invertedAppearance** () const
        void **setInvertedAppearance** (
        **bool** )
        """
        ...

    def setInvertedAppearance(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#invertedAppearance-prop

        **invertedAppearance : bool**

        This property holds whether or not a slider shows its values inverted.

        If this property is `false` (the default), the minimum and maximum will
        be shown in its classic position for the inherited widget. If the value
        is true, the minimum and maximum appear at their opposite location.

        Note: This property makes most sense for sliders and dials. For scroll
        bars, the visual effect of the scroll bar subcontrols depends on whether
        or not the styles understand inverted appearance; most styles ignore
        this property for scroll bars.

        **Access functions:**

        bool **invertedAppearance** () const
        void **setInvertedAppearance** (
        **bool** )
        """
        ...

    def sliderPosition(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#sliderPosition-prop

        **sliderPosition : int**

        This property holds the current slider position

        If **tracking**  is enabled (the default), this is identical to
        **value** .

        **Access functions:**

        int **sliderPosition** () const
        void **setSliderPosition** ( **int** )

        **Notifier signal:**

        void ****sliderMoved** ** (int **value** )
        """
        ...

    def setSliderPosition(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#sliderPosition-prop

        **sliderPosition : int**

        This property holds the current slider position

        If **tracking**  is enabled (the default), this is identical to
        **value** .

        **Access functions:**

        int **sliderPosition** () const
        void **setSliderPosition** ( **int** )

        **Notifier signal:**

        void ****sliderMoved** ** (int **value** )
        """
        ...

    def isSliderDown(self) -> bool:
        ...

    def setSliderDown(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#sliderDown-prop

        **sliderDown : bool**

        This property holds whether the slider is pressed down.

        The property is set by subclasses in order to let the abstract slider
        know whether or not **tracking**  has any effect.

        Changing the slider down property emits the **sliderPressed** () and
        **sliderReleased** () signals.

        **Access functions:**

        bool **isSliderDown** () const
        void **setSliderDown** ( **bool** )
        """
        ...

    def hasTracking(self) -> bool:
        ...

    def setTracking(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#tracking-prop

        **tracking : bool**

        This property holds whether slider tracking is enabled

        If tracking is enabled (the default), the slider emits the
        **valueChanged** () signal while the slider is being dragged. If
        tracking is disabled, the slider emits the **valueChanged** () signal
        only when the user releases the slider.

        **Access functions:**

        bool **hasTracking** () const
        void **setTracking** (bool **enable** )

        **See also** **sliderDown** .
        """
        ...

    def pageStep(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#pageStep-prop

        **pageStep : int**

        This property holds the page step.

        The larger of two natural steps that an abstract slider provides and
        typically corresponds to the user pressing PageUp or PageDown.

        **Access functions:**

        int **pageStep** () const
        void **setPageStep** ( **int** )

        **See also** **singleStep** .
        """
        ...

    def setPageStep(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#pageStep-prop

        **pageStep : int**

        This property holds the page step.

        The larger of two natural steps that an abstract slider provides and
        typically corresponds to the user pressing PageUp or PageDown.

        **Access functions:**

        int **pageStep** () const
        void **setPageStep** ( **int** )

        **See also** **singleStep** .
        """
        ...

    def singleStep(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#singleStep-prop

        **singleStep : int**

        This property holds the single step.

        The smaller of two natural steps that an abstract sliders provides and
        typically corresponds to the user pressing an arrow key.

        If the property is modified during an auto repeating key event, behavior
        is undefined.

        **Access functions:**

        int **singleStep** () const
        void **setSingleStep** ( **int** )

        **See also** **pageStep** .
        """
        ...

    def setSingleStep(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#singleStep-prop

        **singleStep : int**

        This property holds the single step.

        The smaller of two natural steps that an abstract sliders provides and
        typically corresponds to the user pressing an arrow key.

        If the property is modified during an auto repeating key event, behavior
        is undefined.

        **Access functions:**

        int **singleStep** () const
        void **setSingleStep** ( **int** )

        **See also** **pageStep** .
        """
        ...

    def setRange(self, min: int, max: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#setRange

        **[slot] void QAbstractSlider::setRange(int min , int max )**

        Sets the slider's minimum to **min** and its maximum to **max**.

        If **max** is smaller than **min** , **min** becomes the only legal
        value.

        **See also** **minimum**  and **maximum** .
        """
        ...

    def maximum(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#maximum-prop

        **maximum : int**

        This property holds the slider's maximum value

        When setting this property, the **minimum**  is adjusted if necessary to
        ensure that the range remains valid. Also the slider's current value is
        adjusted to be within the new range.

        **Access functions:**

        int **maximum** () const
        void **setMaximum** ( **int** )
        """
        ...

    def setMaximum(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#maximum-prop

        **maximum : int**

        This property holds the slider's maximum value

        When setting this property, the **minimum**  is adjusted if necessary to
        ensure that the range remains valid. Also the slider's current value is
        adjusted to be within the new range.

        **Access functions:**

        int **maximum** () const
        void **setMaximum** ( **int** )
        """
        ...

    def minimum(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#minimum-prop

        **minimum : int**

        This property holds the sliders's minimum value

        When setting this property, the **maximum**  is adjusted if necessary to
        ensure that the range remains valid. Also the slider's current value is
        adjusted to be within the new range.

        **Access functions:**

        int **minimum** () const
        void **setMinimum** ( **int** )
        """
        ...

    def setMinimum(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#minimum-prop

        **minimum : int**

        This property holds the sliders's minimum value

        When setting this property, the **maximum**  is adjusted if necessary to
        ensure that the range remains valid. Also the slider's current value is
        adjusted to be within the new range.

        **Access functions:**

        int **minimum** () const
        void **setMinimum** ( **int** )
        """
        ...

    def orientation(self) -> QtCore.Qt.Orientation:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#orientation-prop

        **orientation : Qt::Orientation**

        This property holds the orientation of the slider

        The orientation must be **Qt::Vertical**  (the default) or
        **Qt::Horizontal** .

        **Access functions:**

        Qt::Orientation **orientation** () const
        void **setOrientation** (
        **Qt::Orientation** )
        """
        ...

    @property
    def actionTriggered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#actionTriggered

        **[signal] void QAbstractSlider::actionTriggered(int action )**

        This signal is emitted when the slider action **action** is triggered.
        Actions are **SliderSingleStepAdd** , **SliderSingleStepSub** ,
        **SliderPageStepAdd** , **SliderPageStepSub** , **SliderToMinimum** ,
        **SliderToMaximum** , and **SliderMove** .

        When the signal is emitted, the **sliderPosition**  has been adjusted
        according to the action, but the **value**  has not yet been propagated
        (meaning the **valueChanged** () signal was not yet emitted), and the
        visual display has not been updated. In slots connected to this signal
        you can thus safely adjust any action by calling **setSliderPosition**
        () yourself, based on both the action and the slider's value.

        **See also** **triggerAction** ().
        """
        ...

    @property
    def rangeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#rangeChanged

        **[signal] void QAbstractSlider::rangeChanged(int min , int max )**

        This signal is emitted when the slider range has changed, with **min**
        being the new minimum, and **max** being the new maximum.

        **See also** **minimum**  and **maximum** .
        """
        ...

    @property
    def sliderMoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#sliderMoved

        **[signal] void QAbstractSlider::sliderMoved(int value )**

        This signal is emitted when **sliderDown**  is true and the slider
        moves. This usually happens when the user is dragging the slider. The
        **value** is the new slider position.

        This signal is emitted even when tracking is turned off.

        **Note:** Notifier signal for property **sliderPosition** .

        **See also** **setTracking** (), **valueChanged** (), **isSliderDown**
        (), **sliderPressed** (), and **sliderReleased** ().
        """
        ...

    @property
    def sliderPressed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#sliderPressed

        **[signal] void QAbstractSlider::sliderPressed()**

        This signal is emitted when the user presses the slider with the mouse,
        or programmatically when **setSliderDown** (true) is called.

        **See also** **sliderReleased** (), **sliderMoved** (), and
        **isSliderDown** ().
        """
        ...

    @property
    def sliderReleased(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#sliderReleased

        **[signal] void QAbstractSlider::sliderReleased()**

        This signal is emitted when the user releases the slider with the mouse,
        or programmatically when **setSliderDown** (false) is called.

        **See also** **sliderPressed** (), **sliderMoved** (), and
        **sliderDown** .
        """
        ...

    @property
    def valueChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractslider.html#valueChanged

        **[signal] void QAbstractSlider::valueChanged(int value )**

        This signal is emitted when the slider value has changed, with the new
        slider **value** as argument.

        **Note:** Notifier signal for property **value** .
        """
        ...
