"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtTextToSpeech import *


class QTextToSpeech(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qtexttospeech.html

    **Detailed Description**

    Use **say** () to start synthesizing text. It is possible to specify the
    language with **setLocale** (). To select between the available voices use
    **setVoice** (). The languages and voices depend on the available
    synthesizers on each platform. On Linux, `speech-dispatcher` is used by
    default.
    """

    class State(int):
        Ready: QTextToSpeech = ...
        Speaking: QTextToSpeech = ...
        Paused: QTextToSpeech = ...
        BackendError: QTextToSpeech = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#QTextToSpeech

        **QTextToSpeech::QTextToSpeech(QObject * parent = nullptr)**

        Loads a text-to-speech engine from a plug-in that uses the default
        engine plug-in and constructs a QTextToSpeech object as the child of
        **parent**.

        The default engine may be platform-specific.

        If the plugin fails to load, **QTextToSpeech::state** () returns
        **QTextToSpeech::BackendError** .

        **See also** **availableEngines** ().
        """
        ...

    @typing.overload
    def __init__(
        self, engine: str, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#QTextToSpeech-1

        **QTextToSpeech::QTextToSpeech(const QString & engine , QObject * parent
        = nullptr)**

        Loads a text-to-speech engine from a plug-in that matches parameter
        **engine** and constructs a QTextToSpeech object as the child of
        **parent**.

        If **engine** is empty, the default engine plug-in is used. The default
        engine may be platform-specific.

        If the plugin fails to load, **QTextToSpeech::state** () returns
        **QTextToSpeech::BackendError** .

        **See also** **availableEngines** ().
        """
        ...

    def setVoice(self, voice: "QVoice") -> None:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#setVoice

        **[slot] void QTextToSpeech::setVoice(const QVoice & voice )**

        Sets the **voice** to use.

        **Note:** On some platforms, setting the voice changes other voice
        attributes such as locale, pitch, and so on. These changes trigger the
        emission of signals.

        **Note:** Setter function for property **voice** .

        **See also** **voice** ().
        """
        ...

    def setVolume(self, volume: float) -> None:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#volume-prop

        **volume : double**

        This property holds the current volume, ranging from 0.0 to 1.0. The
        default value is the platform's default volume.

        **Access functions:**

        double **volume** () const
        void **setVolume** (double **volume** )

        **Notifier signal:**

        void **volumeChanged** (int **volume** )
        void **volumeChanged**
        (double **volume** )

        **Member Function Documentation**
        """
        ...

    def setPitch(self, pitch: float) -> None:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#pitch-prop

        **pitch : double**

        This property holds the voice pitch, ranging from -1.0 to 1.0. The
        default of 0.0 is the normal speech pitch.

        **Access functions:**

        double **pitch** () const
        void **setPitch** (double **pitch** )

        **Notifier signal:**

        void **pitchChanged** (double **pitch** )
        """
        ...

    def setRate(self, rate: float) -> None:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#rate-prop

        **rate : double**

        This property holds the current voice rate, ranging from -1.0 to 1.0.
        The default value of 0.0 is normal speech flow.

        **Access functions:**

        double **rate** () const
        void **setRate** (double **rate** )

        **Notifier signal:**

        void **rateChanged** (double **rate** )
        """
        ...

    def setLocale(self, locale: QtCore.QLocale) -> None:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#setLocale

        **[slot] void QTextToSpeech::setLocale(const QLocale & locale )**

        Sets the **locale** to a given locale if possible. The default is the
        system locale.

        **Note:** Setter function for property **locale** .

        **See also** **locale** ().
        """
        ...

    def resume(self) -> None:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#resume

        **[slot] void QTextToSpeech::resume()**

        Resume speaking after **pause** () has been called.

        **See also** **pause** ().
        """
        ...

    def pause(self) -> None:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#pause

        **[slot] void QTextToSpeech::pause()**

        Pauses the current speech.

        Note:

        * This function depends on the platform and the backend. It may not work
        at all, it may take several seconds before it takes effect, or it may
        pause instantly. Some synthesizers will look for a break that they can
        later resume from, such as a sentence end.
          * Due to Android platform
        limitations, pause() stops what is presently being said, while
        **resume** () starts the previously queued sentence from the beginning.

        **See also** **resume** ().
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#stop

        **[slot] void QTextToSpeech::stop()**

        Stop the text that is being read.
        """
        ...

    def say(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#say

        **[slot] void QTextToSpeech::say(const QString & text )**

        Start synthesizing the **text**. This function will start the
        asynchronous reading of the text. The current state is available using
        the **state**  property. Once the synthesis is done, a **stateChanged**
        () signal with the **Ready**  state is emitted.
        """
        ...

    @staticmethod
    def availableEngines() -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#availableEngines

        **[static] QStringList QTextToSpeech::availableEngines()**

        Gets the list of supported text-to-speech engine plug-ins.
        """
        ...

    def volume(self) -> float:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#volume-prop

        **volume : double**

        This property holds the current volume, ranging from 0.0 to 1.0. The
        default value is the platform's default volume.

        **Access functions:**

        double **volume** () const
        void **setVolume** (double **volume** )

        **Notifier signal:**

        void **volumeChanged** (int **volume** )
        void **volumeChanged**
        (double **volume** )

        **Member Function Documentation**
        """
        ...

    def pitch(self) -> float:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#pitch-prop

        **pitch : double**

        This property holds the voice pitch, ranging from -1.0 to 1.0. The
        default of 0.0 is the normal speech pitch.

        **Access functions:**

        double **pitch** () const
        void **setPitch** (double **pitch** )

        **Notifier signal:**

        void **pitchChanged** (double **pitch** )
        """
        ...

    def rate(self) -> float:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#rate-prop

        **rate : double**

        This property holds the current voice rate, ranging from -1.0 to 1.0.
        The default value of 0.0 is normal speech flow.

        **Access functions:**

        double **rate** () const
        void **setRate** (double **rate** )

        **Notifier signal:**

        void **rateChanged** (double **rate** )
        """
        ...

    def availableVoices(self) -> typing.List["QVoice"]:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#availableVoices

        **QVector<QVoice> QTextToSpeech::availableVoices() const**

        Gets a vector of voices available for the current locale.

        **Note:** if no locale has been set, the system locale is used.
        """
        ...

    def voice(self) -> "QVoice":
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#voice-prop

        **voice : QVoice**

        This property holds the current voice used for the speech.

        **Access functions:**

        QVoice **voice** () const
        void ****setVoice** ** (const QVoice &
        **voice** )

        **Notifier signal:**

        void **voiceChanged** (const QVoice & **voice** )
        """
        ...

    def locale(self) -> QtCore.QLocale:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#locale-prop

        **locale : QLocale**

        This property holds the current locale in use. By default, the system
        locale is used.

        **Access functions:**

        QLocale **locale** () const
        void ****setLocale** ** (const QLocale &
        **locale** )

        **Notifier signal:**

        void **localeChanged** (const QLocale & **locale** )
        """
        ...

    def availableLocales(self) -> typing.List[QtCore.QLocale]:
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#availableLocales

        **QVector<QLocale> QTextToSpeech::availableLocales() const**

        Gets a vector of locales that are currently supported.

        **Note:** On some platforms these can change, for example, when the
        backend changes synthesizers.
        """
        ...

    def state(self) -> "QTextToSpeech.State":
        """
        https://doc.qt.io/qt-5/qtexttospeech.html#state-prop

        **state : const State**

        This property holds the current state of the speech synthesizer. Use
        **say** () to start synthesizing text with the current voice and locale.

        **Access functions:**

        QTextToSpeech::State **state** () const

        **Notifier signal:**

        void **stateChanged** (QTextToSpeech::State **state** )
        """
        ...

    @property
    def localeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def pitchChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def rateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def voiceChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def volumeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def volumeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
