"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtWidgets
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtSvg import *


class QSvgWidget(QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-5/qsvgwidget.html

    **Detailed Description**

    This class enables developers to display SVG drawings alongside standard
    widgets, and is used in much the same way as **QLabel**  is used for
    displaying text and bitmap images.

    Since QSvgWidget is a subclass of **QWidget** , SVG drawings are rendered
    using the properties of the display. More control can be exercised over the
    rendering process with the **QSvgRenderer**  class, as this can be used to
    paint onto other paint devices, such as **QImage**  and QGLWidget. The
    renderer used by the widget can be obtained with the **renderer** ()
    function.

    Each QSvgWidget can be constructed with the file name of a SVG file, or they
    can be constructed without a specific file to render and one can be supplied
    later. The **load** () functions provide two different ways to load an SVG
    file: they accept either the file name of an SVG file or a **QByteArray**
    containing the serialized XML representation of an SVG file.

    By default, the widget provides a size hint to reflect the size of the
    drawing that it displays. If no data has been loaded, the widget provides
    the default **QWidget**  size hint. Subclass this class and reimplement
    **sizeHint** () if you need to customize this behavior.

    **See also** **QSvgRenderer** , **Qt SVG C++ Classes** , and **QPicture** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsvgwidget.html#QSvgWidget

        **QSvgWidget::QSvgWidget(QWidget * parent = nullptr)**

        Constructs a new SVG display widget with the given **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, file: str, parent: typing.Optional[QtWidgets.QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsvgwidget.html#QSvgWidget-1

        **QSvgWidget::QSvgWidget(const QString & file , QWidget * parent =
        nullptr)**

        Constructs a new SVG display widget with the given **parent** and loads
        the contents of the specified **file**.
        """
        ...

    def paintEvent(self, event: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qsvgwidget.html#paintEvent

        **[override virtual protected] void QSvgWidget::paintEvent(QPaintEvent *
        event )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    @typing.overload
    def load(self, file: str) -> None:
        """
        https://doc.qt.io/qt-5/qsvgwidget.html#load

        **[slot] void QSvgWidget::load(const QString & file )**

        Loads the contents of the specified SVG **file** and updates the widget.
        """
        ...

    @typing.overload
    def load(self, contents: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qsvgwidget.html#load-1

        **[slot] void QSvgWidget::load(const QByteArray & contents )**

        Loads the specified SVG format **contents** and updates the widget.
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qsvgwidget.html#sizeHint

        **[override virtual] QSize QSvgWidget::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    def renderer(self) -> QSvgRenderer:
        """
        https://doc.qt.io/qt-5/qsvgwidget.html#renderer

        **QSvgRenderer *QSvgWidget::renderer() const**

        Returns the renderer used to display the contents of the widget.
        """
        ...
