"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore


class QSvgGenerator(QtGui.QPaintDevice):
    """
    https://doc.qt.io/qt-5/qsvggenerator.html

    **Detailed Description**

    This paint device represents a Scalable Vector Graphics (SVG) drawing. Like
    QPrinter, it is designed as a write-only device that generates output in a
    specific format.

    To write an SVG file, you first need to configure the output by setting the
    **fileName**  or **outputDevice**  properties. It is usually necessary to
    specify the size of the drawing by setting the **size**  property, and in
    some cases where the drawing will be included in another, the **viewBox**
    property also needs to be set.

    **QSvgGenerator**  generator;
            generator.setFileName(path);
    generator.setSize(**QSize** (200, 200));
    generator.setViewBox(**QRect** (0, 0, 200, 200));
    generator.setTitle(tr("SVG Generator Example Drawing"));
    generator.setDescription(tr("An SVG drawing created by the SVG Generator "
    "Example provided with Qt."));

    Other meta-data can be specified by setting the **title** , **description**
    and **resolution** properties.

    As with other **QPaintDevice**  subclasses, a **QPainter**  object is used
    to paint onto an instance of this class:

    **QPainter**  painter;
            painter.begin(&generator);
            ...
    painter.end();

    Painting is performed in the same way as for any other paint device.
    However, it is necessary to use the **QPainter::begin** () and **end()**  to
    explicitly begin and end painting on the device.

    The **SVG Generator Example**  shows how the same painting commands can be
    used for painting a widget and writing an SVG file.

    **See also** **QSvgRenderer** , **QSvgWidget** , and **Qt SVG C++ Classes**
    .
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#QSvgGenerator

        **QSvgGenerator::QSvgGenerator()**

        Constructs a new generator.
        """
        ...

    def metric(self, metric: QtGui.QPaintDevice.PaintDeviceMetric) -> int:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#metric

        **[override virtual protected] int
        QSvgGenerator::metric(QPaintDevice::PaintDeviceMetric metric ) const**

        Reimplements: **QPaintDevice::metric** (QPaintDevice::PaintDeviceMetric
        metric) const.
        """
        ...

    def paintEngine(self) -> QtGui.QPaintEngine:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#paintEngine

        **[override virtual protected] QPaintEngine
        *QSvgGenerator::paintEngine() const**

        Reimplements: **QPaintDevice::paintEngine** () const.

        Returns the paint engine used to render graphics to be converted to SVG
        format information.
        """
        ...

    @typing.overload
    def setViewBox(self, viewBox: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#viewBox

        **QRect QSvgGenerator::viewBox() const**

        Returns **viewBoxF** ().toRect().

        This function was introduced in Qt 4.5.

        **See also** **setViewBox** () and **viewBoxF** ().
        """
        ...

    @typing.overload
    def setViewBox(self, viewBox: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#viewBox-prop

        **viewBox : QRectF**

        This property holds the viewBox of the generated SVG drawing

        By default this property is set to `QRect(0, 0, -1, -1)`, which
        indicates that the generator should not output the viewBox attribute of
        the `<svg>` element.

        **Note:** It is not possible to change this property while a
        **QPainter**  is active on the generator.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QRectF **viewBoxF** () const
        void **setViewBox** (const QRect &
        **viewBox** )
        void **setViewBox** (const QRectF & **viewBox** )

        **See also** **viewBox** (), **size** , and **resolution** .

        **Member Function Documentation**
        """
        ...

    def viewBoxF(self) -> QtCore.QRectF:
        ...

    def viewBox(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#viewBox

        **QRect QSvgGenerator::viewBox() const**

        Returns **viewBoxF** ().toRect().

        This function was introduced in Qt 4.5.

        **See also** **setViewBox** () and **viewBoxF** ().
        """
        ...

    def setDescription(self, description: str) -> None:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#description-prop

        **description : QString**

        This property holds the description of the generated SVG drawing

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **description** () const
        void **setDescription** (const
        QString & **description** )

        **See also** **title** .
        """
        ...

    def description(self) -> str:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#description-prop

        **description : QString**

        This property holds the description of the generated SVG drawing

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **description** () const
        void **setDescription** (const
        QString & **description** )

        **See also** **title** .
        """
        ...

    def setTitle(self, title: str) -> None:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#title-prop

        **title : QString**

        This property holds the title of the generated SVG drawing

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &
        **title** )

        **See also** **description** .
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#title-prop

        **title : QString**

        This property holds the title of the generated SVG drawing

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &
        **title** )

        **See also** **description** .
        """
        ...

    def setResolution(self, resolution: int) -> None:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#resolution-prop

        **resolution : int**

        This property holds the resolution of the generated output

        The resolution is specified in dots per inch, and is used to calculate
        the physical size of an SVG drawing.

        This property was introduced in Qt 4.5.

        **Access functions:**

        int **resolution** () const
        void **setResolution** (int **dpi** )

        **See also** **size**  and **viewBox** .
        """
        ...

    def resolution(self) -> int:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#resolution-prop

        **resolution : int**

        This property holds the resolution of the generated output

        The resolution is specified in dots per inch, and is used to calculate
        the physical size of an SVG drawing.

        This property was introduced in Qt 4.5.

        **Access functions:**

        int **resolution** () const
        void **setResolution** (int **dpi** )

        **See also** **size**  and **viewBox** .
        """
        ...

    def setOutputDevice(self, outputDevice: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#outputDevice-prop

        **outputDevice : QIODevice***

        This property holds the output device for the generated SVG drawing

        If both output device and file name are specified, the output device
        will have precedence.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QIODevice * **outputDevice** () const
        void **setOutputDevice**
        (QIODevice * **outputDevice** )

        **See also** **fileName** .
        """
        ...

    def outputDevice(self) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#outputDevice-prop

        **outputDevice : QIODevice***

        This property holds the output device for the generated SVG drawing

        If both output device and file name are specified, the output device
        will have precedence.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QIODevice * **outputDevice** () const
        void **setOutputDevice**
        (QIODevice * **outputDevice** )

        **See also** **fileName** .
        """
        ...

    def setFileName(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#fileName-prop

        **fileName : QString**

        This property holds the target filename for the generated SVG drawing

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **fileName** () const
        void **setFileName** (const QString &
        **fileName** )

        **See also** **outputDevice** .
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#fileName-prop

        **fileName : QString**

        This property holds the target filename for the generated SVG drawing

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **fileName** () const
        void **setFileName** (const QString &
        **fileName** )

        **See also** **outputDevice** .
        """
        ...

    def setSize(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#size-prop

        **size : QSize**

        This property holds the size of the generated SVG drawing

        By default this property is set to `QSize(-1, -1)`, which indicates that
        the generator should not output the width and height attributes of the
        `<svg>` element.

        **Note:** It is not possible to change this property while a
        **QPainter**  is active on the generator.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QSize **size** () const
        void **setSize** (const QSize & **size** )

        **See also** **viewBox**  and **resolution** .
        """
        ...

    def size(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qsvggenerator.html#size-prop

        **size : QSize**

        This property holds the size of the generated SVG drawing

        By default this property is set to `QSize(-1, -1)`, which indicates that
        the generator should not output the width and height attributes of the
        `<svg>` element.

        **Note:** It is not possible to change this property while a
        **QPainter**  is active on the generator.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QSize **size** () const
        void **setSize** (const QSize & **size** )

        **See also** **viewBox**  and **resolution** .
        """
        ...
