"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
from PyQt5.QtSensors import *


class QTapReading(QSensorReading):
    """
    https://doc.qt.io/qt-5/qtapreading.html

    **Detailed Description**

    **QTapReading Units**

    The tap sensor registers tap events along the 3 axes that originate from the
    phone. The axes are arranged as follows.

    ![](images/sensors-coordinates2.jpg)

    By default it returns only double tap events. The
    **QTapSensor::returnDoubleTapEvents**  property must be set to false to
    return individual tap events.
    """

    class TapDirection(int):
        Undefined: QTapReading = ...
        X: QTapReading = ...
        Y: QTapReading = ...
        Z: QTapReading = ...
        X_Pos: QTapReading = ...
        Y_Pos: QTapReading = ...
        Z_Pos: QTapReading = ...
        X_Neg: QTapReading = ...
        Y_Neg: QTapReading = ...
        Z_Neg: QTapReading = ...
        X_Both: QTapReading = ...
        Y_Both: QTapReading = ...
        Z_Both: QTapReading = ...

    def setDoubleTap(self, doubleTap: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtapreading.html#setDoubleTap

        **void QTapReading::setDoubleTap(bool doubleTap )**

        Sets the double tap status of the reading to **doubleTap**.

        **See also** **isDoubleTap** ().
        """
        ...

    def isDoubleTap(self) -> bool:
        ...

    def setTapDirection(self, tapDirection: "QTapReading.TapDirection") -> None:
        """
        https://doc.qt.io/qt-5/qtapreading.html#setTapDirection

        **void QTapReading::setTapDirection(QTapReading::TapDirection
        tapDirection )**

        Sets the tap direction to **tapDirection**.

        **See also** **tapDirection** ().
        """
        ...

    def tapDirection(self) -> "QTapReading.TapDirection":
        """
        https://doc.qt.io/qt-5/qtapreading.html#tapDirection-prop

        **tapDirection : const TapDirection**

        This property holds the direction of the tap.

        **Access functions:**

        QTapReading::TapDirection **tapDirection** () const

        **See also** **QTapReading Units** .

        **Member Function Documentation**
        """
        ...
