"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtSensors import *
from PyQt5 import sip


class QSensorFilter(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qsensorfilter.html

    **Detailed Description**

    Some sensors (eg. the accelerometer) are often accessed very frequently.
    This may be slowed down by the use of signals and slots. The QSensorFilter
    interface provides a more efficient way for the sensor to notify your class
    that the sensor has changed.

    Additionally, multiple filters can be added to a sensor. They are called in
    order and each filter has the option to modify the values in the reading or
    to suppress the reading altogether.

    Note that the values in the class returned by **QSensor::reading** () will
    not be updated until after the filters have been run.

    **See also** **filter** ().
    """

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, a0: "QSensorFilter") -> None:
        ...

    def filter(self, reading: QSensorReading) -> bool:
        """
        https://doc.qt.io/qt-5/qsensorfilter.html#filter

        **[pure virtual] bool QSensorFilter::filter(QSensorReading * reading )**

        This function is called when the sensor **reading** changes.

        The filter can modify the reading.

        Returns true to allow the next filter to receive the value. If this is
        the last filter, returning true causes the signal to be emitted and the
        value is stored in the sensor.

        Returns false to drop the reading.
        """
        ...
