"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
from PyQt5.QtSensors import *


class QHumidityReading(QSensorReading):
    """
    https://doc.qt.io/qt-5/qhumidityreading.html

    **Detailed Description**

    **QHumidityReading Units**

    The humidity sensor returns the relative humidity as a percentage, and
    absolute humidity in grams per cubic meter (g/m3). Note that some sensors
    may not support absolute humidity, 0 will be returned in this case.
    """

    def setAbsoluteHumidity(self, value: float) -> None:
        """
        https://doc.qt.io/qt-5/qhumidityreading.html#setAbsoluteHumidity

        **void QHumidityReading::setAbsoluteHumidity(qreal value )**

        Sets **absoluteHumidity**  to **value**.

        **See also** **absoluteHumidity** ().
        """
        ...

    def absoluteHumidity(self) -> float:
        """
        https://doc.qt.io/qt-5/qhumidityreading.html#absoluteHumidity-prop

        **absoluteHumidity : const qreal**

        Absolute humidity Measured in grams per cubic meter. Note that some
        sensors may not support absolute humidity.

        **Access functions:**

        qreal **absoluteHumidity** () const

        **See also** **QHumidityReading Units** .
        """
        ...

    def setRelativeHumidity(self, percent: float) -> None:
        """
        https://doc.qt.io/qt-5/qhumidityreading.html#setRelativeHumidity

        **void QHumidityReading::setRelativeHumidity(qreal humidity )**

        Sets **relativeHumidity**  to **humidity**.

        **See also** **relativeHumidity** ().
        """
        ...

    def relativeHumidity(self) -> float:
        """
        https://doc.qt.io/qt-5/qhumidityreading.html#relativeHumidity-prop

        **relativeHumidity : const qreal**

        Relative humidity Returned as a percentage.

        **Access functions:**

        qreal **relativeHumidity** () const

        **See also** **QHumidityReading Units** .

        **Member Function Documentation**
        """
        ...
