"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtRemoteObjects import *


class QRemoteObjectRegistry(QRemoteObjectReplica):
    """
    https://doc.qt.io/qt-5/qremoteobjectregistry.html

    **Detailed Description**

    The Registry is a special Source/Replica pair held by a **node**  itself. It
    knows about all other **Source** s available on the network, and simplifies
    the process of connecting to other **node** s.
    """

    def sourceLocations(self) -> typing.Dict[str, "QRemoteObjectSourceLocationInfo"]:
        """
        https://doc.qt.io/qt-5/qremoteobjectregistry.html#sourceLocations

        **QRemoteObjectSourceLocations QRemoteObjectRegistry::sourceLocations()
        const**

        Returns a QRemoteObjectSourceLocations object, which includes the name
        and additional information of all sources known to the registry.

        **Note:** Getter function for property sourceLocations.
        """
        ...

    @property
    def remoteObjectAdded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qremoteobjectregistry.html#remoteObjectAdded

        **[signal] void QRemoteObjectRegistry::remoteObjectAdded(const
        QRemoteObjectSourceLocation & entry )**

        This signal is emitted whenever a new source location is added to the
        registry.

        **entry** is a QRemoteObjectSourceLocation, a typedef for **QPair**
        <**QString** , **QUrl** >.

        **See also** **remoteObjectRemoved** ().
        """
        ...

    @property
    def remoteObjectRemoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qremoteobjectregistry.html#remoteObjectRemoved

        **[signal] void QRemoteObjectRegistry::remoteObjectRemoved(const
        QRemoteObjectSourceLocation & entry )**

        This signal is emitted whenever a Source location is removed from the
        Registry.

        **entry** is a QRemoteObjectSourceLocation, a typedef for **QPair**
        <**QString** , **QUrl** >.

        **See also** **remoteObjectAdded** ().
        """
        ...
