"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtRemoteObjects import *


class QRemoteObjectNode(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qremoteobjectnode.html

    **Detailed Description**

    The QRemoteObjectNode class provides an entry point to a **QtRemoteObjects**
    network. A network can be as simple as two nodes, or an arbitrarily complex
    set of processes and devices.

    A QRemoteObjectNode does not have a url that other nodes can connect to, and
    thus is able to acquire replicas only. It is not able to share source
    objects (only **QRemoteObjectHost**  and **QRemoteObjectRegistryHost**
    Nodes can share).

    Nodes may connect to each other directly using **connectToNode** , or they
    can use the **QRemoteObjectRegistry**  to simplify connections.

    The **QRemoteObjectRegistry**  is a special replica available to every node
    that connects to the Registry Url. It knows how to connect to every
    QRemoteObjectSource object on the network.

    **See also** **QRemoteObjectHost**  and **QRemoteObjectRegistryHost** .
    """

    class ErrorCode(int):
        NoError: QRemoteObjectNode = ...
        RegistryNotAcquired: QRemoteObjectNode = ...
        RegistryAlreadyHosted: QRemoteObjectNode = ...
        NodeIsNoServer: QRemoteObjectNode = ...
        ServerAlreadyCreated: QRemoteObjectNode = ...
        UnintendedRegistryHosting: QRemoteObjectNode = ...
        OperationNotValidOnClientNode: QRemoteObjectNode = ...
        SourceNotRegistered: QRemoteObjectNode = ...
        MissingObjectName: QRemoteObjectNode = ...
        HostUrlInvalid: QRemoteObjectNode = ...
        ProtocolMismatch: QRemoteObjectNode = ...
        ListenFailed: QRemoteObjectNode = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#QRemoteObjectNode

        **QRemoteObjectNode::QRemoteObjectNode(QObject * parent = nullptr)**

        Default constructor for QRemoteObjectNode with the given **parent**. A
        Node constructed in this manner can not be connected to, and thus can
        not expose Source objects on the network. It also will not include a
        **QRemoteObjectRegistry** , unless set manually using **setRegistryUrl**
        .

        **See also** **connectToNode**  and **setRegistryUrl** .
        """
        ...

    @typing.overload
    def __init__(
        self,
        registryAddress: QtCore.QUrl,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#QRemoteObjectNode-1

        **QRemoteObjectNode::QRemoteObjectNode(const QUrl & registryAddress ,
        QObject * parent = nullptr)**

        QRemoteObjectNode connected to a {**QRemoteObjectRegistry** }
        {Registry}. A Node constructed in this manner can not be connected to,
        and thus can not expose Source objects on the network. Finding and
        connecting to other (Host) Nodes is handled by the
        **QRemoteObjectRegistry**  specified by **registryAddress**.

        **See also** **connectToNode** , **setRegistryUrl** ,
        **QRemoteObjectHost** , and **QRemoteObjectRegistryHost** .
        """
        ...

    def timerEvent(self, a0: QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#timerEvent

        **[override virtual protected] void QRemoteObjectNode::timerEvent(
        QTimerEvent * )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    def error(self, errorCode: "QRemoteObjectNode.ErrorCode") -> None:
        ...

    def setHeartbeatInterval(self, interval: int) -> None:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#heartbeatInterval-prop

        **heartbeatInterval : int**

        Heartbeat interval in ms.

        The heartbeat (only helpful for socket connections) will periodically
        send a message to connected nodes to detect whether the connection was
        disrupted. Qt Remote Objects will try to reconnect automatically if it
        detects a dropped connection. This function can help with that detection
        since the client will only detect that the server is unavailable when it
        tries to send data.

        A value of `0` (the default) will disable the heartbeat.

        **Access functions:**

        int **heartbeatInterval** () const
        void **setHeartbeatInterval** (int
        **interval** )

        **Notifier signal:**

        void **heartbeatIntervalChanged** (int **heartbeatInterval** )
        """
        ...

    def heartbeatInterval(self) -> int:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#heartbeatInterval-prop

        **heartbeatInterval : int**

        Heartbeat interval in ms.

        The heartbeat (only helpful for socket connections) will periodically
        send a message to connected nodes to detect whether the connection was
        disrupted. Qt Remote Objects will try to reconnect automatically if it
        detects a dropped connection. This function can help with that detection
        since the client will only detect that the server is unavailable when it
        tries to send data.

        A value of `0` (the default) will disable the heartbeat.

        **Access functions:**

        int **heartbeatInterval** () const
        void **setHeartbeatInterval** (int
        **interval** )

        **Notifier signal:**

        void **heartbeatIntervalChanged** (int **heartbeatInterval** )
        """
        ...

    def lastError(self) -> "QRemoteObjectNode.ErrorCode":
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#lastError

        **QRemoteObjectNode::ErrorCode QRemoteObjectNode::lastError() const**

        Returns the last error set.
        """
        ...

    def setPersistedStore(
        self, persistedStore: QRemoteObjectAbstractPersistedStore
    ) -> None:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#persistedStore-prop

        **persistedStore : QRemoteObjectAbstractPersistedStore***

        Allows setting a **QRemoteObjectAbstractPersistedStore**  instance for
        the node.

        Allows replica **PROP**  members with the PERSISTED trait to save their
        current value when the replica is deleted and restore a stored value the
        next time the replica is started.

        Requires a **QRemoteObjectAbstractPersistedStore**  class implementation
        to control where and how persistence is handled.

        This property was introduced in Qt 5.11.

        **Access functions:**

        QRemoteObjectAbstractPersistedStore * **persistedStore** () const
        void
        **setPersistedStore** (QRemoteObjectAbstractPersistedStore *
        **persistedStore** )
        """
        ...

    def persistedStore(self) -> QRemoteObjectAbstractPersistedStore:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#persistedStore-prop

        **persistedStore : QRemoteObjectAbstractPersistedStore***

        Allows setting a **QRemoteObjectAbstractPersistedStore**  instance for
        the node.

        Allows replica **PROP**  members with the PERSISTED trait to save their
        current value when the replica is deleted and restore a stored value the
        next time the replica is started.

        Requires a **QRemoteObjectAbstractPersistedStore**  class implementation
        to control where and how persistence is handled.

        This property was introduced in Qt 5.11.

        **Access functions:**

        QRemoteObjectAbstractPersistedStore * **persistedStore** () const
        void
        **setPersistedStore** (QRemoteObjectAbstractPersistedStore *
        **persistedStore** )
        """
        ...

    def registry(self) -> "QRemoteObjectRegistry":
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#registry

        **const QRemoteObjectRegistry *QRemoteObjectNode::registry() const**

        Returns a pointer to the Node's **QRemoteObjectRegistry** , if the Node
        is using the Registry feature; otherwise it returns 0.
        """
        ...

    def waitForRegistry(self, timeout: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#waitForRegistry

        **bool QRemoteObjectNode::waitForRegistry(int timeout = 30000)**

        Blocks until this Node's **Registry**  is initialized or **timeout** (in
        milliseconds) expires. Returns `true` if the **Registry**  is
        successfully initialized upon return, or `false` otherwise.
        """
        ...

    def setRegistryUrl(self, registryAddress: QtCore.QUrl) -> bool:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#registryUrl-prop

        **registryUrl : QUrl**

        This property holds the address of the **Registry**  used by this node.

        This is an empty **QUrl**  if there is no registry in use.

        **Access functions:**

        QUrl **registryUrl** () const
        virtual bool **setRegistryUrl** (const
        QUrl & **registryAddress** )

        **Member Function Documentation**
        """
        ...

    def registryUrl(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#registryUrl-prop

        **registryUrl : QUrl**

        This property holds the address of the **Registry**  used by this node.

        This is an empty **QUrl**  if there is no registry in use.

        **Access functions:**

        QUrl **registryUrl** () const
        virtual bool **setRegistryUrl** (const
        QUrl & **registryAddress** )

        **Member Function Documentation**
        """
        ...

    def acquireModel(
        self,
        name: str,
        action: "QtRemoteObjects.InitialAction" = ...,
        rolesHint: typing.Iterable[int] = ...,
    ) -> QAbstractItemModelReplica:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#acquireModel

        **QAbstractItemModelReplica *QRemoteObjectNode::acquireModel(const
        QString & name , QtRemoteObjects::InitialAction action =
        QtRemoteObjects::FetchRootSize, const QVector<int> & rolesHint = {})**

        Returns a pointer to a Replica which is specifically derived from
        **QAbstractItemModel** . The **name** provided must match the name used
        with the matching **enableRemoting**  that put the Model on the network.
        The returned model will be empty until it is initialized with the
        **Source** .
        """
        ...

    def acquireDynamic(self, name: str) -> QRemoteObjectDynamicReplica:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#acquireDynamic

        **QRemoteObjectDynamicReplica *QRemoteObjectNode::acquireDynamic(const
        QString & name )**

        Returns a **QRemoteObjectDynamicReplica**  of the Source **name**.
        """
        ...

    def instances(self, typeName: str) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#instances

        **template <typename T> QStringList QRemoteObjectNode::instances()
        const**

        This templated function (taking a **repc**  generated type as the
        template parameter) will return the list of names of every instance of
        that type on the Remote Objects network. For example, if you have a
        Shape class defined in a .rep file, and Circle and Square classes
        inherit from the Source definition, they can be shared on the Remote
        Objects network using **enableRemoting** .

        Square square;
            Circle circle;
            myHost.enableRemoting(&square,
        "Square");
            myHost.enableRemoting(&circle, "Circle");

        Then instance can be used to find the available instances of Shape.

        **QStringList**  instances = clientNode.instances<Shape>();
            // will
        return a QStringList containing "Circle" and "Square"
            auto instance1
        = clientNode.acquire<Shape>("Circle");
            auto instance2 =
        clientNode.acquire<Shape>("Square");
            ...
        """
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#setName

        **[virtual] void QRemoteObjectNode::setName(const QString & name )**

        Sets **name** as the internal name for this Node. This is then output as
        part of the logging (if enabled). This is primarily useful if you merge
        log data from multiple nodes.
        """
        ...

    def addClientSideConnection(self, ioDevice: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#addClientSideConnection

        **void QRemoteObjectNode::addClientSideConnection(QIODevice * ioDevice
        )**

        In order to **QRemoteObjectNode::acquire** () **Replica**  objects over
        **External QIODevices** , Qt Remote Objects needs access to the
        communications channel (a **QIODevice** ) between the respective nodes.
        It is the addClientSideConnection() call that enables this, taking the
        **ioDevice** as input. Any **acquire** () call made without calling
        addClientSideConnection will still work, but the Node will not be able
        to initialize the **Replica**  without being provided the connection to
        the Host node.

        This function was introduced in Qt 5.12.

        **See also** **QRemoteObjectHostBase::addHostSideConnection** .
        """
        ...

    def connectToNode(self, address: QtCore.QUrl) -> bool:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#connectToNode

        **bool QRemoteObjectNode::connectToNode(const QUrl & address )**

        Connects a client node to the host node at **address**.

        Connections will remain valid until the host node is deleted or no
        longer accessible over a network.

        Once a client is connected to a host, valid Replicas can then be
        acquired if the corresponding Source is being remoted.

        Return `true` on success, `false` otherwise (usually an unrecognized
        url, or connecting to already connected address).

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    @property
    def heartbeatIntervalChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def remoteObjectAdded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#remoteObjectAdded

        **[signal] void QRemoteObjectNode::remoteObjectAdded(const
        QRemoteObjectSourceLocation & loc )**

        This signal is emitted whenever a new **Source**  object is added to the
        Registry. The signal will not be emitted if there is no Registry set
        (i.e., Sources over connections made via **connectToNode**  directly).
        The **loc** parameter contains the information about the added Source,
        including name, type and the **QUrl**  of the hosting Node.

        **See also** **remoteObjectRemoved** () and **instances** ().
        """
        ...

    @property
    def remoteObjectRemoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qremoteobjectnode.html#remoteObjectRemoved

        **[signal] void QRemoteObjectNode::remoteObjectRemoved(const
        QRemoteObjectSourceLocation & loc )**

        This signal is emitted whenever there is a known **Source**  object is
        removed from the Registry. The signal will not be emitted if there is no
        Registry set (i.e., Sources over connections made via **connectToNode**
        directly). The **loc** parameter contains the information about the
        removed Source, including name, type and the **QUrl**  of the hosting
        Node.

        **See also** **remoteObjectAdded**  and **instances** .
        """
        ...
