"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtRemoteObjects import *


class QRemoteObjectHost(QRemoteObjectHostBase):
    """
    https://doc.qt.io/qt-5/qremoteobjecthost.html

    **Detailed Description**

    The QRemoteObjectHost class provides an entry point to a **QtRemoteObjects**
    network. A network can be as simple as two nodes, or an arbitrarily complex
    set of processes and devices.

    QRemoteObjectHosts have the same capabilities as QRemoteObjectNodes, but
    they can also be connected to and can share source objects on the network.

    Nodes may connect to each other directly using **connectToNode** , or they
    can use the **QRemoteObjectRegistry**  to simplify connections.

    The **QRemoteObjectRegistry**  is a special replica available to every node
    that connects to the uegistry Url. It knows how to connect to every
    QRemoteObjectSource object on the network.

    **See also** **QRemoteObjectNode**  and **QRemoteObjectRegistryHost** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qremoteobjecthost.html#QRemoteObjectHost

        **QRemoteObjectHost::QRemoteObjectHost(QObject * parent = nullptr)**

        Constructs a new QRemoteObjectHost Node (i.e., a Node that supports
        exposing **Source**  objects on the QtRO network) with the given
        **parent**. This constructor is meant specific to support QML in the
        future as it will not be available to connect to until **setHostUrl**
        is called.

        **See also** **setHostUrl** () and **setRegistryUrl** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        address: QtCore.QUrl,
        registryAddress: QtCore.QUrl = ...,
        allowedSchemas: QRemoteObjectHostBase.AllowedSchemas = ...,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qremoteobjecthost.html#QRemoteObjectHost-1

        **QRemoteObjectHost::QRemoteObjectHost(const QUrl & address , const QUrl
        & registryAddress = QUrl(), QRemoteObjectHostBase::AllowedSchemas
        allowedSchemas = BuiltInSchemasOnly, QObject * parent = nullptr)**

        Constructs a new QRemoteObjectHost Node (i.e., a Node that supports
        exposing **Source**  objects on the QtRO network) with address
        **address**. If set, **registryAddress** will be used to connect to the
        **QRemoteObjectRegistry**  at the provided address. The
        **allowedSchemas** parameter is only needed (and should be set to
        **AllowExternalRegistration** ) if the schema of the url should be used
        as an **External Schema**  by the registry.

        **See also** **setHostUrl** () and **setRegistryUrl** ().
        """
        ...

    @typing.overload
    def __init__(self, address: QtCore.QUrl, parent: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-5/qremoteobjecthost.html#QRemoteObjectHost-2

        **QRemoteObjectHost::QRemoteObjectHost(const QUrl & address , QObject *
        parent )**

        Constructs a new QRemoteObjectHost Node (i.e., a Node that supports
        exposing **Source**  objects on the QtRO network) with a url of
        **address** and the given **parent**. This overload is provided as a
        convenience for specifying a **QObject**  parent without providing a
        registry address.

        **See also** **setHostUrl** () and **setRegistryUrl** ().
        """
        ...

    def setHostUrl(
        self,
        hostAddress: QtCore.QUrl,
        allowedSchemas: QRemoteObjectHostBase.AllowedSchemas = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qremoteobjecthost.html#setHostUrl

        **[override virtual] bool QRemoteObjectHost::setHostUrl(const QUrl &
        hostAddress , QRemoteObjectHostBase::AllowedSchemas allowedSchemas =
        BuiltInSchemasOnly)**

        Sets the **hostAddress** for a host **QRemoteObjectNode** .

        Returns `true` if the Host address is set, otherwise `false`.

        The **allowedSchemas** parameter is only needed (and should be set to
        **AllowExternalRegistration** ) if the schema of the url should be used
        as an **External Schema**  by the registry.

        **Note:** Setter function for property **hostUrl** .

        **See also** **hostUrl** ().
        """
        ...

    def hostUrl(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qremoteobjecthost.html#hostUrl

        **[override virtual] QUrl QRemoteObjectHost::hostUrl() const**

        Returns the host address for the **QRemoteObjectNode**  as a **QUrl** .
        If the Node is not a Host node, returns an empty **QUrl** .

        **Note:** Getter function for property hostUrl.

        **See also** **setHostUrl** ().
        """
        ...

    @property
    def hostUrlChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
