"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
from PyQt5 import QtGui
from PyQt5.QtQuick import *


class QSGTransformNode(QSGNode):
    """
    https://doc.qt.io/qt-5/qsgtransformnode.html

    **Detailed Description**

    Transformations apply the node's subtree and can be nested. Multiple
    transform nodes will be accumulated by intersecting all their matrices. The
    accumulation happens as part of the rendering.

    The transform nodes implement a 4x4 matrix which in theory supports full 3D
    transformations. However, because the renderer optimizes for 2D use-cases
    rather than 3D use-cases, rendering a scene with full 3D transformations
    needs to be done with some care.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgtransformnode.html#QSGTransformNode

        **QSGTransformNode::QSGTransformNode()**

        Create a new QSGTransformNode with its matrix set to the identity
        matrix.
        """
        ...

    def matrix(self) -> QtGui.QMatrix4x4:
        """
        https://doc.qt.io/qt-5/qsgtransformnode.html#matrix

        **const QMatrix4x4 &QSGTransformNode::matrix() const**

        Returns this transform node's matrix.

        **See also** **setMatrix** ().
        """
        ...

    def setMatrix(self, matrix: QtGui.QMatrix4x4) -> None:
        """
        https://doc.qt.io/qt-5/qsgtransformnode.html#setMatrix

        **void QSGTransformNode::setMatrix(const QMatrix4x4 & matrix )**

        Sets this transform node's matrix to **matrix**.

        **See also** **matrix** ().
        """
        ...
