"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtQuick import *
from PyQt5 import sip


class QSGRendererInterface(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qsgrendererinterface.html

    **Detailed Description**

    Renderer interfaces allow accessing graphics API specific functionality in
    the scenegraph. Such internals are not typically exposed. However, when
    integrating custom rendering via **QSGRenderNode**  for example, it may
    become necessary to query certain values, for instance the graphics device
    (e.g. the Direct3D or Vulkan device) that is used by the scenegraph.

    QSGRendererInterface's functions have varying availability. API and language
    queries, such as, **graphicsApi** () or **shaderType** () are always
    available, meaning it is sufficient to construct a **QQuickWindow**  or
    **QQuickView** , and the graphics API or shading language in use can be
    queried right after via **QQuickWindow::rendererInterface** (). This
    guarantees that utilities like the **GraphicsInfo**  QML type are able to
    report the correct values as early as possible, without having conditional
    property values - depending on for instance **shaderType** () - evaluate to
    unexpected values.

    Engine-specific accessors, like **getResource** (), are however available
    only after the scenegraph is initialized. Additionally, there may be
    backend-specific limitations on when such functions can be called. The only
    way that is guaranteed to succeed is calling them when the rendering of a
    node (i.e. the preparation of the command list for the next frame) is
    active. In practice this typically means **QSGRenderNode::render** ().
    """

    class ShaderSourceType(int):
        ShaderSourceString: QSGRendererInterface = ...
        ShaderSourceFile: QSGRendererInterface = ...
        ShaderByteCode: QSGRendererInterface = ...

    class ShaderCompilationType(int):
        RuntimeCompilation: QSGRendererInterface = ...
        OfflineCompilation: QSGRendererInterface = ...

    class ShaderType(int):
        UnknownShadingLanguage: QSGRendererInterface = ...
        GLSL: QSGRendererInterface = ...
        HLSL: QSGRendererInterface = ...
        RhiShader: QSGRendererInterface = ...

    class Resource(int):
        DeviceResource: QSGRendererInterface = ...
        CommandQueueResource: QSGRendererInterface = ...
        CommandListResource: QSGRendererInterface = ...
        PainterResource: QSGRendererInterface = ...
        RhiResource: QSGRendererInterface = ...
        PhysicalDeviceResource: QSGRendererInterface = ...
        OpenGLContextResource: QSGRendererInterface = ...
        DeviceContextResource: QSGRendererInterface = ...
        CommandEncoderResource: QSGRendererInterface = ...
        VulkanInstanceResource: QSGRendererInterface = ...
        RenderPassResource: QSGRendererInterface = ...

    class GraphicsApi(int):
        Unknown: QSGRendererInterface = ...
        Software: QSGRendererInterface = ...
        OpenGL: QSGRendererInterface = ...
        Direct3D12: QSGRendererInterface = ...
        OpenVG: QSGRendererInterface = ...
        OpenGLRhi: QSGRendererInterface = ...
        Direct3D11Rhi: QSGRendererInterface = ...
        VulkanRhi: QSGRendererInterface = ...
        MetalRhi: QSGRendererInterface = ...
        NullRhi: QSGRendererInterface = ...

    class ShaderCompilationTypes(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QSGRendererInterface.ShaderCompilationTypes",
                "QSGRendererInterface.ShaderCompilationType",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGRendererInterface.ShaderCompilationTypes") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QSGRendererInterface.ShaderCompilationTypes":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class ShaderSourceTypes(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QSGRendererInterface.ShaderSourceTypes",
                "QSGRendererInterface.ShaderSourceType",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGRendererInterface.ShaderSourceTypes") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QSGRendererInterface.ShaderSourceTypes":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @staticmethod
    def isApiRhiBased(api: "QSGRendererInterface.GraphicsApi") -> bool:
        """
        https://doc.qt.io/qt-5/qsgrendererinterface.html#isApiRhiBased

        **[static] bool
        QSGRendererInterface::isApiRhiBased(QSGRendererInterface::GraphicsApi
        api )**

        Returns true if **api** is based on a graphics abstraction layer (QRhi)
        instead of directly calling the native graphics API.

        **Note:** This function can be called on any thread.

        This function was introduced in Qt 5.14.
        """
        ...

    def shaderSourceType(self) -> "QSGRendererInterface.ShaderSourceTypes":
        """
        https://doc.qt.io/qt-5/qsgrendererinterface.html#shaderSourceType

        **[pure virtual] QSGRendererInterface::ShaderSourceTypes
        QSGRendererInterface::shaderSourceType() const**

        Returns a bitmask of the supported ways of providing shader sources in
        **ShaderEffect**  items.

        **Note:** This function can be called on any thread.

        **See also** **QtQuick::GraphicsInfo** .
        """
        ...

    def shaderCompilationType(self) -> "QSGRendererInterface.ShaderCompilationTypes":
        """
        https://doc.qt.io/qt-5/qsgrendererinterface.html#shaderCompilationType

        **[pure virtual] QSGRendererInterface::ShaderCompilationTypes
        QSGRendererInterface::shaderCompilationType() const**

        Returns a bitmask of the shader compilation approaches supported by the
        Qt Quick backend the application is using.

        **Note:** This function can be called on any thread.

        **See also** **QtQuick::GraphicsInfo** .
        """
        ...

    def shaderType(self) -> "QSGRendererInterface.ShaderType":
        """
        https://doc.qt.io/qt-5/qsgrendererinterface.html#shaderType

        **[pure virtual] QSGRendererInterface::ShaderType
        QSGRendererInterface::shaderType() const**

        Returns the shading language supported by the Qt Quick backend the
        application is using.

        **Note:** This function can be called on any thread.

        **See also** **QtQuick::GraphicsInfo** .
        """
        ...

    @typing.overload
    def getResource(
        self, window: QQuickWindow, resource: "QSGRendererInterface.Resource"
    ) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qsgrendererinterface.html#getResource

        **[virtual] void *QSGRendererInterface::getResource(QQuickWindow *
        window , QSGRendererInterface::Resource resource ) const**

        Queries a graphics **resource** in **window**. Returns null when the
        resource in question is not supported or not available.

        When successful, the returned pointer is either a direct pointer to an
        interface (and can be cast, for example, to `ID3D12Device *`) or a
        pointer to an opaque handle that needs to be dereferenced first (for
        example, `VkDevice dev = *static_cast<VkDevice \\*>(result)`). The latter
        is necessary since such handles may have sizes different from a pointer.

        **Note:** The ownership of the returned pointer is never transferred to
        the caller.

        **Note:** This function must only be called on the render thread.
        """
        ...

    @typing.overload
    def getResource(self, window: QQuickWindow, resource: str) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qsgrendererinterface.html#getResource-1

        **[virtual] void *QSGRendererInterface::getResource(QQuickWindow *
        window , const char * resource ) const**

        Queries a graphics resource. **resource** is a backend-specific key.
        This allows supporting any future resources that are not listed in the
        Resource enum.

        **Note:** The ownership of the returned pointer is never transferred to
        the caller.

        **Note:** This function must only be called on the render thread.
        """
        ...

    def graphicsApi(self) -> "QSGRendererInterface.GraphicsApi":
        """
        https://doc.qt.io/qt-5/qsgrendererinterface.html#graphicsApi

        **[pure virtual] QSGRendererInterface::GraphicsApi
        QSGRendererInterface::graphicsApi() const**

        Returns the graphics API that is in use by the Qt Quick scenegraph.

        **Note:** This function can be called on any thread.
        """
        ...
