"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtQuick import *
from PyQt5 import sip


class QSGMaterialShader(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qsgmaterialshader.html

    **Detailed Description**

    The QSGMaterialShader API is relatively low-level. A more convenient API,
    which provides almost all the same features, is available through
    QSGSimpleMaterialShader.

    **Warning:** This class is only functional when running with the legacy
    OpenGL renderer of the Qt Quick scenegraph.

    The **QSGMaterial**  and QSGMaterialShader form a tight relationship. For
    one scene graph (including nested graphs), there is one unique
    QSGMaterialShader instance which encapsulates the **QOpenGLShaderProgram**
    the scene graph uses to render that material, such as a shader to flat
    coloring of geometry. Each **QSGGeometryNode**  can have a unique
    **QSGMaterial**  containing the how the shader should be configured when
    drawing that node, such as the actual color used to render the geometry.

    An instance of QSGMaterialShader is never created explicitly by the user, it
    will be created on demand by the scene graph through
    **QSGMaterial::createShader** (). The scene graph will make sure that there
    is only one instance of each shader implementation through a scene graph.

    The source code returned from **vertexShader** () is used to control what
    the material does with the vertiex data that comes in from the geometry. The
    source code returned from the **fragmentShader** () is used to control what
    how the material should fill each individual pixel in the geometry. The
    vertex and fragment source code is queried once during initialization,
    changing what is returned from these functions later will not have any
    effect.

    The **activate** () function is called by the scene graph when a shader is
    is starting to be used. The deactivate function is called by the scene graph
    when the shader is no longer going to be used. While active, the scene graph
    may make one or more calls to **updateState** () which will update the state
    of the shader for each individual geometry to render.

    The **attributeNames** () returns the name of the attributes used in the
    **vertexShader** (). These are used in the default implementation of
    **activate** () and **deactivate** () to decide whice vertex registers are
    enabled.

    The **initialize** () function is called during program creation to allow
    subclasses to prepare for use, such as resolve uniform names in the
    **vertexShader** () and **fragmentShader** ().

    A minimal example:

    class Shader : public **QSGMaterialShader**
        {
        public:
            const
    char *vertexShader() const {
                return
                "attribute highp
    vec4 vertex;          \\n"
                "uniform highp mat4 matrix;
    \\n"
                "void main() {                         \\n"
                "
    gl_Position = matrix * vertex;    \\n"
                "}";
            }
    const char *fragmentShader() const {
                return
                "uniform
    lowp float opacity;                            \\n"
                "void main()
    {                                          \\n"
                        "
    gl_FragColor = vec4(1, 0, 0, 1) * opacity; \\n"
                "}";
            }
    char const *const *attributeNames() const
            {
                static char
    const *const names[] = { "vertex", 0 };
                return names;
            }
    void initialize()
            {
                **QSGMaterialShader**
    ::initialize();
                m_id_matrix =
    program()->uniformLocation("matrix");
                m_id_opacity =
    program()->uniformLocation("opacity");
            }

            void
    updateState(const RenderState &state, **QSGMaterial**  *newMaterial,
    **QSGMaterial**  *oldMaterial)
            {
    Q_ASSERT(program()->isLinked());
                if (state.isMatrixDirty())
    program()->setUniformValue(m_id_matrix, state.combinedMatrix());
    if (state.isOpacityDirty())
    program()->setUniformValue(m_id_opacity, state.opacity());
            }
    private:
            int m_id_matrix;
            int m_id_opacity;
        };

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.
    """

    class RenderState(sip.simplewrapper):
        class DirtyState(int):
            DirtyMatrix: QSGMaterialShader = ...
            DirtyOpacity: QSGMaterialShader = ...
            DirtyCachedMaterialData: QSGMaterialShader = ...
            DirtyAll: QSGMaterialShader = ...

        class DirtyStates(sip.simplewrapper):
            @typing.overload
            def __init__(self) -> None:
                ...

            @typing.overload
            def __init__(
                self,
                f: typing.Union[
                    "QSGMaterialShader.RenderState.DirtyStates",
                    "QSGMaterialShader.RenderState.DirtyState",
                ],
            ) -> None:
                ...

            @typing.overload
            def __init__(self, a0: "QSGMaterialShader.RenderState.DirtyStates") -> None:
                ...

            def __hash__(self) -> int:
                ...

            def __bool__(self) -> int:
                ...

            def __invert__(self) -> "QSGMaterialShader.RenderState.DirtyStates":
                ...

            def __index__(self) -> int:
                ...

            def __int__(self) -> int:
                ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGMaterialShader.RenderState") -> None:
            ...

        def isCachedMaterialDataDirty(self) -> bool:
            ...

        def devicePixelRatio(self) -> float:
            ...

        def projectionMatrix(self) -> QtGui.QMatrix4x4:
            ...

        def context(self) -> QtGui.QOpenGLContext:
            ...

        def determinant(self) -> float:
            ...

        def deviceRect(self) -> QtCore.QRect:
            ...

        def viewportRect(self) -> QtCore.QRect:
            ...

        def modelViewMatrix(self) -> QtGui.QMatrix4x4:
            ...

        def combinedMatrix(self) -> QtGui.QMatrix4x4:
            ...

        def opacity(self) -> float:
            ...

        def isOpacityDirty(self) -> bool:
            ...

        def isMatrixDirty(self) -> bool:
            ...

        def dirtyStates(self) -> "QSGMaterialShader.RenderState.DirtyStates":
            ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgmaterialshader.html#QSGMaterialShader

        **QSGMaterialShader::QSGMaterialShader()**

        Creates a new QSGMaterialShader.
        """
        ...

    def setShaderSourceFiles(
        self,
        type: typing.Union[
            QtGui.QOpenGLShader.ShaderType, QtGui.QOpenGLShader.ShaderTypeBit
        ],
        sourceFiles: typing.Iterable[str],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgmaterialshader.html#setShaderSourceFiles

        **[protected] void
        QSGMaterialShader::setShaderSourceFiles(QOpenGLShader::ShaderType type ,
        const QStringList & sourceFiles )**

        Sets the GLSL source files for the shader stage **type** to
        **sourceFiles**. The default implementation of the **vertexShader** ()
        and **fragmentShader** () functions will load the source files set by
        this function in the order given.

        **See also** **setShaderSourceFile** (), **vertexShader** (), and
        **fragmentShader** ().
        """
        ...

    def setShaderSourceFile(
        self,
        type: typing.Union[
            QtGui.QOpenGLShader.ShaderType, QtGui.QOpenGLShader.ShaderTypeBit
        ],
        sourceFile: str,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgmaterialshader.html#setShaderSourceFile

        **[protected] void
        QSGMaterialShader::setShaderSourceFile(QOpenGLShader::ShaderType type ,
        const QString & sourceFile )**

        Sets the GLSL source file for the shader stage **type** to
        **sourceFile**. The default implementation of the **vertexShader** ()
        and **fragmentShader** () functions will load the source files set by
        this function.

        This function is useful when you have a single source file for a given
        shader stage. If your shader consists of multiple source files then use
        **setShaderSourceFiles** ()

        **See also** **setShaderSourceFiles** (), **vertexShader** (), and
        **fragmentShader** ().
        """
        ...

    def fragmentShader(self) -> str:
        """
        https://doc.qt.io/qt-5/qsgmaterialshader.html#fragmentShader

        **[virtual protected] const char *QSGMaterialShader::fragmentShader()
        const**

        Called when the shader is being initialized to get the fragment shader
        source code.

        The contents returned from this function should never change.
        """
        ...

    def vertexShader(self) -> str:
        """
        https://doc.qt.io/qt-5/qsgmaterialshader.html#vertexShader

        **[virtual protected] const char *QSGMaterialShader::vertexShader()
        const**

        Called when the shader is being initialized to get the vertex shader
        source code.

        The contents returned from this function should never change.
        """
        ...

    def initialize(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgmaterialshader.html#initialize

        **[virtual protected] void QSGMaterialShader::initialize()**

        Reimplement this function to do one-time initialization when the shader
        program is compiled. The OpenGL shader program is compiled and linked,
        but not bound, when this function is called.
        """
        ...

    def compile(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgmaterialshader.html#compile

        **[virtual protected] void QSGMaterialShader::compile()**

        This function is called when the shader is initialized to compile the
        actual **QOpenGLShaderProgram** . Do not call it explicitly.

        The default implementation will extract the **vertexShader** () and
        **fragmentShader** () and bind the names returned from
        **attributeNames** () to consecutive vertex attribute registers starting
        at 0.
        """
        ...

    def program(self) -> QtGui.QOpenGLShaderProgram:
        """
        https://doc.qt.io/qt-5/qsgmaterialshader.html#program

        **QOpenGLShaderProgram *QSGMaterialShader::program()**

        Returns the shader program used by this **QSGMaterialShader** .
        """
        ...

    def attributeNames(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qsgmaterialshader.html#attributeNames

        **[pure virtual] const char *const *QSGMaterialShader::attributeNames()
        const**

        Returns a zero-terminated array describing the names of the attributes
        used in the vertex shader.

        This function is called when the shader is compiled to specify which
        attributes exist. The order of the attribute names defines the attribute
        register position in the vertex shader.
        """
        ...

    def updateState(
        self,
        state: "QSGMaterialShader.RenderState",
        newMaterial: QSGMaterial,
        oldMaterial: QSGMaterial,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgmaterialshader.html#updateState

        **[virtual] void QSGMaterialShader::updateState(const
        QSGMaterialShader::RenderState & state , QSGMaterial * newMaterial ,
        QSGMaterial * oldMaterial )**

        This function is called by the scene graph before geometry is rendered
        to make sure the shader is in the right state.

        The current rendering **state** is passed from the scene graph. If the
        state indicates that any state is dirty, the updateState implementation
        must update accordingly for the geometry to render correctly.

        The subclass specific state, such as the color of a flat color material,
        should be extracted from **newMaterial** to update the color uniforms
        accordingly.

        The **oldMaterial** can be used to minimze state changes when updating
        material states. The **oldMaterial** is 0 if this shader was just
        activated.

        **See also** **activate** () and **deactivate** ().
        """
        ...

    def deactivate(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgmaterialshader.html#deactivate

        **[virtual] void QSGMaterialShader::deactivate()**

        This function is called by the scene graph to indicate that geometry
        will no longer to be rendered using this shader.
        """
        ...

    def activate(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgmaterialshader.html#activate

        **[virtual] void QSGMaterialShader::activate()**

        This function is called by the scene graph to indicate that geometry is
        about to be rendered using this shader.

        State that is global for all uses of the shader, independent of the
        geometry that is being drawn, can be setup in this function.
        """
        ...
