"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtQuick import *
from PyQt5 import sip


class QSGMaterial(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qsgmaterial.html

    **Detailed Description**

    The QSGMaterial, **QSGMaterialShader**  and **QSGMaterialRhiShader**
    subclasses form a tight relationship. For one scene graph (including nested
    graphs), there is one unique **QSGMaterialShader**  or
    **QSGMaterialRhiShader**  instance which encapsulates the shaders the scene
    graph uses to render that material, such as a shader to flat coloring of
    geometry. Each **QSGGeometryNode**  can have a unique QSGMaterial containing
    the how the shader should be configured when drawing that node, such as the
    actual color to used to render the geometry.

    QSGMaterial has two virtual functions that both need to be implemented. The
    function **type** () should return a unique instance for all instances of a
    specific subclass. The **createShader** () function should return a new
    instance of **QSGMaterialShader**  or **QSGMaterialRhiShader** , specific to
    that subclass of QSGMaterial.

    A minimal QSGMaterial implementation could look like this:

    class Material : public QSGMaterial
        {
        public:
    **QSGMaterialType**  *type() const { static **QSGMaterialType**  type;
    return &type; }
            **QSGMaterialShader**  *createShader() const {
    return new Shader; }
        };

    This is suitable only for the OpenGL-based, traditional renderer of the
    scene graph. When using the new, graphics API abstracted renderer, materials
    must create **QSGMaterialRhiShader**  instances instead, or in addition:

    class Material : public QSGMaterial
        {
        public:
            Material() {
    setFlag(SupportsRhiShader, true); }
            **QSGMaterialType**  *type()
    const { static **QSGMaterialType**  type; return &type; }
    **QSGMaterialShader**  *createShader() {
                if
    (flags().testFlag(RhiShaderWanted)) {
                    return new RhiShader;
    } else {
                    // this is optional, relevant for materials that
    intend to be usable with the legacy OpenGL renderer as well
    return new Shader;
                }
            }
        };

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.
    """

    class Flag(int):
        Blending: QSGMaterial = ...
        RequiresDeterminant: QSGMaterial = ...
        RequiresFullMatrixExceptTranslate: QSGMaterial = ...
        RequiresFullMatrix: QSGMaterial = ...
        CustomCompileStep: QSGMaterial = ...
        SupportsRhiShader: QSGMaterial = ...
        RhiShaderWanted: QSGMaterial = ...

    class Flags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QSGMaterial.Flags", "QSGMaterial.Flag"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGMaterial.Flags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QSGMaterial.Flags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self) -> None:
        ...

    def setFlag(
        self,
        flags: typing.Union["QSGMaterial.Flags", "QSGMaterial.Flag"],
        enabled: bool = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgmaterial.html#setFlag

        **void QSGMaterial::setFlag(QSGMaterial::Flags flags , bool on = true)**

        Sets the flags **flags** on this material if **on** is true; otherwise
        clears the attribute.
        """
        ...

    def flags(self) -> "QSGMaterial.Flags":
        """
        https://doc.qt.io/qt-5/qsgmaterial.html#flags

        **QSGMaterial::Flags QSGMaterial::flags() const**

        Returns the material's flags.
        """
        ...

    def compare(self, other: "QSGMaterial") -> int:
        """
        https://doc.qt.io/qt-5/qsgmaterial.html#compare

        **[virtual] int QSGMaterial::compare(const QSGMaterial * other ) const**

        Compares this material to **other** and returns 0 if they are equal; -1
        if this material should sort before **other** and 1 if **other** should
        sort before.

        The scene graph can reorder geometry nodes to minimize state changes.
        The compare function is called during the sorting process so that the
        materials can be sorted to minimize state changes in each call to
        **QSGMaterialShader::updateState** ().

        The this pointer and **other** is guaranteed to have the same **type**
        ().
        """
        ...

    def createShader(self) -> "QSGMaterialShader":
        """
        https://doc.qt.io/qt-5/qsgmaterial.html#createShader

        **[pure virtual] QSGMaterialShader *QSGMaterial::createShader() const**

        This function returns a new instance of a the **QSGMaterialShader**
        implementatation used to render geometry for a specific implementation
        of **QSGMaterial** .

        The function will be called only once for each material type that exists
        in the scene graph and will be cached internally.

        When the **QSGMaterial**  reports **SupportsRhiShader**  in **flags**
        (), the scene graph may request a **QSGMaterialRhiShader**  instead of
        **QSGMaterialShader** . This is indicated by having the
        **RhiShaderWanted**  flag set. In this case the return value must be a
        QSGRhiMaterialShader subclass.
        """
        ...

    def type(self) -> "QSGMaterialType":
        """
        https://doc.qt.io/qt-5/qsgmaterial.html#type

        **[pure virtual] QSGMaterialType *QSGMaterial::type() const**

        This function is called by the scene graph to return a unique instance
        per subclass.
        """
        ...
